/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockBrokerToControllerChannelManager;
import kafka.server.MockBrokerToControllerChannelManager$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00042\u0001\u0001\u0006Ia\u000b\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u0019y\u0004\u0001)A\u0005i!9\u0001\t\u0001b\u0001\n\u0013\t\u0005BB#\u0001A\u0003%!\tC\u0004G\u0001\t\u0007I\u0011B$\t\r-\u0003\u0001\u0015!\u0003I\u0011\u001da\u0005A1A\u0005\n5Ca!\u0015\u0001!\u0002\u0013q\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007=\u0002\u0001\u000b\u0011\u0002+\t\u000b}\u0003A\u0011\u00021\t\u000b\u0011\u0004A\u0011A3\t\u000bQ\u0004A\u0011A3\t\u000bY\u0004A\u0011A3\t\u000ba\u0004A\u0011A3\t\u000bi\u0004A\u0011A3\t\u000bq\u0004A\u0011A3\t\u000by\u0004A\u0011B@\t\ry\u0004A\u0011BA\u001c\u0011\u001d\t)\u0007\u0001C\u0005\u0003O\u0012QCR8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003e\tA\u0001^5nKV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002/7\u0005)Q\u000f^5mg&\u0011\u0001'\f\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u000511\r\\5f]R,\u0012\u0001\u000e\t\u0003kuj\u0011A\u000e\u0006\u0003oa\nqa\u00197jK:$8O\u0003\u0002\u001ds)\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0013\tqdG\u0001\u0006N_\u000e\\7\t\\5f]R\fqa\u00197jK:$\b%\u0001\fd_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s+\u0005\u0011\u0005C\u0001\u0015D\u0013\t!\u0015D\u0001\fD_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s\u0003]\u0019wN\u001c;s_2dWM\u001d(pI\u0016\u0004&o\u001c<jI\u0016\u0014\b%\u0001\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014X#\u0001%\u0011\u0005!J\u0015B\u0001&\u001a\u0005\u0011junY6Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013!\u00054pe^\f'\u000fZ5oO6\u000bg.Y4feV\ta\n\u0005\u0002)\u001f&\u0011\u0001+\u0007\u0002\u0016\r>\u0014x/\u0019:eS:<W*\u00198bO\u0016\u0014\u0018*\u001c9m\u0003I1wN]<be\u0012LgnZ'b]\u0006<WM\u001d\u0011\u0002!A\u0014\u0018N\\2ja\u0006d')^5mI\u0016\u0014X#\u0001+\u0011\u0005UcV\"\u0001,\u000b\u0005]C\u0016!D1vi\",g\u000e^5dCR|'O\u0003\u0002Z5\u0006A1/Z2ve&$\u0018P\u0003\u0002\\q\u000511m\\7n_:L!!\u0018,\u00039\u0011+g-Y;mi.\u000bgm[1Qe&t7-\u001b9bY\n+\u0018\u000e\u001c3fe\u0006\t\u0002O]5oG&\u0004\u0018\r\u001c\"vS2$WM\u001d\u0011\u0002+\r|g\u000e\u001e:pY2,'/\u00119j-\u0016\u00148/[8ogV\t\u0011\r\u0005\u00026E&\u00111M\u000e\u0002\u0010\u001d>$W-\u00119j-\u0016\u00148/[8og\u0006\tC/Z:u%\u0016\u001c\bo\u001c8tK\u000e{'O]3mCRLwN\\%e\u001b&\u001cX.\u0019;dQR\ta\r\u0005\u0002!O&\u0011\u0001.\t\u0002\u0005+:LG\u000f\u000b\u0002\u0010UB\u00111N]\u0007\u0002Y*\u0011QN\\\u0001\u0004CBL'BA8q\u0003\u001dQW\u000f]5uKJT!!]\u001e\u0002\u000b),h.\u001b;\n\u0005Md'\u0001\u0002+fgR\fq\u0003^3tiVs7/\u001e9q_J$X\r\u001a,feNLwN\\:)\u0005AQ\u0017A\r;fgR4uN]<be\u0012Lgn\u001a+j[\u0016|W\u000f^,bSRLgn\u001a$pe\u000e{g\u000e\u001e:pY2,'\u000fR5tG>4XM]=)\u0005EQ\u0017a\b;fgR4uN]<be\u0012Lgn\u001a+j[\u0016|W\u000f^!gi\u0016\u0014(+\u001a;ss\"\u0012!C[\u0001(i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u001a\u0013x.\u001c(fi^|'o[\"mS\u0016tG\u000f\u000b\u0002\u0014U\u0006AB/Z:u\r\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8)\u0005QQ\u0017\u0001\u00042vS2$'+Z9vKN$HCBA\u0001\u0003G\ti\u0003E\u0004!\u0003\u0007\t9!a\u0005\n\u0007\u0005\u0015\u0011E\u0001\u0004UkBdWM\r\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002.\u0002\u0011I,\u0017/^3tiNLA!!\u0005\u0002\f\ti!+Z9vKN$\b*Z1eKJ\u0004B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0002oS>T!!!\b\u0002\t)\fg/Y\u0005\u0005\u0003C\t9B\u0001\u0006CsR,')\u001e4gKJDq!!\n\u0016\u0001\u0004\t9#\u0001\u0003c_\u0012L\b\u0003BA\u0005\u0003SIA!a\u000b\u0002\f\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u00020U\u0001\r!!\r\u0002\u001b\r|'O]3mCRLwN\\%e!\r\u0001\u00131G\u0005\u0004\u0003k\t#aA%oiRA\u0011\u0011HA'\u0003#\n)\u0006\u0005\u0003\u0002<\u0005\u001dc\u0002BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u00053$A\u0004oKR<xN]6\n\t\u0005\u0015\u0013qH\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\tI%a\u0013\u0003\u000fI+\u0017/^3ti*!\u0011QIA \u0011\u001d\tyE\u0006a\u0001\u0003\u000f\tQB]3rk\u0016\u001cH\u000fS3bI\u0016\u0014\bbBA*-\u0001\u0007\u00111C\u0001\u000ee\u0016\fX/Z:u\u0005V4g-\u001a:\t\u000f\u0005]c\u00031\u0001\u0002Z\u0005I\u0001O]5oG&\u0004\u0018\r\u001c\t\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011q\f-\u0002\t\u0005,H\u000f[\u0005\u0005\u0003G\niF\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002-Q,7\u000f^!mi\u0016\u00148i\u001c8gS\u001e\u0014V-];fgR,\"!!\u001b\u0011\t\u0005%\u00111N\u0005\u0005\u0003[\nYAA\nBYR,'oQ8oM&<7OU3rk\u0016\u001cH\u000f")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockBrokerToControllerChannelManager brokerToController = new MockBrokerToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$5(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((BrokerToControllerChannelManager)this.brokerToController());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockBrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)new Node(0, "host", 1234)));
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)new Node(0, "host", 1234)));
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)None$.MODULE$);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)new Node(0, "host", 1234)));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Node controllerNode = new Node(0, "host", 1234);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)controllerNode));
        this.client().prepareUnsupportedVersionResponse(arg_0 -> ForwardingManagerTest.$anonfun$testUnsupportedVersionFromNetworkClient$1((RequestHeader)requestHeader2, arg_0));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Node controllerNode = new Node(0, "host", 1234);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)controllerNode));
        this.client().createPendingAuthenticationError(controllerNode, 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannel.Metrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$);
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionFromNetworkClient$1(RequestHeader requestHeader$1, AbstractRequest req) {
        ApiKeys apiKeys = req.apiKey();
        ApiKeys apiKeys2 = requestHeader$1.apiKey();
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }
}

