/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractMetadataRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y2Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C!-!)q\u0006\u0001C!a!)A\u0007\u0001C\u0001k!)!\b\u0001C\u0001k!)A\b\u0001C\u0001k\t\tS*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHoV5uQ\u001a{'o^1sI&tw\rV3ti*\u0011\u0011BC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0011%\u0011\u0011\u0003\u0003\u0002\u001c\u0003\n\u001cHO]1di6+G/\u00193bi\u0006\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005!\u0002CA\b\u0001\u0003\u0015\u0019X\r^+q)\t9R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0003V]&$\b\"\u0002\u0010\u0003\u0001\u0004y\u0012\u0001\u0003;fgRLeNZ8\u0011\u0005\u0001JS\"A\u0011\u000b\u0005\t\u001a\u0013aA1qS*\u0011A%J\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1s%A\u0003kk:LGOC\u0001)\u0003\ry'oZ\u0005\u0003U\u0005\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u00051\u0002\"\u0001I\u0017\n\u00059\n#A\u0003\"fM>\u0014X-R1dQ\u0006\u0001RM\\1cY\u00164uN]<be\u0012LgnZ\u000b\u0002cA\u0011\u0001DM\u0005\u0003ge\u0011qAQ8pY\u0016\fg.A\u000buKN$\u0018)\u001e;p)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8\u0015\u0003]A#\u0001B\u001c\u0011\u0005\u0001B\u0014BA\u001d\"\u0005\u0011!Vm\u001d;\u0002_Q,7\u000f^!vi>\u001c%/Z1uKR{\u0007/[2XSRD\u0017J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0005\u00159\u0014a\b;fgR\fU\u000f^8De\u0016\fG/Z(g\u0007>dG.\u001b3j]\u001e$v\u000e]5dg\"\u0012aa\u000e")
public class MetadataRequestWithForwardingTest
extends AbstractMetadataRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @Override
    public boolean enableForwarding() {
        return true;
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic(topic3, response2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)topic4, (List)Nil$.MODULE$), false), (short)3), this.sendMetadataRequest$default$2()));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic5));
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplicationFactor() {
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)1, (int)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        Assertions.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assertions.assertEquals((int)0, (int)topicMetadata.partitionMetadata().size());
    }

    @Test
    public void testAutoCreateOfCollidingTopics() {
        String topic1 = "testAutoCreate.Topic";
        String topic2 = "testAutoCreate_Topic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)2, (int)response1.topicMetadata().size());
        Map responseMap = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)metadata -> new Tuple2((Object)metadata.topic(), (Object)metadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (Object)responseMap.keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.LEADER_NOT_AVAILABLE, Errors.INVALID_TOPIC_EXCEPTION})), (Object)responseMap.values().toSet());
        String topicCreated = (String)((Tuple2)responseMap.head())._1();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topicCreated, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), topicCreated, 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicCreated, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response2.topicMetadata()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assertions.assertEquals((Object)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.error, Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((int)1, (int)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).head();
        Assertions.assertEquals((int)0, (int)partitionMetadata.partition());
        Assertions.assertEquals((int)2, (int)partitionMetadata.replicaIds.size());
        Assertions.assertTrue((boolean)partitionMetadata.leaderId.isPresent());
        Assertions.assertTrue((Predef$.MODULE$.Integer2int((Integer)partitionMetadata.leaderId.get()) >= 0 ? 1 : 0) != 0);
    }
}

