/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001\u0002\u0013&\u0001)BQa\f\u0001\u0005\u0002ABQA\r\u0001\u0005BMBqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019Q\u0005\u0001)A\u0005\u000f\"91\n\u0001b\u0001\n\u0003a\u0005BB*\u0001A\u0003%Q\nC\u0004U\u0001\t\u0007I\u0011A+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\u0002UCaa\u0017\u0001!\u0002\u00131\u0006b\u0002/\u0001\u0005\u0004%\t!\u0016\u0005\u0007;\u0002\u0001\u000b\u0011\u0002,\t\u000fy\u0003!\u0019!C\u0001?\"11\u000f\u0001Q\u0001\n\u0001Dq\u0001\u001e\u0001C\u0002\u0013\u0005q\f\u0003\u0004v\u0001\u0001\u0006I\u0001\u0019\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0011\u001d\ti\u0001\u0001Q\u0001\naD\u0001\"a\u0004\u0001\u0005\u0004%\ta\u001e\u0005\b\u0003#\u0001\u0001\u0015!\u0003y\u0011!\t\u0019\u0002\u0001b\u0001\n\u00039\bbBA\u000b\u0001\u0001\u0006I\u0001\u001f\u0005\n\u0003/\u0001!\u0019!C\u0001\u00033A\u0001\"!\t\u0001A\u0003%\u00111\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\t9\u0004\u0001C!\u0003sAq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002h\u0001!\t!!\u0018\t\u000f\u0005-\u0004\u0001\"\u0001\u0002^!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\tI\u000f\u0001C\u0005\u0003W\u0014ac\u00144gg\u0016$h)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003M\u001d\naa]3sm\u0016\u0014(\"\u0001\u0015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u000b\t\u0003Y5j\u0011!J\u0005\u0003]\u0015\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"\u0001\f\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t\u0019\u0011J\u001c;\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bA\u0001\\1oO*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005\u001dIe\u000e^3hKJ\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\r=4gm]3u+\u00059\u0005CA\u001bI\u0013\tIeG\u0001\u0003M_:<\u0017aB8gMN,G\u000fI\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.F\u0001N!\rq\u0015\u000bP\u0007\u0002\u001f*\u0011\u0001\u000bQ\u0001\u0005kRLG.\u0003\u0002S\u001f\nAq\n\u001d;j_:\fG.\u0001\u0007mK\u0006$WM]#q_\u000eD\u0007%\u0001\u0005nKR\fG-\u0019;b+\u00051\u0006CA\u001fX\u0013\tAfH\u0001\u0004TiJLgnZ\u0001\n[\u0016$\u0018\rZ1uC\u0002\nQ\u0001^8qS\u000e\fa\u0001^8qS\u000e\u0004\u0013aB4s_V\u0004\u0018\nZ\u0001\tOJ|W\u000f]%eA\u00051qM]8vaN,\u0012\u0001\u0019\t\u0004C&dgB\u00012h\u001d\t\u0019g-D\u0001e\u0015\t)\u0017&\u0001\u0004=e>|GOP\u0005\u0002o%\u0011\u0001NN\u0001\ba\u0006\u001c7.Y4f\u0013\tQ7NA\u0002TKFT!\u0001\u001b\u001c\u0011\u00055\fhB\u00018p!\t\u0019g'\u0003\u0002qm\u00051\u0001K]3eK\u001aL!\u0001\u0017:\u000b\u0005A4\u0014aB4s_V\u00048\u000fI\u0001\u0007i>\u0004\u0018nY:\u0002\u000fQ|\u0007/[2tA\u0005QAo\u001c9jGFb\u0015n\u001d;\u0016\u0003a\u00042AT=|\u0013\tQxJ\u0001\u0003MSN$\bc\u0001?\u0002\n5\tQP\u0003\u0002\u007f\u007f\u000611m\\7n_:T1\u0001KA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9!A\u0002pe\u001eL1!a\u0003~\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0002^8qS\u000e\fD*[:uA\u0005qAo\u001c9jGF\ne\u000e\u001a\u001aMSN$\u0018a\u0004;pa&\u001c\u0017'\u00118ee1K7\u000f\u001e\u0011\u0002\u001b\u0005dG\u000eV8qS\u000e\u001cH*[:u\u00039\tG\u000e\u001c+pa&\u001c7\u000fT5ti\u0002\n1c\u001a:pkB$v\u000eU1si&$\u0018n\u001c8NCB,\"!a\u0007\u0011\u000b9\u000bi\u0002\u001c=\n\u0007\u0005}qJA\u0002NCB\fAc\u001a:pkB$v\u000eU1si&$\u0018n\u001c8NCB\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\u0011\t9#!\f\u0011\u0007U\nI#C\u0002\u0002,Y\u0012A!\u00168ji\"9\u0011qF\u000eA\u0002\u0005E\u0012A\u00039s_B,'\u000f^5fgB\u0019a*a\r\n\u0007\u0005UrJ\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$B!a\n\u0002<!9\u0011Q\b\u000fA\u0002\u0005}\u0012\u0001\u0003;fgRLeNZ8\u0011\t\u0005\u0005\u0013qJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005\u0019\u0011\r]5\u000b\t\u0005%\u00131J\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\ti%!\u0002\u0002\u000b),h.\u001b;\n\t\u0005E\u00131\t\u0002\t)\u0016\u001cH/\u00138g_\"\u001aA$!\u0016\u0011\t\u0005\u0005\u0013qK\u0005\u0005\u00033\n\u0019E\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011\u0005^3ti>3gm]3u\r\u0016$8\r\u001b*fcV,7\u000f^*j]\u001edWm\u0012:pkB$\"!a\n)\u0007u\t\t\u0007\u0005\u0003\u0002B\u0005\r\u0014\u0002BA3\u0003\u0007\u0012A\u0001V3ti\u0006AC/Z:u\u001f\u001a47/\u001a;GKR\u001c\u0007NU3rk\u0016\u001cHoV5uQ6+H\u000e^5qY\u0016<%o\\;qg\"\u001aa$!\u0019\u0002{Q,7\u000f^(gMN,GOR3uG\"\u0014V-];fgR<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u000fJ|W\u000f]:XSRDwJ\\3He>,\bOU3qK\u0006$\u0018N\\4)\u0007}\t\t'A\rwKJLg-_*j]\u001edWm\u0012:pkB\u0014Vm\u001d9p]N,GCEA\u0014\u0003g\ni(!!\u0002\u0006\u0006%\u0015QRAI\u0003+Cq!!\u001e!\u0001\u0004\t9(A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0007U\nI(C\u0002\u0002|Y\u0012Qa\u00155peRDq!a !\u0001\u0004\t9(A\u0007sKN\u0004xN\\:f\u000bJ\u0014xN\u001d\u0005\b\u0003\u0007\u0003\u0003\u0019AA<\u00039\u0001\u0018M\u001d;ji&|g.\u0012:s_JDa!a\"!\u0001\u0004a\u0017!\u0003;pa&\u001cg*Y7f\u0011\u0019\tY\t\ta\u0001y\u0005q\u0001/\u0019:uSRLwN\\%oI\u0016D\bBBAHA\u0001\u0007q)A\bd_6l\u0017\u000e\u001e;fI>3gm]3u\u0011\u0019\t\u0019\n\ta\u0001y\u0005!2m\\7nSR$X\r\u001a'fC\u0012,'/\u00129pG\"Da!a&!\u0001\u0004a\u0017!\u00059beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u0006\u0019b/\u001a:jMf\u0004\u0016M\u001d;ji&|g\u000eR1uCR!\u0011qEAO\u0011\u001d\ty*\ta\u0001\u0003C\u000bQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007\u0003BAR\u0003_sA!!*\u0002,6\u0011\u0011q\u0015\u0006\u0004\u0003Sk\u0018\u0001\u0003:fcV,7\u000f^:\n\t\u00055\u0016qU\u0001\u0014\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/Z\u0005\u0005\u0003c\u000b\u0019LA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0003[\u000b9+\u0001\bwKJLg-\u001f*fgB|gn]3\u0015\u0011\u0005\u001d\u0012\u0011XAe\u0003KDq!a/#\u0001\u0004\ti,\u0001\nhe>,\b\u000fT3wK2\u0014Vm\u001d9p]N,\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\rW0\u0001\u0005qe>$xnY8m\u0013\u0011\t9-!1\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\tyJ\ta\u0001\u0003\u0017\u0004bATA\u000fw\u00065\u0007\u0003BAh\u0003_sA!!5\u0002,:!\u00111[Ar\u001d\u0011\t).!9\u000f\t\u0005]\u0017q\u001c\b\u0005\u00033\fiND\u0002d\u00037L!!a\u0002\n\t\u0005\r\u0011QA\u0005\u0004Q\u0005\u0005\u0011B\u0001@\u0000\u0013\r\tI+ \u0005\u0007\u0003O\u0014\u0003\u0019\u0001=\u0002\u0013Q|\u0007/[2MSN$\u0018!D2p[6LGo\u00144gg\u0016$8\u000f\u0006\u0003\u0002(\u00055\bBBAxG\u0001\u0007\u00010\u0001\u0004ua2K7\u000f\u001e")
public class OffsetFetchRequestTest
extends BaseRequestTest {
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);
    private final long offset;
    private final Optional<Integer> leaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(3));
    private final String metadata;
    private final String topic;
    private final String groupId;
    private final Seq<String> groups = (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)i -> OffsetFetchRequestTest.$anonfun$groups$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    private final Seq<String> topics = (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> OffsetFetchRequestTest.$anonfun$topics$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    private final List<TopicPartition> topic1List = Collections.singletonList(new TopicPartition((String)this.topics().apply(0), 0));
    private final List<TopicPartition> topic1And2List = Arrays.asList((Object[])new TopicPartition[]{new TopicPartition((String)this.topics().apply(0), 0), new TopicPartition((String)this.topics().apply(1), 0), new TopicPartition((String)this.topics().apply(1), 1)});
    private final List<TopicPartition> allTopicsList = Arrays.asList((Object[])new TopicPartition[]{new TopicPartition((String)this.topics().apply(0), 0), new TopicPartition((String)this.topics().apply(1), 0), new TopicPartition((String)this.topics().apply(1), 1), new TopicPartition((String)this.topics().apply(2), 0), new TopicPartition((String)this.topics().apply(2), 1), new TopicPartition((String)this.topics().apply(2), 2)});
    private final java.util.Map<String, List<TopicPartition>> groupToPartitionMap = new HashMap<String, List<TopicPartition>>();

    @Override
    public int brokerCount() {
        return 1;
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    public long offset() {
        return this.offset;
    }

    public Optional<Integer> leaderEpoch() {
        return this.leaderEpoch;
    }

    public String metadata() {
        return this.metadata;
    }

    public String topic() {
        return this.topic;
    }

    public String groupId() {
        return this.groupId;
    }

    public Seq<String> groups() {
        return this.groups;
    }

    public Seq<String> topics() {
        return this.topics;
    }

    public List<TopicPartition> topic1List() {
        return this.topic1List;
    }

    public List<TopicPartition> topic1And2List() {
        return this.topic1And2List;
    }

    public List<TopicPartition> allTopicsList() {
        return this.allTopicsList;
    }

    public java.util.Map<String, List<TopicPartition>> groupToPartitionMap() {
        return this.groupToPartitionMap;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.BrokerIdProp(), this.brokerId().toString());
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testOffsetFetchRequestSingleGroup() {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        List<TopicPartition> tpList = Collections.singletonList(new TopicPartition(this.topic(), 0));
        this.consumerConfig().setProperty("group.id", this.groupId());
        this.commitOffsets(tpList);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), (int)ApiKeys.OFFSET_FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            if (version < 8) {
                OffsetFetchRequest request = version < 7 ? new OffsetFetchRequest.Builder(this.groupId(), false, tpList, false).build((short)version) : new OffsetFetchRequest.Builder(this.groupId(), false, tpList, true).build((short)version);
                OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
                OffsetFetchResponseData.OffsetFetchResponseTopic topicData = (OffsetFetchResponseData.OffsetFetchResponseTopic)response.data().topics().get(0);
                OffsetFetchResponseData.OffsetFetchResponsePartition partitionData = (OffsetFetchResponseData.OffsetFetchResponsePartition)topicData.partitions().get(0);
                if (version < 3) {
                    Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
                }
                this.verifySingleGroupResponse((short)version, response.error().code(), partitionData.errorCode(), topicData.name(), Predef$.MODULE$.int2Integer(partitionData.partitionIndex()), partitionData.committedOffset(), Predef$.MODULE$.int2Integer(partitionData.committedLeaderEpoch()), partitionData.metadata());
                return;
            }
            OffsetFetchRequest request = new OffsetFetchRequest.Builder((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupId()), (Object)tpList)}))).asJava(), false, false).build((short)version);
            OffsetFetchResponseData.OffsetFetchResponseGroup groupData = (OffsetFetchResponseData.OffsetFetchResponseGroup)((OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).data().groups().get(0);
            OffsetFetchResponseData.OffsetFetchResponseTopics topicData = (OffsetFetchResponseData.OffsetFetchResponseTopics)groupData.topics().get(0);
            OffsetFetchResponseData.OffsetFetchResponsePartitions partitionData = (OffsetFetchResponseData.OffsetFetchResponsePartitions)topicData.partitions().get(0);
            this.verifySingleGroupResponse((short)version, groupData.errorCode(), partitionData.errorCode(), topicData.name(), Predef$.MODULE$.int2Integer(partitionData.partitionIndex()), partitionData.committedOffset(), Predef$.MODULE$.int2Integer(partitionData.committedLeaderEpoch()), partitionData.metadata());
        });
    }

    @Test
    public void testOffsetFetchRequestWithMultipleGroups() {
        this.createTopic((String)this.topics().apply(0), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic((String)this.topics().apply(1), 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic((String)this.topics().apply(2), 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.mutable.Map partitionMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.groupToPartitionMap()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e._1(), Option$.MODULE$.apply(e._2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.allTopicsList())), Map$.MODULE$.canBuildFrom());
        this.groups().foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            OffsetFetchRequestTest.$anonfun$testOffsetFetchRequestWithMultipleGroups$3(this, partitionMap, groupId);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), (int)ApiKeys.OFFSET_FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            OffsetFetchRequest request = new OffsetFetchRequest.Builder(this.groupToPartitionMap(), false, false).build((short)version);
            OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
            ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().groups()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.groupId(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
                this.verifyResponse(response.groupLevelError(groupId), response.partitionDataMap(groupId), (List)partitionMap.apply((Object)groupId));
                return BoxedUnit.UNIT;
            });
        });
    }

    @Test
    public void testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating() {
        this.createTopic((String)this.topics().apply(0), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic((String)this.topics().apply(1), 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic((String)this.topics().apply(2), 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.mutable.Map partitionMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.groupToPartitionMap()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e._1(), Option$.MODULE$.apply(e._2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.allTopicsList())), Map$.MODULE$.canBuildFrom());
        this.groups().foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            OffsetFetchRequestTest.$anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$3(this, partitionMap, groupId);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), (int)ApiKeys.OFFSET_FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            OffsetFetchRequest request = new OffsetFetchRequest.Builder(this.groupToPartitionMap(), false, false).build((short)version);
            List requestGroups = request.data().groups();
            requestGroups.add(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId((String)this.groups().apply(2)).setTopics(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName((String)this.topics().apply(0)).setPartitionIndexes(Collections.singletonList(Predef$.MODULE$.int2Integer(0))))));
            request.data().setGroups(requestGroups);
            OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
            ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().groups()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.groupId(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
                OffsetFetchRequestTest.$anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$6(this, response, partitionMap, groupId);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void verifySingleGroupResponse(short version, short responseError, short partitionError, String topicName, Integer partitionIndex, long committedOffset, Integer committedLeaderEpoch, String partitionMetadata) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseError);
        Assertions.assertEquals((Object)this.topic(), (Object)topicName);
        Assertions.assertEquals((int)0, (Integer)partitionIndex);
        Assertions.assertEquals((long)this.offset(), (long)committedOffset);
        if (version >= 5) {
            Assertions.assertEquals((Integer)this.leaderEpoch().get(), (Integer)committedLeaderEpoch);
        }
        Assertions.assertEquals((Object)this.metadata(), (Object)partitionMetadata);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionError);
    }

    private void verifyPartitionData(OffsetFetchResponse.PartitionData partitionData) {
        Assertions.assertTrue((!partitionData.hasError() ? 1 : 0) != 0);
        Assertions.assertEquals((long)this.offset(), (long)partitionData.offset);
        Assertions.assertEquals((Object)this.metadata(), (Object)partitionData.metadata);
        Assertions.assertEquals((Integer)this.leaderEpoch().get(), (Integer)((Integer)partitionData.leaderEpoch.get()));
    }

    private void verifyResponse(Errors groupLevelResponse, java.util.Map<TopicPartition, OffsetFetchResponse.PartitionData> partitionData, List<TopicPartition> topicList) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)groupLevelResponse);
        Assertions.assertTrue((partitionData.size() == topicList.size() ? 1 : 0) != 0);
        topicList.forEach(t -> this.verifyPartitionData((OffsetFetchResponse.PartitionData)partitionData.get(t)));
    }

    private void commitOffsets(List<TopicPartition> tpList) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(tpList);
        java.util.Map offsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(tpList).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)new OffsetAndMetadata(this.offset(), this.leaderEpoch(), this.metadata())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        consumer.commitSync(offsets);
        consumer.close();
    }

    public static final /* synthetic */ String $anonfun$groups$1(int i) {
        return new StringBuilder(5).append("group").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$topics$1(int i) {
        return new StringBuilder(5).append("topic").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$testOffsetFetchRequestWithMultipleGroups$3(OffsetFetchRequestTest $this, scala.collection.mutable.Map partitionMap$1, String groupId) {
        $this.consumerConfig().setProperty("group.id", groupId);
        $this.commitOffsets((List)partitionMap$1.apply((Object)groupId));
    }

    public static final /* synthetic */ void $anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$3(OffsetFetchRequestTest $this, scala.collection.mutable.Map partitionMap$2, String groupId) {
        $this.consumerConfig().setProperty("group.id", groupId);
        $this.commitOffsets((List)partitionMap$2.apply((Object)groupId));
    }

    public static final /* synthetic */ void $anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$6(OffsetFetchRequestTest $this, OffsetFetchResponse response$2, scala.collection.mutable.Map partitionMap$2, String groupId) {
        String string = groupId;
        String string2 = "group3";
        if (string != null && string.equals(string2)) {
            $this.verifyResponse(response$2.groupLevelError(groupId), response$2.partitionDataMap(groupId), $this.topic1List());
            return;
        }
        $this.verifyResponse(response$2.groupLevelError(groupId), response$2.partitionDataMap(groupId), (List)partitionMap$2.apply((Object)groupId));
    }

    public OffsetFetchRequestTest() {
        this.offset = 15L;
        this.metadata = "metadata";
        this.topic = "topic";
        this.groupId = "groupId";
        this.groupToPartitionMap().put((String)this.groups().apply(0), this.topic1List());
        this.groupToPartitionMap().put((String)this.groups().apply(1), this.topic1And2List());
        this.groupToPartitionMap().put((String)this.groups().apply(2), this.allTopicsList());
        this.groupToPartitionMap().put((String)this.groups().apply(3), null);
        this.groupToPartitionMap().put((String)this.groups().apply(4), null);
    }
}

