/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.CorruptIndexException;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.ProducerStateManager;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class LogLoader$
implements Logging {
    public static LogLoader$ MODULE$;
    private final String CleanShutdownFile;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogLoader$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load(LoadLogParams params) {
        long l;
        long l2;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles(params);
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableLike)swapFiles.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)UnifiedLog$.MODULE$.isLogFile(new File(CoreUtils$.MODULE$.replaceSuffix(f.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), "")))))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            LogLoader$.$anonfun$load$2(params, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            block8: {
                try {
                    if (!file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                        long offset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                        if (offset >= minSwapFileOffset$1.elem && offset < maxSwapFileOffset$1.elem) {
                            LogLoader$ logLoader$ = MODULE$;
                            if (logLoader$ == null) {
                                throw null;
                            }
                            LogLoader$ info_this = logLoader$;
                            if (info_this.logger().underlying().isInfoEnabled()) {
                                info_this.logger().underlying().info(info_this.msgWithLogIdent(LogLoader$.$anonfun$load$6(params, file)));
                            }
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block8;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                LogLoader$ logLoader$ = MODULE$;
                if (logLoader$ == null) {
                    throw null;
                }
                LogLoader$ info_this = logLoader$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    info_this.logger().underlying().info(info_this.msgWithLogIdent(LogLoader$.$anonfun$load$9(params, file)));
                }
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), ""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader$.$anonfun$load$10(params);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(LogLoader$.$anonfun$retryOnOffsetOverflow$1(params, retryOnOffsetOverflow_e)));
                }
                SplitSegmentResult retryOnOffsetOverflow_result = UnifiedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment(), params.segments(), params.dir(), params.topicPartition(), params.config(), params.scheduler(), params.logDirFailureChannel(), params.logIdentifier());
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments(), params);
                continue;
            }
            break;
        }
        if (!params.dir().getAbsolutePath().endsWith(UnifiedLog$.MODULE$.DeleteDirSuffix())) {
            void var8_12;
            void var6_11;
            Tuple2 tuple2;
            while (true) {
                try {
                    tuple2 = LogLoader$.MODULE$.recoverLog(params);
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(this.msgWithLogIdent(LogLoader$.$anonfun$retryOnOffsetOverflow$1(params, retryOnOffsetOverflow_e)));
                    }
                    SplitSegmentResult retryOnOffsetOverflow_result = UnifiedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment(), params.segments(), params.dir(), params.topicPartition(), params.config(), params.scheduler(), params.logDirFailureChannel(), params.logIdentifier());
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments(), params);
                    continue;
                }
                break;
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple22._1$mcJ$sp();
            long nextOffset = tuple22._2$mcJ$sp();
            ((LogSegment)params.segments().lastSegment().get()).resizeIndexes(Predef$.MODULE$.Integer2int(params.config().maxIndexSize()));
            l2 = var6_11;
            l = var8_12;
        } else {
            if (params.segments().isEmpty()) {
                File x$9 = params.dir();
                long x$10 = 0L;
                LogConfig x$11 = params.config();
                Time x$12 = params.time();
                int x$13 = params.config().initFileSize();
                boolean x$14 = LogSegment$.MODULE$.open$default$5();
                boolean x$15 = LogSegment$.MODULE$.open$default$7();
                String x$16 = LogSegment$.MODULE$.open$default$8();
                params.segments().add(LogSegment$.MODULE$.open(x$9, x$10, x$11, x$12, x$14, x$13, x$15, x$16));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        params.leaderEpochCache().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.truncateFromEnd(l3);
            return BoxedUnit.UNIT;
        });
        long newLogStartOffset = package$.MODULE$.max(params.logStartOffsetCheckpoint(), ((LogSegment)params.segments().firstSegment().get()).baseOffset());
        params.leaderEpochCache().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.truncateFromStart(params.logStartOffsetCheckpoint());
            return BoxedUnit.UNIT;
        });
        if (!params.producerStateManager().isEmpty()) {
            throw new IllegalStateException("Producer state must be empty during log initialization");
        }
        params.producerStateManager().removeStraySnapshots((Seq<Object>)params.segments().baseOffsets().toSeq());
        UnifiedLog$.MODULE$.rebuildProducerState(params.producerStateManager(), params.segments(), newLogStartOffset, l3, params.config().recordVersion(), params.time(), params.hadCleanShutdown(), params.logIdentifier());
        LogSegment activeSegment = (LogSegment)params.segments().lastSegment().get();
        return new LoadedLogOffsets(newLogStartOffset, l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles(LoadLogParams params) {
        void var7_7;
        void var6_6;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix())) {
                LogLoader$ logLoader$ = MODULE$;
                if (logLoader$ == null) {
                    throw null;
                }
                LogLoader$ debug_this = logLoader$;
                if (debug_this.logger().underlying().isDebugEnabled()) {
                    debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$3(params, file)));
                }
                return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(UnifiedLog$.MODULE$.offsetFromFile((File)file), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        void invalidSwapFiles2 = var6_6;
        void validSwapFiles2 = var7_7;
        invalidSwapFiles2.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$5(params, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$7(params, file)));
        return validSwapFiles2;
    }

    private <T> T retryOnOffsetOverflow(LoadLogParams params, Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(LogLoader$.$anonfun$retryOnOffsetOverflow$1(params, e)));
                }
                SplitSegmentResult result = UnifiedLog$.MODULE$.splitOverflowedSegment(e.segment(), params.segments(), params.dir(), params.topicPartition(), params.config(), params.scheduler(), params.logDirFailureChannel(), params.logIdentifier());
                this.deleteProducerSnapshotsAsync(result.deletedSegments(), params);
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles(LoadLogParams params) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.dir().listFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$))).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (UnifiedLog$.MODULE$.isIndexFile((File)file)) {
                long offset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                if (!UnifiedLog$.MODULE$.logFile(params.dir(), offset, UnifiedLog$.MODULE$.logFile$default$3()).exists()) {
                    LogLoader$ logLoader$ = MODULE$;
                    if (logLoader$ == null) {
                        throw null;
                    }
                    LogLoader$ warn_this = logLoader$;
                    if (warn_this.logger().underlying().isWarnEnabled()) {
                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(LogLoader$.$anonfun$loadSegmentFiles$4(params, file)));
                    }
                    return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (UnifiedLog$.MODULE$.isLogFile((File)file)) {
                long baseOffset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                boolean timeIndexFileNewlyCreated = !UnifiedLog$.MODULE$.timeIndexFile(params.dir(), baseOffset, UnifiedLog$.MODULE$.timeIndexFile$default$3()).exists();
                LogSegment segment = LogSegment$.MODULE$.open(params.dir(), baseOffset, params.config(), params.time(), true, LogSegment$.MODULE$.open$default$6(), LogSegment$.MODULE$.open$default$7(), LogSegment$.MODULE$.open$default$8());
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    LogLoader$ logLoader$ = MODULE$;
                    if (logLoader$ == null) {
                        throw null;
                    }
                    LogLoader$ error_this = logLoader$;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent(LogLoader$.$anonfun$loadSegmentFiles$5(params, segment)));
                    }
                    MODULE$.recoverSegment(segment, params);
                }
                catch (CorruptIndexException e) {
                    LogLoader$ logLoader$ = MODULE$;
                    if (logLoader$ == null) {
                        throw null;
                    }
                    LogLoader$ warn_this = logLoader$;
                    if (warn_this.logger().underlying().isWarnEnabled()) {
                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(LogLoader$.$anonfun$loadSegmentFiles$6(params, segment, e)));
                    }
                    MODULE$.recoverSegment(segment, params);
                }
                return params.segments().add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    private int recoverSegment(LogSegment segment, LoadLogParams params) {
        ProducerStateManager producerStateManager = new ProducerStateManager(params.topicPartition(), params.dir(), params.maxProducerIdExpirationMs(), params.time());
        UnifiedLog$.MODULE$.rebuildProducerState(producerStateManager, params.segments(), params.logStartOffsetCheckpoint(), segment.baseOffset(), params.config().recordVersion(), params.time(), false, params.logIdentifier());
        int bytesTruncated = segment.recover(producerStateManager, params.leaderEpochCache());
        producerStateManager.takeSnapshot();
        return bytesTruncated;
    }

    public Tuple2<Object, Object> recoverLog(LoadLogParams params) {
        Tuple2.mcJJ.sp sp2;
        boolean bl;
        if (!params.hadCleanShutdown()) {
            Iterator unflushed = params.segments().values(params.recoveryPointCheckpoint(), Long.MAX_VALUE).iterator();
            boolean truncated = false;
            while (unflushed.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushed.next();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(LogLoader$.$anonfun$recoverLog$3(params, segment)));
                }
                try {
                    n = this.recoverSegment(segment, params);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(this.msgWithLogIdent(LogLoader$.$anonfun$recoverLog$4(params, startOffset)));
                    }
                    n = segment.truncateTo(startOffset);
                }
                if (n <= 0) continue;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(this.msgWithLogIdent(LogLoader$.$anonfun$recoverLog$5(params, segment)));
                }
                this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushed.toList(), params);
                truncated = true;
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1(params);
        if (params.segments().isEmpty()) {
            File x$1 = params.dir();
            long x$2 = params.logStartOffsetCheckpoint();
            LogConfig x$3 = params.config();
            Time x$4 = params.time();
            int x$5 = params.config().initFileSize();
            boolean x$6 = Predef$.MODULE$.Boolean2boolean(params.config().preallocate());
            boolean x$7 = LogSegment$.MODULE$.open$default$5();
            String x$8 = LogSegment$.MODULE$.open$default$8();
            params.segments().add(LogSegment$.MODULE$.open(x$1, x$2, x$3, x$4, x$7, x$5, x$6, x$8));
        }
        if ((bl = params.hadCleanShutdown()) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            sp2 = new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        } else {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((LogSegment)params.segments().lastSegment().get()).readNextOffset()));
            sp2 = new Tuple2.mcJJ.sp(Math.min(params.recoveryPointCheckpoint(), logEndOffset), logEndOffset);
        }
        return sp2;
    }

    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete, LoadLogParams params) {
        if (segmentsToDelete.nonEmpty()) {
            List toDelete = segmentsToDelete.toList();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(LogLoader$.$anonfun$removeAndDeleteSegmentsAsync$1(params, toDelete)));
            }
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LogLoader$.$anonfun$removeAndDeleteSegmentsAsync$2(params, segment);
                return BoxedUnit.UNIT;
            });
            UnifiedLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, true, params.dir(), params.topicPartition(), params.config(), params.scheduler(), params.logDirFailureChannel(), params.logIdentifier());
            this.deleteProducerSnapshotsAsync(segmentsToDelete, params);
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments, LoadLogParams params) {
        UnifiedLog$.MODULE$.deleteProducerSnapshots(segments, params.producerStateManager(), true, params.scheduler(), params.config(), params.logDirFailureChannel(), params.dir().getParent(), params.topicPartition());
    }

    public static final /* synthetic */ String $anonfun$load$3(LoadLogParams params$1, File f$1) {
        return new StringBuilder(94).append(params$1.logIdentifier()).append("Found log file ").append(f$1.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString();
    }

    public static final /* synthetic */ void $anonfun$load$2(LoadLogParams params$1, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long baseOffset = UnifiedLog$.MODULE$.offsetFromFile(f);
        File x$1 = f.getParentFile();
        LogConfig x$3 = params$1.config();
        Time x$4 = params$1.time();
        String x$5 = UnifiedLog$.MODULE$.SwapFileSuffix();
        boolean x$6 = LogSegment$.MODULE$.open$default$5();
        int x$7 = LogSegment$.MODULE$.open$default$6();
        boolean x$8 = LogSegment$.MODULE$.open$default$7();
        LogSegment segment = LogSegment$.MODULE$.open(x$1, baseOffset, x$3, x$4, x$6, x$7, x$8, x$5);
        LogLoader$ logLoader$ = MODULE$;
        if (logLoader$ == null) {
            throw null;
        }
        LogLoader$ info_this = logLoader$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent(LogLoader$.$anonfun$load$3(params$1, f)));
        }
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ String $anonfun$load$6(LoadLogParams params$1, File file$1) {
        return new StringBuilder(71).append(params$1.logIdentifier()).append("Deleting segment files ").append(file$1.getName()).append(" that is compacted but has not been deleted yet.").toString();
    }

    public static final /* synthetic */ String $anonfun$load$9(LoadLogParams params$1, File file$2) {
        return new StringBuilder(41).append(params$1.logIdentifier()).append("Recovering file ").append(file$2.getName()).append(" by renaming from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString();
    }

    public static final /* synthetic */ void $anonfun$load$10(LoadLogParams params$1) {
        params$1.segments().close();
        params$1.segments().clear();
        MODULE$.loadSegmentFiles(params$1);
    }

    public static final /* synthetic */ String $anonfun$removeTempFilesAndCollectSwapFiles$3(LoadLogParams params$2, File file$3) {
        return new StringBuilder(30).append(params$2.logIdentifier()).append("Deleting stray temporary file ").append(file$3.getAbsolutePath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return UnifiedLog$.MODULE$.offsetFromFile(file) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ String $anonfun$removeTempFilesAndCollectSwapFiles$6(LoadLogParams params$2, File file$4, LongRef minCleanedFileOffset$1) {
        return new StringBuilder(50).append(params$2.logIdentifier()).append("Deleting invalid swap file ").append(file$4.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LoadLogParams params$2, LongRef minCleanedFileOffset$1, File file) {
        LogLoader$ logLoader$ = MODULE$;
        if (logLoader$ == null) {
            throw null;
        }
        LogLoader$ debug_this = logLoader$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$6(params$2, file, minCleanedFileOffset$1)));
        }
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ String $anonfun$removeTempFilesAndCollectSwapFiles$8(LoadLogParams params$2, File file$5) {
        return new StringBuilder(27).append(params$2.logIdentifier()).append("Deleting stray .clean file ").append(file$5.getAbsolutePath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LoadLogParams params$2, File file) {
        LogLoader$ logLoader$ = MODULE$;
        if (logLoader$ == null) {
            throw null;
        }
        LogLoader$ debug_this = logLoader$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(LogLoader$.$anonfun$removeTempFilesAndCollectSwapFiles$8(params$2, file)));
        }
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ String $anonfun$retryOnOffsetOverflow$1(LoadLogParams params$3, LogSegmentOffsetOverflowException e$1) {
        return new StringBuilder(57).append(params$3.logIdentifier()).append("Caught segment overflow error: ").append(e$1.getMessage()).append(". Split segment and retry.").toString();
    }

    public static final /* synthetic */ String $anonfun$loadSegmentFiles$4(LoadLogParams params$4, File file$6) {
        return new StringBuilder(62).append(params$4.logIdentifier()).append("Found an orphaned index file ").append(file$6.getAbsolutePath()).append(", with no corresponding log file.").toString();
    }

    public static final /* synthetic */ String $anonfun$loadSegmentFiles$5(LoadLogParams params$4, LogSegment segment$1) {
        return new StringBuilder(109).append(params$4.logIdentifier()).append("Could not find offset index file corresponding to log file").append(" ").append(segment$1.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString();
    }

    public static final /* synthetic */ String $anonfun$loadSegmentFiles$6(LoadLogParams params$4, LogSegment segment$1, CorruptIndexException e$2) {
        return new StringBuilder(114).append(params$4.logIdentifier()).append("Found a corrupted index file corresponding to log file").append(" ").append(segment$1.log().file().getAbsolutePath()).append(" due to ").append(e$2.getMessage()).append("}, recovering segment and").append(" rebuilding index files...").toString();
    }

    public static final /* synthetic */ String $anonfun$recoverLog$1(LoadLogParams params$5, long logEndOffset$1) {
        return new StringBuilder(148).append(params$5.logIdentifier()).append("Deleting all segments because logEndOffset (").append(logEndOffset$1).append(") ").append("is smaller than logStartOffset ").append(params$5.logStartOffsetCheckpoint()).append(". ").append("This could happen if segment files were deleted from the file system.").toString();
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1(LoadLogParams params$5) {
        if (params$5.segments().nonEmpty()) {
            long logEndOffset = ((LogSegment)params$5.segments().lastSegment().get()).readNextOffset();
            if (logEndOffset >= params$5.logStartOffsetCheckpoint()) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(LogLoader$.$anonfun$recoverLog$1(params$5, logEndOffset)));
            }
            this.removeAndDeleteSegmentsAsync(params$5.segments().values(), params$5);
            params$5.leaderEpochCache().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.clearAndFlush();
                return BoxedUnit.UNIT;
            });
            params$5.producerStateManager().truncateFullyAndStartAt(params$5.logStartOffsetCheckpoint());
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$recoverLog$3(LoadLogParams params$5, LogSegment segment$2) {
        return new StringBuilder(29).append(params$5.logIdentifier()).append("Recovering unflushed segment ").append(segment$2.baseOffset()).toString();
    }

    public static final /* synthetic */ String $anonfun$recoverLog$4(LoadLogParams params$5, long startOffset$1) {
        return new StringBuilder(114).append(params$5.logIdentifier()).append("Found invalid offset during recovery. Deleting the").append(" corrupt segment and creating an empty one with starting offset ").append(startOffset$1).toString();
    }

    public static final /* synthetic */ String $anonfun$recoverLog$5(LoadLogParams params$5, LogSegment segment$2) {
        return new StringBuilder(51).append(params$5.logIdentifier()).append("Corruption found in segment ").append(segment$2.baseOffset()).append(",").append(" truncating to offset ").append(segment$2.readNextOffset()).toString();
    }

    public static final /* synthetic */ String $anonfun$removeAndDeleteSegmentsAsync$1(LoadLogParams params$6, List toDelete$1) {
        return new StringBuilder(43).append(params$6.logIdentifier()).append("Deleting segments as part of log recovery: ").append(toDelete$1.mkString(",")).toString();
    }

    public static final /* synthetic */ void $anonfun$removeAndDeleteSegmentsAsync$2(LoadLogParams params$6, LogSegment segment) {
        params$6.segments().remove(segment.baseOffset());
    }

    private LogLoader$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.CleanShutdownFile = ".kafka_cleanshutdown";
    }
}

