/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper$;
import kafka.server.ThrottleCallback;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.collection.Iterable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%w!B\u000b\u0017\u0011\u0003Yb!B\u000f\u0017\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003\"B\u0014\u0002\t\u0003Ac\u0001B\u000f\u0017\u0001QC\u0001\"\u0016\u0003\u0003\u0002\u0003\u0006IA\u0016\u0005\t9\u0012\u0011\t\u0011)A\u0005;\"A\u0001\u000e\u0002B\u0001B\u0003%\u0011\u000eC\u0003&\t\u0011\u0005a\u000fC\u0003|\t\u0011\u0005A\u0010C\u0004\u0002\"\u0011!\t!a\t\t\u000f\u0005EB\u0001\"\u0001\u00024!9\u0011q\b\u0003\u0005\u0002\u0005\u0005\u0003bBA+\t\u0011\u0005\u0011q\u000b\u0005\b\u0003K\"A\u0011AA4\u0011\u001d\ti\u0007\u0002C\u0001\u0003_Bq!a\u001d\u0005\t\u0003\t)\bC\u0004\u0002\u0006\u0012!\t!a\"\t\u0013\u0005\rF!%A\u0005\u0002\u0005\u0015\u0006bBA^\t\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u0007$A\u0011AAc\u0003Q\u0011V-];fgRD\u0015M\u001c3mKJDU\r\u001c9fe*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u001d\u00035\taC\u0001\u000bSKF,Xm\u001d;IC:$G.\u001a:IK2\u0004XM]\n\u0003\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001c\u0003Iyg\u000eT3bI\u0016\u00148\u000f[5q\u0007\"\fgnZ3\u0015\u000b%bcG\u0010*\u0011\u0005\u0001R\u0013BA\u0016\"\u0005\u0011)f.\u001b;\t\u000b5\u001a\u0001\u0019\u0001\u0018\u0002!\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u00159'o\\;q\u0015\t\u0019\u0004$A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018BA\u001b1\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'\u000fC\u00038\u0007\u0001\u0007\u0001(\u0001\buq:\u001cun\u001c:eS:\fGo\u001c:\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\u0012\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:L!!\u0010\u001e\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_JDQaP\u0002A\u0002\u0001\u000ba\"\u001e9eCR,G\rT3bI\u0016\u00148\u000fE\u0002B\u00132s!AQ$\u000f\u0005\r3U\"\u0001#\u000b\u0005\u0015S\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\tA\u0015%A\u0004qC\u000e\\\u0017mZ3\n\u0005)[%\u0001C%uKJ\f'\r\\3\u000b\u0005!\u000b\u0003CA'Q\u001b\u0005q%BA(\u0019\u0003\u001d\u0019G.^:uKJL!!\u0015(\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B*\u0004\u0001\u0004\u0001\u0015\u0001E;qI\u0006$X\r\u001a$pY2|w/\u001a:t'\t!q$\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0005]SV\"\u0001-\u000b\u0005eC\u0012a\u00028fi^|'o[\u0005\u00037b\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\u0004rk>$\u0018m\u001d\t\u0003=\u0016t!aX2\u000f\u0005\u0001\u0014gBA\"b\u0013\u0005I\u0012BA\f\u0019\u0013\t!g#\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0002gO\ni\u0011+^8uC6\u000bg.Y4feNT!\u0001\u001a\f\u0002\tQLW.\u001a\t\u0003URl\u0011a\u001b\u0006\u0003Y6\fQ!\u001e;jYNT!A\\8\u0002\r\r|W.\\8o\u0015\tI\u0002O\u0003\u0002re\u00061\u0011\r]1dQ\u0016T\u0011a]\u0001\u0004_J<\u0017BA;l\u0005\u0011!\u0016.\\3\u0015\t]D\u0018P\u001f\t\u00039\u0011AQ!\u0016\u0005A\u0002YCQ\u0001\u0018\u0005A\u0002uCQ\u0001\u001b\u0005A\u0002%\f\u0001\u0002\u001e5s_R$H.\u001a\u000b\u0007Su\f)!a\u0006\t\u000byL\u0001\u0019A@\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0011\u0007q\t\t!C\u0002\u0002\u0004Y\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\"9\u0011qA\u0005A\u0002\u0005%\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u0017\t\tBD\u0002X\u0003\u001bI1!a\u0004Y\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LA!a\u0005\u0002\u0016\t9!+Z9vKN$(bAA\b1\"9\u0011\u0011D\u0005A\u0002\u0005m\u0011A\u0004;ie>$H\u000f\\3US6,Wj\u001d\t\u0004A\u0005u\u0011bAA\u0010C\t\u0019\u0011J\u001c;\u0002\u0017!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u000b\u0006S\u0005\u0015\u0012q\u0005\u0005\b\u0003\u000fQ\u0001\u0019AA\u0005\u0011\u001d\tIC\u0003a\u0001\u0003W\t\u0011!\u001a\t\u0004\u0003\u00065\u0012bAA\u0018\u0017\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u001bg\u0016tG-\u0012:s_J|%o\u00117pg\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\bS\u0005U\u0012qGA\u001e\u0011\u001d\t9a\u0003a\u0001\u0003\u0013Aq!!\u000f\f\u0001\u0004\tY#A\u0003feJ|'\u000fC\u0004\u0002>-\u0001\r!a\u0007\u0002\u0015QD'o\u001c;uY\u0016l5/A\u000btK:$gi\u001c:xCJ$W\r\u001a*fgB|gn]3\u0015\u000b%\n\u0019%!\u0012\t\u000f\u0005\u001dA\u00021\u0001\u0002\n!9\u0011q\t\u0007A\u0002\u0005%\u0013\u0001\u0003:fgB|gn]3\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014n\u0003!\u0011X-];fgR\u001c\u0018\u0002BA*\u0003\u001b\u0012\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u00023M,g\u000e\u001a*fgB|gn]3NCf\u0014W\r\u00165s_R$H.\u001a\u000b\u0006S\u0005e\u00131\f\u0005\b\u0003\u000fi\u0001\u0019AA\u0005\u0011\u001d\ti&\u0004a\u0001\u0003?\nab\u0019:fCR,'+Z:q_:\u001cX\rE\u0004!\u0003C\nY\"!\u0013\n\u0007\u0005\r\u0014EA\u0005Gk:\u001cG/[8oc\u0005q2/\u001a8e\u000bJ\u0014xN\u001d*fgB|gn]3NCf\u0014W\r\u00165s_R$H.\u001a\u000b\u0006S\u0005%\u00141\u000e\u0005\b\u0003\u000fq\u0001\u0019AA\u0005\u0011\u001d\tID\u0004a\u0001\u0003W\tq$\\1zE\u0016\u0014VmY8sI\u0006sGmR3u)\"\u0014x\u000e\u001e;mKRKW.Z't)\u0011\tY\"!\u001d\t\u000f\u0005\u001dq\u00021\u0001\u0002\n\u0005a3/\u001a8e%\u0016\u001c\bo\u001c8tK6\u000b\u0017PY3UQJ|G\u000f\u001e7f/&$\bnQ8oiJ|G\u000e\\3s#V|G/\u0019\u000b\bS\u0005]\u0014\u0011QAB\u0011\u001d\tI\b\u0005a\u0001\u0003w\nqcY8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1\u0011\u0007q\ti(C\u0002\u0002\u0000Y\u0011qcQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1\t\u000f\u0005\u001d\u0001\u00031\u0001\u0002\n!9\u0011Q\f\tA\u0002\u0005}\u0013AG:f]\u0012\u0014Vm\u001d9p]N,W\t_3naR$\u0006N]8ui2,GcB\u0015\u0002\n\u0006-\u0015Q\u0012\u0005\b\u0003\u000f\t\u0002\u0019AA\u0005\u0011\u001d\t9%\u0005a\u0001\u0003\u0013B\u0011\"a$\u0012!\u0003\u0005\r!!%\u0002\u0015=t7i\\7qY\u0016$X\rE\u0003!\u0003'\u000b9*C\u0002\u0002\u0016\u0006\u0012aa\u00149uS>t\u0007C\u0002\u0011\u0002b\u0005e\u0015\u0006\u0005\u0003\u0002\u001c\u0006}UBAAO\u0015\tIV.\u0003\u0003\u0002\"\u0006u%\u0001B*f]\u0012\fAe]3oIJ+7\u000f]8og\u0016,\u00050Z7qiRC'o\u001c;uY\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003OSC!!%\u0002*.\u0012\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003%)hn\u00195fG.,GMC\u0002\u00026\u0006\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI,a,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0010tK:$WI\u001d:peJ+7\u000f]8og\u0016,\u00050Z7qiRC'o\u001c;uY\u0016$R!KA`\u0003\u0003Dq!a\u0002\u0014\u0001\u0004\tI\u0001C\u0004\u0002:M\u0001\r!a\u000b\u0002=M,g\u000e\u001a(p\u001fB\u0014Vm\u001d9p]N,W\t_3naR$\u0006N]8ui2,GcA\u0015\u0002H\"9\u0011q\u0001\u000bA\u0002\u0005%\u0001")
public class RequestHandlerHelper {
    public final RequestChannel kafka$server$RequestHandlerHelper$$requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;

    public static void onLeadershipChange(GroupCoordinator groupCoordinator, TransactionCoordinator transactionCoordinator, Iterable<Partition> iterable, Iterable<Partition> iterable2) {
        RequestHandlerHelper$.MODULE$.onLeadershipChange(groupCoordinator, transactionCoordinator, iterable, iterable2);
    }

    public void throttle(ClientQuotaManager quotaManager, RequestChannel.Request request, int throttleTimeMs) {
        ThrottleCallback callback = new ThrottleCallback(this, request){
            private final /* synthetic */ RequestHandlerHelper $outer;
            private final RequestChannel.Request request$1;

            public void startThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.startThrottling(this.request$1);
            }

            public void endThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.endThrottling(this.request$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        };
        quotaManager.throttle(request, callback, throttleTimeMs);
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        if (e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    public void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        AbstractResponse response = requestBody.getErrorResponse(throttleMs, error);
        if (response == null) {
            this.kafka$server$RequestHandlerHelper$$requestChannel.closeConnection(request, requestBody.errorCounts(error));
            return;
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response) {
        int throttleTimeMs = response.throttleTimeMs();
        this.throttle(this.quotas.request(), request, throttleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, (AbstractResponse)createResponse.apply((Object)BoxesRunTime.boxToInteger((int)throttleTimeMs)), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    /*
     * WARNING - void declaration
     */
    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        void var2_2;
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return (int)var2_2;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.throttle(this.quotas.controllerMutation(), request, controllerThrottleTimeMs);
            } else {
                this.throttle(this.quotas.request(), request, requestThrottleTimeMs);
            }
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, (AbstractResponse)createResponse.apply((Object)BoxesRunTime.boxToInteger((int)maxThrottleTimeMs)), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, onComplete);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    public void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendNoOpResponse(request);
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time) {
        this.kafka$server$RequestHandlerHelper$$requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
    }
}

