/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$1$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tMd!\u0002\u0014(\u0003\u0003a\u0003\"B\u001a\u0001\t\u0003!\u0004\"B\u001c\u0001\t\u0003A\u0004\"C$\u0001\u0001\u0004\u0005\r\u0011\"\u0003I\u0011%a\u0006\u00011AA\u0002\u0013%Q\fC\u0005d\u0001\u0001\u0007\t\u0011)Q\u0005\u0013\"9A\r\u0001b\u0001\n\u0013)\u0007B\u0002:\u0001A\u0003%a\rC\u0005t\u0001\u0001\u0007\t\u0019!C\ti\"I!\u0010\u0001a\u0001\u0002\u0004%\tb\u001f\u0005\n{\u0002\u0001\r\u0011!Q!\nUDqA \u0001C\u0002\u0013Eq\u0010\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0001\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\f\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002N\u0001!\t\"a\u0014\t\u0013\u0005\r\u0005!%A\u0005\u0012\u0005\u0015\u0005\"CAN\u0001E\u0005I\u0011CAC\u0011%\ti\nAI\u0001\n#\t)\tC\u0005\u0002 \u0002\t\n\u0011\"\u0005\u0002\"\"I\u0011Q\u0015\u0001\u0012\u0002\u0013E\u0011q\u0015\u0005\n\u0003W\u0003\u0011\u0013!C\t\u0003OCq!!,\u0001\t#\ty\u000bC\u0004\u00024\u0002!\t!!.\t\u000f\u0005%\b\u0001\"\u0001\u0002l\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\bb\u0002B\u0001\u0001\u0011E!1\u0001\u0005\n\u0005\u001b\u0001\u0011\u0013!C\t\u0003\u000bC\u0011Ba\u0004\u0001#\u0003%\t\"a*\t\u000f\tE\u0001\u0001\"\u0005\u0003\u0014!9!1\u0006\u0001\u0005\u0002\t5\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003h\u0001!\tA!\u001b\u0003)\t\u000b7/\u001a)s_\u0012,8-\u001a:TK:$G+Z:u\u0015\tA\u0013&A\u0002ba&T\u0011AK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0006\u0005\u0002/c5\tqF\u0003\u00021S\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\t\u0011tF\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tQ\u0007\u0005\u00027\u00015\tq%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005I\u0004c\u0001\u001e@\u00036\t1H\u0003\u0002={\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001e\u0003\u0007M+\u0017\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002ES\u000511/\u001a:wKJL!AR\"\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\tG>t7/^7feV\t\u0011\n\u0005\u0003K'V+V\"A&\u000b\u0005\u001dc%BA'O\u0003\u001d\u0019G.[3oiNT!AK(\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0005\u0003).\u0013QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\bc\u0001,X36\tQ(\u0003\u0002Y{\t)\u0011I\u001d:bsB\u0011aKW\u0005\u00037v\u0012AAQ=uK\u0006a1m\u001c8tk6,'o\u0018\u0013fcR\u0011a,\u0019\t\u0003-~K!\u0001Y\u001f\u0003\tUs\u0017\u000e\u001e\u0005\bE\u0012\t\t\u00111\u0001J\u0003\rAH%M\u0001\nG>t7/^7fe\u0002\n\u0011\u0002\u001d:pIV\u001cWM]:\u0016\u0003\u0019\u00042a\u001a6m\u001b\u0005A'BA5<\u0003\u001diW\u000f^1cY\u0016L!a\u001b5\u0003\r\t+hMZ3s!\u0011i\u0007/V+\u000e\u00039T!a\u001c'\u0002\u0011A\u0014x\u000eZ;dKJL!!\u001d8\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0003)\u0001(o\u001c3vG\u0016\u00148\u000fI\u0001\u0006C\u0012l\u0017N\\\u000b\u0002kB\u0011a\u000f_\u0007\u0002o*\u00111\u000fT\u0005\u0003s^\u0014Q!\u00113nS:\f\u0011\"\u00193nS:|F%Z9\u0015\u0005yc\bb\u00022\n\u0003\u0003\u0005\r!^\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0005Y\u0006twM\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!!\u0002\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005Qa.^7SK\u000e|'\u000fZ:\u0016\u0005\u0005]\u0001c\u0001,\u0002\u001a%\u0019\u00111D\u001f\u0003\u0007%sG/A\u0006ok6\u0014VmY8sIN\u0004\u0013!B:fiV\u0003Hc\u00010\u0002$!9\u0011QE\bA\u0002\u0005\u001d\u0012\u0001\u0003;fgRLeNZ8\u0011\t\u0005%\u0012QG\u0007\u0003\u0003WQ1\u0001KA\u0017\u0015\u0011\ty#!\r\u0002\u000f),\b/\u001b;fe*\u0019\u00111G)\u0002\u000b),h.\u001b;\n\t\u0005]\u00121\u0006\u0002\t)\u0016\u001cH/\u00138g_\"\u001aq\"a\u000f\u0011\t\u0005%\u0012QH\u0005\u0005\u0003\u007f\tYC\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002=\"\u001a\u0001#a\u0012\u0011\t\u0005%\u0012\u0011J\u0005\u0005\u0003\u0017\nYCA\u0005BMR,'/R1dQ\u0006q1M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H#\u00047\u0002R\u0005U\u0013\u0011LA/\u0003k\ny\bC\u0005\u0002TE\u0001\n\u00111\u0001\u0002\u0018\u0005AA.\u001b8hKJl5\u000fC\u0005\u0002XE\u0001\n\u00111\u0001\u0002\u0018\u0005\tB-\u001a7jm\u0016\u0014\u0018\u0010V5nK>,H/T:\t\u0013\u0005m\u0013\u0003%AA\u0002\u0005]\u0011!\u00032bi\u000eD7+\u001b>f\u0011%\ty&\u0005I\u0001\u0002\u0004\t\t'A\bd_6\u0004(/Z:tS>tG+\u001f9f!\u0011\t\u0019'!\u001d\u000f\t\u0005\u0015\u0014Q\u000e\t\u0004\u0003OjTBAA5\u0015\r\tYgK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=T(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\u0019HC\u0002\u0002puB\u0011\"a\u001e\u0012!\u0003\u0005\r!!\u001f\u0002\u00155\f\u0007P\u00117pG.l5\u000fE\u0002W\u0003wJ1!! >\u0005\u0011auN\\4\t\u0013\u0005\u0005\u0015\u0003%AA\u0002\u0005e\u0014A\u00032vM\u001a,'oU5{K\u0006A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d%\u0006BA\f\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+k\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\r&\u0006BA1\u0003\u0013\u000b\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tIK\u000b\u0003\u0002z\u0005%\u0015\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0001\"/Z4jgR,'\u000f\u0015:pIV\u001cWM\u001d\u000b\u0004Y\u0006E\u0006\"B8\u0019\u0001\u0004a\u0017A\u0004;fgR\u001cVM\u001c3PM\u001a\u001cX\r\u001e\u000b\u0004=\u0006]\u0006bBA]3\u0001\u0007\u0011\u0011M\u0001\u0007cV|'/^7)\u000fe\ti,!4\u0002PB!\u0011qXAe\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005\u001d\u0017QF\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005-\u0017\u0011\u0019\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005E\u0017Q[\u0011\u0003\u0003'\f!A_6\"\u0005\u0005]\u0017!B6sC\u001a$\bfB\r\u0002\\\u0006\r\u0018Q\u001d\t\u0005\u0003;\fy.\u0004\u0002\u0002F&!\u0011\u0011]Ac\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002h\u0006A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002OQ,7\u000f^*f]\u0012\u001cu.\u001c9sKN\u001cX\rZ'fgN\fw-Z,ji\"\u001c%/Z1uKRKW.\u001a\u000b\u0004=\u00065\bbBA]5\u0001\u0007\u0011\u0011\r\u0015\b5\u0005u\u0016QZAyY\u0011\t\t.!6)\u000fi\tY.a9\u0002f\u0006QC/Z:u'\u0016tGMT8o\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,w+\u001b;i\u0007J,\u0017\r^3US6,Gc\u00010\u0002z\"9\u0011\u0011X\u000eA\u0002\u0005\u0005\u0004fB\u000e\u0002>\u00065\u0017Q \u0017\u0005\u0003#\f)\u000eK\u0004\u001c\u00037\f\u0019/!:\u0002\u001bM,g\u000eZ!oIZ+'/\u001b4z)\u001dq&Q\u0001B\u0004\u0005\u0013AQa\u001c\u000fA\u00021D\u0011\"a\u0005\u001d!\u0003\u0005\r!a\u0006\t\u0013\t-A\u0004%AA\u0002\u0005e\u0014!\u0003;j[\u0016|W\u000f^'t\u0003]\u0019XM\u001c3B]\u00124VM]5gs\u0012\"WMZ1vYR$#'A\ftK:$\u0017I\u001c3WKJLg-\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u000512/\u001a8e\u0003:$g+\u001a:jMf$\u0016.\\3ti\u0006l\u0007\u000fF\u0003_\u0005+\u00119\u0002C\u0003p?\u0001\u0007A\u000eC\u0004\u0003\u001a}\u0001\rAa\u0007\u0002\u001bQLW.Z:uC6\u0004H+\u001f9f!\u0011\u0011iBa\n\u000e\u0005\t}!\u0002\u0002B\u0011\u0005G\taA]3d_J$'b\u0001B\u0013\u001d\u000611m\\7n_:LAA!\u000b\u0003 \tiA+[7fgR\fW\u000e\u001d+za\u0016\f\u0011\u0002^3ti\u000ecwn]3\u0015\u0007y\u0013y\u0003C\u0004\u0002:\u0002\u0002\r!!\u0019)\u000f\u0001\ni,!4\u000341\"\u0011\u0011[AkQ\u001d\u0001\u00131\\Ar\u0003K\f1\u0003^3tiN+g\u000e\u001a+p!\u0006\u0014H/\u001b;j_:$2A\u0018B\u001e\u0011\u001d\tI,\ta\u0001\u0003CBs!IA_\u0003\u001b\u0014y\u0004\f\u0003\u0002R\u0006U\u0007fB\u0011\u0002\\\u0006\r\u0018Q]\u0001)i\u0016\u001cHoU3oI\n+gm\u001c:f\u0003:$\u0017I\u001a;feB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u000b\u0004=\n\u001d\u0003bBA]E\u0001\u0007\u0011\u0011\r\u0015\bE\u0005u\u0016Q\u001aB&Y\u0011\t\t.!6)\u000f\t\nY.a9\u0002f\u0006IA/Z:u\r2,8\u000f\u001b\u000b\u0004=\nM\u0003bBA]G\u0001\u0007\u0011\u0011\r\u0015\bG\u0005u\u0016Q\u001aB,Y\u0011\t\t.!6)\u000f\r\nY.a9\u0002f\u0006AC/Z:u\u00072|7/Z,ji\"TVM]8US6,w.\u001e;Ge>l7)\u00197mKJ$\u0006N]3bIR\u0019aLa\u0018\t\u000f\u0005eF\u00051\u0001\u0002b!:A%!0\u0002N\n\rD\u0006BAi\u0003+Ds\u0001JAn\u0003G\f)/\u0001\u0015uKN$8\t\\8tK^KG\u000f\u001b.fe>$\u0016.\\3pkR4%o\\7TK:$WM\u001d+ie\u0016\fG\rF\u0002_\u0005WBq!!/&\u0001\u0004\t\t\u0007K\u0004&\u0003{\u000biMa\u001c-\t\u0005E\u0017Q\u001b\u0015\bK\u0005m\u00171]As\u0001")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private Admin admin;
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(4));
        String x$2 = this.zkConnectOrNull();
        boolean x$3 = false;
        Some x$4 = new Some((Object)this.securityProtocol());
        Option<File> x$5 = this.trustStoreFile();
        Option<Properties> x$6 = this.serverSaslProperties();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$18();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(numServers, x$2, x$3, x$7, (Option<SecurityProtocol>)x$4, x$5, x$6, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), TestUtils$.MODULE$.securityConfigs(Mode.CLIENT, this.securityProtocol(), this.trustStoreFile(), "adminClient", TestUtils$.MODULE$.SslCertificateCn(), this.clientSaslProperties(), TestUtils$.MODULE$.securityConfigs$default$7(), TestUtils$.MODULE$.securityConfigs$default$8())));
        String x$1 = this.bootstrapServers(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        String x$3 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, x$5, x$6, x$7, x$2, x$8, x$9, x$10, x$11));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.admin().close();
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs, long bufferSize) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$3 = this.securityProtocol();
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.clientSaslProperties();
        int x$11 = TestUtils$.MODULE$.createProducer$default$2();
        int x$12 = TestUtils$.MODULE$.createProducer$default$5();
        int x$13 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$11, maxBlockMs, bufferSize, x$12, deliveryTimeoutMs, lingerMs, batchSize, compressionType, x$13, x$3, x$4, x$5, x$14, x$15, x$16);
        return this.registerProducer(producer);
    }

    public int createProducer$default$1() {
        return 0;
    }

    public int createProducer$default$2() {
        return 120000;
    }

    public int createProducer$default$3() {
        return 16384;
    }

    public String createProducer$default$4() {
        return "none";
    }

    public long createProducer$default$5() {
        return 60000L;
    }

    public long createProducer$default$6() {
        return 0x100000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendOffset(String quorum) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 0");
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assertions.assertEquals((long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 1");
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 2");
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 3");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0, (Callback)this.callback$2(callback$module, partition)));
            Assertions.assertEquals((long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendCompressedMessageWithCreateTime(String quorum) {
        String x$1 = "gzip";
        int x$2 = Integer.MAX_VALUE;
        int x$3 = Integer.MAX_VALUE;
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$1, x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendNonCompressedMessageWithCreateTime(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, partition, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
            } else {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            }
            Admin x$1 = this.admin();
            String x$2 = this.topic();
            Buffer<KafkaBroker> x$3 = this.brokers();
            int x$4 = 1;
            int x$5 = 2;
            Map<Object, Seq<Object>> x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$7, topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, partition, baseTimestamp, producer, callback$module, timestampType, startTime, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset(), (String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset()).toString());
        }
        finally {
            producer.close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClose(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0));
            Future response0 = producer.send(record0);
            producer.close();
            Assertions.assertTrue((boolean)response0.isDone(), (String)"The last message should be acked before producer is shutdown");
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendToPartition(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 2, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
            int partition = 1;
            long now = System.currentTimeMillis();
            ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$4);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            ((IterableLike)TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.consumeRecords$default$3()).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendBeforeAndAfterPartitionExpansion(String quorum) {
        long x$1 = 5000L;
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$52 = this.createProducer$default$4();
        long x$62 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$52, x$1, x$62);
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
        int partition0 = 0;
        ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (RecordMetadata)x$5.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$6);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get());
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        this.admin().createPartitions(Collections.singletonMap(this.topic(), NewPartitions.increaseTo((int)2))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$9(this, partition1, x$8);
            return BoxedUnit.UNIT;
        });
        ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$13(this, partition0, x$10);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFlush(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 2, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$11 -> producer.send(record), IndexedSeq$.MODULE$.canBuildFrom());
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$12))), (String)"No request is complete.");
                producer.flush();
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDone())), (String)"All requests are complete.");
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCloseWithZeroTimeoutFromCallerThread(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 2, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$14 -> producer.send(record0), IndexedSeq$.MODULE$.canBuildFrom());
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$15))), (String)"No request is complete.");
            producer.close(Duration.ZERO);
            responses.foreach((Function1 & Serializable & scala.Serializable)future -> {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(future);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((int)0, (int)this.consumer().poll(Duration.ofMillis(50L)).count(), (String)"Fetch response should have no message returned.");
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCloseWithZeroTimeoutFromSenderThread(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, BoxesRunTime.unboxToInt((Object)i)));
    }

    private final /* synthetic */ BaseProducerSendTest$callback$1$ callback$lzycompute$1(LazyRef callback$module$1, int partition$1) {
        synchronized (callback$module$1) {
            BaseProducerSendTest$callback$1$ baseProducerSendTest$callback$1$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : (BaseProducerSendTest$callback$1$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$1$(this, partition$1));
            return baseProducerSendTest$callback$1$;
        }
    }

    private final BaseProducerSendTest$callback$1$ callback$2(LazyRef callback$module$1, int partition$1) {
        if (callback$module$1.initialized()) {
            return (BaseProducerSendTest$callback$1$)callback$module$1.value();
        }
        return this.callback$lzycompute$1(callback$module$1, partition$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)partition$2, (int)recordMetadata.partition());
        Assertions.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$2(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        synchronized (callback$module$2) {
            BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : (BaseProducerSendTest$callback$3$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$3$(this, timestampType$1, baseTimestamp$1, startTime$1, partition$3));
            return baseProducerSendTest$callback$3$;
        }
    }

    private final BaseProducerSendTest$callback$3$ callback$4(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        if (callback$module$2.initialized()) {
            return (BaseProducerSendTest$callback$3$)callback$module$2.value();
        }
        return this.callback$lzycompute$2(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$3.send(record, (Callback)$this.callback$4(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ProducerRecord record = (ProducerRecord)x0$1._1();
            RecordMetadata recordMetadata = (RecordMetadata)((Future)x0$1._2()).get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                return;
            }
            Assertions.assertEquals((Long)record.timestamp(), (long)recordMetadata.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$4) {
        if (x$4 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$4._1();
            Assertions.assertEquals((long)x$4._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition$4, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)$this.topic(), (Object)record.topic());
            Assertions.assertEquals((int)partition$4, (int)record.partition());
            Assertions.assertEquals((long)i, (long)record.offset());
            Assertions.assertNull((Object)record.key());
            Assertions.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((long)now$1, (long)record.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$6) {
        if (x$6 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$6._1();
            Assertions.assertEquals((long)x$6._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$9(BaseProducerSendTest $this, int partition1$1, Tuple2 x$8) {
        if (x$8 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$8._1();
            Assertions.assertEquals((long)x$8._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition1$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$13(BaseProducerSendTest $this, int partition0$1, Tuple2 x$10) {
        if (x$10 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$10._1();
            Assertions.assertEquals((long)x$10._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$12) {
        return !x$12.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$15) {
        return !x$15.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(Future future) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get());
        Assertions.assertEquals(KafkaException.class, e.getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, KafkaProducer producer$9, ProducerRecord record$2, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, BoxesRunTime.unboxToInt((Object)x$16)));
                }
                this.producer.close(Duration.ZERO);
                this.producer.close();
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$16) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$17) {
        return !x$17.isDone();
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$3(), $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6());){
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer, record$2, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$17))), (String)"No request is complete.");
            producer.flush();
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isDone())), (String)"All requests are complete.");
            seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords($this.consumer(), $this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

