/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ResultOrError;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}h!B\u001e=\u0003\u0003\t\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0003'\u0001\u0001\u0004\u0005\r\u0011\"\u0001N\u0011%I\u0006\u00011AA\u0002\u0013\u0005!\fC\u0005b\u0001\u0001\u0007\t\u0011)Q\u0005\u001d\"9!\r\u0001b\u0001\n\u0013\u0019\u0007BB7\u0001A\u0003%A\rC\u0003o\u0001\u0011\u0005q\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0003\u0011)\tI\u0001\u0001a\u0001\u0002\u0003\u0006Ka\u001f\u0005\u0007\u0003\u0017\u0001a\u0011A'\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005=\u0001BBA\n\u0001\u0011\u0005Q\nC\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002\"CA4\u0001E\u0005I\u0011AA5\u0011\u001d\ty\b\u0001C\t\u0003\u0003Cq!a\u0013\u0001\t#\t\u0019\nC\u0004\u0002\u0016\u0002!\t\"a&\t\u000f\u0005-\u0006\u0001\"\u0005\u0002.\"9\u0011Q\u0018\u0001\u0005\u0012\u00055\u0006bBA`\u0001\u0011E\u0011\u0011\u0019\u0005\b\u0003'\u0004A\u0011IAk\u0011\u001d\t9\u0010\u0001C!\u0003\u001fAqA!\u0001\u0001\t\u0003\u0011\u0019\u0001C\u0005\u0003\u000e\u0001\t\n\u0011\"\u0001\u0003\u0010!I!1\u0003\u0001\u0012\u0002\u0013\u0005!q\u0002\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011%\u0011y\u0002AI\u0001\n\u0003\tI\u0007C\u0005\u0003\"\u0001\t\n\u0011\"\u0001\u0003$!9!q\u0005\u0001\u0005\u0002\t%\u0002\"\u0003B&\u0001E\u0005I\u0011\u0001B'\u0011%\u0011\t\u0006AI\u0001\n\u0003\u0011i\u0005C\u0005\u0003T\u0001\t\n\u0011\"\u0001\u0003$!I!Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0005/\u0002\u0011\u0013!C\u0001\u0005GAqA!\u0017\u0001\t\u0003\u0011Y\u0006C\u0005\u0003l\u0001\t\n\u0011\"\u0001\u0002j!9!Q\u000e\u0001\u0005\u0002\t=\u0004\"\u0003B;\u0001E\u0005I\u0011AA5\u0011\u001d\u00119\b\u0001C\u0001\u0005sBqAa(\u0001\t\u0003\u0011\t\u000bC\u0004\u0003(\u0002!\tA!+\t\u000f\t-\u0006\u0001\"\u0001\u0003.\"9!1\u0017\u0001\u0005\u0002\tU\u0006\"\u0003B]\u0001E\u0005I\u0011\u0001B\b\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{CqAa2\u0001\t\u0003\u0011I\rC\u0004\u0003L\u0002!\tA!4\t\u000f\t-\u0007\u0001\"\u0001\u0003b\"9!1\u001d\u0001\u0005\u0002\t\u0015\bb\u0002Bu\u0001\u0011%!1\u001e\u0005\b\u0005_\u0004A\u0011\u0002By\u0011\u001d\u00119\u0010\u0001C\u0001\u0005sDqA!@\u0001\t\u0003\tyA\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0015\tid(A\u0006j]R,wM]1uS>t'\"A \u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bz\naa]3sm\u0016\u0014\u0018BA$E\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0003\"a\u0013\u0001\u000e\u0003q\nq\"\u001b8ti\u0006t7-Z\"p]\u001aLwm]\u000b\u0002\u001dB\u0019q\n\u0016,\u000e\u0003AS!!\u0015*\u0002\u0015\r|G\u000e\\3di&|gNC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)\u0006KA\u0002TKF\u0004\"aQ,\n\u0005a#%aC&bM.\f7i\u001c8gS\u001e\f1#\u001b8ti\u0006t7-Z\"p]\u001aLwm]0%KF$\"aW0\u0011\u0005qkV\"\u0001*\n\u0005y\u0013&\u0001B+oSRDq\u0001Y\u0002\u0002\u0002\u0003\u0007a*A\u0002yIE\n\u0001#\u001b8ti\u0006t7-Z\"p]\u001aLwm\u001d\u0011\u0002\u0011}\u0013'o\\6feN,\u0012\u0001\u001a\t\u0004K\"TW\"\u00014\u000b\u0005\u001d\u0004\u0016aB7vi\u0006\u0014G.Z\u0005\u0003S\u001a\u00141\"\u0011:sCf\u0014UO\u001a4feB\u00111i[\u0005\u0003Y\u0012\u00131bS1gW\u0006\u0014%o\\6fe\u0006IqL\u0019:pW\u0016\u00148\u000fI\u0001\bEJ|7.\u001a:t+\u0005\u0001\bcA3rU&\u0011!O\u001a\u0002\u0007\u0005V4g-\u001a:\u0002\u000fM,'O^3sgV\tQ\u000fE\u0002fcZ\u0004\"aQ<\n\u0005a$%aC&bM.\f7+\u001a:wKJ\fQ!\u00197jm\u0016,\u0012a\u001f\t\u00049rt\u0018BA?S\u0005\u0015\t%O]1z!\tav0C\u0002\u0002\u0002I\u0013qAQ8pY\u0016\fg.A\u0005bY&4Xm\u0018\u0013fcR\u00191,a\u0002\t\u000f\u0001T\u0011\u0011!a\u0001w\u00061\u0011\r\\5wK\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u)\u0005Y\u0016AI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\u00063G/\u001a:TKJ4XM]:Ti\u0006\u0014H/A\u0004d_:4\u0017nZ:\u0002\u0017M,'O^3s\r>\u0014\u0018\n\u001a\u000b\u0005\u00033\ty\u0002\u0005\u0003]\u000371\u0018bAA\u000f%\n1q\n\u001d;j_:Dq!!\t\u0011\u0001\u0004\t\u0019#\u0001\u0002jIB\u0019A,!\n\n\u0007\u0005\u001d\"KA\u0002J]R\f\u0011BY8v]\u0012\u0004vN\u001d;\u0015\t\u0005\r\u0012Q\u0006\u0005\u0006\u000bF\u0001\rA^\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN$B!a\r\u0002JA!\u0011QGA\"\u001d\u0011\t9$a\u0010\u0011\u0007\u0005e\"+\u0004\u0002\u0002<)\u0019\u0011Q\b!\u0002\rq\u0012xn\u001c;?\u0013\r\t\tEU\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0013q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005#\u000bC\u0005\u0002LI\u0001\n\u00111\u0001\u0002N\u0005aA.[:uK:,'OT1nKB!\u0011qJA2\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013a\u00028fi^|'o\u001b\u0006\u0005\u0003/\nI&\u0001\u0004d_6lwN\u001c\u0006\u0004\u007f\u0005m#\u0002BA/\u0003?\na!\u00199bG\",'BAA1\u0003\ry'oZ\u0005\u0005\u0003K\n\tF\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u000ec_>$8\u000f\u001e:baN+'O^3sg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002l)\"\u0011QJA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=%\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003\u001b\u000b)&\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\t*a\"\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>dWCAA'\u00039!(/^:u'R|'/\u001a$jY\u0016,\"!!'\u0011\u000bq\u000bY\"a'\u0011\t\u0005u\u0015qU\u0007\u0003\u0003?SA!!)\u0002$\u0006\u0011\u0011n\u001c\u0006\u0003\u0003K\u000bAA[1wC&!\u0011\u0011VAP\u0005\u00111\u0015\u000e\\3\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\t\ty\u000bE\u0003]\u00037\t\t\f\u0005\u0003\u00024\u0006eVBAA[\u0015\u0011\t9,a)\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003w\u000b)L\u0001\u0006Qe>\u0004XM\u001d;jKN\fAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00032s_.,'\u000fV5nKR!\u00111YAh!\u0011\t)-a3\u000e\u0005\u0005\u001d'\u0002BAe\u0003+\nQ!\u001e;jYNLA!!4\u0002H\n!A+[7f\u0011\u001d\t\t.\u0007a\u0001\u0003G\t\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00047\u0006]\u0007bBAm5\u0001\u0007\u00111\\\u0001\ti\u0016\u001cH/\u00138g_B!\u0011Q\\Av\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018aA1qS*!\u0011Q]At\u0003\u001dQW\u000f]5uKJTA!!;\u0002`\u0005)!.\u001e8ji&!\u0011Q^Ap\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\u000e\u0002rB!\u0011Q\\Az\u0013\u0011\t)0a8\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rY\u00121 \t\u0005\u0003;\fi0\u0003\u0003\u0002\u0000\u0006}'!C!gi\u0016\u0014X)Y2i\u0003=\u0011Xm\u0019:fCR,'I]8lKJ\u001cH#B.\u0003\u0006\t%\u0001\u0002\u0003B\u00049A\u0005\t\u0019\u0001@\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u0005\t\u0005\u0017a\u0002\u0013!a\u0001}\u000691\u000f^1siV\u0004\u0018!\u0007:fGJ,\u0017\r^3Ce>\\WM]:%I\u00164\u0017-\u001e7uIE*\"A!\u0005+\u0007y\fi'A\rsK\u000e\u0014X-\u0019;f\u0005J|7.\u001a:tI\u0011,g-Y;mi\u0012\u0012\u0014AE2sK\u0006$Xm\u00144gg\u0016$8\u000fV8qS\u000e$Ra\u0017B\r\u00057A\u0011\"a\u0013 !\u0003\u0005\r!!\u0014\t\u0013\tuq\u0004%AA\u0002\u0005E\u0016!E1e[&t7\t\\5f]R\u001cuN\u001c4jO\u0006a2M]3bi\u0016|eMZ:fiN$v\u000e]5dI\u0011,g-Y;mi\u0012\n\u0014\u0001H2sK\u0006$Xm\u00144gg\u0016$8\u000fV8qS\u000e$C-\u001a4bk2$HEM\u000b\u0003\u0005KQC!!-\u0002n\u0005Y1M]3bi\u0016$v\u000e]5d)9\u0011YCa\u000e\u0003<\t}\"1\tB$\u0005\u0013\u0002\u0002B!\f\u00034\u0005\r\u00121E\u0007\u0003\u0005_Q1A!\rQ\u0003%IW.\\;uC\ndW-\u0003\u0003\u00036\t=\"aA'ba\"9!\u0011\b\u0012A\u0002\u0005M\u0012!\u0002;pa&\u001c\u0007\"\u0003B\u001fEA\u0005\t\u0019AA\u0012\u00035qW/\u001c)beRLG/[8og\"I!\u0011\t\u0012\u0011\u0002\u0003\u0007\u00111E\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\b\"\u0003B#EA\u0005\t\u0019AAY\u0003-!x\u000e]5d\u0007>tg-[4\t\u0013\u0005-#\u0005%AA\u0002\u00055\u0003\"\u0003B\u000fEA\u0005\t\u0019AAY\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uII*\"Aa\u0014+\t\u0005\r\u0012QN\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00134\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIQ\nQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$S'A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001c\u00023\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u000b\t\u0005W\u0011iFa\u0018\u0003j!9!\u0011\b\u0015A\u0002\u0005M\u0002b\u0002B1Q\u0001\u0007!1M\u0001\u001ba\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\b\u001f\n\u0015\u00141\u0005B4\u0013\r\u0011)\u0004\u0015\t\u0005\u001fR\u000b\u0019\u0003C\u0005\u0002L!\u0002\n\u00111\u0001\u0002N\u0005\u00193M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\u001a\u0014a\u00033fY\u0016$X\rV8qS\u000e$Ra\u0017B9\u0005gBqA!\u000f+\u0001\u0004\t\u0019\u0004C\u0005\u0002L)\u0002\n\u00111\u0001\u0002N\u0005)B-\u001a7fi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\u0012\u0014\u0001E1eI\u0006sGMV3sS\u001aL\u0018i\u00197t)\u0015Y&1\u0010BI\u0011\u001d\u0011i\b\fa\u0001\u0005\u007f\nA!Y2mgB1\u0011Q\u0007BA\u0005\u000bKAAa!\u0002H\t\u00191+\u001a;\u0011\t\t\u001d%QR\u0007\u0003\u0005\u0013SAAa#\u0002V\u0005\u0019\u0011m\u00197\n\t\t=%\u0011\u0012\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010C\u0004\u0003\u00142\u0002\rA!&\u0002\u0011I,7o\\;sG\u0016\u0004BAa&\u0003\u001c6\u0011!\u0011\u0014\u0006\u0005\u0005'\u000b)&\u0003\u0003\u0003\u001e\ne%a\u0004*fg>,(oY3QCR$XM\u001d8\u0002'I,Wn\u001c<f\u0003:$g+\u001a:jMf\f5\r\\:\u0015\u000bm\u0013\u0019K!*\t\u000f\tuT\u00061\u0001\u0003\u0000!9!1S\u0017A\u0002\tU\u0015\u0001E6jY2\u0014\u0016M\u001c3p[\n\u0013xn[3s)\t\t\u0019#\u0001\u0006lS2d'I]8lKJ$2a\u0017BX\u0011\u001d\u0011\tl\fa\u0001\u0003G\tQ!\u001b8eKb\f!C]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sgR\u00191La.\t\u0011\t\u001d\u0001\u0007%AA\u0002y\fAD]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sg\u0012\"WMZ1vYR$\u0013'\u0001\u0018xC&$hi\u001c:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fG\u000eV8BaB,\u0017M](o\u00032d'I]8lKJ\u001cH#B.\u0003@\n\r\u0007b\u0002Bae\u0001\u0007\u00111G\u0001\u0010G2LWM\u001c;Qe&t7-\u001b9bY\"9!Q\u0019\u001aA\u0002\u0005M\u0012!D7fG\"\fg.[:n\u001d\u0006lW-A\u0007hKR\u001cuN\u001c;s_2dWM\u001d\u000b\u0002m\u0006Yq-\u001a;U_BL7-\u00133t)\u0011\u0011yMa7\u0011\u0011\u0005U\"\u0011[A\u001a\u0005'LAA!\u000e\u0002HA!!Q\u001bBl\u001b\t\t)&\u0003\u0003\u0003Z\u0006U#\u0001B+vS\u0012DqA!85\u0001\u0004\u0011y.A\u0003oC6,7\u000f\u0005\u0003P)\u0006MBC\u0001Bh\u000359W\r\u001e+pa&\u001cg*Y7fgR\u0011!q\u001d\t\t\u0003k\u0011\tNa5\u00024\u0005i1M]3bi\u0016\u0014%o\\6feN$2a\u0017Bw\u0011\u0019\u0011Ya\u000ea\u0001}\u000612M]3bi\u0016\u0014%o\\6fe\u001a\u0013x.\\\"p]\u001aLw\rF\u0002k\u0005gDaA!>9\u0001\u00041\u0016AB2p]\u001aLw-\u0001\u0007bY&4XM\u0011:pW\u0016\u00148/\u0006\u0002\u0003|B\u0019q\n\u00166\u0002;\u0015t7/\u001e:f\u0007>t7/[:uK:$8JU1gi6+G/\u00193bi\u0006\u0004")
public abstract class KafkaServerTestHarness
extends QuorumTestHarness {
    private Seq<KafkaConfig> instanceConfigs;
    private final ArrayBuffer<KafkaBroker> _brokers = new ArrayBuffer();
    private boolean[] alive;

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    private ArrayBuffer<KafkaBroker> _brokers() {
        return this._brokers;
    }

    public Buffer<KafkaBroker> brokers() {
        return this._brokers();
    }

    public Buffer<KafkaServer> servers() {
        this.checkIsZKTest();
        return this._brokers();
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart() {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public String bootstrapServers(ListenerName listenerName) {
        return TestUtils$.MODULE$.bootstrapServers(this._brokers(), listenerName);
    }

    public ListenerName bootstrapServers$default$1() {
        return this.listenerName();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart();
        this.createBrokers(true);
        this.configureSecurityAfterServersStart();
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this._brokers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    public void recreateBrokers(boolean reconfigure, boolean startup) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        TestUtils$.MODULE$.shutdownServers(this._brokers(), false);
        this._brokers().clear();
        Arrays.fill(this.alive(), false);
        this.createBrokers(startup);
    }

    public boolean recreateBrokers$default$1() {
        return false;
    }

    public boolean recreateBrokers$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void createOffsetsTopic(ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var5_4 = resource_resource;
                TestUtils$.MODULE$.createOffsetsTopicWithAdmin((Admin)var5_4, this.brokers());
            }
            finally {
                resource_resource.close();
            }
            return;
        }
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
    }

    public ListenerName createOffsetsTopic$default$1() {
        return this.listenerName();
    }

    public Properties createOffsetsTopic$default$2() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var9_8 = resource_resource;
                map = KafkaServerTestHarness.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, (Admin)var9_8);
            }
            finally {
                resource_resource.close();
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), topicConfig);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public ListenerName createTopic$default$5() {
        return this.listenerName();
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopicWithAssignment(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3());
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var6_5 = resource_resource;
                map = KafkaServerTestHarness.$anonfun$createTopicWithAssignment$1(this, topic, partitionReplicaAssignment, (Admin)var6_5);
            }
            finally {
                resource_resource.close();
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaBroker>)this.servers());
    }

    public ListenerName createTopicWithAssignment$default$3() {
        return this.listenerName();
    }

    /*
     * WARNING - void declaration
     */
    public void deleteTopic(String topic, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3());
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var5_4 = resource_resource;
                TestUtils$.MODULE$.deleteTopicWithAdmin((Admin)var5_4, topic, this.aliveBrokers());
            }
            finally {
                resource_resource.close();
            }
            return;
        }
        this.adminZkClient().deleteTopic(topic);
    }

    public ListenerName deleteTopic$default$2() {
        return this.listenerName();
    }

    public void addAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.addAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    public void removeAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.removeAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    /*
     * WARNING - void declaration
     */
    public int killRandomBroker() {
        void var1_1;
        int index = TestUtils$.MODULE$.random().nextInt(this._brokers().length());
        this.killBroker(index);
        return (int)var1_1;
    }

    public void killBroker(int index) {
        if (this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).shutdown();
            ((KafkaBroker)this._brokers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
        }
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this._brokers().indices().withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !this.alive()[i]).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            if (reconfigure) {
                this._brokers().update(i, (Object)this.createBrokerFromConfig((KafkaConfig)this.configs().apply(i)));
            }
            ((KafkaBroker)this._brokers().apply(i)).startup();
            $this.alive()[i] = true;
        });
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this._brokers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public KafkaServer getController() {
        this.checkIsZKTest();
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds(Seq<String> names) {
        HashMap result = new HashMap();
        if (this.isKRaftTest()) {
            java.util.Map topicIdsMap = (java.util.Map)this.controllerServer().controller().findTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(names).asJava()).get();
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                ResultOrError response = (ResultOrError)topicIdsMap.get(name);
                return (Uuid)result.put(name, response.result());
            });
        } else {
            scala.collection.immutable.Map topicIdsMap = this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                if (topicIdsMap.contains(name)) {
                    return result.put(name, topicIdsMap.get(name).get());
                }
                return BoxedUnit.UNIT;
            });
        }
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        if (this.isKRaftTest()) {
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        if (this.isKRaftTest()) {
            HashMap result = new HashMap();
            ((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).entrySet().forEach(e -> result.put(e.getValue(), e.getKey()));
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicNames().toMap(Predef$.MODULE$.$conforms());
    }

    private void createBrokers(boolean startup) {
        Seq<KafkaConfig> potentiallyRegeneratedConfigs = this.configs();
        this.alive_$eq(new boolean[potentiallyRegeneratedConfigs.length()]);
        Arrays.fill(this.alive(), false);
        potentiallyRegeneratedConfigs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            KafkaServerTestHarness.$anonfun$createBrokers$1(this, startup, config);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaBroker createBrokerFromConfig(KafkaConfig config) {
        if (this.isKRaftTest()) {
            return this.createBroker(config, this.brokerTime(config.brokerId()), false, this.createBroker$default$4());
        }
        return TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId()), (Option<String>)None$.MODULE$, false, this.isZkMigrationTest() || config.migrationEnabled() && config.interBrokerProtocolVersion().isApiForwardingEnabled());
    }

    public Seq<KafkaBroker> aliveBrokers() {
        return ((SeqLike)this._brokers().filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$aliveBrokers$1(this, broker)))).toSeq();
    }

    public void ensureConsistentKRaftMetadata() {
        if (this.isKRaftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata(this.aliveBrokers(), this.controllerServer(), TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
        }
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(KafkaServerTestHarness $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Buffer<KafkaBroker> x$3 = $this.brokers();
        Map<Object, Seq<Object>> x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$3, numPartitions$1, replicationFactor$1, x$7, topicConfig$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopicWithAssignment$1(KafkaServerTestHarness $this, String topic$2, Map partitionReplicaAssignment$1, Admin admin) {
        Buffer<KafkaBroker> x$4 = $this.brokers();
        int x$5 = TestUtils$.MODULE$.createTopicWithAdmin$default$4();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        Properties x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$2, x$4, x$5, x$6, (Map<Object, Seq<Object>>)partitionReplicaAssignment$1, x$7);
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaBroker server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanismName$1, ScramCredential.class);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ void $anonfun$createBrokers$1(KafkaServerTestHarness $this, boolean startup$1, KafkaConfig config) {
        KafkaBroker broker = $this.createBrokerFromConfig(config);
        $this._brokers().$plus$eq((Object)broker);
        if (startup$1) {
            broker.startup();
            $this.alive()[$this._brokers().length() - 1] = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$aliveBrokers$1(KafkaServerTestHarness $this, KafkaBroker broker) {
        return $this.alive()[broker.config().brokerId()];
    }

    public static final /* synthetic */ Object $anonfun$deleteTopic$1$adapted(KafkaServerTestHarness $this, String topic$3, Admin admin) {
        TestUtils$.MODULE$.deleteTopicWithAdmin(admin, topic$3, $this.aliveBrokers());
        return BoxedUnit.UNIT;
    }
}

