/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-ga\u0002\u000f\u001e!\u0003\r\t\u0001\n\u0005\u0006W\u0001!\t\u0001\f\u0005\u0006=\u00011\t\u0001\r\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u001d9\u0005A1A\u0005\u0002yBq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\nC\u0004T\u0001\t\u0007I\u0011\u0001+\t\u000fm\u0003!\u0019!C\u0001}!IA\f\u0001a\u0001\u0002\u0004%\t!\u0018\u0005\nG\u0002\u0001\r\u00111A\u0005\u0002\u0011D\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00015\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0003\u0001\b\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0001t\u0011%I\b\u00011AA\u0002\u0013\u0005!\u0010C\u0003}\u0001\u0011\u0005A\u0006\u0003\u0004\u0002\u0012\u0001!\t\u0001\f\u0005\u0007\u0003+\u0001A\u0011\u0001\u0017\t\r\u0005e\u0001\u0001\"\u0001-\u0011\u0019\ti\u0002\u0001C\u0001Y!1\u0011\u0011\u0005\u0001\u0005\u00021Ba!!\n\u0001\t\u0003a\u0003BBA\u0015\u0001\u0011\u0005A\u0006\u0003\u0004\u0002.\u0001!\t\u0001\f\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011%\t9\u0006AI\u0001\n\u0003\tI\u0006C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r'A\u0005\"bg\u0016\fU\u000f\u001e5pe&TXM\u001d+fgRT!AH\u0010\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002!C\u0005A1/Z2ve&$\u0018PC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\tQ\u0006\u0005\u0002']%\u0011qf\n\u0002\u0005+:LG/F\u00012!\t\u00114(D\u00014\u0015\tqBG\u0003\u00026m\u000511/\u001a:wKJT!AI\u001c\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0005\u0003yM\u0012!\"Q;uQ>\u0014\u0018N_3s\u0003)\u0019X\u000f]3s+N,'o]\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0005Y\u0006twMC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%AB*ue&tw-\u0001\u0005vg\u0016\u0014h.Y7f\u0003%\u0001(/\u001b8dSB\fG.F\u0001K!\tY\u0015+D\u0001M\u0015\tie*\u0001\u0003bkRD'B\u0001\u0011P\u0015\t\u0001f'\u0001\u0004d_6lwN\\\u0005\u0003%2\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001W(\u0002\u0011I,\u0017/^3tiNL!AW,\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\u0006i1/\u001e9feV\u001bXM\u001d(b[\u0016\faaY8oM&<W#\u00010\u0011\u0005}\u000bW\"\u00011\u000b\u0005U\n\u0013B\u00012a\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002.K\"9a-CA\u0001\u0002\u0004q\u0016a\u0001=%c\u0005y!p\\8LK\u0016\u0004XM]\"mS\u0016tG/F\u0001j!\tQW.D\u0001l\u0015\ta\u0017%A\u0005{_>\\W-\u001a9fe&\u0011an\u001b\u0002\u00105>|7*Z3qKJ\u001cE.[3oi\u0006\u0019\"p\\8LK\u0016\u0004XM]\"mS\u0016tGo\u0018\u0013fcR\u0011Q&\u001d\u0005\bM.\t\t\u00111\u0001j\u0003!\u0011Xm]8ve\u000e,W#\u0001;\u0011\u0005U<X\"\u0001<\u000b\u0005I|\u0015B\u0001=w\u0005=\u0011Vm]8ve\u000e,\u0007+\u0019;uKJt\u0017\u0001\u0004:fg>,(oY3`I\u0015\fHCA\u0017|\u0011\u001d1W\"!AA\u0002Q\fq\u0006^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,W*\u001e7uSBdW-\u00113e\u0003:$'+Z7pm\u0016D#A\u0004@\u0011\u0007}\fi!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000f\tI!A\u0004kkBLG/\u001a:\u000b\u0007\u0005-\u0011(A\u0003kk:LG/\u0003\u0003\u0002\u0010\u0005\u0005!\u0001\u0002+fgR\f!\t^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,\u0017j]8mCRLwN\\+oe\u0016d\u0017\r^3e\t\u0016t\u0017pV8oi\u0012{W.\u001b8bi\u0016\fE\u000e\\8xQ\tya0\u0001\u0018uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/\u001a#f]f$\u0016m[3t!J,7-\u001a3f]\u000e,\u0007F\u0001\t\u007f\u0003]\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qKB\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,G)\u001a8z\t>l\u0017N\\1uK\"\u0012\u0011C`\u00018i\u0016\u001cH/Q;uQ>\u0014\u0018N_3CsJ+7o\\;sG\u0016$\u0016\u0010]3XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\u0012+g.\u001f#p[&t\u0017\r^3)\u0005Iq\u0018A\f;fgR\fU\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004XmV5uQ\u0006cGn\u00149fe\u0006$\u0018n\u001c8BG\u0016D#a\u0005@\u0002SQ,7\u000f^!vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f/&$\b.\u00117m\u0011>\u001cH/Q2fQ\t!b0\u0001\u0018uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/Z,ji\"\fE\u000e\u001c)sS:\u001c\u0017\u000e]1m\u0003\u000e,\u0007FA\u000b\u007f\u00031\"Xm\u001d;BkRDwN\u001d>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f'V\u0004XM]+tKJD\u0015m]!dG\u0016\u001c8\u000f\u000b\u0002\u0017}\u0006\tb.Z<SKF,Xm\u001d;D_:$X\r\u001f;\u0015\u000fU\u000b)$a\u000e\u0002H!)\u0001j\u0006a\u0001\u0015\"9\u0011\u0011H\fA\u0002\u0005m\u0012!D2mS\u0016tG/\u00113ee\u0016\u001c8\u000f\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\teQ\u0001\u0004]\u0016$\u0018\u0002BA#\u0003\u007f\u00111\"\u00138fi\u0006#GM]3tg\"I\u0011\u0011J\f\u0011\u0002\u0003\u0007\u00111J\u0001\u0007CBL7*Z=\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015P\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA+\u0003\u001f\u0012q!\u00119j\u0017\u0016L8/A\u000eoK^\u0014V-];fgR\u001cuN\u001c;fqR$C-\u001a4bk2$HeM\u000b\u0003\u00037RC!a\u0013\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002j\u001d\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fbkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qKRQ\u00111OA=\u0003w\ni(!$\u0011\u0007\u0019\n)(C\u0002\u0002x\u001d\u0012qAQ8pY\u0016\fg\u000eC\u0003\u001f3\u0001\u0007\u0011\u0007C\u0003T3\u0001\u0007Q\u000bC\u0004\u0002\u0000e\u0001\r!!!\u0002\u0013=\u0004XM]1uS>t\u0007\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001du*A\u0002bG2LA!a#\u0002\u0006\na\u0011i\u00197Pa\u0016\u0014\u0018\r^5p]\"9\u0011qR\rA\u0002\u0005E\u0015\u0001\u0004:fg>,(oY3UsB,\u0007cA;\u0002\u0014&\u0019\u0011Q\u0013<\u0003\u0019I+7o\\;sG\u0016$\u0016\u0010]3\u0002\u000f\u0005$G-Q2mgR9Q&a'\u0002\u001e\u0006u\u0006\"\u0002\u0010\u001b\u0001\u0004\t\u0004bBAP5\u0001\u0007\u0011\u0011U\u0001\u0005C\u000e,7\u000f\u0005\u0004\u0002$\u0006E\u0016q\u0017\b\u0005\u0003K\u000bi\u000bE\u0002\u0002(\u001ej!!!+\u000b\u0007\u0005-6%\u0001\u0004=e>|GOP\u0005\u0004\u0003_;\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00024\u0006U&aA*fi*\u0019\u0011qV\u0014\u0011\t\u0005\r\u0015\u0011X\u0005\u0005\u0003w\u000b)I\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\bBBA`5\u0001\u0007A/A\bsKN|WO]2f!\u0006$H/\u001a:o\u0003)\u0011X-\\8wK\u0006\u001bGn\u001d\u000b\t\u0003g\n)-a2\u0002J\")ad\u0007a\u0001c!9\u0011qT\u000eA\u0002\u0005\u0005\u0006BBA`7\u0001\u0007A\u000f")
public interface BaseAuthorizerTest {
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String var1);

    public Authorizer authorizer();

    public String superUsers();

    public String username();

    public KafkaPrincipal principal();

    public RequestContext requestContext();

    public String superUserName();

    public KafkaConfig config();

    public void config_$eq(KafkaConfig var1);

    public ZooKeeperClient zooKeeperClient();

    public void zooKeeperClient_$eq(ZooKeeperClient var1);

    public ResourcePattern resource();

    public void resource_$eq(ResourcePattern var1);

    public static /* synthetic */ void testAuthorizeByResourceTypeMultipleAddAndRemove$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeMultipleAddAndRemove();
    }

    @Test
    default public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
            this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
                this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
                Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            });
            this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
        });
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow();
    }

    @Test
    default public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.GROUP, "s", PatternType.PREFIXED);
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl7 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl6, acl7}))), resource1);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl4}))), resource2);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), resource3);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host2 should not have READ access to any consumer group");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.CLUSTER), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should have READ access to at least one topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeDenyTakesPrecedence$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeDenyTakesPrecedence();
    }

    @Test
    default public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should have WRITE access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should not have WRITE access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypePrefixedResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypePrefixedResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern a = new ResourcePattern(ResourceType.GROUP, "a", PatternType.PREFIXED);
        ResourcePattern ab = new ResourcePattern(ResourceType.GROUP, "ab", PatternType.PREFIXED);
        ResourcePattern abc = new ResourcePattern(ResourceType.GROUP, "abc", PatternType.PREFIXED);
        ResourcePattern abcd = new ResourcePattern(ResourceType.GROUP, "abcd", PatternType.PREFIXED);
        ResourcePattern abcde = new ResourcePattern(ResourceType.GROUP, "abcde", PatternType.PREFIXED);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abcde);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 should have READ access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), abcd);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abc);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), a);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), ab);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 still should not have READ access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWildcardResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWildcardResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern wildcard = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern prefixed = new ResourcePattern(ResourceType.GROUP, "hello", PatternType.PREFIXED);
        ResourcePattern literal = new ResourcePattern(ResourceType.GROUP, "aloha", PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), prefixed);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 should have WRITE access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 now should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), literal);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllOperationAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllOperationAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllOperationAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        AccessControlEntry allowAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyWrite = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWrite, allowAll}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAll}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllHostAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllHostAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllHostAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        String allHost = AclEntry$.MODULE$.WildcardHost();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowHost1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyHost1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllHost}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllPrincipalAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllPrincipalAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        String allUser = AclEntry$.MODULE$.WildcardPrincipalString();
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u2h1Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowUser1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyUser1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllUser}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorzeByResourceTypeSuperUserHasAccess$(BaseAuthorizerTest $this) {
        $this.testAuthorzeByResourceTypeSuperUserHasAccess();
    }

    @Test
    default public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        AccessControlEntry denyAllAce = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        KafkaPrincipal superUser1 = new KafkaPrincipal("User", this.superUserName());
        InetAddress host1 = InetAddress.getByName("192.0.4.4");
        ResourcePattern allTopicsResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL);
        ResourcePattern groupResource = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern transactionIdResource = new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "*", PatternType.LITERAL);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), allTopicsResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), clusterResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), groupResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), transactionIdResource);
        RequestContext superUserContext = this.newRequestContext(superUser1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TOPIC), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.CLUSTER), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.GROUP), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"superuser always has access, no matter what acls.");
    }

    public static /* synthetic */ RequestContext newRequestContext$(BaseAuthorizerTest $this, KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return $this.newRequestContext(principal, clientAddress, apiKey);
    }

    default public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY, false);
    }

    public static /* synthetic */ ApiKeys newRequestContext$default$3$(BaseAuthorizerTest $this) {
        return $this.newRequestContext$default$3();
    }

    default public ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public static /* synthetic */ boolean authorizeByResourceType$(BaseAuthorizerTest $this, Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return $this.authorizeByResourceType(authorizer, requestContext, operation, resourceType);
    }

    default public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        AuthorizationResult authorizationResult = authorizer.authorizeByResourceType((AuthorizableRequestContext)requestContext, operation, resourceType);
        AuthorizationResult authorizationResult2 = AuthorizationResult.ALLOWED;
        return !(authorizationResult != null ? !authorizationResult.equals(authorizationResult2) : authorizationResult2 != null);
    }

    public static /* synthetic */ void addAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        $this.addAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (AclCreateResult)x$1.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            BaseAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean removeAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        return $this.removeAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter(), Set$.MODULE$.canBuildFrom());
        return ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (AclDeleteResult)x$2.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)BaseAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    public static /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
        result.aclBindingDeleteResults().forEach(r -> r.exception().ifPresent(e -> {
            throw e;
        }));
        return !result.aclBindingDeleteResults().isEmpty();
    }

    public static void $init$(BaseAuthorizerTest $this) {
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq("User:superuser1; User:superuser2");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq("alice");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(new KafkaPrincipal("User", $this.username()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq($this.newRequestContext($this.principal(), InetAddress.getByName("192.168.0.1"), $this.newRequestContext$default$3()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq("superuser1");
    }
}

