/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import kafka.server.ConfigAdminManager;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004>\u0001\u0001\u0006I!\u000e\u0005\u0006}\u0001!\ta\u0010\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006U\u0002!\tA\u0014\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006g\u0002!\t\u0001\u001c\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0011\u0019a\b\u0001)A\u0005m\")Q\u0010\u0001C\u0001}\"1\u00111\u0004\u0001\u0005\u0002yDa!a\b\u0001\t\u0003q\bBBA\u0012\u0001\u0011\u0005a\u0010\u0003\u0004\u0002(\u0001!\tA \u0005\u0007\u0003W\u0001A\u0011\u0001@\t\r\u0005=\u0002\u0001\"\u0001\u007f\u0011\u0019\t\u0019\u0004\u0001C\u0001\u001d\"1\u0011Q\u0007\u0001\u0005\u00029Ca!a\u000e\u0001\t\u0003q\bBBA\u001e\u0001\u0011\u0005a\u0010\u0003\u0004\u0002@\u0001!\tA \u0005\u0007\u0003\u0007\u0002A\u0011\u0001@\t\r\u0005\u001d\u0003\u0001\"\u0001m\u0011\u0019\tI\u0005\u0001C\u0001Y\"1\u00111\n\u0001\u0005\u0002yDa!a\u0014\u0001\t\u0003q\bBBA*\u0001\u0011\u0005a\u0010\u0003\u0004\u0002X\u0001!\tA\u0014\u0005\u0007\u00033\u0002A\u0011\u00017\t\r\u0005m\u0003\u0001\"\u0001\u007f\u0011\u0019\ty\u0006\u0001C\u0001}\"1\u00111\r\u0001\u0005\u0002y\u0014acQ8oM&<\u0017\tZ7j]6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003I\u0015\naa]3sm\u0016\u0014(\"\u0001\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u0005\u0019\u0013A\u00027pO\u001e,'/F\u00016!\t14(D\u00018\u0015\tA\u0014(A\u0003tY\u001a$$NC\u0001;\u0003\ry'oZ\u0005\u0003y]\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0016]\u0016<8i\u001c8gS\u001e\fE-\\5o\u001b\u0006t\u0017mZ3s)\t\u00015\t\u0005\u00023\u0003&\u0011!i\t\u0002\u0013\u0007>tg-[4BI6Lg.T1oC\u001e,'\u000fC\u0003E\t\u0001\u0007Q)\u0001\u0005ce>\\WM]%e!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013q!\u00138uK\u001e,'/\u0001\nce>\\WM\u001d\u0019J]\u000e\u0014X-\\3oi\u0006dG#A(\u0011\u0005A;gBA)e\u001d\t\u0011\u0016M\u0004\u0002T=:\u0011A\u000b\u0018\b\u0003+js!AV-\u000e\u0003]S!\u0001W\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014BA.:\u0003\u0019\t\u0007/Y2iK&\u0011a%\u0018\u0006\u00037fJ!a\u00181\u0002\r\r|W.\\8o\u0015\t1S,\u0003\u0002cG\u00069Q.Z:tC\u001e,'BA0a\u0013\t)g-\u0001\u0012J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0003E\u000eL!\u0001[5\u0003)\u0005cG/\u001a:D_:4\u0017nZ:SKN|WO]2f\u0015\t)g-A\tu_BL7-Q%oGJ,W.\u001a8uC2\fQB\u0019:pW\u0016\u0014\b\u0007T3hC\u000eLH#A7\u0011\u00059\fhBA)p\u0013\t\u0001h-A\fBYR,'oQ8oM&<7OU3rk\u0016\u001cH\u000fR1uC&\u0011\u0001N\u001d\u0006\u0003a\u001a\fA\u0002^8qS\u000e\fE*Z4bGf\f1#\u001b8wC2LGMU3rk\u0016\u001cH/\u0012:s_J,\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u000e\f\u0001B]3rk\u0016\u001cHo]\u0005\u0003wb\u0014\u0001\"\u00119j\u000bJ\u0014xN]\u0001\u0015S:4\u0018\r\\5e%\u0016\fX/Z:u\u000bJ\u0014xN\u001d\u0011\u0002SQ,7\u000f^\"paf<\u0016\u000e\u001e5pkR\u0004&/\u001a9s_\u000e,7o]3e\r>\u0014\u0018J\\2sK6,g\u000e^1m)\u0005y\bc\u0001\u0016\u0002\u0002%\u0019\u00111A\u0016\u0003\tUs\u0017\u000e\u001e\u0015\u0004\u0017\u0005\u001d\u0001\u0003BA\u0005\u0003/i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0004CBL'\u0002BA\t\u0003'\tqA[;qSR,'OC\u0002\u0002\u0016e\nQA[;oSRLA!!\u0007\u0002\f\t!A+Z:u\u0003\u0011\"Xm\u001d;D_BLx+\u001b;i_V$\bK]3qe>\u001cWm]:fI\u001a{'\u000fT3hC\u000eL\bf\u0001\u0007\u0002\b\u0005\tC/Z:u%\u0016\f7o]3nE2,\u0017J\\2sK6,g\u000e^1m%\u0016\u001c\bo\u001c8tK\"\u001aQ\"a\u0002\u00029Q,7\u000f\u001e*fCN\u001cX-\u001c2mK2+w-Y2z%\u0016\u001c\bo\u001c8tK\"\u001aa\"a\u0002\u0002OQ,7\u000f\u001e,bY&$\u0017\r^3SKN|WO]2f\u001d\u0006lW-S:DkJ\u0014XM\u001c;O_\u0012,\u0017\n\u001a\u0015\u0004\u001f\u0005\u001d\u0011a\u0007;fgR4\u0016\r\\5eCR,Gj\\4MKZ,GnQ8oM&<7\u000fK\u0002\u0011\u0003\u000f\tq\u0004^3tiZ\u000bG.\u001b3bi\u0016\u0014vn\u001c;M_\u001edUM^3m\u0007>tg-[4tQ\r\t\u0012qA\u0001\u0019EJ|7.\u001a:M_\u001e<WM]\u0019J]\u000e\u0014X-\\3oi\u0006d\u0017\u0001\u00072s_.,'\u000fT8hO\u0016\u0014('\u00138de\u0016lWM\u001c;bY\u0006aD/Z:u!J,\u0007O]8dKN\u001c\u0018J\\2sK6,g\u000e^1m/&$\b.\u00168bkRDwN]5{K\u0012\u0014%o\\6fe2{wmZ3s\u0007\"\fgnZ3tQ\r!\u0012qA\u0001#i\u0016\u001cH\u000f\u0015:faJ|7-Z:t\u0013:\u001c'/Z7f]R\fGnV5uQ:+H\u000e\\:)\u0007U\t9!\u0001\u0016uKN$\bK]3qe>\u001cWm]:J]\u000e\u0014X-\\3oi\u0006dw+\u001b;i\u0019><w-\u001a:DQ\u0006tw-Z:)\u0007Y\t9!A\u0014uKN$\bK]3qe>\u001cWm]:J]\u000e\u0014X-\\3oi\u0006dw+\u001b;i\tV\u0004H.[2bi\u0016\u001c\bfA\f\u0002\b\u0005\u0019\"M]8lKJdunZ4feFbUmZ1ds\u0006i!M]8lKJ\u0014D*Z4bGf\f1\u0006^3tiB\u0013X\r\u001d:pG\u0016\u001c8\u000fT3hC\u000eLx+\u001b;i\u0005J|7.\u001a:M_\u001e<WM]\"iC:<Wm\u001d\u0015\u00045\u0005\u001d\u0011!\b;fgR\u0004&/\u001a9s_\u000e,7o\u001d'fO\u0006\u001c\u0017pV5uQ:+H\u000e\\:)\u0007m\t9!\u0001\u0012uKN$\bK]3qe>\u001cWm]:MK\u001e\f7-_,ji\"$U\u000f\u001d7jG\u0006$Xm\u001d\u0015\u00049\u0005\u001d\u0011AE;oW:|wO\\%oGJ,W.\u001a8uC2\fQ\"\u001e8l]><h\u000eT3hC\u000eL\u0018\u0001\f;fgR\u0004&/\u001a9s_\u000e,7o]%oGJ,W.\u001a8uC2<\u0016\u000e\u001e5V].twn\u001e8SKN|WO]2fQ\ry\u0012qA\u0001(i\u0016\u001cH\u000f\u0015:faJ|7-Z:t\u0019\u0016<\u0017mY=XSRDWK\\6o_^t'+Z:pkJ\u001cW\rK\u0002!\u0003\u000f\ta\u0003^3ti\u000e{g\u000e^1j]N$U\u000f\u001d7jG\u0006$Xm\u001d\u0015\u0004C\u0005\u001d\u0001")
public class ConfigAdminManagerTest {
    private final Logger logger = LoggerFactory.getLogger(ConfigAdminManagerTest.class);
    private final ApiError invalidRequestError = new ApiError(Errors.INVALID_REQUEST);

    public Logger logger() {
        return this.logger;
    }

    public ConfigAdminManager newConfigAdminManager(Integer brokerId) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(Predef$.MODULE$.Integer2int(brokerId), null, TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        return new ConfigAdminManager(Predef$.MODULE$.Integer2int(brokerId), new KafkaConfig((Map)config), (ConfigRepository)new MockConfigRepository());
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource broker0Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource topicAIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker0Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource topicALegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    public ApiError invalidRequestError() {
        return this.invalidRequestError;
    }

    @Test
    public void testCopyWithoutPreprocessedForIncremental() {
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0.duplicate(), topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed2));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed3));
    }

    @Test
    public void testCopyWithoutPreprocessedForLegacy() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData request = new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0.duplicate(), topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed2));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed3));
    }

    @Test
    public void testReassembleIncrementalResponse() {
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData original = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        IncrementalAlterConfigsResponseData persistentResponses1 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleIncrementalResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        IncrementalAlterConfigsResponseData persistentResponses2 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleIncrementalResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testReassembleLegacyResponse() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData original = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        AlterConfigsResponseData persistentResponses1 = new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        AlterConfigsResponseData persistentResponses2 = new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testValidateResourceNameIsCurrentNodeId() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateResourceNameIsCurrentNodeId("5");
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: ", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("")).getMessage());
        Assertions.assertEquals((Object)"Unexpected broker id, expected 5, but received 3", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("3")).getMessage());
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: e", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("e")).getMessage());
    }

    @Test
    public void testValidateLogLevelConfigs() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("TRACE")}));
        manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.DELETE.id()).setValue("")}));
        Assertions.assertEquals((Object)"APPEND operation is not allowed for the BROKER_LOGGER resource", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.APPEND.id()).setValue("TRACE")}))).getMessage());
        Assertions.assertEquals((Object)new StringBuilder(95).append("Cannot set the log level of ").append(this.logger().getName()).append(" to BOGUS as it is not ").append("a supported log level. Valid log levels are ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(LogLevelConfig.VALID_LOG_LEVELS).asScala()).mkString(", ")).toString(), (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("BOGUS")}))).getMessage());
    }

    @Test
    public void testValidateRootLogLevelConfigs() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(Log4jController$.MODULE$.ROOT_LOGGER()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("TRACE")}));
        Assertions.assertEquals((Object)new StringBuilder(52).append("Removing the log level of the ").append(Log4jController$.MODULE$.ROOT_LOGGER()).append(" logger is not allowed").toString(), (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateLogLevelConfigs(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(Log4jController$.MODULE$.ROOT_LOGGER()).setConfigOperation(AlterConfigOp.OpType.DELETE.id()).setValue("")}))).getMessage());
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null).setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator())), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(x$1, x$2))));
    }

    @Test
    public void testPreprocessIncrementalWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.brokerLogger2Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger2}).iterator())), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithNulls$1(x$3, x$4))));
    }

    @Test
    public void testPreprocessIncrementalWithLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.NONE, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator())), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithLoggerChanges$1(x$5, x$6))));
    }

    @Test
    public void testPreprocessIncrementalWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Incremental();
        IdentityHashMap output = manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1a, brokerLogger1b}).iterator())), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$1(x$7, x$8)));
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$2(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public AlterConfigsRequestData.AlterConfigsResource brokerLogger1Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO")}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker2Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null)}).iterator()));
    }

    @Test
    public void testPreprocessLegacyWithBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 8")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.broker2Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger2}).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Legacy();
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Legacy();
        IdentityHashMap output = manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1a, brokerLogger1b}).iterator())));
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessLegacyWithDuplicates$1(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource unknownIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource unknownLegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource unknown = this.unknownIncremental();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{unknown}).iterator())), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnknownResource$1(x$9, x$10))));
    }

    @Test
    public void testPreprocessLegacyWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource unknown = this.unknownLegacy();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{unknown}).iterator()))));
    }

    @Test
    public void testContainsDuplicates() {
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)Nil$.MODULE$));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)Nil$.MODULE$)))));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))))));
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(ResourceType x$1, String x$2) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithNulls$1(ResourceType x$3, String x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithLoggerChanges$1(ResourceType x$5, String x$6) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithDuplicates$1(ResourceType x$7, String x$8) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$testPreprocessIncrementalWithDuplicates$2(IdentityHashMap output$1, IncrementalAlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$1.get(r));
    }

    public static final /* synthetic */ void $anonfun$testPreprocessLegacyWithDuplicates$1(IdentityHashMap output$2, AlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$2.get(r));
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnknownResource$1(ResourceType x$9, String x$10) {
        return false;
    }
}

