/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!)!\u0005\u0001C!G!)Q\u0006\u0001C\u0001]!)q\b\u0001C\u0001]!)\u0011\t\u0001C\u0001\u0005\")\u0011\u000b\u0001C\u0001]!)1\u000b\u0001C\u0001]!)Q\u000b\u0001C\u0001-\")q\f\u0001C\u0005A\")!\r\u0001C\u0005G\n\u0019c)\u001a;dQJ+\u0017/^3ti\n+Go^3f]\u0012KgMZ3sK:$\u0018J\u00199UKN$(B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005i\u0011B\u0001\f\u000e\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001a!\t!\u0002!A\u0006ce>\\WM]\"pk:$X#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\u0007%sG/A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005!\u0003cA\u0013)U5\taE\u0003\u0002(=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005%2#aA*fcB\u0011AcK\u0005\u0003Y5\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006!B/Z:u\u0007>tGO]8mY\u0016\u0014x\n\u001c3J\u0005B#\u0012a\f\t\u0003;AJ!!\r\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u0003\tM\u0002\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\u0007\u0005\u0004\u0018N\u0003\u00029s\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001e<\u0003\u0015QWO\\5u\u0015\u0005a\u0014aA8sO&\u0011a(\u000e\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$8i\u001c8ue>dG.\u001a:OK^L%\t\u0015\u0015\u0003\u000bM\n!\u0004^3ti\u000e{g\u000e\u001e:pY2,'oV5uQ\u001eKg/\u001a8J\u0005B#2aL\"P\u0011\u0015!e\u00011\u0001F\u0003\u001d1XM]:j_:\u0004\"AR'\u000e\u0003\u001dS!\u0001S%\u0002\r\r|W.\\8o\u0015\tq!J\u0003\u0002\u0011\u0017*\u0011AjO\u0001\u0007CB\f7\r[3\n\u00059;%aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\t\u000bA3\u0001\u0019\u0001\u000f\u0002!\r|g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014\u0018!\u0007;fgR\u001cuN\u001c;s_2dWM\u001d(foR{w\n\u001c3J\u0005BC#aB\u001a\u00023Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe>cG\rV8OK^L%\t\u0015\u0015\u0003\u0011M\n!\u0004^3ti\u000e{g\u000e\u001e:pY2,'oU<ji\u000eD\u0017N\\4J\u0005B#RaL,Z7vCQ\u0001W\u0005A\u0002\u0015\u000b\u0001B^3sg&|g.\r\u0005\u00065&\u0001\r\u0001H\u0001\bEJ|7.\u001a:2\u0011\u0015a\u0016\u00021\u0001F\u0003!1XM]:j_:\u0014\u0004\"\u00020\n\u0001\u0004a\u0012a\u00022s_.,'OM\u0001\u0018K:\u001cXO]3D_:$(o\u001c7mKJ<\u0016\u000e\u001e5J\u0005B#\"aL1\t\u000b\u0011S\u0001\u0019A#\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0007)\"g\rC\u0003f\u0017\u0001\u0007A$\u0001\u0004o_\u0012,\u0017\n\u001a\u0005\u0006O.\u0001\r!R\u0001\u0013S:$XM\u001d\"s_.,'OV3sg&|g\u000e")
public class FetchRequestBetweenDifferentIbpTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)this.createConfig(0, MetadataVersion.IBP_2_7_IV0), (List)new .colon.colon((Object)this.createConfig(1, MetadataVersion.IBP_2_8_IV1), (List)new .colon.colon((Object)this.createConfig(2, MetadataVersion.IBP_3_1_IV0), (List)Nil$.MODULE$)));
    }

    @Test
    public void testControllerOldIBP() {
        this.testControllerWithGivenIBP(MetadataVersion.IBP_2_7_IV0, 0);
    }

    @Test
    public void testControllerNewIBP() {
        this.testControllerWithGivenIBP(MetadataVersion.IBP_3_1_IV0, 2);
    }

    public void testControllerWithGivenIBP(MetadataVersion version, int controllerBroker) {
        String topic = "topic";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.ensureControllerWithIBP(version);
        Assertions.assertEquals((int)controllerBroker, (int)this.controllerSocketServer().config().brokerId());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        producer.send(record2);
        consumer.assign(Arrays.asList((Object[])new TopicPartition[]{new TopicPartition(topic, 0), new TopicPartition(topic, 1)}));
        int count = consumer.poll(Duration.ofMillis(5000L)).count() + consumer.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertEquals((int)2, (int)count);
    }

    @Test
    public void testControllerNewToOldIBP() {
        this.testControllerSwitchingIBP(MetadataVersion.IBP_3_1_IV0, 2, MetadataVersion.IBP_2_7_IV0, 0);
    }

    @Test
    public void testControllerOldToNewIBP() {
        this.testControllerSwitchingIBP(MetadataVersion.IBP_2_7_IV0, 0, MetadataVersion.IBP_3_1_IV0, 2);
    }

    public void testControllerSwitchingIBP(MetadataVersion version1, int broker1, MetadataVersion version2, int broker2) {
        String topic = "topic";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.ensureControllerWithIBP(version1);
        Assertions.assertEquals((int)broker1, (int)this.controllerSocketServer().config().brokerId());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        producer.send(record2);
        consumer.assign(Arrays.asList((Object[])new TopicPartition[]{new TopicPartition(topic, 0), new TopicPartition(topic, 1)}));
        int count = consumer.poll(Duration.ofMillis(5000L)).count() + consumer.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertEquals((int)2, (int)count);
        this.ensureControllerWithIBP(version2);
        Assertions.assertEquals((int)broker2, (int)this.controllerSocketServer().config().brokerId());
        this.createTopicWithAssignment(topic2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic2, 1);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        ProducerRecord record3 = new ProducerRecord(topic2, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record4 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record3);
        producer.send(record4);
        consumer.assign(Arrays.asList((Object[])new TopicPartition[]{new TopicPartition(topic, 0), new TopicPartition(topic, 1), new TopicPartition(topic2, 0)}));
        int count2 = consumer.poll(Duration.ofMillis(5000L)).count() + consumer.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertEquals((int)2, (int)count2);
    }

    private void ensureControllerWithIBP(MetadataVersion version) {
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestBetweenDifferentIbpTest.$anonfun$ensureControllerWithIBP$1(version, x$1)));
        nonControllerServers.iterator().foreach((Function1 & Serializable & scala.Serializable)server -> {
            server.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        nonControllerServers.iterator().foreach((Function1 & Serializable & scala.Serializable)server -> {
            server.startup();
            return BoxedUnit.UNIT;
        });
    }

    private KafkaConfig createConfig(int nodeId, MetadataVersion interBrokerVersion) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerVersion.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ boolean $anonfun$ensureControllerWithIBP$1(MetadataVersion version$1, KafkaServer x$1) {
        MetadataVersion metadataVersion = x$1.config().interBrokerProtocolVersion();
        return metadataVersion == null ? version$1 != null : !metadataVersion.equals(version$1);
    }
}

