/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.junit.jupiter.api.Assertions;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;

public final class PlaintextAdminIntegrationTest$ {
    public static PlaintextAdminIntegrationTest$ MODULE$;

    static {
        new PlaintextAdminIntegrationTest$();
    }

    public void checkValidAlterConfigs(Admin admin, KafkaServerTestHarness test, ConfigResource topicResource1, ConfigResource topicResource2) {
        java.util.List topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), (List)Nil$.MODULE$)).asJava();
        java.util.List topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), (List)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), (List)Nil$.MODULE$))).asJava();
        AlterConfigsResult alterResult = admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2))}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        test.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"1000", (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MessageMaxBytes()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)"lz4", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MaxMessageBytesProp(), "10"), (List)Nil$.MODULE$)).asJava();
        topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.3"), (List)Nil$.MODULE$)).asJava();
        alterResult = admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        test.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MessageMaxBytes()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp()).value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
    }

    public void checkInvalidAlterConfigs(KafkaServerTestHarness test, Admin admin) {
        String topic1 = "invalid-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic1, test.brokers(), 1, 1, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
        String topic2 = "invalid-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic2, test.brokers(), 1, 1, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
        java.util.List topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), (List)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), (List)Nil$.MODULE$))).asJava();
        java.util.List topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), (List)Nil$.MODULE$)).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaBroker)test.brokers().head()).config().brokerId()));
        java.util.List brokerConfigEntries = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181"), (List)Nil$.MODULE$)).asJava();
        AlterConfigsResult alterResult = admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), InvalidConfigurationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        test.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$)))).asJava()).all().get();
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"snappy", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.CompressionTypeProp()).value());
        topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), (List)Nil$.MODULE$)).asJava();
        alterResult = admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), InvalidConfigurationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        test.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$)))).asJava()).all().get();
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"snappy", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.CompressionTypeProp()).value());
    }

    private PlaintextAdminIntegrationTest$() {
        MODULE$ = this;
    }
}

