/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00115b\u0001B5k\u0001=DQA\u001e\u0001\u0005\u0002]D\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011A>\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003'\u0001\u0001\u0019!A!B\u0013a\b\"CA\u000b\u0001\t\u0007I\u0011AA\f\u0011!\tI\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0016\u0001\t\u0007I\u0011AA\f\u0011!\ti\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0018\u0001\t\u0007I\u0011AA\u0019\u0011!\tI\u0005\u0001Q\u0001\n\u0005M\u0002\"CA&\u0001\t\u0007I\u0011AA'\u0011!\t)\u0006\u0001Q\u0001\n\u0005=\u0003\"CA,\u0001\t\u0007I\u0011AA-\u0011!\t9\u0007\u0001Q\u0001\n\u0005m\u0003\u0002C6\u0001\u0005\u0004%\t!!\u001b\t\u0011\u0005E\u0004\u0001)A\u0005\u0003WBq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\u000e\u0002!\t!!\u001e\u0007\r\u0005]\u0005\u0001QAM\u0011)\t9k\u0005BK\u0002\u0013\u0005\u0011\u0011\u0016\u0005\u000b\u0003\u0003\u001c\"\u0011#Q\u0001\n\u0005-\u0006BCAb'\tU\r\u0011\"\u0001\u0002*\"Q\u0011QY\n\u0003\u0012\u0003\u0006I!a+\t\rY\u001cB\u0011AAd\u0011\u001d\t\tn\u0005C\u0001\u0003'D\u0011\"!=\u0014#\u0003%\t!a=\t\u0013\t%1#!A\u0005\u0002\t-\u0001\"\u0003B\t'E\u0005I\u0011\u0001B\n\u0011%\u00119bEI\u0001\n\u0003\u0011\u0019\u0002C\u0005\u0003\u001aM\t\t\u0011\"\u0011\u0003\u001c!I!qE\n\u0002\u0002\u0013\u0005!\u0011\u0006\u0005\n\u0005c\u0019\u0012\u0011!C\u0001\u0005gA\u0011B!\u0010\u0014\u0003\u0003%\tEa\u0010\t\u0013\t53#!A\u0005\u0002\t=\u0003\"\u0003B-'\u0005\u0005I\u0011\tB.\u0011%\u0011ifEA\u0001\n\u0003\u0012y\u0006C\u0005\u0003bM\t\t\u0011\"\u0011\u0003d\u001d9!q\r\u0001\t\u0002\t%daBAL\u0001!\u0005!1\u000e\u0005\u0007m\u001e\"\tA!\u001c\t\u000f\t=t\u0005\"\u0001\u0003r!I!1P\u0014\u0002\u0002\u0013\u0005%Q\u0010\u0005\n\u0005\u0007;\u0013\u0011!CA\u0005\u000bCqAa&\u0001\t\u0013\u0011I\nC\u0004\u00034\u0002!IA!.\t\u000f\tu\u0006\u0001\"\u0003\u0003@\"I!\u0011\u001a\u0001\u0012\u0002\u0013%!1\u001a\u0005\n\u0005\u001f\u0004\u0011\u0013!C\u0005\u0003gDqA!5\u0001\t\u0013\u0011\u0019\u000eC\u0005\u0003|\u0002\t\n\u0011\"\u0003\u0003L\"I!Q \u0001\u0012\u0002\u0013%\u00111\u001f\u0005\n\u0005\u007f\u0004\u0011\u0013!C\u0005\u0007\u0003A\u0011b!\u0002\u0001#\u0003%Iaa\u0002\t\u0013\r-\u0001!%A\u0005\n\r5\u0001\"CB\t\u0001E\u0005I\u0011BB\u0004\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0003kBqa!\b\u0001\t\u0003\t)\bC\u0004\u0004\"\u0001!\t!!\u001e\t\u000f\r\u0015\u0002\u0001\"\u0001\u0002v!91\u0011\u0006\u0001\u0005\u0002\u0005U\u0004bBB\u0017\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0007c\u0001A\u0011AA;\u0011\u001d\u0019)\u0004\u0001C\u0001\u0003kBqa!\u000f\u0001\t\u0003\t)\bC\u0004\u0004>\u0001!\t!!\u001e\t\u000f\r\u0005\u0003\u0001\"\u0001\u0002v!91Q\t\u0001\u0005\u0002\u0005U\u0004bBB%\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0007\u001b\u0002A\u0011BB(\u0011\u001d\u0019)\u0006\u0001C\u0001\u0003kBqa!\u0017\u0001\t\u0003\t)\bC\u0004\u0004^\u0001!Iaa\u0018\t\u000f\r\r\u0004\u0001\"\u0001\u0002v!91q\r\u0001\u0005\u0002\u0005U\u0004bBB6\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0007_\u0002A\u0011AA;\u0011\u001d\u0019\u0019\b\u0001C\u0001\u0003kBqaa\u001e\u0001\t\u0003\t)\bC\u0004\u0004|\u0001!\t!!\u001e\t\u000f\r}\u0004\u0001\"\u0001\u0002v!911\u0011\u0001\u0005\n\r\u0015\u0005bBBH\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0007'\u0003A\u0011AA;\u0011\u001d\u00199\n\u0001C\u0001\u0003kBqaa'\u0001\t\u0003\t)\bC\u0004\u0004 \u0002!\t!!\u001e\t\u000f\r\r\u0006\u0001\"\u0001\u0002v!91q\u0015\u0001\u0005\u0002\u0005U\u0004bBBV\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0007_\u0003A\u0011AA;\u0011\u001d\u0019\u0019\f\u0001C\u0001\u0003kBqaa.\u0001\t\u0003\t)\bC\u0004\u0004<\u0002!\t!!\u001e\t\u000f\r}\u0006\u0001\"\u0001\u0002v!911\u0019\u0001\u0005\u0002\u0005U\u0004bBBd\u0001\u0011%1\u0011\u001a\u0005\n\t\u000b\u0001\u0011\u0013!C\u0005\t\u000fA\u0011\u0002b\u0003\u0001#\u0003%I\u0001\"\u0004\t\u0013\u0011E\u0001!%A\u0005\n\u0005M\b\"\u0003C\n\u0001E\u0005I\u0011BB\u0007\u0011%!)\u0002AI\u0001\n\u0013!9\u0002C\u0005\u0005\u001c\u0001\t\n\u0011\"\u0003\u0005\u001e!IA\u0011\u0005\u0001\u0012\u0002\u0013%A1\u0005\u0005\n\tO\u0001\u0011\u0013!C\u0005\tS\u0011A\u0002T8dC2dun\u001a+fgRT!a\u001b7\u0002\u00071|wMC\u0001n\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00019\u0011\u0005E$X\"\u0001:\u000b\u0003M\fQa]2bY\u0006L!!\u001e:\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0010\u0005\u0002z\u00015\t!.\u0001\u0004d_:4\u0017nZ\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a 7\u0002\rM,'O^3s\u0013\r\t\u0019A \u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!!\u0003\u0002\u0010A\u0019\u0011/a\u0003\n\u0007\u00055!O\u0001\u0003V]&$\b\u0002CA\t\u0007\u0005\u0005\t\u0019\u0001?\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\rQl\u0007\u000fR5s+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0005%|'BAA\u0012\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0012Q\u0004\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u00024A!\u0011QGA#\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012AB2p[6|gNC\u0002n\u0003{QA!a\u0010\u0002B\u00051\u0011\r]1dQ\u0016T!!a\u0011\u0002\u0007=\u0014x-\u0003\u0003\u0002H\u0005]\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\"!a\u0014\u0011\u0007u\f\t&C\u0002\u0002Ty\u0014A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eI\u0001\t[>\u001c7\u000eV5nKV\u0011\u00111\f\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r7\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\u0015\u0014q\f\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u000b\u0003\u0003W\u00022!_A7\u0013\r\tyG\u001b\u0002\t\u0019>\u001c\u0017\r\u001c'pO\u0006!An\\4!\u0003\u0015\u0019X\r^+q)\t\tI\u0001K\u0002\u0012\u0003s\u0002B!a\u001f\u0002\n6\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0002ba&TA!a!\u0002\u0006\u00069!.\u001e9ji\u0016\u0014(\u0002BAD\u0003\u0003\nQA[;oSRLA!a#\u0002~\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3AEAI!\u0011\tY(a%\n\t\u0005U\u0015Q\u0010\u0002\n\u0003\u001a$XM]#bG\"\u0014\u0001bS3z-\u0006dW/Z\n\u0007'A\fY*!)\u0011\u0007E\fi*C\u0002\u0002 J\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002r\u0003GK1!!*s\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\rYW-_\u000b\u0003\u0003W\u0003B!!,\u0002<:!\u0011qVA\\!\r\t\tL]\u0007\u0003\u0003gS1!!.o\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0018:\u0002\rA\u0013X\rZ3g\u0013\u0011\ti,a0\u0003\rM#(/\u001b8h\u0015\r\tIL]\u0001\u0005W\u0016L\b%A\u0003wC2,X-\u0001\u0004wC2,X\r\t\u000b\u0007\u0003\u0013\fi-a4\u0011\u0007\u0005-7#D\u0001\u0001\u0011\u001d\t9\u000b\u0007a\u0001\u0003WCq!a1\u0019\u0001\u0004\tY+\u0001\u0005u_J+7m\u001c:e)\u0011\t).!9\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033TA!a7\u00028\u00051!/Z2pe\u0012LA!a8\u0002Z\na1+[7qY\u0016\u0014VmY8sI\"I\u00111]\r\u0011\n\u0003\u0007\u0011Q]\u0001\ni&lWm\u001d;b[B\u0004R!]At\u0003WL1!!;s\u0005!a$-\u001f8b[\u0016t\u0004cA9\u0002n&\u0019\u0011q\u001e:\u0003\t1{gnZ\u0001\u0013i>\u0014VmY8sI\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002v*\"\u00111^A|W\t\tI\u0010\u0005\u0003\u0002|\n\u0015QBAA\u007f\u0015\u0011\tyP!\u0001\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0002e\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d\u0011Q \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001B2paf$b!!3\u0003\u000e\t=\u0001\"CAT7A\u0005\t\u0019AAV\u0011%\t\u0019m\u0007I\u0001\u0002\u0004\tY+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU!\u0006BAV\u0003o\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005;\u0001BAa\b\u0003&5\u0011!\u0011\u0005\u0006\u0005\u0005G\t\t#\u0001\u0003mC:<\u0017\u0002BA_\u0005C\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u000b\u0011\u0007E\u0014i#C\u0002\u00030I\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u000e\u0003<A\u0019\u0011Oa\u000e\n\u0007\te\"OA\u0002B]fD\u0011\"!\u0005!\u0003\u0003\u0005\rAa\u000b\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0011\u0011\r\t\r#\u0011\nB\u001b\u001b\t\u0011)EC\u0002\u0003HI\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YE!\u0012\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005#\u00129\u0006E\u0002r\u0005'J1A!\u0016s\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0005#\u0003\u0003\u0005\rA!\u000e\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\b\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tF!\u001a\t\u0013\u0005EQ%!AA\u0002\tU\u0012\u0001C&fsZ\u000bG.^3\u0011\u0007\u0005-we\u0005\u0003(a\u0006\u0005FC\u0001B5\u0003)1'o\\7SK\u000e|'\u000f\u001a\u000b\u0005\u0003\u0013\u0014\u0019\bC\u0004\u0002\\&\u0002\rA!\u001e\u0011\t\u0005]'qO\u0005\u0005\u0005s\nIN\u0001\u0004SK\u000e|'\u000fZ\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u0013\u0014yH!!\t\u000f\u0005\u001d&\u00061\u0001\u0002,\"9\u00111\u0019\u0016A\u0002\u0005-\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000f\u0013\u0019\nE\u0003r\u0005\u0013\u0013i)C\u0002\u0003\fJ\u0014aa\u00149uS>t\u0007cB9\u0003\u0010\u0006-\u00161V\u0005\u0004\u0005#\u0013(A\u0002+va2,'\u0007C\u0005\u0003\u0016.\n\t\u00111\u0001\u0002J\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019-48\u000fV8SK\u000e|'\u000fZ:\u0015\t\tm%Q\u0016\t\u0007\u0005;\u00139+!6\u000f\t\t}%1\u0015\b\u0005\u0003c\u0013\t+C\u0001t\u0013\r\u0011)K]\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IKa+\u0003\u0011%#XM]1cY\u0016T1A!*s\u0011\u001d\u0011y\u000b\fa\u0001\u0005c\u000b\u0011b[3z-\u0006dW/Z:\u0011\r\tu%qUAe\u00031\u0011XmY8sIN$vn\u0013<t)\u0011\u0011\tLa.\t\u000f\teV\u00061\u0001\u0003<\u00069!/Z2pe\u0012\u001c\bC\u0002BO\u0005O\u0013)(A\u0007baB,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\t\u0003\u0013\u0011\tMa1\u0003F\"9!\u0011\u0018\u0018A\u0002\tm\u0005\u0002C6/!\u0003\u0005\r!a\u001b\t\u0013\t\u001dg\u0006%AA\u0002\u0005-\u0018!D5oSRL\u0017\r\\(gMN,G/A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001a\u0016\u0005\u0003W\n90A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cwN\u001d3t)9\u0011)Na7\u0003^\n\u0005(q\u001dBv\u0005o\u00042! Bl\u0013\r\u0011IN \u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\u0011-\f\u0004\u0013!a\u0001\u0003WB\u0011Ba82!\u0003\u0005\r!a;\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\n\u0005G\f\u0004\u0013\"a\u0001\u0005K\f\u0011\"\\1y\u0019\u0016tw\r\u001e5\u0011\u000bE\f9Oa\u000b\t\u0013\t%\u0018\u0007%AA\u0002\tE\u0013!D7j]>sW-T3tg\u0006<W\rC\u0005\u0003nF\u0002J\u00111\u0001\u0003p\u0006\tR.\u0019=PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0011\u000bE\f9O!=\u0011\u0007u\u0014\u00190C\u0002\u0003vz\u0014\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011%\u0011I0\rI\u0001\u0002\u0004\u0011\t&\u0001\nj]\u000edW\u000fZ3BE>\u0014H/\u001a3Uq:\u001c\u0018!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%M\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0011X-\u00193SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"aa\u0001+\t\t-\u0012q_\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019IA\u000b\u0003\u0003R\u0005]\u0018!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007\u001fQCA!=\u0002x\u0006)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0014\u0001\b;fgRdun\u001a#fY\u0016$XmU3h[\u0016tGo]*vG\u000e,7o\u001d\u0015\u0004q\r]\u0001\u0003BA>\u00073IAaa\u0007\u0002~\t!A+Z:u\u0003i!Xm\u001d;S_2dW)\u001c9us\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uQ\rI4qC\u00017i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJ\u001cVoY2fgN<\u0006.\u001a8F[B$\u00180\u00118e\r\u0006LG.\u001e:f/\",gNT8o\u000b6\u0004H/\u001f\u0015\u0004u\r]\u0011\u0001\u0005;fgR,\u0006\u000fZ1uK\u000e{gNZ5hQ\rY4qC\u0001\u0019i\u0016\u001cH\u000fT8h\t&\u0014(+\u001a8b[\u0016$vNT3x\t&\u0014\bf\u0001\u001f\u0004\u0018\u0005iB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u000bbL7\u000f^5oO\u0012K'\u000fK\u0002>\u0007/\tA\u0002^3ti2{wM\u00127vg\"D3APB\f\u00035!Xm\u001d;M_\u001e\f\u0005\u000f]3oI\"\u001aqha\u0006\u0002'Q,7\u000f\u001e'pO\u000ecwn]3Tk\u000e\u001cWm]:)\u0007\u0001\u001b9\"\u0001\fuKN$Hj\\4DY>\u001cX-\u00133f[B|G/\u001a8uQ\r\t5qC\u0001,i\u0016\u001cH\u000fT8h\u00072|7/\u001a$bS2,(/Z,iK:Le.T3n_JL()\u001e4gKJ\u001cEn\\:fI\"\u001a!ia\u0006\u0002)Q,7\u000f\u001e'pO\u000ecwn]3IC:$G.\u001a:tQ\r\u00195qC\u0001\u001fi\u0016\u001cH\u000fT8h\u00072|7/\u001a%b]\u0012dWM]:JI\u0016l\u0007o\u001c;f]RD3\u0001RB\f\u0003m!Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ugR!\u0011\u0011BB)\u0011\u001d\u0019\u0019&\u0012a\u0001\u0005#\n1\"Y:z]\u000e$U\r\\3uK\u0006yB/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\u001c\u0016P\\2)\u0007\u0019\u001b9\"\u0001\u0011uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]!ts:\u001c\u0007fA$\u0004\u0018\u00051B/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7\u000f\u0006\u0003\u0002\n\r\u0005\u0004bBB*\u0011\u0002\u0007!\u0011K\u0001\u001bi\u0016\u001cH\u000fR3mKR,7+Z4nK:$h)\u001b7fgNKhn\u0019\u0015\u0004\u0013\u000e]\u0011a\u0007;fgR$U\r\\3uKN+w-\\3oi\u001aKG.Z:Bgft7\rK\u0002K\u0007/\t1\u0004^3ti\u0012+G.\u001a;bE2,7+Z4nK:$8OR5mi\u0016\u0014\bfA&\u0004\u0018\u0005qB/Z:u\t\u0016dW\r^1cY\u0016\u001cVmZ7f]R\u001c\u0018\n^3sCRLwN\u001c\u0015\u0004\u0019\u000e]\u0011A\u0007;fgR\u001c%/Z1uK\u0006sG\rR3mKR,7+Z4nK:$\bfA'\u0004\u0018\u0005YB/Z:u)J,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003RD3ATB\f\u00039!Xm\u001d;UeVt7-\u0019;f)>D3aTB\f\u0003e!Xm\u001d;O_:\f5\r^5wKN+w-\\3oiN4%o\\7)\u0007A\u001b9\"\u0001\nu_BL7\rU1si&$\u0018n\u001c8OC6,GCBAV\u0007\u000f\u001bY\tC\u0004\u0004\nF\u0003\r!a+\u0002\u000bQ|\u0007/[2\t\u000f\r5\u0015\u000b1\u0001\u0002,\u0006I\u0001/\u0019:uSRLwN\\\u0001\u001ci\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3)\u0007I\u001b9\"\u0001\u001buKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.Z,ji\"\u0004VM]5pI\u001a{'\u000fR3mKR,G\rV8qS\u000eD3aUB\f\u0003\u001d\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/R7qift\u0015-\\3)\u0007Q\u001b9\"\u0001\u0012uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe:+H\u000e\u001c\u0015\u0004+\u000e]\u0011A\f;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u001b&\u001c8/\u001b8h'\u0016\u0004\u0018M]1u_JD3AVB\f\u0003)\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/T5tg&tw\rV8qS\u000eD3aVB\f\u00039\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/T5tg&tw\rU1si&$\u0018n\u001c8)\u0007a\u001b9\"\u0001\u0018uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe&sg/\u00197jIB\u000b'\u000f^5uS>t\u0007fA-\u0004\u0018\u0005\u0001D/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]#ySN$\u0018N\\4J]Z\fG.\u001b3ESJD3AWB\f\u0003Q!Xm\u001d;M_\u001e$U\r\\3uK\u0012K'OT1nK\"\u001a1la\u0006\u0002%Q,7\u000f^(gMN,GO\u0012:p[\u001aKG.\u001a\u0015\u00049\u000e]\u0011\u0001\t;fgR\u0014v\u000e\u001c7TK\u001elWM\u001c;UQ\u0006$\u0018\t\u001c:fC\u0012LX\t_5tiND3!XB\f\u0003a!Xm\u001d;OK^\u001cVmZ7f]R\u001c\u0018I\u001a;feJ{G\u000e\u001c\u0015\u0004=\u000e]\u0011a\u000b;fgR\u0014v\u000e\u001c7TK\u001elWM\u001c;FeJ|'o\u00165f]:+\u0007\u0010^(gMN,G/S:JY2,w-\u00197)\u0007}\u001b9\"A\u0010de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$B#a\u001b\u0004L\u000e=7q[Bq\u0007K\u001cIoa=\u0005\u0002\u0011\r\u0001\"CBgAB\u0005\t\u0019AA\r\u0003\r!\u0017N\u001d\u0005\u0007u\u0002\u0004\ra!5\u0011\u0007e\u001c\u0019.C\u0002\u0004V*\u0014\u0011\u0002T8h\u0007>tg-[4\t\u0013\re\u0007\r%AA\u0002\rm\u0017\u0001C:fO6,g\u000e^:\u0011\u0007e\u001ci.C\u0002\u0004`*\u00141\u0002T8h'\u0016<W.\u001a8ug\"I11\u001d1\u0011\u0002\u0003\u0007\u00111^\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0013\r\u001d\b\r%AA\u0002\tE\u0018A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006D\u0011ba;a!\u0003\u0005\ra!<\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA/\u0007_LAa!=\u0002`\tI1k\u00195fIVdWM\u001d\u0005\n\u0007k\u0004\u0007\u0013!a\u0001\u0007o\fA\u0001^5nKB!1\u0011`B\u007f\u001b\t\u0019YP\u0003\u0003\u0002b\u0005]\u0012\u0002BB\u0000\u0007w\u0014A\u0001V5nK\"I\u0011q\u00061\u0011\u0002\u0003\u0007\u00111\u0007\u0005\n\u0003\u0017\u0002\u0007\u0013!a\u0001\u0003\u001f\n\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\nTC\u0001C\u0005U\u0011\tI\"a>\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t!yA\u000b\u0003\u0004\\\u0006]\u0018!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$C'A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0011e!\u0006BBw\u0003o\f\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012:TC\u0001C\u0010U\u0011\u001990a>\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t!)C\u000b\u0003\u00024\u0005]\u0018!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0005,)\"\u0011qJA|\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable & scala.Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> kv.toRecord$default$1()), Iterable$.MODULE$.canBuildFrom());
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable & scala.Serializable)r -> this.KeyValue().fromRecord((Record)r), Iterable$.MODULE$.canBuildFrom());
    }

    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        List segmentsBeforeDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = Predef$.MODULE$.Integer2int(oldConfig.segmentSize()) + 1;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        LocalLog x$2 = this.readRecords$default$1();
        long x$3 = this.readRecords$default$2();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(x$3, LocalLogTest.$anonfun$testLogAppend$1(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo2 = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo2.records().records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo2.records().records()).asScala())));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete, List$.MODULE$.canBuildFrom())));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, x$1) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$1)));
        List expected = ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$2, x$3)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$42 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$52 = 9L;
        LocalLog x$6 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$6, x$52);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$4, x$5)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.readRecords$default$1();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.appendRecords$default$2();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        long x$7 = 10L;
        LocalLog x$8 = this.readRecords$default$1();
        boolean x$10 = this.readRecords$default$4();
        boolean x$12 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$8.read(x$7, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        long x$4 = 6L;
        LocalLog x$5 = this.readRecords$default$1();
        boolean x$7 = this.readRecords$default$4();
        boolean x$9 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$5.read(x$4, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala())));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$11 = 7L;
        LocalLog x$12 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, x$11);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LocalLog$.MODULE$.logFile(this.tmpDir(), offset, LocalLog$.MODULE$.logFile$default$3());
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(logFile));
        File offsetIndexFile = LocalLog$.MODULE$.offsetIndexFile(this.tmpDir(), offset, LocalLog$.MODULE$.offsetIndexFile$default$3());
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(offsetIndexFile));
        File timeIndexFile = LocalLog$.MODULE$.timeIndexFile(this.tmpDir(), offset, LocalLog$.MODULE$.timeIndexFile$default$3());
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        Iterable x$1 = (Iterable)keyValues2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.mockTime().milliseconds() + 10L), List$.MODULE$.canBuildFrom());
        long x$2 = 1L;
        LocalLog x$3 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((GenTraversableOnce)keyValues2, List$.MODULE$.canBuildFrom()), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records().records()).asScala())));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        long x$4 = 1L;
        LocalLog x$5 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, x$4);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        long x$2 = 0L;
        int x$5 = config.initFileSize();
        boolean x$6 = Predef$.MODULE$.Boolean2boolean(config.preallocate());
        boolean x$7 = LogSegment$.MODULE$.open$default$5();
        String x$8 = LogSegment$.MODULE$.open$default$8();
        segments.add(LogSegment$.MODULE$.open(dir, x$2, config, time, x$7, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$1) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$2, Option x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$4, Option x$5) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10());
        File x$2 = this.createLocalLogWithActiveSegment$default$1();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = this.createLocalLogWithActiveSegment$default$4();
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        Time x$7 = this.createLocalLogWithActiveSegment$default$7();
        TopicPartition x$8 = this.createLocalLogWithActiveSegment$default$8();
        LogDirFailureChannel x$9 = this.createLocalLogWithActiveSegment$default$9();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    scala.Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof KeyValue)) return false;
            if (((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() != this.kafka$log$LocalLogTest$KeyValue$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyValue keyValue = (KeyValue)x$1;
            String string = this.key();
            String string2 = keyValue.key();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.value();
            String string4 = keyValue.value();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!keyValue.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

