/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogTestUtils$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManagerConfig;
import kafka.log.RollParams;
import kafka.log.UnifiedLog$;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004H\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019)\u0006\u0001)A\u0005\u0015\"Ia\u000b\u0001a\u0001\u0002\u0004%Ia\u0016\u0005\nA\u0002\u0001\r\u00111A\u0005\n\u0005D\u0011b\u001a\u0001A\u0002\u0003\u0005\u000b\u0015\u0002-\t\u000b!\u0004A\u0011A5\t\u000fq\u0004\u0011\u0013!C\u0001{\"I\u0011\u0011\u0003\u0001\u0012\u0002\u0013\u0005\u00111\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013Bq!!\u0019\u0001\t\u0003\tI\u0005C\u0004\u0002l\u0001!\t!!\u0013\t\u000f\u0005U\u0004\u0001\"\u0001\u0002J!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005%\u0003bBA?\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u0003\u0003A\u0011AA%\u0011\u001d\t)\t\u0001C\u0001\u0003\u0013Bq!!#\u0001\t\u0003\tI\u0005C\u0004\u0002\u000e\u0002!\t!!\u0013\t\u000f\u0005E\u0005\u0001\"\u0001\u0002J!9\u0011Q\u0013\u0001\u0005\u0002\u0005%\u0003bBAM\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003;\u0003A\u0011AA%\u0011\u001d\t\t\u000b\u0001C\u0001\u0003\u0013Bq!!*\u0001\t\u0003\tI\u0005C\u0004\u0002*\u0002!I!a+\t\u0011\u0005M\u0007!%A\u0005\nuD\u0001\"!6\u0001#\u0003%I! \u0005\n\u0003/\u0004\u0011\u0013!C\u0005\u00033Dq!!8\u0001\t\u0003\tI\u0005C\u0004\u0002b\u0002!\t!!\u0013\t\r!\u0004A\u0011BAs\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u0013BqA!\u0001\u0001\t\u0003\tI\u0005C\u0004\u0003\u0006\u0001!\t!!\u0013\t\u000f\t%\u0001\u0001\"\u0001\u0002J!9!Q\u0002\u0001\u0005\n\t=!A\u0004'pON+w-\\3oiR+7\u000f\u001e\u0006\u0003W1\n1\u0001\\8h\u0015\u0005i\u0013!B6bM.\f7\u0001A\n\u0003\u0001A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00019!\tI\u0004!D\u0001+\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012\u0001\u0010\t\u0003{\u0015k\u0011A\u0010\u0006\u0003\u007f\u0001\u000baaY8n[>t'BA\u0017B\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\n\u0005\u0019s$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005A1/Z4nK:$8/F\u0001K!\rY\u0005KU\u0007\u0002\u0019*\u0011QJT\u0001\b[V$\u0018M\u00197f\u0015\ty%'\u0001\u0006d_2dWm\u0019;j_:L!!\u0015'\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003sMK!\u0001\u0016\u0016\u0003\u00151{wmU3h[\u0016tG/A\u0005tK\u001elWM\u001c;tA\u00051An\\4ESJ,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000b!![8\u000b\u0003u\u000bAA[1wC&\u0011qL\u0017\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$\"AY3\u0011\u0005E\u001a\u0017B\u000133\u0005\u0011)f.\u001b;\t\u000f\u0019<\u0011\u0011!a\u00011\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1|w\rR5sA\u0005i1M]3bi\u0016\u001cVmZ7f]R$BA\u00156pi\")1.\u0003a\u0001Y\u00061qN\u001a4tKR\u0004\"!M7\n\u00059\u0014$\u0001\u0002'p]\u001eDq\u0001]\u0005\u0011\u0002\u0003\u0007\u0011/\u0001\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\bCA\u0019s\u0013\t\u0019(GA\u0002J]RDq!^\u0005\u0011\u0002\u0003\u0007a/\u0001\u0003uS6,\u0007CA<{\u001b\u0005A(BA=?\u0003\u0015)H/\u001b7t\u0013\tY\bP\u0001\u0003US6,\u0017aF2sK\u0006$XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005q(FA9\u0000W\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0006e\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0011Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF2sK\u0006$XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)B\u000b\u0002w\u007f\u00069!/Z2pe\u0012\u001cHCBA\u000e\u0003O\tI\u0003\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tCP\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005\u0015\u0012q\u0004\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000b-d\u0001\u0019\u00017\t\u000f\u0005]A\u00021\u0001\u0002,A)\u0011'!\f\u00022%\u0019\u0011q\u0006\u001a\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u00024\u0005\u0005c\u0002BA\u001b\u0003{\u00012!a\u000e3\u001b\t\tIDC\u0002\u0002<9\na\u0001\u0010:p_Rt\u0014bAA e\u00051\u0001K]3eK\u001aLA!a\u0011\u0002F\t11\u000b\u001e:j]\u001eT1!a\u00103\u0003\u0015\u0019X\r^;q)\u0005\u0011\u0007fA\u0007\u0002NA!\u0011qJA/\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013aA1qS*!\u0011qKA-\u0003\u001dQW\u000f]5uKJT1!a\u0017D\u0003\u0015QWO\\5u\u0013\u0011\ty&!\u0015\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hm\\<oQ\rq\u0011Q\r\t\u0005\u0003\u001f\n9'\u0003\u0003\u0002j\u0005E#!C!gi\u0016\u0014X)Y2i\u0003Y!Xm\u001d;SK\u0006$wJ\\#naRL8+Z4nK:$\bfA\b\u0002pA!\u0011qJA9\u0013\u0011\t\u0019(!\u0015\u0003\tQ+7\u000f^\u0001\u001ai\u0016\u001cHOU3bI\n+gm\u001c:f\r&\u00148\u000f^(gMN,G\u000fK\u0002\u0011\u0003_\n\u0011\u0003^3tiJ+\u0017\rZ!gi\u0016\u0014H*Y:uQ\r\t\u0012qN\u0001\u0010i\u0016\u001cHOU3bI\u001a\u0013x.\\$ba\"\u001a!#a\u001c\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3)\u0007M\ty'\u0001\ruKN$HK];oG\u0006$X-R7qif\u001cVmZ7f]RD3\u0001FA8\u0003Y\"Xm\u001d;SK2|\u0017\r\u001a'be\u001e,7\u000f\u001e+j[\u0016\u001cH/Y7q\u0003:$g*\u001a=u\u001f\u001a47/\u001a;BMR,'\u000f\u0016:v]\u000e\fG/[8oQ\r)\u0012qN\u0001\u0011i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2D3AFA8\u0003e!Xm\u001d;GS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9)\u0007]\ty'A\ruKN$h*\u001a=u\u001f\u001a47/\u001a;DC2\u001cW\u000f\\1uS>t\u0007f\u0001\r\u0002p\u00051B/Z:u\u0007\"\fgnZ3GS2,7+\u001e4gSb,7\u000fK\u0002\u001a\u0003_\nQ\u0004^3tiJ+7m\u001c<fef4\u0015\u000e_3t\u0007>\u0014(/\u001e9u\u0013:$W\r\u001f\u0015\u00045\u0005=\u0014a\u0007;fgR\u0014VmY8wKJ$&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010K\u0002\u001c\u0003_\na\u0004^3tiJ+7m\u001c<fef\u0014VMY;jY\u0012\u001cX\t]8dQ\u000e\u000b7\r[3)\u0007q\ty'A\u0007f]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u000b\u0011\u00037\ti+a.\u0002<\u0006\u0015\u0017qYAf\u0003\u001fDq!a,\u001e\u0001\u0004\t\t,A\td_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016\u0004B!!\b\u00024&!\u0011QWA\u0010\u0005E\u0019uN\u001c;s_2\u0014VmY8sIRK\b/\u001a\u0005\u0007\u0003sk\u0002\u0019\u00017\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0004\u0002>v\u0001\r!a0\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\r\t\u0014\u0011Y\u0005\u0004\u0003\u0007\u0014$!B*i_J$\b\"B6\u001e\u0001\u0004a\u0007\u0002CAe;A\u0005\t\u0019A9\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011!\ti-\bI\u0001\u0002\u0004\t\u0018\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011!\t\t.\bI\u0001\u0002\u0004a\u0017!\u0003;j[\u0016\u001cH/Y7q\u0003])g\u000e\u001a+y]J+7m\u001c:eg\u0012\"WMZ1vYR$S'A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u00059RM\u001c3Uq:\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u00037T#\u0001\\@\u0002CQ,7\u000f\u001e*fG>4XM]=GSb,7oQ8seV\u0004H\u000fV5nK&sG-\u001a=)\u0007\u0005\ny'\u0001\u0010uKN$(+Z2pm\u0016\u0014\u0018pV5uQ\u000e{'O];qi6+7o]1hK\"\u001a!%a\u001c\u0015\u0013I\u000b9/a;\u0002v\u0006e\bBBAuG\u0001\u0007A.\u0001\u0006cCN,wJ\u001a4tKRDq!!<$\u0001\u0004\ty/A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiN\u00042!MAy\u0013\r\t\u0019P\r\u0002\b\u0005>|G.Z1o\u0011\u0019\t9p\ta\u0001c\u0006a\u0011N\\5u\r&dWmU5{K\"9\u00111`\u0012A\u0002\u0005=\u0018a\u00039sK\u0006dGn\\2bi\u0016\fq\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138ji\u001aKG.Z*ju\u0016\f\u0005\u000f]3oI6+7o]1hK\"\u001aA%a\u001c\u0002OQ,7\u000f^\"sK\u0006$XmV5uQ&s\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3DY\u0016\f'o\u00155vi\u0012|wO\u001c\u0015\u0004K\u0005=\u0014AL:i_VdG\r\u0016:v]\u000e\fG/Z#wK:Lem\u00144gg\u0016$\bk\\5oiN$v.Q$ba&sG\u000b[3M_\u001eD3AJA8\u0003I!Xm\u001d;BaB,g\u000e\u001a$s_64\u0015\u000e\\3)\u0007\u001d\ny'A\foK^\u0004&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feR\u0011!\u0011\u0003\t\u0004s\tM\u0011b\u0001B\u000bU\t!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u0004")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertNull((Object)seg.read(40L, 300, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read(41L, 300, seg.read$default$3(), seg.read$default$4()).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200, seg.read$default$3(), seg.read$default$4()), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = this.records(offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = this.records(offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000, seg.read$default$3(), seg.read$default$4());
            Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        long x$4 = 0L;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)time);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()), (String)"Segment should be empty.");
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assertions.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assertions.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        File timeIndexFile = seg.lazyTimeIndex().file();
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assertions.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyTimeIndex().file().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.lazyOffsetIndex().get();
        Assertions.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
        seg.lazyTimeIndex().get();
        Assertions.assertTrue((boolean)seg.lazyTimeIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(this.newProducerStateManager(), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long x$1 = i;
            int x$2 = 1;
            boolean x$3 = true;
            long x$4 = seg.read$default$3();
            java.lang.Iterable records = seg.read(x$1, x$2, x$4, x$3).records().records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = this.newProducerStateManager();
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = this.newProducerStateManager();
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, -1L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRecoveryRebuildsEpochCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public void write(Iterable<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)epochs.toVector());
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }
            {
                this.epochs = Nil$.MODULE$;
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint);
        seg.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(107L, -1L, 106L, MemoryRecords.withRecords((long)106L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(109L, -1L, 108L, MemoryRecords.withRecords((long)108L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(111L, -1L, 110L, MemoryRecords.withRecords((long)110L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.recover(this.newProducerStateManager(), (Option)new Some((Object)cache));
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)})), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(this.newProducerStateManager(), seg.recover$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$5.findOffsetByTimestamp((long)((long)(i * 10)), (long)seg$5.findOffsetByTimestamp$default$2()).get()).offset);
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$5.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)seg$5.findOffsetByTimestamp$default$2()).get()).offset);
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(this.newProducerStateManager(), seg.recover$default$2());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp()), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp()), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava(), LogConfig$.MODULE$.apply$default$2());
        long x$2 = 40L;
        Time x$4 = Time.SYSTEM;
        int x$5 = 0x20000000;
        boolean x$6 = true;
        boolean x$7 = LogSegment$.MODULE$.open$default$5();
        String x$8 = LogSegment$.MODULE$.open$default$8();
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, x$2, logConfig, x$4, x$7, x$5, x$6, x$8);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(log.records().batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)UnifiedLog$.MODULE$.logFile(tempDir, 0L, UnifiedLog$.MODULE$.logFile$default$3()));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    private ProducerStateManager newProducerStateManager() {
        return new ProducerStateManager(this.topicPartition(), this.logDir(), 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs()), (Time)new MockTime());
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }
}

