/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.SegmentDeletion$;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r%a\u0001\u0002\"D\u0005!CQa\u0014\u0001\u0005\u0002AC\u0011b\u0015\u0001A\u0002\u0003\u0007I\u0011\u0001+\t\u0013u\u0003\u0001\u0019!a\u0001\n\u0003q\u0006\"\u00033\u0001\u0001\u0004\u0005\t\u0015)\u0003V\u0011\u001d)\u0007A1A\u0005\u0002\u0019Da!\u001c\u0001!\u0002\u00139\u0007\"\u00028\u0001\t\u0003y\u0007\"B?\u0001\t\u0003y\u0007BBA\u0003\u0001\u0011\u0005q\u000e\u0003\u0004\u0002\u0010\u0001!\ta\u001c\u0005\u0007\u0003'\u0001A\u0011A8\t\r\u0005]\u0001\u0001\"\u0001p\u0011\u0019\tY\u0002\u0001C\u0001_\"1\u0011q\u0004\u0001\u0005\u0002=Da!a\t\u0001\t\u0003y\u0007BBA\u0014\u0001\u0011\u0005q\u000e\u0003\u0004\u0002,\u0001!\ta\u001c\u0005\u0007\u0003_\u0001A\u0011A8\t\r\u0005M\u0002\u0001\"\u0001p\u0011\u0019\t9\u0004\u0001C\u0001_\"1\u00111\b\u0001\u0005\u0002=Da!a\u0010\u0001\t\u0003y\u0007BBA\"\u0001\u0011\u0005q\u000e\u0003\u0004\u0002H\u0001!\ta\u001c\u0005\u0007\u0003\u0017\u0002A\u0011A8\t\r\u0005=\u0003\u0001\"\u0001p\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Bq!a\u0017\u0001\t\u0013\ti\u0006\u0003\u0004\u0002x\u0001!\ta\u001c\u0005\u0007\u0003w\u0002A\u0011A8\t\r\u0005}\u0004\u0001\"\u0001p\u0011\u0019\t\u0019\t\u0001C\u0001_\"1\u0011q\u0011\u0001\u0005\u0002=Da!a#\u0001\t\u0003y\u0007bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\u0007\u0003k\u0003A\u0011A8\t\r\u0005e\u0006\u0001\"\u0001p\u0011\u0019\ti\f\u0001C\u0001_\"1\u0011\u0011\u0019\u0001\u0005\u0002=Da!!2\u0001\t\u0003y\u0007BBAe\u0001\u0011\u0005q\u000e\u0003\u0004\u0002N\u0002!\ta\u001c\u0005\u0007\u0003#\u0004A\u0011A8\t\r\u0005U\u0007\u0001\"\u0001p\u0011\u0019\tI\u000e\u0001C\u0001_\"1\u0011Q\u001c\u0001\u0005\u0002=Da!!9\u0001\t\u0003y\u0007BBAs\u0001\u0011\u0005qnB\u0004\u0002j\u000eC\t!a;\u0007\r\t\u001b\u0005\u0012AAw\u0011\u0019y%\u0007\"\u0001\u0002p\u001a1\u0011\u0011\u001f\u001a\u0001\u0003gDaa\u0014\u001b\u0005\u0002\t}\u0001bBAXi\u0011\u0005#Q\u0005\u0005\b\u0005w!D\u0011\tB\u001f\u0011\u001d\u0011i\u0005\u000eC!\u0005\u001fB\u0011Ba\u00183\u0005\u0004%\tA!\u0019\t\u0011\t%$\u0007)A\u0005\u0005GBqAa\u001b3\t\u0003\u0011i\u0007C\u0005\u0003\u0016J\n\n\u0011\"\u0001\u0003\u0018\"9!Q\u0016\u001a\u0005\u0002\t=\u0006\"\u0003B\\eE\u0005I\u0011\u0001BL\u0011\u001d\u0011IL\rC\u0001\u0005wCqA!/3\t\u0003\u0011)\u000eC\u0004\u0003jJ\"IAa;\u0003)-\u000bgm[1NKR\fG-\u0019;b\u0019><G+Z:u\u0015\t!U)\u0001\u0003sC\u001a$(\"\u0001$\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0006C\u0001*\u0001\u001b\u0005\u0019\u0015a\u0002;f[B$\u0015N]\u000b\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0003S>T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n!a)\u001b7f\u0003-!X-\u001c9ESJ|F%Z9\u0015\u0005}\u0013\u0007C\u0001&a\u0013\t\t7J\u0001\u0003V]&$\bbB2\u0004\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0014\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\u00115|7m\u001b+j[\u0016,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u0016\u000bQ!\u001e;jYNL!\u0001\\5\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0003}C#aB9\u0011\u0005I\\X\"A:\u000b\u0005Q,\u0018aA1qS*\u0011ao^\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u00180A\u0003kk:LGOC\u0001{\u0003\ry'oZ\u0005\u0003yN\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007F\u0001\u0005\u0000!\r\u0011\u0018\u0011A\u0005\u0004\u0003\u0007\u0019(!C!gi\u0016\u0014X)Y2i\u0003)!Xm\u001d;D_:4\u0017n\u001a\u0015\u0004\u0013\u0005%\u0001c\u0001:\u0002\f%\u0019\u0011QB:\u0003\tQ+7\u000f^\u0001\u001bi\u0016\u001cH/\u00168fqB,7\r^3e\u0003B\u0004XM\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004\u0015\u0005%\u0011A\u0005;fgR\u001c%/Z1uKNs\u0017\r]:i_RD3aCA\u0005\u0003}!Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;Ge>lWI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004\u0019\u0005%\u0011\u0001\u000b;fgR\u001c%/Z1uKNs\u0017\r]:i_Rd\u0015\r^3s)\"\fg\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0007fA\u0007\u0002\n\u0005\u0001C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u001bV\u001c\u0007\u000eT1uKJ,\u0005o\\2iQ\rq\u0011\u0011B\u0001'i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GOQ3g_J,Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\b\u0002\n\u0005\u0001C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\t&4XM]4j]\u001e,\u0005o\\2iQ\r\u0001\u0012\u0011B\u0001\u001di\u0016\u001cHo\u0011:fCR,7K\\1qg\"|Go\u00147eKJ,\u0005o\\2iQ\r\t\u0012\u0011B\u0001#i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GoV5uQ6K7o]5oO\u0016\u0003xn\u00195)\u0007I\tI!\u0001\u000euKN$8I]3bi\u0016,\u00050[:uS:<7K\\1qg\"|G\u000fK\u0002\u0014\u0003\u0013\t1\u0002^3tiR{\u0007/[2JI\"\u001aA#!\u0003\u0002/Q,7\u000f\u001e*fC\u0012l\u0015n]:j]\u001e\u001cf.\u00199tQ>$\bfA\u000b\u0002\n\u0005iB/Z:u\t\u0016dW\r^3O_:,\u00050[:uK:$8K\\1qg\"|G\u000fK\u0002\u0017\u0003\u0013\t\u0011\u0005^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z)>d\u0015\r^3tiNs\u0017\r]:i_RD3aFA\u0005\u0003\r\"Xm\u001d;UeVt7-\u0019;f/&dGNU3n_Z,w\n\u001c3feNs\u0017\r]:i_RD3\u0001GA\u0005\u0003\r\"Xm\u001d;Ti\u0006\u0014H/\u001e9XSRD\u0017J\u001c<bY&$7K\\1qg\"|Go\u0015;bi\u0016D3!GA\u0005\u00031\"Xm\u001d;T]\u0006\u00048\u000f[8u\t\u0016dW\r^5p]^KG\u000f[%om\u0006d\u0017\u000eZ*oCB\u001c\bn\u001c;Ti\u0006$X\rK\u0002\u001b\u0003\u0013\ta\"\\3uC\u0012\fG/\u0019'pO\u0012K'\u000fF\u0002V\u0003/Ba!!\u0017\u001c\u0001\u0004)\u0016A\u00027pO\u0012K'/\u0001\nxe&$X-R7qif\u001cf.\u00199tQ>$H#B0\u0002`\u0005\r\u0004BBA19\u0001\u0007Q+A\u0006nKR\fG-\u0019;b\t&\u0014\bbBA39\u0001\u0007\u0011qM\u0001\u000bg:\f\u0007o\u001d5pi&#\u0007\u0003BA5\u0003gj!!a\u001b\u000b\u0007\u0011\u000biGC\u0002G\u0003_R1!!\u001dz\u0003\u0019\t\u0007/Y2iK&!\u0011QOA6\u00059yeMZ:fi\u0006sG-\u00129pG\"\fq\u0003^3ti\u0012{Wm\u001d8u)J,hnY1uK\u001a+H\u000e\\=)\u0007u\tI!A\u000euKN$8\t\\3b]V\u0004\b+\u0019:uS\u0006d7K\\1qg\"|Go\u001d\u0015\u0004=\u0005%\u0011!\u0007;fgR\u001cE.Z1okB|E\u000eZ3s':\f\u0007o\u001d5piND3aHA\u0005\u0003\u0015\"Xm\u001d;De\u0016\fG/\u001a*fa2L7-\u0019;fI2{w\r\u0016:v]\u000e\fG/Z:Gk2d\u0017\u0010K\u0002!\u0003\u0013\t\u0001\u0003^3ti6\u000b\u0007PQ1uG\"\u001c\u0016N_3)\u0007\u0005\nI!\u0001\u0010uKN$HK];oG\u0006$XMQ3m_^D\u0015n\u001a5XCR,'/\\1sW\"\u001a!%!\u0003\u0002\u001d\t,\u0018\u000e\u001c3Gk2d')\u0019;dQRA\u00111SAR\u0003[\u000b\t\f\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\rI,7m\u001c:e\u0015\u0011\ti*!\u001c\u0002\r\r|W.\\8o\u0013\u0011\t\t+a&\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\t)k\ta\u0001\u0003O\u000b1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019!*!+\n\u0007\u0005-6JA\u0002J]RDq!a,$\u0001\u0004\t9+\u0001\u0006sK\u000e|'\u000fZ*ju\u0016Dq!a-$\u0001\u0004\t9+A\nnCb\u0014\u0015\r^2i'&TX-\u00138CsR,7/\u0001\u0016uKN$h+\u00197jI\u0006$X-\u00129pG\"<%/Z1uKJ$\u0006.\u00198MCN$8J\\8x]\u0016\u0003xn\u00195)\u0007\u0011\nI!\u0001\u0017uKN$h+\u00197jI\u0006$X-\u00129pG\"dUm]:UQ\u0006tw\n\u001c3fgR\u001cf.\u00199tQ>$X\t]8dQ\"\u001aQ%!\u0003\u0002]Q,7\u000f\u001e,bY&$\u0017\r^3PM\u001a\u001cX\r\u001e'fgN$\u0006.\u00198PY\u0012,7\u000f^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r\u001e\u0015\u0004M\u0005%\u0011!\f;fgR4\u0016\r\\5eCR,wJ\u001a4tKR,\u0015/^1m)>|E\u000eZ3tiNs\u0017\r]:i_R|eMZ:fi\"\u001aq%!\u0003\u0002\u0005R,7\u000f\u001e,bY&$\u0017\r^3V].twn\u001e8Fa>\u001c\u0007\u000eT3tgRC\u0017M\u001c'bgR\\en\\<o\u000fJ,\u0017\r^3s)\"\fgn\u00147eKN$8K\\1qg\"|G\u000fK\u0002)\u0003\u0013\t\u0001\u0006^3tiZ\u000bG.\u001b3bi\u0016,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]\u001aK'o\u001d;Fa>\u001c\u0007.\u00138M_\u001eD3!KA\u0005\u0003\u0011\"Xm\u001d;WC2LG-\u0019;f\u001f\u001a47/\u001a;He\u0016\fG\u000f\u00165b]\u0016sGm\u00144gg\u0016$\bf\u0001\u0016\u0002\n\u0005iB/Z:u-\u0006d\u0017\u000eZ1uK>3gm]3u\u0019\u0016\u001c8\u000f\u00165b]2+u\nK\u0002,\u0003\u0013\tq\u0004^3tiZ\u000bG.\u001b3bi\u00164\u0016\r\\5e\u000bB|7\r[!oI>3gm]3uQ\ra\u0013\u0011B\u0001'i\u0016\u001cH/\u00113wC:\u001cW\rT8h'R\f'\u000f^(gMN,G/\u00114uKJ\u001cE.Z1oS:<\u0007fA\u0017\u0002\n\u0005\u0019B/Z:u\t\u0016dW\r^3T]\u0006\u00048\u000f[8ug\"\u001aa&!\u0003\u0002-Q,7\u000f^*pMR\u0014V\r^3oi&|g\u000eT5nSRD3aLA\u0005\u0003\t\"Xm\u001d;TK\u001elWM\u001c;t\u0019\u0016\u001c8\u000f\u00165b]2\u000bG/Z:u':\f\u0007o\u001d5pi\"\u001a\u0001'!\u0003\u0002)-\u000bgm[1NKR\fG-\u0019;b\u0019><G+Z:u!\t\u0011&g\u0005\u00023\u0013R\u0011\u00111\u001e\u0002\u000f\u0005f$X-\u0011:sCf\u001cVM\u001d3f'\u0015!\u0014Q\u001fB\u0001!\u0011\t90!@\u000e\u0005\u0005e(bAA~3\u0006!A.\u00198h\u0013\u0011\ty0!?\u0003\r=\u0013'.Z2u!\u0019\u0011\u0019Aa\u0004\u0003\u00145\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0005\u0003;\u0013YA\u0003\u0003\u0003\u000e\u00055\u0014AB:feZ,'/\u0003\u0003\u0003\u0012\t\u0015!a\u0003*fG>\u0014HmU3sI\u0016\u0004RA\u0013B\u000b\u00053I1Aa\u0006L\u0005\u0015\t%O]1z!\rQ%1D\u0005\u0004\u0005;Y%\u0001\u0002\"zi\u0016$\"A!\t\u0011\u0007\t\rB'D\u00013)\u0019\t9Ka\n\u0003,!9!\u0011\u0006\u001cA\u0002\tM\u0011\u0001\u00023bi\u0006DqA!\f7\u0001\u0004\u0011y#\u0001\ntKJL\u0017\r\\5{CRLwN\\\"bG\",\u0007\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\t\tU\u00121T\u0001\taJ|Go\\2pY&!!\u0011\bB\u001a\u0005ay%M[3diN+'/[1mSj\fG/[8o\u0007\u0006\u001c\u0007.Z\u0001\u0006oJLG/\u001a\u000b\b?\n}\"\u0011\tB\"\u0011\u001d\u0011Ic\u000ea\u0001\u0005'AqA!\f8\u0001\u0004\u0011y\u0003C\u0004\u0003F]\u0002\rAa\u0012\u0002\u0007=,H\u000f\u0005\u0003\u00032\t%\u0013\u0002\u0002B&\u0005g\u0011\u0001b\u0016:ji\u0006\u0014G.Z\u0001\u0005e\u0016\fG\r\u0006\u0004\u0003\u0014\tE#1\f\u0005\b\u0005'B\u0004\u0019\u0001B+\u0003\u0015Ig\u000e];u!\u0011\u0011\tDa\u0016\n\t\te#1\u0007\u0002\t%\u0016\fG-\u00192mK\"9!Q\f\u001dA\u0002\u0005\u001d\u0016\u0001B:ju\u0016\f\u0001\u0004R3gCVdG/T3uC\u0012\fG/\u0019'pO\u000e{gNZ5h+\t\u0011\u0019\u0007E\u0002S\u0005KJ1Aa\u001aD\u0005EiU\r^1eCR\fGj\\4D_:4\u0017nZ\u0001\u001a\t\u00164\u0017-\u001e7u\u001b\u0016$\u0018\rZ1uC2{wmQ8oM&<\u0007%\u0001\fck&dG-T3uC\u0012\fG/\u0019'pO\u0006sG\rR5s)!\u0011yGa#\u0003\u000e\nE\u0005#\u0003&\u0003r\tU$Q\u0011B2\u0013\r\u0011\u0019h\u0013\u0002\u0007)V\u0004H.Z\u001a\u0011\t\t]$\u0011Q\u0007\u0003\u0005sRAAa\u001f\u0003~\u0005!a-\u001b7f\u0015\r\u0011y(W\u0001\u0004]&|\u0017\u0002\u0002BB\u0005s\u0012A\u0001U1uQB\u0019!Ka\"\n\u0007\t%5I\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pO\")1k\u000fa\u0001+\"1!qR\u001eA\u0002\u001d\fA\u0001^5nK\"I!1S\u001e\u0011\u0002\u0003\u0007!1M\u0001\u0012[\u0016$\u0018\rZ1uC2{wmQ8oM&<\u0017\u0001\t2vS2$W*\u001a;bI\u0006$\u0018\rT8h\u0003:$G)\u001b:%I\u00164\u0017-\u001e7uIM*\"A!'+\t\t\r$1T\u0016\u0003\u0005;\u0003BAa(\u0003*6\u0011!\u0011\u0015\u0006\u0005\u0005G\u0013)+A\u0005v]\u000eDWmY6fI*\u0019!qU&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003,\n\u0005&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\t\u0005\u000b\u0013\tLa-\u00036\")1+\u0010a\u0001+\"1!qR\u001fA\u0002\u001dD\u0011Ba%>!\u0003\u0005\rAa\u0019\u00025\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0002\r\u0005\u0004\b/\u001a8e)!\u0011iLa1\u0003N\nE\u0007\u0003BA5\u0005\u007fKAA!1\u0002l\tiAj\\4BaB,g\u000eZ%oM>DqA!2@\u0001\u0004\u00119-A\u0002m_\u001e\u0004B!!\u001b\u0003J&!!1ZA6\u00055\u0011V\r\u001d7jG\u0006$X\r\u001a'pO\"9!qZ A\u0002\u0005\u001d\u0016a\u00048v[\n,'o\u00144SK\u000e|'\u000fZ:\t\u000f\tMw\b1\u0001\u0002(\u0006)Q\r]8dQR)qLa6\u0003h\"9!\u0011\u001c!A\u0002\tm\u0017AD:oCB\u001c\bn\u001c;Xe&$XM\u001d\t\u0005\u0005;\u0014\u0019/\u0004\u0002\u0003`*!!\u0011]A7\u0003!\u0019h.\u00199tQ>$\u0018\u0002\u0002Bs\u0005?\u0014\u0011CU1x':\f\u0007o\u001d5pi^\u0013\u0018\u000e^3s\u0011\u001d\u0011y\r\u0011a\u0001\u0003O\u000b!c\u0019:fCR,Gj\\4ESJ,7\r^8ssR)QK!<\u0003p\"1\u0011\u0011L!A\u0002UCqA!=B\u0001\u0004\u0011\u00190\u0001\u0006m_\u001e$\u0015N\u001d(b[\u0016\u0004BA!>\u0004\u00049!!q\u001fB\u0000!\r\u0011IpS\u0007\u0003\u0005wT1A!@H\u0003\u0019a$o\\8u}%\u00191\u0011A&\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019)aa\u0002\u0003\rM#(/\u001b8h\u0015\r\u0019\ta\u0013")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();

    public static void append(RawSnapshotWriter rawSnapshotWriter, int n) {
        KafkaMetadataLogTest$.MODULE$.append(rawSnapshotWriter, n);
    }

    public static LogAppendInfo append(ReplicatedLog replicatedLog, int n, int n2) {
        return KafkaMetadataLogTest$.MODULE$.append(replicatedLog, n, n2);
    }

    public static MetadataLogConfig buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3();
    }

    public static KafkaMetadataLog buildMetadataLog(File file, MockTime mockTime, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(file, mockTime, metadataLogConfig);
    }

    public static MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3();
    }

    public static Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File file, MockTime mockTime, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(file, mockTime, metadataLogConfig);
    }

    public static MetadataLogConfig DefaultMetadataLogConfig() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), Arrays.asList((Object[])new String[]{"broker"}));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9093");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), BoxesRunTime.boxToInteger((int)2));
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMillisProp(), BoxesRunTime.boxToInteger((int)10240));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
            KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
        });
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
        KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
    }

    @Test
    public void testUnexpectedAppendOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch));
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsFollower((Records)MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset(snapshotId.offset() - 1L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset() - 2L, snapshotId.epoch())));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshotOlderEpoch() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateExistingSnapshot() {
        void resource_resource;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateFullyToLatestSnapshot() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(sameEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(greaterEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertNotEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        Assertions.assertTrue((boolean)log2.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        log2.close();
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$2 -> x$2.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$7((KafkaMetadataLog)log2, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.log().truncateFullyAndStartAt(100L);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.log().truncateFullyAndStartAt(200L);
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.log().truncateFullyAndStartAt(100L);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        return new File(logDir.getAbsolutePath(), UnifiedLog$.MODULE$.logDirName(KafkaRaftServer$.MODULE$.MetadataPartition()));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        FileRawSnapshotWriter writer = FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId, Optional.empty());
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            writer.freeze();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDoesntTruncateFully() {
        void resource_resource;
        void resource_resource2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(olderEpochSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(olderOffsetSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void resource_resource;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        void logDir2 = var2_2;
        void log2 = var3_3;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.close();
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)log2.startOffset());
        Assertions.assertEquals((int)epoch, (int)log2.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)log2.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$5 -> x$5.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void resource_resource;
        void resource_resource2;
        void resource_resource3;
        void resource_resource4;
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        AutoCloseable autoCloseable = (AutoCloseable)log2.storeSnapshot(oldSnapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource4).freeze();
        }
        finally {
            resource_resource4.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        AutoCloseable autoCloseable2 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource3).freeze();
        }
        finally {
            resource_resource3.close();
        }
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable3 = (AutoCloseable)log2.storeSnapshot(oldSnapshotId3).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        AutoCloseable autoCloseable4 = (AutoCloseable)log2.storeSnapshot(greaterSnapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log2.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$7 -> x$7.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$7((KafkaMetadataLog)log2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch(), (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        int x$2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$1();
        int x$3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$2();
        long x$4 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$3();
        long x$5 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$4();
        long x$6 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$5();
        int x$7 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7();
        int x$8 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8();
        int x$9 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9();
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9));
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numRecords = 10;
        int epoch = 5;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset);
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), CompressionType.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.log().maybeIncrementLogStartOffset((long)offset, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        void resource_resource;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        AutoCloseable autoCloseable = (AutoCloseable)log.createNewSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        void resource_resource;
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 5;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().maxFetchSizeInBytes(), Defaults$.MODULE$.FileDeleteDelayMs(), 1);
        config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2((RawSnapshotWriter)resource_resource2);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3((RawSnapshotWriter)resource_resource);
        }
        finally {
            resource_resource.close();
        }
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset() ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(1024, 1024, 10000L, 1024L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            void resource_resource;
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId).get();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3((RawSnapshotWriter)resource_resource);
            }
            finally {
                resource_resource.close();
            }
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$4((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSoftRetentionLimit() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2((RawSnapshotWriter)resource_resource2);
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3((RawSnapshotWriter)resource_resource);
        }
        finally {
            resource_resource.close();
        }
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        void resource_resource;
        void resource_resource2;
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 200, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableLike)log.log().logSegments().drop(1)).head()).baseOffset(), 1);
        AutoCloseable autoCloseable = (AutoCloseable)log.storeSnapshot(snapshotId1).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource2).freeze();
        }
        finally {
            resource_resource2.close();
        }
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableLike)log.log().logSegments().drop(2)).head()).baseOffset(), 1);
        AutoCloseable autoCloseable2 = (AutoCloseable)log.storeSnapshot(snapshotId2).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        finally {
            resource_resource.close();
        }
        long defaultLogRetentionMs = Defaults$.MODULE$.RetentionMs() * 2L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)new StringBuilder(23).append(log.startOffset()).append(" must be greater than 0").toString());
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset();
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)new StringBuilder(56).append("latest snapshot offset (").append(latestSnapshotOffset).append(") must be >= log start offset (").append(log.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$7(KafkaMetadataLog log$7, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$7.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$7(KafkaMetadataLog log$8, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$8.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 10);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$4(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset());
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$13, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$13.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$13, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset(), (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$13.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$13, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotBeforeLogStartOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotOlderEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateExistingSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeEmptySnapshot$1$adapted(FileRawSnapshotWriter x$3) {
        x$3.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupPartialSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateReplicatedLogTruncatesFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanOldestSnapshotEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetLessThanOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetEqualToOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanFirstEpochInLog$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$2$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$2$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeleteSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }
    }
}

