/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u00181\u0001UBQA\u000f\u0001\u0005\u0002mBq!\u0010\u0001C\u0002\u0013\u0005a\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0001?\u0011\u00199\u0005\u0001)A\u0005\u007f!9\u0001\n\u0001b\u0001\n\u0003I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\t\u0007I\u0011A%\t\r=\u0003\u0001\u0015!\u0003K\u0011\u001d\u0001\u0006A1A\u0005\u0002ECaA\u0017\u0001!\u0002\u0013\u0011\u0006\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0001]\u0011%1\u0007\u00011AA\u0002\u0013\u0005q\rC\u0005n\u0001\u0001\u0007\t\u0011)Q\u0005;\"9a\u000e\u0001b\u0001\n\u0003y\u0007B\u0002<\u0001A\u0003%\u0001\u000fC\u0004x\u0001\t\u0007I\u0011A%\t\ra\u0004\u0001\u0015!\u0003K\u0011\u001dI\bA1A\u0005\u0002iDq!!\u0004\u0001A\u0003%1\u0010C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0001bCA\r\u0001\u0001\u0007\t\u0019!C\u0001\u00037A1\"a\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011AA\t\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%\t!!\n\t\u0017\u0005%\u0002\u00011A\u0001B\u0003&\u00111\u0003\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\ty\u0003\u0001C\u0001\u0003[A\u0001\"!\r\u0001\u0005\u0004%\ta\u001c\u0005\b\u0003g\u0001\u0001\u0015!\u0003q\u0011-\t)\u0004\u0001a\u0001\u0002\u0004%\t!a\u000e\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013\u0005\u00111\r\u0005\f\u0003O\u0002\u0001\u0019!A!B\u0013\tI\u0004C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005e\u0004\u0001\"\u0001\u0002l!I\u00111\u0010\u0001A\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0001\u0003\u0007C\u0001\"a\"\u0001A\u0003&\u0011q\u0010\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!!-\u0001\t\u0003\nY\tC\u0004\u0002<\u0002!\t!a#\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002\f\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0005bBAg\u0001\u0011\u0005\u00111\u0012\u0005\b\u0003#\u0004A\u0011BAj\u0005=aun\u001a*fG>4XM]=UKN$(BA\u00193\u0003\u0019\u0019XM\u001d<fe*\t1'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0004CA\u001c9\u001b\u0005\u0001\u0014BA\u001d1\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"a\u000e\u0001\u0002'I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013A\u0001T8oO\u0006!\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002\nQC]3qY&\u001c\u0017\rT1h\u001b\u0006DX*Z:tC\u001e,7/\u0001\fsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:!\u0003U\u0011X\r\u001d7jG\u00064U\r^2i/\u0006LG/T1y\u001bN,\u0012A\u0013\t\u0003\u0001.K!\u0001T!\u0003\u0007%sG/\u0001\fsKBd\u0017nY1GKR\u001c\u0007nV1ji6\u000b\u00070T:!\u0003Q\u0011X\r\u001d7jG\u00064U\r^2i\u001b&t')\u001f;fg\u0006)\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKN\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\tU$\u0018\u000e\u001c\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\u0002\u000f\r|gNZ5hgV\tQ\fE\u0002_C\u000el\u0011a\u0018\u0006\u0003A\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u0011wLA\u0002TKF\u0004\"a\u000e3\n\u0005\u0015\u0004$aC&bM.\f7i\u001c8gS\u001e\f1bY8oM&<7o\u0018\u0013fcR\u0011\u0001n\u001b\t\u0003\u0001&L!A[!\u0003\tUs\u0017\u000e\u001e\u0005\bY6\t\t\u00111\u0001^\u0003\rAH%M\u0001\tG>tg-[4tA\u0005)Ao\u001c9jGV\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002t-\u0006!A.\u00198h\u0013\t)(O\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005Y\bc\u0001?\u0002\n5\tQP\u0003\u0002\u007f\u007f\u000611m\\7n_:T1aMA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9!A\u0002pe\u001eL1!a\u0003~\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\bg\u0016\u0014h/\u001a:2+\t\t\u0019\u0002E\u00028\u0003+I1!a\u00061\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sc}#S-\u001d\u000b\u0004Q\u0006u\u0001\u0002\u00037\u0017\u0003\u0003\u0005\r!a\u0005\u0002\u0011M,'O^3sc\u0001\nqa]3sm\u0016\u0014('A\u0006tKJ4XM\u001d\u001a`I\u0015\fHc\u00015\u0002(!AA.GA\u0001\u0002\u0004\t\u0019\"\u0001\u0005tKJ4XM\u001d\u001a!\u00031\u0019wN\u001c4jOB\u0013x\u000e]:2+\u0005\u0019\u0017\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0014aB7fgN\fw-Z\u0001\t[\u0016\u001c8/Y4fA\u0005A\u0001O]8ek\u000e,'/\u0006\u0002\u0002:AA\u00111HA\"\u0003\u000f\ni%\u0004\u0002\u0002>)!\u0011QGA \u0015\r\t\te`\u0001\bG2LWM\u001c;t\u0013\u0011\t)%!\u0010\u0003\u001b-\u000bgm[1Qe>$WoY3s!\r\t\u0018\u0011J\u0005\u0004\u0003\u0017\u0012(aB%oi\u0016<WM\u001d\t\u0005\u0003\u001f\niF\u0004\u0003\u0002R\u0005e\u0003cAA*\u00036\u0011\u0011Q\u000b\u0006\u0004\u0003/\"\u0014A\u0002\u001fs_>$h(C\u0002\u0002\\\u0005\u000ba\u0001\u0015:fI\u00164\u0017bA;\u0002`)\u0019\u00111L!\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0007!\f)\u0007\u0003\u0005mA\u0005\u0005\t\u0019AA\u001d\u0003%\u0001(o\u001c3vG\u0016\u0014\b%A\u0004io\u001aKG.Z\u0019\u0016\u0005\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M\u0004'A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018\u0002BA<\u0003c\u0012Ac\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017a\u00025x\r&dWMM\u0001\bg\u0016\u0014h/\u001a:t+\t\ty\b\u0005\u0003_C\u0006M\u0011aC:feZ,'o]0%KF$2\u0001[AC\u0011!aW%!AA\u0002\u0005}\u0014\u0001C:feZ,'o\u001d\u0011\u0002\u001dU\u0004H-\u0019;f!J|G-^2feR\t\u0001.A\u0003tKR,\u0006\u000fF\u0002i\u0003#Cq!a%)\u0001\u0004\t)*\u0001\u0005uKN$\u0018J\u001c4p!\u0011\t9*!*\u000e\u0005\u0005e%\u0002BAN\u0003;\u000b1!\u00199j\u0015\u0011\ty*!)\u0002\u000f),\b/\u001b;fe*!\u00111UA\u0003\u0003\u0015QWO\\5u\u0013\u0011\t9+!'\u0003\u0011Q+7\u000f^%oM>D3\u0001KAV!\u0011\t9*!,\n\t\u0005=\u0016\u0011\u0014\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007%\n)\f\u0005\u0003\u0002\u0018\u0006]\u0016\u0002BA]\u00033\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002UQ,7\u000f\u001e%X\u0007\",7m\u001b9pS:$hj\u001c$bS2,(/Z:TS:<G.\u001a'pON+w-\\3oi\"\u001a!&a0\u0011\t\u0005]\u0015\u0011Y\u0005\u0005\u0003\u0007\fIJ\u0001\u0003UKN$\u0018\u0001\f;fgRDuk\u00115fG.\u0004x.\u001b8u/&$\bNR1jYV\u0014Xm]*j]\u001edW\rT8h'\u0016<W.\u001a8uQ\rY\u0013qX\u0001.i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]RtuNR1jYV\u0014Xm]'vYRL\u0007\u000f\\3M_\u001e\u001cVmZ7f]R\u001c\bf\u0001\u0017\u0002@\u0006yC/Z:u\u0011^\u001b\u0005.Z2la>Lg\u000e^,ji\"4\u0015-\u001b7ve\u0016\u001cX*\u001e7uSBdW\rT8h'\u0016<W.\u001a8ug\"\u001aQ&a0\u0002\u0019M,g\u000eZ'fgN\fw-Z:\u0015\u0007!\f)\u000e\u0003\u0004\u0002X:\u0002\rAS\u0001\u0002]\u0002")
public class LogRecoveryTest
extends QuorumTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps = new Properties();
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpointFile hwFile1() {
        return new OffsetCheckpointFile(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public OffsetCheckpointFile hwFile2() {
        return new OffsetCheckpointFile(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$1 = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)this.server1(), (List)new .colon.colon((Object)this.server2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$1(this, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(x$2);
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assertions.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assertions.assertEquals((long)numMessages, (long)followerHW);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = LongRef.create((long)1L);
        this.server1().shutdown();
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$32 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$32, x$5, (Option<Object>)x$4, x$6);
        Assertions.assertEquals((int)1, (int)leader, (String)"Leader must move to broker 1");
        this.server1().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assertions.assertTrue((leader == 0 || leader == 1 ? 1 : 0) != 0, (String)"Leader must remain on broker 1, in case of ZooKeeper session expiration it can move to broker 0");
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresSingleLogSegment$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresSingleLogSegment$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.server2().shutdown();
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$7 = this.zkClient();
        String x$8 = this.topic();
        int x$9 = this.partitionId();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, x$8, x$9, x$11, (Option<Object>)x$10, x$12);
        Assertions.assertTrue((leader == 0 || leader == 1 ? 1 : 0) != 0, (String)"Leader must remain on broker 0, in case of ZooKeeper session expiration it can move to broker 1");
        this.sendMessages(1);
        ++hw.elem;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresSingleLogSegment$7(this, hw)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresSingleLogSegment$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresMultipleLogSegments$1(this, hw)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresMultipleLogSegments$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assertions.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assertions.assertEquals((long)hw, (long)followerHW);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = LongRef.create((long)2L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$1(this, hw)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.server1().shutdown();
        this.server2().shutdown();
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$3 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$52 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$52, (Option<Object>)x$4, x$6);
        Assertions.assertEquals((int)1, (int)leader, (String)"Leader must move to broker 1");
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server1().startup();
        this.updateProducer();
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.sendMessages(2);
        hw.elem += 2L;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$8(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$10(this, hw)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogRecoveryTest.$anonfun$testHWCheckpointWithFailuresMultipleLogSegments$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assertions.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    private void sendMessages(int n) {
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)x$6 -> LogRecoveryTest.$anonfun$sendMessages$1(this, BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get());
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointNoFailuresSingleLogSegment$1(LogRecoveryTest $this, long numMessages$1) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == numMessages$1;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointNoFailuresSingleLogSegment$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ void $anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(KafkaServer x$2) {
        x$2.replicaManager().checkpointHighWatermarks();
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresSingleLogSegment$4(LogRecoveryTest $this) {
        return ((Partition)$this.server2().replicaManager().onlinePartition($this.topicPartition()).get()).inSyncReplicaIds().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresSingleLogSegment$5() {
        return "Server 1 is not able to join the ISR after restart";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresSingleLogSegment$7(LogRecoveryTest $this, LongRef hw$1) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresSingleLogSegment$8() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointNoFailuresMultipleLogSegments$1(LogRecoveryTest $this, long hw$2) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$2;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointNoFailuresMultipleLogSegments$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$1(LogRecoveryTest $this, LongRef hw$3) {
        return $this.server2().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$3.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$2() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$8(LogRecoveryTest $this) {
        return $this.server1().replicaManager().localLog($this.topicPartition()).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$9() {
        return "Failed to create replica in follower after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$10(LogRecoveryTest $this, LongRef hw$3) {
        return $this.server1().replicaManager().localLogOrException($this.topicPartition()).highWatermark() == hw$3.elem;
    }

    public static final /* synthetic */ String $anonfun$testHWCheckpointWithFailuresMultipleLogSegments$11() {
        return "Failed to update high watermark for follower after timeout";
    }

    public static final /* synthetic */ Future $anonfun$sendMessages$1(LogRecoveryTest $this, int x$6) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)$this.message()));
    }

    public LogRecoveryTest() {
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(this.replicaLagTimeMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), Integer.toString(this.replicaFetchWaitMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), Integer.toString(this.replicaFetchMinBytes()));
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.message = "hello";
        this.servers = Nil$.MODULE$;
    }
}

