/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001!4A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)A\n\u0001C\u0001\u001b\")\u0001\u000b\u0001C\u0001#\nqR*\u001a;bI\u0006$\u0018MV3sg&|g.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0002CA\u000b\u0001\u001b\u00051\u0011a\b;fgR\u0014\u0015m]5d\u001b\u0016$\u0018\rZ1uCZ+'o]5p]V\u0003xM]1eKR\u0011\u0001d\u0007\t\u0003\u001beI!A\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\u00069\t\u0001\r!H\u0001\u0010G2,8\u000f^3s\u0013:\u001cH/\u00198dKB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005C\u0001\u0005i\u0016\u001cH/\u0003\u0002#?\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0003\u0003I)Z\u0003CA\u0013)\u001b\u00051#BA\u0014 \u0003)\tgN\\8uCRLwN\\\u0005\u0003S\u0019\u0012Ab\u00117vgR,'\u000fV3tiN\fQA^1mk\u0016d3\u0001\f#IW\u0015i\u0003'\r\u001c8!\t)c&\u0003\u00020M\tY1\t\\;ti\u0016\u0014H+Z:u\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u0003IJ!a\r\u001b\u0002\u000b-\u0013\u0016I\u0012+\u000b\u0005U2\u0013\u0001\u0002+za\u0016\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u0013\u0002q%\u0011\u0011HO\u0001\f\u0013\n\u0003vlM04?&3\u0006G\u0003\u0002<y\u0005yQ*\u001a;bI\u0006$\u0018MV3sg&|gN\u0003\u0002>}\u000511m\\7n_:T!aB \u000b\u0005%\u0001%BA!C\u0003\u0019\t\u0007/Y2iK*\t1)A\u0002pe\u001e\\S!\f\u00192m\u0015#\u0013AR\u0005\u0003\u000fj\n1\"\u0013\"Q?Nz6gX%Wc-*Q\u0006M\u00197\u0013\u0012\n!*\u0003\u0002Lu\u0005Y\u0011J\u0011)`g}\u001bt,\u0013,3\u0003Y!Xm\u001d;Va\u001e\u0014\u0018\rZ3TC6,g+\u001a:tS>tGC\u0001\rO\u0011\u0015a2\u00011\u0001\u001eQ\u0019\u0019Q\u0006M\u00197o\u0005QB/Z:u\t\u00164\u0017-\u001e7u\u0013Nd\u0015\r^3tiZ+'o]5p]R\u0011\u0001D\u0015\u0005\u00069\u0011\u0001\r!\b\u0015\u0005\t5\u0002\u0014\u0007\u000b\u0003\u0001+*\n\u0007C\u0001,`\u001b\u00059&B\u0001-Z\u0003%)\u0007\u0010^3og&|gN\u0003\u0002[7\u0006\u0019\u0011\r]5\u000b\u0005qk\u0016a\u00026va&$XM\u001d\u0006\u0003=\n\u000bQA[;oSRL!\u0001Y,\u0003\u0015\u0015CH/\u001a8e/&$\b\u000eL\u0001cG\u0005\u0019\u0007C\u00013g\u001b\u0005)'B\u00010 \u0013\t9WMA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:")
public class MetadataVersionIntegrationTest {
    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV0), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV1), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV2)})
    public void testBasicMetadataVersionUpgrade(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)admin.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        Assertions.assertEquals((short)ff.minVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
        Assertions.assertEquals((short)ff.maxVersionLevel(), (short)clusterInstance.config().metadataVersion().featureLevel());
        short updateVersion = MetadataVersion.IBP_3_3_IV3.featureLevel();
        admin.updateFeatures((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataVersionIntegrationTest.$anonfun$testBasicMetadataVersionUpgrade$1(admin, updateVersion)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataVersionIntegrationTest.$anonfun$testBasicMetadataVersionUpgrade$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_3_IV0)
    public void testUpgradeSameVersion(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        short updateVersion = MetadataVersion.IBP_3_3_IV0.featureLevel();
        admin.updateFeatures((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(updateVersion, FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions()).all().get();
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testDefaultIsLatestVersion(ClusterInstance clusterInstance) {
        FinalizedVersionRange ff = (FinalizedVersionRange)((FeatureMetadata)clusterInstance.createAdminClient().describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        Assertions.assertEquals((short)ff.minVersionLevel(), (short)MetadataVersion.latest().featureLevel(), (String)"If this test fails, check the default MetadataVersion in the @ClusterTest annotation");
        Assertions.assertEquals((short)ff.maxVersionLevel(), (short)MetadataVersion.latest().featureLevel());
    }

    public static final /* synthetic */ boolean $anonfun$testBasicMetadataVersionUpgrade$1(Admin admin$1, short updateVersion$1) {
        FinalizedVersionRange ff2 = (FinalizedVersionRange)((FeatureMetadata)admin$1.describeFeatures().featureMetadata().get()).finalizedFeatures().get("metadata.version");
        return ff2.minVersionLevel() == updateVersion$1 && ff2.maxVersionLevel() == updateVersion$1;
    }

    public static final /* synthetic */ String $anonfun$testBasicMetadataVersionUpgrade$2() {
        return "Never saw metadata.version increase on broker";
    }
}

