/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.List;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.BaseConsumerRecord$;
import kafka.tools.MirrorMaker;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000112A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)\u0001\u0006\u0001C\u0001/!)!\u0006\u0001C\u0001/\tyQ*\u001b:s_Jl\u0015m[3s)\u0016\u001cHO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011Q\u0003A\u0007\u0002\r\u0005!C/Z:u\t\u00164\u0017-\u001e7u\u001b&\u0014(o\u001c:NC.,'/T3tg\u0006<W\rS1oI2,'\u000fF\u0001\u0019!\ti\u0011$\u0003\u0002\u001b\u001d\t!QK\\5uQ\t\u0011A\u0004\u0005\u0002\u001eM5\taD\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0005\u0005\u0012\u0013a\u00026va&$XM\u001d\u0006\u0003G\u0011\nQA[;oSRT\u0011!J\u0001\u0004_J<\u0017BA\u0014\u001f\u0005\u0011!Vm\u001d;\u0002\u0005R,7\u000f\u001e#fM\u0006,H\u000e^'jeJ|'/T1lKJlUm]:bO\u0016D\u0015M\u001c3mKJ<\u0016\u000e\u001e5O_RKW.Z:uC6\u0004\u0018J\\*pkJ\u001cW-T3tg\u0006<W\r\u000b\u0002\u00049\u0005yC/Z:u\t\u00164\u0017-\u001e7u\u001b&\u0014(o\u001c:NC.,'/T3tg\u0006<W\rS1oI2,'oV5uQ\"+\u0017\rZ3sg\"\u0012A\u0001\b")
public class MirrorMakerTest {
    @Test
    public void testDefaultMirrorMakerMessageHandler() {
        long now = 12345L;
        BaseConsumerRecord consumerRecord = new BaseConsumerRecord("topic", 0, 1L, now, TimestampType.CREATE_TIME, "key".getBytes(), "value".getBytes(), BaseConsumerRecord$.MODULE$.apply$default$8());
        List result = MirrorMaker.defaultMirrorMakerMessageHandler$.MODULE$.handle(consumerRecord);
        Assertions.assertEquals((int)1, (int)result.size());
        ProducerRecord producerRecord = (ProducerRecord)result.get(0);
        Assertions.assertEquals((long)now, (Long)producerRecord.timestamp());
        Assertions.assertEquals((Object)"topic", (Object)producerRecord.topic());
        Assertions.assertNull((Object)producerRecord.partition());
        Assertions.assertEquals((Object)"key", (Object)new String((byte[])producerRecord.key()));
        Assertions.assertEquals((Object)"value", (Object)new String((byte[])producerRecord.value()));
    }

    @Test
    public void testDefaultMirrorMakerMessageHandlerWithNoTimestampInSourceMessage() {
        BaseConsumerRecord consumerRecord = new BaseConsumerRecord("topic", 0, 1L, -1L, TimestampType.CREATE_TIME, "key".getBytes(), "value".getBytes(), BaseConsumerRecord$.MODULE$.apply$default$8());
        List result = MirrorMaker.defaultMirrorMakerMessageHandler$.MODULE$.handle(consumerRecord);
        Assertions.assertEquals((int)1, (int)result.size());
        ProducerRecord producerRecord = (ProducerRecord)result.get(0);
        Assertions.assertNull((Object)producerRecord.timestamp());
        Assertions.assertEquals((Object)"topic", (Object)producerRecord.topic());
        Assertions.assertNull((Object)producerRecord.partition());
        Assertions.assertEquals((Object)"key", (Object)new String((byte[])producerRecord.key()));
        Assertions.assertEquals((Object)"value", (Object)new String((byte[])producerRecord.value()));
    }

    @Test
    public void testDefaultMirrorMakerMessageHandlerWithHeaders() {
        long now = 12345L;
        BaseConsumerRecord consumerRecord = new BaseConsumerRecord("topic", 0, 1L, now, TimestampType.CREATE_TIME, "key".getBytes(), "value".getBytes(), BaseConsumerRecord$.MODULE$.apply$default$8());
        consumerRecord.headers().add("headerKey", "headerValue".getBytes());
        List result = MirrorMaker.defaultMirrorMakerMessageHandler$.MODULE$.handle(consumerRecord);
        Assertions.assertEquals((int)1, (int)result.size());
        ProducerRecord producerRecord = (ProducerRecord)result.get(0);
        Assertions.assertEquals((long)now, (Long)producerRecord.timestamp());
        Assertions.assertEquals((Object)"topic", (Object)producerRecord.topic());
        Assertions.assertNull((Object)producerRecord.partition());
        Assertions.assertEquals((Object)"key", (Object)new String((byte[])producerRecord.key()));
        Assertions.assertEquals((Object)"value", (Object)new String((byte[])producerRecord.value()));
        Assertions.assertEquals((Object)"headerValue", (Object)new String(producerRecord.headers().lastHeader("headerKey").value()));
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)producerRecord.headers()).asScala()).size());
    }
}

