/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.CustomQuotaCallbackTest$GroupedUser$;
import kafka.api.GroupedUserPrincipal;
import kafka.api.GroupedUserPrincipalBuilder;
import kafka.api.GroupedUserPrincipalBuilder$;
import kafka.api.GroupedUserQuotaCallback;
import kafka.api.GroupedUserQuotaCallback$;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.QuotaTestClients;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.JaasTestUtils$ScramLoginModule$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001\u0002-Z\u0001yCQA\u001a\u0001\u0005\u0002\u001dDQ!\u001b\u0001\u0005R)DQA\u001f\u0001\u0005RmDa!!\u0002\u0001\t#Z\bBCA\u0004\u0001!\u0015\r\u0011\"\u0015\u0002\n!I\u0011q\u0005\u0001C\u0002\u0013\u0005\u0013\u0011\u0006\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002,!I\u00111\u0007\u0001C\u0002\u0013%\u0011Q\u0007\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u00028!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002D!I\u0011q\u000b\u0001C\u0002\u0013E\u0013\u0011\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002\\!I\u00111\u000e\u0001C\u0002\u0013E\u0013\u0011\f\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002\\!I\u0011q\u000e\u0001C\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002t!Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011BAJ\u0011-\ti\u000b\u0001a\u0001\u0002\u0004%I!a,\t\u0017\u0005m\u0006\u00011A\u0001B\u0003&\u0011Q\u0013\u0005\n\u0003{\u0003!\u0019!C\u0001\u0003SA\u0001\"a0\u0001A\u0003%\u00111\u0006\u0005\n\u0003\u0003\u0004!\u0019!C\u0001\u0003SA\u0001\"a1\u0001A\u0003%\u00111\u0006\u0005\n\u0003\u000b\u0004!\u0019!C\u0001\u0003SA\u0001\"a2\u0001A\u0003%\u00111\u0006\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\tY\u000e\u0001C!\u0003\u0017Dq!!:\u0001\t\u0003\nY\rC\u0004\u0002h\u0002!\t!a3\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"91\u0011\u000f\u0001\u0005\n\rM\u0004bBB@\u0001\u0011%1\u0011\u0011\u0005\b\u0007\u0007\u0003A\u0011BBC\u0011\u001d\u0019i\t\u0001C\u0005\u0007\u001f3a!!?\u0001\u0001\u0006m\bB\u0003B\bI\tU\r\u0011\"\u0001\u0003\u0012!Q!q\u0005\u0013\u0003\u0012\u0003\u0006IAa\u0005\t\u0015\t%BE!f\u0001\n\u0003\u0011\t\u0002\u0003\u0006\u0003,\u0011\u0012\t\u0012)A\u0005\u0005'A!B!\f%\u0005+\u0007I\u0011\u0001B\t\u0011)\u0011y\u0003\nB\tB\u0003%!1\u0003\u0005\u000b\u0005c!#Q3A\u0005\u0002\tM\u0002B\u0003B!I\tE\t\u0015!\u0003\u00036!Q!1\t\u0013\u0003\u0016\u0004%\tA!\u0005\t\u0015\t\u0015CE!E!\u0002\u0013\u0011\u0019\u0002\u0003\u0006\u0003H\u0011\u0012)\u001a!C\u0001\u0005#A!B!\u0013%\u0005#\u0005\u000b\u0011\u0002B\n\u0011)\tY\n\nBK\u0002\u0013\u0005\u00131\u0013\u0005\r\u0005\u0017\"#\u0011#Q\u0001\n\u0005U%Q\n\u0005\u000b\u0005\u001f\"#Q3A\u0005B\tE\u0003\u0002\u0004B/I\tE\t\u0015!\u0003\u0003T\t}\u0003B\u00024%\t\u0003\u0011\t\u0007C\u0004\u0003t\u0011\"\tE!\u001e\t\u000f\tuD\u0005\"\u0011\u0003\u0000!9!1\u0012\u0013\u0005B\t5\u0005b\u0002BTI\u0011\u0005\u00131\u001a\u0005\b\u0005S#C\u0011\u0001BV\u0011\u001d\u0011)\f\nC\u0001\u0005oC\u0011Ba4%#\u0003%\tA!5\t\u0013\t\u001dH%%A\u0005\u0002\t%\bb\u0002BwI\u0011\u0005!q\u001e\u0005\b\u0005\u007f$C\u0011AAf\u0011\u001d\u0019\t\u0001\nC\u0005\u0007\u0007A\u0011ba\u0002%\u0003\u0003%\ta!\u0003\t\u0013\rmA%%A\u0005\u0002\ru\u0001\"CB\u0011IE\u0005I\u0011AB\u000f\u0011%\u0019\u0019\u0003JI\u0001\n\u0003\u0019i\u0002C\u0005\u0004&\u0011\n\n\u0011\"\u0001\u0004(!I11\u0006\u0013\u0012\u0002\u0013\u00051Q\u0004\u0005\n\u0007[!\u0013\u0013!C\u0001\u0007;A\u0011ba\f%#\u0003%\ta!\r\t\u0013\rUB%%A\u0005\u0002\r]\u0002\"CB\u001eI\u0005\u0005I\u0011IA*\u0011%\u0019i\u0004JA\u0001\n\u0003\tI\u0003C\u0005\u0004@\u0011\n\t\u0011\"\u0001\u0004B!I11\n\u0013\u0002\u0002\u0013\u00053Q\n\u0005\n\u0007+\"\u0013\u0011!C\u0001\u0007/B\u0011ba\u0017%\u0003\u0003%\te!\u0018\t\u0013\r}C%!A\u0005B\r\u0005\u0004\"CB2I\u0005\u0005I\u0011IB3\u000f%\u0019)\nAA\u0001\u0012\u0003\u00199JB\u0005\u0002z\u0002\t\t\u0011#\u0001\u0004\u001a\"1am\u0015C\u0001\u0007OC\u0011ba\u0018T\u0003\u0003%)e!\u0019\t\u0013\r%6+!A\u0005\u0002\u000e-\u0006\"CB_'\u0006\u0005I\u0011QB`\u0005]\u0019Uo\u001d;p[F+x\u000e^1DC2d'-Y2l)\u0016\u001cHO\u0003\u0002[7\u0006\u0019\u0011\r]5\u000b\u0003q\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001?\u000e\u0004\"\u0001Y1\u000e\u0003eK!AY-\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\u0004\"\u0001\u00193\n\u0005\u0015L&!C*bg2\u001cV\r^;q\u0003\u0019a\u0014N\\5u}Q\t\u0001\u000e\u0005\u0002a\u0001\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002WB\u0011A\u000e_\u0007\u0002[*\u0011an\\\u0001\u0005CV$\bN\u0003\u0002qc\u0006A1/Z2ve&$\u0018P\u0003\u0002sg\u000611m\\7n_:T!\u0001\u0018;\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u0005\u0003s6\u0014\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@r\u0003\u001dqW\r^<pe.L1!a\u0001\u007f\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0005\u0005-\u0001CBA\u0007\u0003'\t9\"\u0004\u0002\u0002\u0010)\u0011\u0011\u0011C\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003+\tyA\u0001\u0003T_6,\u0007\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0003S>T!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tYB\u0001\u0003GS2,\u0017a\u00032s_.,'oQ8v]R,\"!a\u000b\u0011\t\u00055\u0011QF\u0005\u0005\u0003_\tyAA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\u0011\u0011q\u0007\t\u0007\u0003s\ty$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u001f\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000f\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\b\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\n9E\u0001\u0004TiJLgnZ\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000fI\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNlWCAA\"\u0003eY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\u001c\u0011\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\t\tY\u0006\u0005\u0004\u0002\u000e\u0005M\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)!\u00111MA\u0010\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0014\u0011\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005a\u0011\rZ7j]\u000ec\u0017.\u001a8ugV\u0011\u00111\u000f\t\u0007\u0003k\nY(a \u000e\u0005\u0005]$\u0002BA=\u0003w\tq!\\;uC\ndW-\u0003\u0003\u0002~\u0005]$aC!se\u0006L()\u001e4gKJ\u0004B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0003bI6LgNC\u0002\u0002\nN\fqa\u00197jK:$8/\u0003\u0003\u0002\u000e\u0006\r%!B!e[&t\u0017!D1e[&t7\t\\5f]R\u001c\b%\u0001\u000bqe>$WoY3s/&$\bn\\;u#V|G/Y\u000b\u0003\u0003+\u0003\u0002\"a&\u0002\u001e\u0006\u0005\u0016\u0011U\u0007\u0003\u00033SA!a'\u0002\b\u0006A\u0001O]8ek\u000e,'/\u0003\u0003\u0002 \u0006e%!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0005\u0004\u0002\u000e\u0005\r\u0016qU\u0005\u0005\u0003K\u000byAA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u000e\u0005%\u0016\u0002BAV\u0003\u001f\u0011AAQ=uK\u0006A\u0002O]8ek\u000e,'oV5uQ>,H/U;pi\u0006|F%Z9\u0015\t\u0005E\u0016q\u0017\t\u0005\u0003\u001b\t\u0019,\u0003\u0003\u00026\u0006=!\u0001B+oSRD\u0011\"!/\u0014\u0003\u0003\u0005\r!!&\u0002\u0007a$\u0013'A\u000bqe>$WoY3s/&$\bn\\;u#V|G/\u0019\u0011\u0002'\u0011,g-Y;miJ+\u0017/^3tiF+x\u000e^1\u0002)\u0011,g-Y;miJ+\u0017/^3tiF+x\u000e^1!\u0003M!WMZ1vYR\u0004&o\u001c3vG\u0016\fVo\u001c;b\u0003Q!WMZ1vYR\u0004&o\u001c3vG\u0016\fVo\u001c;bA\u0005\u0019B-\u001a4bk2$8i\u001c8tk6,\u0017+^8uC\u0006!B-\u001a4bk2$8i\u001c8tk6,\u0017+^8uC\u0002\nQa]3u+B$\"!!-)\u0007m\ty\r\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)N^\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00033\f\u0019N\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001aA$a8\u0011\t\u0005E\u0017\u0011]\u0005\u0005\u0003G\f\u0019NA\u0003BMR,'/A\u0012d_:4\u0017nZ;sKN+7-\u001e:jif\u0014UMZ8sKN+'O^3sgN#\u0018M\u001d;\u0002/Q,7\u000f^\"vgR|W.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007f\u0001\u0010\u0002lB!\u0011\u0011[Aw\u0013\u0011\ty/a5\u0003\tQ+7\u000f^\u0001\u0017GJ,\u0017\r^3He>,\boV5uQ>sW-V:feR1\u0011Q_B5\u0007[\u00022!a>%\u001b\u0005\u0001!aC$s_V\u0004X\rZ+tKJ\u001cr\u0001JA\u007f\u0005\u0007\u0011I\u0001E\u0002a\u0003\u007fL1A!\u0001Z\u0005A\tVo\u001c;b)\u0016\u001cHo\u00117jK:$8\u000f\u0005\u0003\u0002\u000e\t\u0015\u0011\u0002\u0002B\u0004\u0003\u001f\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u000e\t-\u0011\u0002\u0002B\u0007\u0003\u001f\u0011AbU3sS\u0006d\u0017N_1cY\u0016\fA!^:feV\u0011!1\u0003\t\u0005\u0005+\u0011\u0019C\u0004\u0003\u0003\u0018\t}\u0001\u0003\u0002B\r\u0003\u001fi!Aa\u0007\u000b\u0007\tuQ,\u0001\u0004=e>|GOP\u0005\u0005\u0005C\ty!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\u0012)C\u0003\u0003\u0003\"\u0005=\u0011!B;tKJ\u0004\u0013!C;tKJ<%o\\;q\u0003))8/\u001a:He>,\b\u000fI\u0001\u0006i>\u0004\u0018nY\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u00151,\u0017\rZ3s\u001d>$W-\u0006\u0002\u00036A!!q\u0007B\u001f\u001b\t\u0011IDC\u0002\u0003<m\u000baa]3sm\u0016\u0014\u0018\u0002\u0002B \u0005s\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006YA.Z1eKJtu\u000eZ3!\u0003A\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE-A\tqe>$WoY3s\u00072LWM\u001c;JI\u0002\n\u0001cY8ogVlWM]\"mS\u0016tG/\u00133\u0002#\r|gn];nKJ\u001cE.[3oi&#\u0007%A\u0005qe>$WoY3sA%!\u00111TA\u0000\u0003!\u0019wN\\:v[\u0016\u0014XC\u0001B*!!\u0011)F!\u0017\u0002\"\u0006\u0005VB\u0001B,\u0015\u0011\u0011y%a\"\n\t\tm#q\u000b\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0002\u0013\r|gn];nKJ\u0004\u0013\u0002\u0002B(\u0003\u007f$\"#!>\u0003d\t\u0015$q\rB5\u0005W\u0012iGa\u001c\u0003r!9!qB\u001bA\u0002\tM\u0001b\u0002B\u0015k\u0001\u0007!1\u0003\u0005\b\u0005[)\u0004\u0019\u0001B\n\u0011\u001d\u0011\t$\u000ea\u0001\u0005kAqAa\u00116\u0001\u0004\u0011\u0019\u0002C\u0004\u0003HU\u0002\rAa\u0005\t\u000f\u0005mU\u00071\u0001\u0002\u0016\"9!qJ\u001bA\u0002\tM\u0013!D;tKJ\u0004&/\u001b8dSB\fG.\u0006\u0002\u0003xA\u0019AN!\u001f\n\u0007\tmTN\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002\u001fE,x\u000e^1NKR\u0014\u0018n\u0019+bON$BA!!\u0003\bBA!Q\u0003BB\u0005'\u0011\u0019\"\u0003\u0003\u0003\u0006\n\u0015\"aA'ba\"9!\u0011R\u001cA\u0002\tM\u0011\u0001C2mS\u0016tG/\u00133\u0002\u001d=4XM\u001d:jI\u0016\fVo\u001c;bgRA\u0011\u0011\u0017BH\u00053\u0013i\nC\u0004\u0003\u0012b\u0002\rAa%\u0002\u001bA\u0014x\u000eZ;dKJ\fVo\u001c;b!\u0011\tiA!&\n\t\t]\u0015q\u0002\u0002\u0005\u0019>tw\rC\u0004\u0003\u001cb\u0002\rAa%\u0002\u001b\r|gn];nKJ\fVo\u001c;b\u0011\u001d\u0011y\n\u000fa\u0001\u0005C\u000bAB]3rk\u0016\u001cH/U;pi\u0006\u0004B!!\u0004\u0003$&!!QUA\b\u0005\u0019!u.\u001e2mK\u0006!\"/Z7pm\u0016\fVo\u001c;b\u001fZ,'O]5eKN\fabY8oM&<WO]3Rk>$\u0018\r\u0006\u0006\u00022\n5&q\u0016BY\u0005gCqA!\u000b;\u0001\u0004\u0011\u0019\u0002C\u0004\u0003\u0012j\u0002\rAa%\t\u000f\tm%\b1\u0001\u0003\u0014\"9!q\u0014\u001eA\u0002\t\u0005\u0016\u0001G2p]\u001aLw-\u001e:f\u0003:$w+Y5u\r>\u0014\u0018+^8uCRQ\u0011\u0011\u0017B]\u0005{\u0013\tM!2\t\u000f\tm6\b1\u0001\u0003\u0014\u0006a\u0001O]8ek\u000e,\u0017+^8uC\"9!qX\u001eA\u0002\tM\u0015A\u00034fi\u000eD\u0017+^8uC\"I!1Y\u001e\u0011\u0002\u0003\u0007\u00111F\u0001\bI&4\u0018n]8s\u0011%\u00119m\u000fI\u0001\u0002\u0004\u0011I-A\u0003he>,\b\u000f\u0005\u0004\u0002\u000e\t-'1C\u0005\u0005\u0005\u001b\fyA\u0001\u0004PaRLwN\\\u0001#G>tg-[4ve\u0016\fe\u000eZ,bSR4uN])v_R\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM'\u0006BA\u0016\u0005+\\#Aa6\u0011\t\te'1]\u0007\u0003\u00057TAA!8\u0003`\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005C\fy!\u0001\u0006b]:|G/\u0019;j_:LAA!:\u0003\\\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002E\r|gNZ5hkJ,\u0017I\u001c3XC&$hi\u001c:Rk>$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YO\u000b\u0003\u0003J\nU\u0017A\u00049s_\u0012,8-Z\"p]N,X.\u001a\u000b\u0007\u0003c\u0013\tPa?\t\u000f\tMh\b1\u0001\u0003v\u0006)R\r\u001f9fGR\u0004&o\u001c3vG\u0016$\u0006N]8ui2,\u0007\u0003BA\u0007\u0005oLAA!?\u0002\u0010\t9!i\\8mK\u0006t\u0007b\u0002B\u007f}\u0001\u0007!Q_\u0001\u0016Kb\u0004Xm\u0019;D_:\u001cX/\\3UQJ|G\u000f\u001e7f\u0003U\u0011X-\\8wKRC'o\u001c;uY\u0016lU\r\u001e:jGN\fq\"];pi\u0006,e\u000e^5us:\u000bW.\u001a\u000b\u0005\u0005'\u0019)\u0001C\u0004\u0003*\u0001\u0003\rAa\u0005\u0002\t\r|\u0007/\u001f\u000b\u0013\u0003k\u001cYa!\u0004\u0004\u0010\rE11CB\u000b\u0007/\u0019I\u0002C\u0005\u0003\u0010\u0005\u0003\n\u00111\u0001\u0003\u0014!I!\u0011F!\u0011\u0002\u0003\u0007!1\u0003\u0005\n\u0005[\t\u0005\u0013!a\u0001\u0005'A\u0011B!\rB!\u0003\u0005\rA!\u000e\t\u0013\t\r\u0013\t%AA\u0002\tM\u0001\"\u0003B$\u0003B\u0005\t\u0019\u0001B\n\u0011%\tY*\u0011I\u0001\u0002\u0004\t)\nC\u0005\u0003P\u0005\u0003\n\u00111\u0001\u0003T\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\u0010U\u0011\u0011\u0019B!6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007SQCA!\u000e\u0003V\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0019\u0019D\u000b\u0003\u0002\u0016\nU\u0017AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007sQCAa\u0015\u0003V\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004D\r%\u0003\u0003BA\u0007\u0007\u000bJAaa\u0012\u0002\u0010\t\u0019\u0011I\\=\t\u0013\u0005eF*!AA\u0002\u0005-\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r=\u0003CBA\u001d\u0007#\u001a\u0019%\u0003\u0003\u0004T\u0005m\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!>\u0004Z!I\u0011\u0011\u0018(\u0002\u0002\u0003\u000711I\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111F\u0001\ti>\u001cFO]5oOR\u0011\u00111I\u0001\u0007KF,\u0018\r\\:\u0015\t\tU8q\r\u0005\n\u0003s\u000b\u0016\u0011!a\u0001\u0007\u0007Bqaa\u001b \u0001\u0004\u0011\u0019\"A\u0005gSJ\u001cH/V:fe\"91qN\u0010A\u0002\u0005-\u0012\u0001\u00032s_.,'/\u00133\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\t\u0003c\u001b)ha\u001e\u0004|!9!Q\u0006\u0011A\u0002\tM\u0001bBB=A\u0001\u0007\u00111F\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\ru\u0004\u00051\u0001\u0002,\u00051A.Z1eKJ\f\u0011c\u0019:fCR,\u0017\tZ7j]\u000ec\u0017.\u001a8u)\t\ty(\u0001\fqe>$WoY3XSRDw.\u001e;UQJ|G\u000f\u001e7f)\u0019\t\tla\"\u0004\n\"9!Q\u0006\u0012A\u0002\tM\u0001bBBFE\u0001\u0007\u00111F\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018aB1eIV\u001bXM\u001d\u000b\u0007\u0003k\u001c\tja%\t\u000f\t=1\u00051\u0001\u0003\u0014!91QP\u0012A\u0002\u0005-\u0012aC$s_V\u0004X\rZ+tKJ\u00042!a>T'\u0015\u001961\u0014B\u0005!Y\u0019ija)\u0003\u0014\tM!1\u0003B\u001b\u0005'\u0011\u0019\"!&\u0003T\u0005UXBABP\u0015\u0011\u0019\t+a\u0004\u0002\u000fI,h\u000e^5nK&!1QUBP\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000f\u000b\u0003\u0007/\u000bQ!\u00199qYf$\"#!>\u0004.\u000e=6\u0011WBZ\u0007k\u001b9l!/\u0004<\"9!q\u0002,A\u0002\tM\u0001b\u0002B\u0015-\u0002\u0007!1\u0003\u0005\b\u0005[1\u0006\u0019\u0001B\n\u0011\u001d\u0011\tD\u0016a\u0001\u0005kAqAa\u0011W\u0001\u0004\u0011\u0019\u0002C\u0004\u0003HY\u0003\rAa\u0005\t\u000f\u0005me\u000b1\u0001\u0002\u0016\"9!q\n,A\u0002\tM\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u0003\u001cI\r\u0005\u0004\u0002\u000e\t-71\u0019\t\u0015\u0003\u001b\u0019)Ma\u0005\u0003\u0014\tM!Q\u0007B\n\u0005'\t)Ja\u0015\n\t\r\u001d\u0017q\u0002\u0002\u0007)V\u0004H.\u001a\u001d\t\u0013\r-w+!AA\u0002\u0005U\u0018a\u0001=%a\u0001")
public class CustomQuotaCallbackTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private volatile CustomQuotaCallbackTest$GroupedUser$ GroupedUser$module;
    private final int brokerCount;
    private final Seq<String> kafkaServerSaslMechanisms;
    private final String kafkaClientSaslMechanism;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final ArrayBuffer<Admin> adminClients;
    private KafkaProducer<byte[], byte[]> producerWithoutQuota;
    private final int defaultRequestQuota;
    private final int defaultProduceQuota;
    private final int defaultConsumeQuota;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    public CustomQuotaCallbackTest$GroupedUser$ GroupedUser() {
        if (this.GroupedUser$module == null) {
            this.GroupedUser$lzycompute$1();
        }
        return this.GroupedUser$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName("BROKER");
    }

    private Some<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private Seq<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    private ArrayBuffer<Admin> adminClients() {
        return this.adminClients;
    }

    private KafkaProducer<byte[], byte[]> producerWithoutQuota() {
        return this.producerWithoutQuota;
    }

    private void producerWithoutQuota_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producerWithoutQuota = x$1;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public int defaultProduceQuota() {
        return this.defaultProduceQuota;
    }

    public int defaultConsumeQuota() {
        return this.defaultConsumeQuota;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections(this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)"SCRAM-SHA-256"), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), GroupedUserQuotaCallback.class.getName());
        this.serverConfig().setProperty(new StringBuilder(0).append(this.listenerName().configPrefix()).append(KafkaConfig$.MODULE$.PrincipalBuilderClassProp()).toString(), GroupedUserPrincipalBuilder.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
        super.setUp();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        this.producerWithoutQuota_$eq(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()));
    }

    @Override
    @After
    public void tearDown() {
        this.adminClients().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        GroupedUserQuotaCallback$.MODULE$.tearDown();
        super.tearDown();
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Test
    public void testCustomQuotaCallback() {
        int brokerId = 0;
        GroupedUser user = this.createGroupWithOneUser("group0_user1", brokerId);
        long x$1 = 1000000L;
        long x$22 = 2000000L;
        int x$3 = user.configureAndWaitForQuota$default$3();
        Option<String> x$4 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(x$1, x$22, x$3, x$4);
        GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.set(0);
            return BoxedUnit.UNIT;
        });
        user.produceConsume(false, false);
        Assert.assertEquals((long)1L, (long)((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.PRODUCE)).get());
        Assert.assertEquals((long)1L, (long)((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.FETCH)).get());
        Assert.assertTrue((String)new StringBuilder(26).append("Too many quotaLimit calls ").append(GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls()).toString(), (((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.REQUEST)).get() <= 10 ? 1 : 0) != 0);
        long x$5 = 9000L;
        long x$6 = 3000L;
        int x$7 = user.configureAndWaitForQuota$default$3();
        Option<String> x$8 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(x$5, x$6, x$7, x$8);
        user.produceConsume(true, true);
        user = this.addUser("group0_user2", brokerId);
        user.removeQuotaOverrides();
        long x$9 = this.defaultProduceQuota();
        long x$10 = this.defaultConsumeQuota();
        double x$11 = this.defaultRequestQuota();
        KafkaServer x$12 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(x$9, x$10, x$11, x$12);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(8000L, 2500L, 1, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        user = this.addUser("group0_user3", brokerId);
        long x$13 = 2000000L;
        long x$14 = 2000000L;
        int x$15 = user.configureAndWaitForQuota$default$3();
        Option<String> x$16 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(x$13, x$14, x$15, x$16);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        brokerId = 1;
        user = this.createGroupWithOneUser("group1_user1", brokerId);
        long x$17 = 800000L;
        long x$18 = 250000L;
        int x$19 = user.configureAndWaitForQuota$default$3();
        Option<String> x$20 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(x$17, x$18, x$19, x$20);
        user.produceConsume(false, false);
        String largeTopic = "group1_largeTopic";
        this.createTopic(largeTopic, 99, 0);
        long x$21 = 8000L;
        long x$222 = 2500L;
        double x$23 = this.defaultRequestQuota();
        KafkaServer x$24 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(x$21, x$222, x$23, x$24);
        user.produceConsume(true, true);
        user = this.addUser("group1_user2", brokerId);
        long x$25 = this.defaultProduceQuota() / 100;
        long x$26 = this.defaultConsumeQuota() / 100;
        double x$27 = this.defaultRequestQuota();
        KafkaServer x$28 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(x$25, x$26, x$27, x$28);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(800000L, 250000L, 100, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        this.adminZkClient().deleteTopic(largeTopic);
        user = this.addUser("group1_user3", brokerId);
        long x$29 = 800000L;
        long x$30 = 250000L;
        double x$31 = this.defaultRequestQuota();
        KafkaServer x$32 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(x$29, x$30, x$31, x$32);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        Admin adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultProduceQuotaProp(), "8000");
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultFetchQuotaProp(), "2500");
        TestUtils$.MODULE$.alterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, false);
        long x$33 = 8000L;
        long x$34 = 2500L;
        double x$35 = this.defaultRequestQuota();
        KafkaServer x$36 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(x$33, x$34, x$35, x$36);
        user.produceConsume(true, true);
        Assert.assertEquals((long)this.brokerCount(), (long)GroupedUserQuotaCallback$.MODULE$.callbackInstances().get());
    }

    /*
     * WARNING - void declaration
     */
    private GroupedUser createGroupWithOneUser(String firstUser, int brokerId) {
        void var3_3;
        GroupedUser user = this.addUser(firstUser, brokerId);
        this.createTopic(user.topic(), 1, brokerId);
        user.configureAndWaitForQuota(this.defaultProduceQuota(), this.defaultConsumeQuota(), 1, (Option<String>)None$.MODULE$);
        return var3_3;
    }

    private void createTopic(String topic, int numPartitions, int leader) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        scala.collection.immutable.Map assignment = ((TraversableOnce)RichInt$.MODULE$.until$extension0(n, numPartitions).map((Function1 & Serializable & scala.Serializable)i -> CustomQuotaCallbackTest.$anonfun$createTopic$1(leader, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)this.servers());
    }

    /*
     * WARNING - void declaration
     */
    private Admin createAdminClient() {
        void var2_2;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName("BROKER")));
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.clientSecurityProps("admin-client")).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Object key = x0$1._1();
            Object value = x0$1._2();
            Object object = config.put(key.toString(), (String)value);
            return object;
        });
        config.put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        AdminClient adminClient = AdminClient.create(config);
        this.adminClients().$plus$eq((Object)adminClient);
        return var2_2;
    }

    public void kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(String topic, int numRecords) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                CustomQuotaCallbackTest.$anonfun$produceWithoutThrottle$1(this, topic, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    private GroupedUser addUser(String user, int leader) {
        String password = new StringBuilder(7).append(user).append(":secret").toString();
        this.createScramCredentials(this.zkConnect(), user, password);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CustomQuotaCallbackTest.$anonfun$addUser$1(this, user, server);
            return BoxedUnit.UNIT;
        });
        String userGroup = GroupedUserPrincipalBuilder$.MODULE$.group(user);
        String topic = new StringBuilder(6).append(userGroup).append("_topic").toString();
        String producerClientId = new StringBuilder(19).append(user).append(":producer-client-id").toString();
        String consumerClientId = new StringBuilder(19).append(user).append(":consumer-client-id").toString();
        this.producerConfig().put("client.id", producerClientId);
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.consumerConfig().put("client.id", consumerClientId);
        this.consumerConfig().put("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().put("group.id", new StringBuilder(6).append(user).append("-group").toString());
        this.consumerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        return new GroupedUser(this, user, userGroup, topic, (KafkaServer)this.servers().apply(leader), producerClientId, consumerClientId, producer, consumer);
    }

    private final void GroupedUser$lzycompute$1() {
        synchronized (this) {
            if (this.GroupedUser$module == null) {
                this.GroupedUser$module = new CustomQuotaCallbackTest$GroupedUser$(this);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$createTopic$1(int leader$1, int i) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader$1}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ Future $anonfun$produceWithoutThrottle$1(CustomQuotaCallbackTest $this, String topic$1, int i) {
        byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
        return $this.producerWithoutQuota().send(new ProducerRecord(topic$1, null, null, (Object)payload));
    }

    public static final /* synthetic */ boolean $anonfun$addUser$2(CredentialCache.Cache cache$1, String user$1) {
        return cache$1.get(user$1) != null;
    }

    public static final /* synthetic */ String $anonfun$addUser$3() {
        return "SCRAM credentials not created";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$addUser$1(CustomQuotaCallbackTest $this, String user$1, KafkaServer server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache($this.kafkaClientSaslMechanism(), ScramCredential.class);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!CustomQuotaCallbackTest.$anonfun$addUser$2(cache, user$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(CustomQuotaCallbackTest.$anonfun$addUser$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public CustomQuotaCallbackTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 2;
        this.kafkaServerSaslMechanisms = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}));
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties(this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.adminClients = new ArrayBuffer();
        this.defaultRequestQuota = 1000;
        this.defaultProduceQuota = 2000000000;
        this.defaultConsumeQuota = 1000000000;
    }

    public static final /* synthetic */ Future $anonfun$produceWithoutThrottle$1$adapted(CustomQuotaCallbackTest $this, String topic$1, Object i) {
        return CustomQuotaCallbackTest.$anonfun$produceWithoutThrottle$1($this, topic$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public class GroupedUser
    extends QuotaTestClients
    implements Product,
    scala.Serializable {
        private final String user;
        private final String userGroup;
        private final String topic;
        private final KafkaServer leaderNode;
        private final String producerClientId;
        private final String consumerClientId;
        public final /* synthetic */ CustomQuotaCallbackTest $outer;

        public String user() {
            return this.user;
        }

        public String userGroup() {
            return this.userGroup;
        }

        public String topic() {
            return this.topic;
        }

        public KafkaServer leaderNode() {
            return this.leaderNode;
        }

        public String producerClientId() {
            return this.producerClientId;
        }

        public String consumerClientId() {
            return this.consumerClientId;
        }

        @Override
        public KafkaProducer<byte[], byte[]> producer() {
            return super.producer();
        }

        @Override
        public KafkaConsumer<byte[], byte[]> consumer() {
            return super.consumer();
        }

        @Override
        public KafkaPrincipal userPrincipal() {
            return new GroupedUserPrincipal(this.user(), this.userGroup());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public scala.collection.immutable.Map<String, String> quotaMetricTags(String clientId) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = this.userGroup();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)GroupedUserQuotaCallback$.MODULE$.QuotaGroupTag());
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        }

        @Override
        public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
            this.configureQuota(this.userGroup(), producerQuota, consumerQuota, requestQuota);
        }

        @Override
        public void removeQuotaOverrides() {
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(this.userGroup()), new Properties());
        }

        public void configureQuota(String userGroup, long producerQuota, long consumerQuota, double requestQuota) {
            Properties quotaProps = this.quotaProperties(producerQuota, consumerQuota, requestQuota);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(userGroup), quotaProps);
        }

        public void configureAndWaitForQuota(long produceQuota, long fetchQuota, int divisor, Option<String> group) {
            if (group == null) {
                throw null;
            }
            Object object = group.isEmpty() ? GroupedUser.$anonfun$configureAndWaitForQuota$1() : group.get();
            this.configureQuota((String)object, produceQuota, fetchQuota, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota());
            this.waitForQuotaUpdate(produceQuota / (long)divisor, fetchQuota / (long)divisor, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota(), this.waitForQuotaUpdate$default$4());
        }

        public int configureAndWaitForQuota$default$3() {
            return 1;
        }

        public Option<String> configureAndWaitForQuota$default$4() {
            return new Some((Object)this.userGroup());
        }

        public void produceConsume(boolean expectProduceThrottle, boolean expectConsumeThrottle) {
            int numRecords = 1000;
            int produced = this.produceUntilThrottled(numRecords, false);
            this.verifyProduceThrottle(expectProduceThrottle, false);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(this.topic(), numRecords - produced);
            this.consumeUntilThrottled(numRecords, false);
            this.verifyConsumeThrottle(expectConsumeThrottle, false);
        }

        public void removeThrottleMetrics() {
            this.removeSensors$1((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
        }

        private String quotaEntityName(String userGroup) {
            return new StringBuilder(1).append(userGroup).append("_").toString();
        }

        public GroupedUser copy(String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            return new GroupedUser(this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer(), user, userGroup, topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.userGroup();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public KafkaServer copy$default$4() {
            return this.leaderNode();
        }

        public String copy$default$5() {
            return this.producerClientId();
        }

        public String copy$default$6() {
            return this.consumerClientId();
        }

        public KafkaProducer<byte[], byte[]> copy$default$7() {
            return this.producer();
        }

        public KafkaConsumer<byte[], byte[]> copy$default$8() {
            return this.consumer();
        }

        public String productPrefix() {
            return "GroupedUser";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.userGroup();
                }
                case 2: {
                    return this.topic();
                }
                case 3: {
                    return this.leaderNode();
                }
                case 4: {
                    return this.producerClientId();
                }
                case 5: {
                    return this.consumerClientId();
                }
                case 6: {
                    return this.producer();
                }
                case 7: {
                    return this.consumer();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof GroupedUser;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof GroupedUser)) return false;
            if (((GroupedUser)x$1).kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() != this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            GroupedUser groupedUser = (GroupedUser)x$1;
            String string = this.user();
            String string2 = groupedUser.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.userGroup();
            String string4 = groupedUser.userGroup();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.topic();
            String string6 = groupedUser.topic();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            KafkaServer kafkaServer = this.leaderNode();
            KafkaServer kafkaServer2 = groupedUser.leaderNode();
            if (kafkaServer == null) {
                if (kafkaServer2 != null) {
                    return false;
                }
            } else if (!kafkaServer.equals(kafkaServer2)) return false;
            String string7 = this.producerClientId();
            String string8 = groupedUser.producerClientId();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.consumerClientId();
            String string10 = groupedUser.consumerClientId();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            KafkaProducer<byte[], byte[]> kafkaProducer = this.producer();
            KafkaProducer<byte[], byte[]> kafkaProducer2 = groupedUser.producer();
            if (kafkaProducer == null) {
                if (kafkaProducer2 != null) {
                    return false;
                }
            } else if (!kafkaProducer.equals(kafkaProducer2)) return false;
            KafkaConsumer<byte[], byte[]> kafkaConsumer = this.consumer();
            KafkaConsumer<byte[], byte[]> kafkaConsumer2 = groupedUser.consumer();
            if (kafkaConsumer == null) {
                if (kafkaConsumer2 != null) {
                    return false;
                }
            } else if (!kafkaConsumer.equals(kafkaConsumer2)) return false;
            if (!groupedUser.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ CustomQuotaCallbackTest kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ String $anonfun$configureAndWaitForQuota$1() {
            return "";
        }

        private final void removeSensors$1(QuotaType quotaType, String clientId) {
            String sensorSuffix = this.quotaMetricTags(clientId).values().mkString(":");
            this.leaderNode().metrics().removeSensor(new StringBuilder(13).append(quotaType).append("ThrottleTime-").append(sensorSuffix).toString());
            this.leaderNode().metrics().removeSensor(new StringBuilder(1).append(quotaType).append("-").append(sensorSuffix).toString());
        }

        public GroupedUser(CustomQuotaCallbackTest $outer, String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            this.user = user;
            this.userGroup = userGroup;
            this.topic = topic;
            this.leaderNode = leaderNode;
            this.producerClientId = producerClientId;
            this.consumerClientId = consumerClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
            Product.$init$((Product)this);
        }
    }
}

