/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0003,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u0013Y\u0003B\u0002\u001c\u0001A\u0003%A\u0006C\u00048\u0001\t\u0007I\u0011A\u0016\t\ra\u0002\u0001\u0015!\u0003-\u0011\u001dI\u0004A1A\u0005\niBaa\u0011\u0001!\u0002\u0013Y\u0004b\u0002#\u0001\u0005\u0004%IA\u000f\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u001e\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\"1a\n\u0001Q\u0001\n!CQa\u0014\u0001\u0005BACQ!\u0018\u0001\u0005\u0002yCQa\u001b\u0001\u0005\n1D\u0011\"!\u000e\u0001#\u0003%I!a\u000e\t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u00191\u0011Q\f\u0001\u0005\u0003?BaAJ\u000b\u0005\u0002\u00055\u0004BBA:+\u0011\u0005c\f\u0003\u0004\u0002vU!\tE\u0018\u0002\u0017)J\fgn]1di&|gn\u001d\"pk:\u001cW\rV3ti*\u00111\u0004H\u0001\u0004CBL'\"A\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003Gq\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QE\t\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AG\u0001\u0013aJ|G-^2fe\n+hMZ3s'&TX-F\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\rIe\u000e^\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\rI\u0001\u0016g\u0016\u0014h/\u001a:NKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3t\u0003Y\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u00159,XnU3sm\u0016\u00148/A\u0006ok6\u001cVM\u001d<feN\u0004\u0013aC8viB,H\u000fV8qS\u000e,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\u0019\u0019FO]5oO\u0006aq.\u001e;qkR$v\u000e]5dA\u0005Q\u0011N\u001c9viR{\u0007/[2\u0002\u0017%t\u0007/\u001e;U_BL7\rI\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002L\u007f\u0005!Q\u000f^5m\u0013\ti%J\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012!\u0015\t\u0004%V;V\"A*\u000b\u0005Qs\u0013AC2pY2,7\r^5p]&\u0011ak\u0015\u0002\u0004'\u0016\f\bC\u0001-\\\u001b\u0005I&B\u0001.\u001d\u0003\u0019\u0019XM\u001d<fe&\u0011A,\u0017\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\tuKN$(I]8lKJ4\u0015-\u001b7ve\u0016$\u0012a\u0018\t\u0003[\u0001L!!\u0019\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u0003#\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u000b),h.\u001b;\u000b\u0003!\f1a\u001c:h\u0013\tQWM\u0001\u0003UKN$\u0018AI2sK\u0006$XmQ8ogVlWM]!oIN+(m]2sS\n,Gk\u001c+pa&\u001c7\u000f\u0006\u0004n}\u0006U\u00111\u0006\t\u0005]ZD\b0D\u0001p\u0015\t\u0001\u0018/\u0001\u0005d_:\u001cX/\\3s\u0015\t\u00118/A\u0004dY&,g\u000e^:\u000b\u0005u!(BA;h\u0003\u0019\t\u0007/Y2iK&\u0011qo\u001c\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u00075J80\u0003\u0002{]\t)\u0011I\u001d:bsB\u0011Q\u0006`\u0005\u0003{:\u0012AAQ=uK\"1qP\u0005a\u0001\u0003\u0003\tqa\u001a:pkBLE\r\u0005\u0003\u0002\u0004\u0005Ea\u0002BA\u0003\u0003\u001b\u00012!a\u0002/\u001b\t\tIAC\u0002\u0002\fy\ta\u0001\u0010:p_Rt\u0014bAA\b]\u00051\u0001K]3eK\u001aL1AQA\n\u0015\r\tyA\f\u0005\b\u0003/\u0011\u0002\u0019AA\r\u0003\u0019!x\u000e]5dgB1\u00111DA\u0013\u0003\u0003qA!!\b\u0002\"9!\u0011qAA\u0010\u0013\u0005y\u0013bAA\u0012]\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0014\u0003S\u0011A\u0001T5ti*\u0019\u00111\u0005\u0018\t\u0013\u00055\"\u0003%AA\u0002\u0005=\u0012!\u0004:fC\u0012\u001cu.\\7jiR,G\rE\u0002.\u0003cI1!a\r/\u0005\u001d\u0011un\u001c7fC:\fAf\u0019:fCR,7i\u001c8tk6,'/\u00118e'V\u00147o\u0019:jE\u0016$v\u000eV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e\"\u0006BA\u0018\u0003wY#!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fr\u0013AC1o]>$\u0018\r^5p]&!\u00111JA!\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\u0003\u0003#\u0002b!a\u0015\u0002Z1bSBAA+\u0015\r\t9fU\u0001\nS6lW\u000f^1cY\u0016LA!a\u0017\u0002V\t\u0019Q*\u00199\u0003\u001f\t{WO\\2f'\u000eDW\rZ;mKJ\u001c2!FA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA49\u0005)Q\u000f^5mg&!\u00111NA3\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0015\u0005\u0005=\u0004cAA9+5\t\u0001!\u0001\u0004e_^{'o[\u0001\tg\",H\u000fZ8x]\u0002")
public class TransactionsBounceTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final int numServers;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public int numServers() {
        return this.numServers;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testBrokerFailure() {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndSubscribeToTopics(consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribeToTopics$default$3());
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer("test-txn", (Seq<KafkaServer>)this.servers(), 512, TestUtils$.MODULE$.createTransactionalProducer$default$4(), TestUtils$.MODULE$.createTransactionalProducer$default$5());
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        IntRef numMessagesProcessed = IntRef.create((int)0);
        IntRef iteration = IntRef.create((int)0);
        try {
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), !shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(records.size()).append(" messages. Committing offsets.").toString());
                producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), consumerGroup);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(records.size()).append(" messages.").toString());
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(records.size()).append(" messages.").toString());
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.size();
                }
                ++iteration.elem;
            }
        }
        finally {
            producer.close();
            consumer.close();
        }
        scheduler.shutdown();
        KafkaConsumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribeToTopics("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(outputRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        Set recordSet = outputRecords.toSet();
        Assert.assertEquals((long)numInputRecords, (long)recordSet.size());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Set expectedValues = RichInt$.MODULE$.until$extension0(n, numInputRecords).toSet();
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(expectedValues.$minus$minus((GenTraversableOnce)recordSet)).toString(), (Object)expectedValues, (Object)recordSet);
        verifyingConsumer.close();
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndSubscribeToTopics(String groupId, List<String> topics, boolean readCommitted) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$4 = false;
        String x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, groupId, x$5, x$4, readCommitted, x$6, x$7, x$8, x$9, x$10, x$11);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribeToTopics$default$3() {
        return false;
    }

    private scala.collection.immutable.Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$7(HashMap recordsByPartition$1, ConsumerRecord record) {
        String string = TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int value = new StringOps(string).toInt();
        TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
        ((BufferLike)recordsByPartition$1.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> new ListBuffer())).append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value}));
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$9(ListBuffer outputRecords$1, ListBuffer x0$1) {
        Assert.assertEquals((String)"Out of order messages detected", (Object)x0$1, (Object)x0$1.sorted((Ordering)Ordering.Int$.MODULE$));
        outputRecords$1.appendAll((TraversableOnce)x0$1);
    }

    public TransactionsBounceTest() {
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.numServers = 4;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
    }

    public class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions());
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().zkClient(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), foreach_i, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaServer server) {
            $this.trace((Function0 & Serializable & scala.Serializable)() -> {
                String string = "Shutting down server : %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())}));
            });
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.trace((Function0 & Serializable & scala.Serializable)() -> {
                String string = "Server %s shut down. Starting it up again.";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())}));
            });
            server.startup();
            $this.trace((Function0 & Serializable & scala.Serializable)() -> {
                String string = "Restarted server: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())}));
            });
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

