/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004H\u0001\u0001\u0006I!\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001A\u0011\u0019I\u0005\u0001)A\u0005\u0003\"9!\n\u0001b\u0001\n\u0003\u0001\u0005BB&\u0001A\u0003%\u0011\tC\u0004M\u0001\t\u0007I\u0011\u0001!\t\r5\u0003\u0001\u0015!\u0003B\u0011\u001dq\u0005A1A\u0005\u0002=Ca\u0001\u0017\u0001!\u0002\u0013\u0001\u0006bB-\u0001\u0005\u0004%\ta\u0014\u0005\u00075\u0002\u0001\u000b\u0011\u0002)\t\u000fm\u0003!\u0019!C\u00019\"1\u0001\u0010\u0001Q\u0001\nuCq!\u001f\u0001C\u0002\u0013\u0005!\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B>\t\u0011\u0005\u001d\u0001A1A\u0005\u0002iDq!!\u0003\u0001A\u0003%1\u0010C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u00111\b\u0001\u0005B\u0005\u0015\u0002bBA#\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u001f\u0002A\u0011AA\u0013\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003KAq!a\u0016\u0001\t\u0003\t)\u0003C\u0004\u0002\\\u0001!\t!!\n\t\u000f\u0005}\u0003\u0001\"\u0001\u0002&!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0002bBA4\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003W\u0002A\u0011AA\u0013\u0011\u001d\ty\u0007\u0001C\u0001\u0003KAq!a\u001d\u0001\t\u0003\t)\u0003C\u0004\u0002x\u0001!\t!!\n\t\u000f\u0005-\u0005\u0001\"\u0001\u0002&!9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003;\u0004A\u0011BAp\u0011%\ti\u000fAI\u0001\n\u0013\ty\u000fC\u0005\u0003\u0006\u0001\t\n\u0011\"\u0003\u0003\b!I!1\u0002\u0001\u0012\u0002\u0013%!Q\u0002\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u00119\u0002\u0001C\u0005\u00053A\u0011B!\f\u0001#\u0003%IAa\f\t\u0013\tM\u0002!%A\u0005\n\t=\"\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cH+Z:u\u0015\t\u0001\u0014'A\u0002ba&T\u0011AM\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0007\u0005\u00027s5\tqG\u0003\u00029c\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\tQtG\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tQ\b\u0005\u0002?\u00015\tq&\u0001\u0006ok6\u001cVM\u001d<feN,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0004\u0013:$\u0018a\u00038v[N+'O^3sg\u0002\n!\u0004\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'oQ8v]R\f1\u0004\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'oQ8v]R\u0004\u0013A\u0007;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\u0018a\u0007;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\b%A\u000fo_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8u\u0003yqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]\"pk:$\b%\u0001\u0004u_BL7-M\u000b\u0002!B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0005Y\u0006twMC\u0001V\u0003\u0011Q\u0017M^1\n\u0005]\u0013&AB*ue&tw-A\u0004u_BL7-\r\u0011\u0002\rQ|\u0007/[23\u0003\u001d!x\u000e]5de\u0001\na\u0003\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'o]\u000b\u0002;B\u0019alY3\u000e\u0003}S!\u0001Y1\u0002\u000f5,H/\u00192mK*\u0011!mQ\u0001\u000bG>dG.Z2uS>t\u0017B\u00013`\u0005\u0019\u0011UO\u001a4feB!a\r\u001d:s\u001b\u00059'B\u00015j\u0003!\u0001(o\u001c3vG\u0016\u0014(B\u00016l\u0003\u001d\u0019G.[3oiNT!A\r7\u000b\u00055t\u0017AB1qC\u000eDWMC\u0001p\u0003\ry'oZ\u0005\u0003c\u001e\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bc\u0001\"tk&\u0011Ao\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0005ZL!a^\"\u0003\t\tKH/Z\u0001\u0018iJ\fgn]1di&|g.\u00197Qe>$WoY3sg\u0002\na\u0003\u001e:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o]\u000b\u0002wB\u0019al\u0019?\u0011\u000bu\f\tA\u001d:\u000e\u0003yT!a`5\u0002\u0011\r|gn];nKJL1!a\u0001\u007f\u00055Y\u0015MZ6b\u0007>t7/^7fe\u00069BO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148\u000fI\u0001\u001a]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148/\u0001\u000eo_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\t\ty\u0001\u0005\u0004\u0002\u0012\u0005M\u0011qC\u0007\u0002C&\u0019\u0011QC1\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\"M\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0005\u00121\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0003tKR,\u0006\u000f\u0006\u0002\u0002(A\u0019!)!\u000b\n\u0007\u0005-2I\u0001\u0003V]&$\bfA\u000b\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u000269\fQA[;oSRLA!!\u000f\u00024\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004-\u0005}\u0002\u0003BA\u0019\u0003\u0003JA!a\u0011\u00024\t)\u0011I\u001a;fe\u0006)B/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\u001c\bfA\f\u0002JA!\u0011\u0011GA&\u0013\u0011\ti%a\r\u0003\tQ+7\u000f^\u00013i\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'o\u00155pk2$gj\u001c;TK\u0016,f\u000eZ3dS\u0012,G\rR1uC\"\u001a\u0001$!\u0013\u0002UQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eD\u0017J\\2mk\u0012,7/\u00112peR,G\r\u0016:b]N\f7\r^5p]\"\u001a\u0011$!\u0013\u0002\u001fQ,7\u000f^*f]\u0012|eMZ:fiND3AGA%\u0003M!Xm\u001d;GK:\u001c\u0017N\\4P]\u000e{W.\\5uQ\rY\u0012\u0011J\u0001\u0019i\u0016\u001cHOR3oG&twm\u00148TK:$wJ\u001a4tKR\u001c\bf\u0001\u000f\u0002J\u0005aC/Z:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0013:\u001cVM\u001c3PM\u001a\u001cX\r^:U_R\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004;\u0005%\u0013!\u0005;fgR4UM\\2j]\u001e|enU3oI\"\u001aa$!\u0013\u00025Q,7\u000f\u001e$f]\u000eLgnZ(o\u0003\u0012$\u0007+\u0019:uSRLwN\\:)\u0007}\tI%\u0001\u0012uKN$h)\u001a8dS:<wJ\u001c+sC:\u001c\u0018m\u0019;j_:,\u0005\u0010]5sCRLwN\u001c\u0015\u0004A\u0005%\u0013\u0001\b;fgRlU\u000f\u001c;ja2,W*\u0019:lKJ\u001cxJ\\3MK\u0006$WM\u001d\u0015\u0004C\u0005%\u0013\u0001\n;fgR\u001cuN\\:fGV$\u0018N^3msJ+h.\u00138jiR\u0013\u0018M\\:bGRLwN\\:)\u000f\t\nI%a\u001f\u0002~\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0002\u0000A!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u0006.\faaY8n[>t\u0017\u0002BAE\u0003\u0007\u0013abS1gW\u0006,\u0005pY3qi&|g.\u0001\u000fuKN$8i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;)\u000f\r\nI%a\u001f\u0002\u0010\u000e\u0012\u0011\u0011\u0013\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*!\u0011qSAB\u0003\u0019)'O]8sg&!\u00111TAK\u0005A!\u0016.\\3pkR,\u0005pY3qi&|g.A\u0014tK:$GK]1og\u0006\u001cG/[8oC2lUm]:bO\u0016\u001cx+\u001b;i-\u0006dW/\u001a*b]\u001e,G\u0003DA\u0014\u0003C\u000b\u0019+a/\u0002@\u0006\r\u0007\"\u00025%\u0001\u0004)\u0007bBASI\u0001\u0007\u0011qU\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003S\u000b9L\u0004\u0003\u0002,\u0006M\u0006cAAW\u00076\u0011\u0011q\u0016\u0006\u0004\u0003c\u001b\u0014A\u0002\u001fs_>$h(C\u0002\u00026\u000e\u000ba\u0001\u0015:fI\u00164\u0017bA,\u0002:*\u0019\u0011QW\"\t\r\u0005uF\u00051\u0001B\u0003\u0015\u0019H/\u0019:u\u0011\u0019\t\t\r\na\u0001\u0003\u0006\u0019QM\u001c3\t\u000f\u0005\u0015G\u00051\u0001\u0002H\u0006yq/\u001b7m\u0005\u0016\u001cu.\\7jiR,G\rE\u0002C\u0003\u0013L1!a3D\u0005\u001d\u0011un\u001c7fC:\f1b]3sm\u0016\u0014\bK]8qgR\u0011\u0011\u0011\u001b\t\u0005\u0003'\fI.\u0004\u0002\u0002V*\u0019\u0011q\u001b+\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\f)N\u0001\u0006Qe>\u0004XM\u001d;jKN\f1d\u0019:fCR,'+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014Hc\u0002?\u0002b\u0006\u0015\u0018\u0011\u001e\u0005\n\u0003G4\u0003\u0013!a\u0001\u0003O\u000bQa\u001a:pkBD\u0001\"a:'!\u0003\u0005\r!Q\u0001\u000f[\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t\u0011%\tYO\nI\u0001\u0002\u0004\t\t.A\u0003qe>\u00048/A\u0013de\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001f\u0016\u0005\u0003O\u000b\u0019p\u000b\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018!C;oG\",7m[3e\u0015\r\typQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0002\u0003s\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0015\u001a'/Z1uKJ+\u0017\rZ\"p[6LG\u000f^3e\u0007>t7/^7fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\n)\u001a\u0011)a=\u0002K\r\u0014X-\u0019;f%\u0016\fGmQ8n[&$H/\u001a3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\u001aTC\u0001B\bU\u0011\t\t.a=\u0002;\r\u0014X-\u0019;f%\u0016\fG-\u00168d_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$2\u0001 B\u000b\u0011\u001d\t\u0019O\u000ba\u0001\u0003O\u000b1d\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014HcB3\u0003\u001c\t}!\u0011\u0006\u0005\b\u0005;Y\u0003\u0019AAT\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007\"\u0003B\u0011WA\u0005\t\u0019\u0001B\u0012\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;NgB\u0019!I!\n\n\u0007\t\u001d2I\u0001\u0003M_:<\u0007\"\u0003B\u0016WA\u0005\t\u0019\u0001B\u0012\u0003)i\u0017\r\u001f\"m_\u000e\\Wj]\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uII*\"A!\r+\t\t\r\u00121_\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIM\u0002")
public class TransactionsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 4;
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.topic1(), numPartitions, this.numServers(), topicConfig);
        this.createTopic(this.topic2(), numPartitions, this.numServers(), topicConfig);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.transactionalProducerCount());
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                this.createTransactionalProducer("transactional-producer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, this.transactionalConsumerCount());
        if (range2 == null) {
            throw null;
        }
        Range foreach_this2 = range2;
        if (!foreach_this2.isEmpty()) {
            int foreach_i = foreach_this2.start();
            while (true) {
                this.createReadCommittedConsumer("transactional-group", this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
                if (foreach_i == foreach_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this2.step();
            }
        }
        int n3 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range3 = RichInt$.MODULE$.until$extension0(n3, this.nonTransactionalConsumerCount());
        if (range3 == null) {
            throw null;
        }
        Range foreach_this3 = range3;
        if (!foreach_this3.isEmpty()) {
            int foreach_i = foreach_this3.start();
            while (true) {
                this.createReadUncommittedConsumer("non-transactional-group");
                if (foreach_i == foreach_this3.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this3.step();
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testBasicTransactions() {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedConsumerShouldNotSeeUndecidedData() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3());
        KafkaConsumer readCommittedConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer readUncommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, TestUtils$.MODULE$.consumeRecords$default$3());
        Tuple2[] tuple2Array = new Tuple2[2];
        Long l = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Long l2 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertEquals((long)2L, (long)readUncommittedOffsetsForTimes.size());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)2L, (long)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(readCommittedConsumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$2(readCommittedConsumer, tp);
            return BoxedUnit.UNIT;
        });
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Long l3 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Long l4 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava());
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransaction() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3());
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = this.createReadCommittedConsumer$default$1();
        int x$3 = this.createReadCommittedConsumer$default$2();
        KafkaConsumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0)}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)2L, (long)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assert.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assert.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assert.assertEquals((long)3L, (long)second.offset());
    }

    @Test
    public void testSendOffsets() {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), "UTF-8");
                    String value = new String((byte[])record.value(), "UTF-8");
                    return producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), key, value, shouldCommit$1.elem));
                });
                producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), consumerGroupId);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)records.last()).value(), "UTF-8")).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)records.last()).value(), "UTF-8")).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        KafkaConsumer verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$testSendOffsets$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)numSeedMessages, (long)valueSeq.size());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)valueSeq.size(), (long)valueSet.size());
    }

    @Test
    public void testFencingOnCommit() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true));
        try {
            producer1.commitTransaction();
            throw Assertions$.MODULE$.fail("Should not be able to commit transactions from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingOnSendOffsets() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true));
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            producer1.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), "foobarGroup");
            throw Assertions$.MODULE$.fail("Should not be able to send offsets from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetMetadataInSendOffsetsToTransaction() {
        void $minus$greater$extension_$this;
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)offsetAndMetadata);
        producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), groupId);
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(TransactionsTest.$anonfun$testOffsetMetadataInSendOffsetsToTransaction$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testFencingOnSend() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)server.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnAddPartitions() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)server.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnTransactionExpiration() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, this.createTransactionalProducer$default$3());
        producer.initTransactions();
        producer.beginTransaction();
        Assert.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), "2", "2", false)).get();
            throw Assertions$.MODULE$.fail("should have raised a ProducerFencedException since the transaction has expired", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        KafkaConsumer nonTransactionalConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        KafkaConsumer transactionalConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assert.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    @Test
    public void testMultipleMarkersOneLeader() {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(topicWith10Partitions, 10, this.numServers(), topicConfig);
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = ((TraversableOnce)package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable & scala.Serializable)x$7 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=KafkaException.class)
    public void testConsecutivelyRunInitTransactions() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3());
        producer.initTransactions();
        producer.initTransactions();
        throw Assertions$.MODULE$.fail("Should have raised a KafkaException", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
    }

    @Test(expected=TimeoutException.class)
    public void testCommitTransactionTimeout() {
        String x$1 = "transactionalProducer";
        long x$2 = 1000L;
        long x$3 = this.createTransactionalProducer$default$2();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$3, x$2);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(new ProducerRecord(this.topic1(), (Object)"foobar".getBytes()));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.servers().size());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.killBroker(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        try {
            producer.commitTransaction();
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(start, end);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic, ((Object)BoxesRunTime.boxToInteger((int)foreach_i)).toString(), ((Object)BoxesRunTime.boxToInteger((int)foreach_i)).toString(), willBeCommitted));
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        producer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, x$3, x$4, maxPollRecords, x$7, x$8, x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        void var2_12;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return var2_12;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs) {
        Buffer<KafkaServer> x$2 = this.servers();
        int x$5 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, (Seq<KafkaServer>)x$2, x$5, transactionTimeoutMs, maxBlockMs);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assert.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$2(KafkaConsumer readCommittedConsumer$1, TopicPartition tp) {
        Assert.assertEquals((long)1L, (long)readCommittedConsumer$1.position(tp));
    }

    public static final /* synthetic */ int $anonfun$testSendOffsets$4(ConsumerRecord record) {
        String string = TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toInt();
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$7) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public TransactionsTest() {
        this.numServers = 3;
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
    }

    public static final /* synthetic */ KafkaProducer $anonfun$setUp$1$adapted(TransactionsTest $this, Object _) {
        return $this.createTransactionalProducer("transactional-producer", $this.createTransactionalProducer$default$2(), $this.createTransactionalProducer$default$3());
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$2$adapted(TransactionsTest $this, Object _) {
        return $this.createReadCommittedConsumer("transactional-group", $this.createReadCommittedConsumer$default$2(), $this.createReadCommittedConsumer$default$3());
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$3$adapted(TransactionsTest $this, Object _) {
        return $this.createReadUncommittedConsumer("non-transactional-group");
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1$adapted(KafkaProducer producer$2, String topic$1, boolean willBeCommitted$1, Object i) {
        return producer$2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString(), ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString(), willBeCommitted$1));
    }
}

