/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.AutoPreferredReplicaLeaderElection$;
import kafka.controller.BrokerChange$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerEventProcessor;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.TopicChange$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!IQ\u0004\u0001a\u0001\u0002\u0004%IA\b\u0005\nE\u0001\u0001\r\u00111A\u0005\n\rB\u0011\"\u000b\u0001A\u0002\u0003\u0005\u000b\u0015B\u0010\t\u000b)\u0002A\u0011A\u0016\t\u000bU\u0002A\u0011A\u0016\t\u000bi\u0002A\u0011A\u0016\t\u000bq\u0002A\u0011A\u0016\t\u000by\u0002A\u0011A\u0016\t\u000b\u0001\u0003A\u0011B!\t\u000be\u0003A\u0011\u0002.\u00035\r{g\u000e\u001e:pY2,'/\u0012<f]Rl\u0015M\\1hKJ$Vm\u001d;\u000b\u00059y\u0011AC2p]R\u0014x\u000e\u001c7fe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u001b\u000512m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/F\u0001 !\ta\u0002%\u0003\u0002\"\u001b\t12i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/\u0001\u000ed_:$(o\u001c7mKJ,e/\u001a8u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002%OA\u0011A#J\u0005\u0003MU\u0011A!\u00168ji\"9\u0001fAA\u0001\u0002\u0004y\u0012a\u0001=%c\u000592m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\tA\u0005\u000b\u0002\u0006[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002e\u0005\u0019qN]4\n\u0005Qz#!B!gi\u0016\u0014\u0018!\u0007;fgRlU\r\u001e:jGN\u001cE.Z1oK\u0012|en\u00117pg\u0016D#AB\u001c\u0011\u00059B\u0014BA\u001d0\u0005\u0011!Vm\u001d;\u0002%Q,7\u000f^#wK:$\u0018+^3vKRKW.\u001a\u0015\u0003\u000f]\n1\u0003^3tiN+8mY3tg\u001a,H.\u0012<f]RD#\u0001C\u001c\u00029Q,7\u000f^#wK:$H\u000b[1u)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u0012\u0011bN\u0001\u0006G\",7m\u001b\u000b\u0005I\t{E\u000bC\u0003D\u0015\u0001\u0007A)\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$\u0016\u001b\u0005A%BA%\u0012\u0003\u0019a$o\\8u}%\u00111*F\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L+!)\u0001K\u0003a\u0001#\u0006)QM^3oiB\u0011ADU\u0005\u0003'6\u0011qbQ8oiJ|G\u000e\\3s\u000bZ,g\u000e\u001e\u0005\u0006+*\u0001\rAV\u0001\u0005MVt7\rE\u0002\u0015/\u0012J!\u0001W\u000b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014!\u0002;j[\u0016\u0014HCA.h!\taV-D\u0001^\u0015\tqv,\u0001\u0003d_J,'B\u00011b\u0003\u001diW\r\u001e:jGNT!AY2\u0002\re\fW.\\3s\u0015\u0005!\u0017aA2p[&\u0011a-\u0018\u0002\u0006)&lWM\u001d\u0005\u0006\u0007.\u0001\r\u0001\u0012")
public class ControllerEventManagerTest {
    private ControllerEventManager controllerEventManager;

    private ControllerEventManager controllerEventManager() {
        return this.controllerEventManager;
    }

    private void controllerEventManager_$eq(ControllerEventManager x$1) {
        this.controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        if (this.controllerEventManager() != null) {
            this.controllerEventManager().close();
        }
    }

    @Test
    public void testMetricsCleanedOnClose() {
        MockTime time = new MockTime();
        ControllerStats controllerStats = new ControllerStats();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null){

            public void process(ControllerEvent event) {
            }

            public void preempt(ControllerEvent event) {
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().nonEmpty());
        this.controllerEventManager().close();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventQueueTime() {
        Object object;
        String metricName = "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs";
        ControllerStats controllerStats = new ControllerStats();
        MockTime time = new MockTime();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger processedEvents = new AtomicInteger();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, latch, time, processedEvents){
            private final CountDownLatch latch$1;
            private final MockTime time$1;
            private final AtomicInteger processedEvents$1;

            public void process(ControllerEvent event) {
                this.latch$1.await();
                this.time$1.sleep(500L);
                this.processedEvents$1.incrementAndGet();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$1 = latch$1;
                this.time$1 = time$1;
                this.processedEvents$1 = processedEvents$1;
            }
        };
        Assert.assertTrue((boolean)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$1(metricName, x$2))).values().isEmpty());
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        latch.countDown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$testEventQueueTime$2(processedEvents)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$testEventQueueTime$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Option option = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$4(metricName, x$3))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ControllerEventManagerTest.$anonfun$testEventQueueTime$5(metricName);
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        Histogram queueTimeHistogram = (Histogram)object;
        Assert.assertEquals((long)2L, (long)queueTimeHistogram.count());
        Assert.assertEquals((double)0.0, (double)queueTimeHistogram.min(), (double)0.01);
        Assert.assertEquals((double)500.0, (double)queueTimeHistogram.max(), (double)0.01);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulEvent() {
        void check_func;
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {};
        AutoPreferredReplicaLeaderElection$ check_event = AutoPreferredReplicaLeaderElection$.MODULE$;
        String check_metricName = "kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs";
        ControllerStats check_controllerStats = new ControllerStats();
        AtomicInteger check_eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch check_latch = new CountDownLatch(1);
        ControllerEventProcessor check_eventProcessor = new ControllerEventProcessor(null, check_latch, check_eventProcessedListenerCount, (Function0)check_func){
            private final CountDownLatch latch$2;
            private final AtomicInteger eventProcessedListenerCount$1;
            private final Function0 func$1;

            public void process(ControllerEvent event) {
                this.latch$2.await();
                this.eventProcessedListenerCount$1.incrementAndGet();
                this.func$1.apply$mcV$sp();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$2 = latch$2;
                this.eventProcessedListenerCount$1 = eventProcessedListenerCount$1;
                this.func$1 = func$1;
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, check_eventProcessor, (Time)new MockTime(), check_controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        long check_initialTimerCount = this.timer(check_metricName).count();
        this.controllerEventManager().put((ControllerEvent)check_event);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long check_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, (ControllerEvent)check_event)) {
            void check_waitUntilTrue_pause;
            void check_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime + check_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2((ControllerEvent)check_event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)check_waitUntilTrue_waitTimeMs, (long)check_waitUntilTrue_pause));
        }
        check_latch.countDown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long check_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            void check_waitUntilTrue_pause;
            void check_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime2 + check_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)check_waitUntilTrue_waitTimeMs, (long)check_waitUntilTrue_pause));
        }
        Assert.assertEquals((long)1L, (long)check_eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(check_initialTimerCount + 1L), (long)this.timer(check_metricName).count());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventThatThrowsException() {
        void check_func;
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            throw new NullPointerException();
        };
        BrokerChange$ check_event = BrokerChange$.MODULE$;
        String check_metricName = "kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs";
        ControllerStats check_controllerStats = new ControllerStats();
        AtomicInteger check_eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch check_latch = new CountDownLatch(1);
        ControllerEventProcessor check_eventProcessor = new /* invalid duplicate definition of identical inner class */;
        this.controllerEventManager_$eq(new ControllerEventManager(0, check_eventProcessor, (Time)new MockTime(), check_controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        long check_initialTimerCount = this.timer(check_metricName).count();
        this.controllerEventManager().put((ControllerEvent)check_event);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long check_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, (ControllerEvent)check_event)) {
            void check_waitUntilTrue_pause;
            void check_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime + check_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2((ControllerEvent)check_event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)check_waitUntilTrue_waitTimeMs, (long)check_waitUntilTrue_pause));
        }
        check_latch.countDown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long check_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            void check_waitUntilTrue_pause;
            void check_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime2 + check_waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)check_waitUntilTrue_waitTimeMs, (long)check_waitUntilTrue_pause));
        }
        Assert.assertEquals((long)1L, (long)check_eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(check_initialTimerCount + 1L), (long)this.timer(check_metricName).count());
    }

    /*
     * WARNING - void declaration
     */
    private void check(String metricName, ControllerEvent event, Function0<BoxedUnit> func) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventProcessor eventProcessor = new /* invalid duplicate definition of identical inner class */;
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)new MockTime(), controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        this.controllerEventManager().put(event);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, event)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2(event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        latch.countDown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        Object object;
        Option option = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$timer$1(metricName, x$4))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ControllerEventManagerTest.$anonfun$timer$2(metricName);
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        return (Timer)object;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsCleanedOnClose$1(MetricName x$1) {
        return x$1.getMBeanName().startsWith("kafka.controller:type=ControllerEventManager");
    }

    private static final Set allEventManagerMetrics$1() {
        return ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testMetricsCleanedOnClose$1(x$1)))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$1(String metricName$1, MetricName x$2) {
        String string = x$2.getMBeanName();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$2(AtomicInteger processedEvents$1) {
        return processedEvents$1.get() == 2;
    }

    public static final /* synthetic */ String $anonfun$testEventQueueTime$3() {
        return "Timed out waiting for processing of all events";
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$4(String metricName$1, MetricName x$3) {
        String string = x$3.getMBeanName();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testEventQueueTime$5(String metricName$1) {
        Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$check$1(ControllerEventManagerTest $this, ControllerEvent event$1) {
        ControllerState controllerState = $this.controllerEventManager().state();
        ControllerState controllerState2 = event$1.state();
        return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$check$2(ControllerEvent event$1) {
        return new StringBuilder(24).append("Controller state is not ").append(event$1.state()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$check$3(ControllerEventManagerTest $this) {
        ControllerState controllerState = $this.controllerEventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
    }

    public static final /* synthetic */ String $anonfun$check$4() {
        return "Controller state has not changed back to Idle";
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$2, MetricName x$4) {
        String string = x$4.getMBeanName();
        return !(string != null ? !string.equals(metricName$2) : metricName$2 != null);
    }

    public static final /* synthetic */ void $anonfun$timer$2(String metricName$2) {
        Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName$2).toString());
    }
}

