/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002BB\u0012\u0001A\u0003%\u0001\u0005C\u0004%\u0001\t\u0007I\u0011B\u0013\t\r1\u0002\u0001\u0015!\u0003'\u0011\u001di\u0003A1A\u0005\n9BaA\r\u0001!\u0002\u0013y\u0003\"B\u001a\u0001\t\u0003!\u0004\"B!\u0001\t\u0003!\u0004\"B\"\u0001\t\u0003!\u0004\"B#\u0001\t\u0003!\u0004\"B$\u0001\t\u0003A%\u0001\u0007+pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'\u000fV3ti*\u0011q\u0002E\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005q\u0011\u0001\u00032s_.,'/\u00133\u0016\u0003\u0001\u0002\"!F\u0011\n\u0005\t2\"aA%oi\u0006I!M]8lKJLE\rI\u0001\u0007G>tg-[4\u0016\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\t\u0002\rM,'O^3s\u0013\tY\u0003FA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000fI\u0016dW\r^5p]\u000ec\u0017.\u001a8u+\u0005y\u0003CA\u000f1\u0013\t\tdB\u0001\bEK2,G/[8o\u00072LWM\u001c;\u0002\u001f\u0011,G.\u001a;j_:\u001cE.[3oi\u0002\n!\u0003^3ti&s\u0017\u000e^5bY&T\u0018\r^5p]R\tQ\u0007\u0005\u0002\u0016m%\u0011qG\u0006\u0002\u0005+:LG\u000f\u000b\u0002\tsA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001[$\u0001\u0002+fgR\f\u0011\u0003^3ti\n\u000b7/[2EK2,G/[8oQ\tI\u0011(A\u000fuKN$H)\u001a7fi&|gnV5uQ\n\u0013xn[3s\u001f\u001a4G.\u001b8fQ\tQ\u0011(A\u0013uKN$(I]8lKJ4\u0015-\u001b7ve\u0016\fe\r^3s\t\u0016dW\r^5p]N#\u0018M\u001d;fI\"\u00121\"O\u0001\fS:LGoQ8oi\u0016DH\u000fF\u0003J\u0019j;\u0017\u000e\u0005\u0002\u001e\u0015&\u00111J\u0004\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\b\"B'\r\u0001\u0004q\u0015a\u00022s_.,'o\u001d\t\u0004\u001f^\u0003cB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019&#\u0001\u0004=e>|GOP\u0005\u0002/%\u0011aKF\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016LA\u0002TKFT!A\u0016\f\t\u000bmc\u0001\u0019\u0001/\u0002\rQ|\u0007/[2t!\ri\u0016\r\u001a\b\u0003=~\u0003\"!\u0015\f\n\u0005\u00014\u0012A\u0002)sK\u0012,g-\u0003\u0002cG\n\u00191+\u001a;\u000b\u0005\u00014\u0002CA/f\u0013\t17M\u0001\u0004TiJLgn\u001a\u0005\u0006Q2\u0001\r\u0001I\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000b)d\u0001\u0019\u0001\u0011\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f")
public class TopicDeletionManagerTest {
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private DeletionClient deletionClient() {
        return this.deletionClient;
    }

    @Test
    public void testInitialization() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar", "baz"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "baz"})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted().toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsIneligibleForDeletion().toSet());
    }

    @Test
    public void testBasicDeletion() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletion$1(x$1))));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletionWithBrokerOffline() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$1(failedBrokerId, x$2)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        void offlineReplicas2 = var12_11;
        void onlineReplicas2 = var13_12;
        replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)offlineReplicas2.toSeq(), (ReplicaState)OfflineReplica$.MODULE$);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)OfflineReplica$.MODULE$));
        Tuple2[] tuple2Array = new Tuple2[1];
        Long l = BoxesRunTime.boxToLong((long)(lastEpoch + 1L));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)offlineBroker);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        controllerContext.addLiveBrokersAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)offlineReplicas2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$2(x$4))));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerFailureAfterDeletionStarted() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBrokerFailureAfterDeletionStarted$1(failedBrokerId, x$5)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        void offlineReplicas2 = var12_11;
        void onlineReplicas2 = var13_12;
        deletionManager.failReplicaDeletion((Set)offlineReplicas2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Tuple2[] tuple2Array = new Tuple2[1];
        Long l = BoxesRunTime.boxToLong((long)(lastEpoch + 1L));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)offlineBroker);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        controllerContext.addLiveBrokersAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
    }

    public ControllerContext initContext(Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)brokerId -> TopicDeletionManagerTest.$anonfun$initContext$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        context.setLiveBrokerAndEpochs((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManagerTest.$anonfun$initContext$2(numPartitions, replicationFactor, brokers, leaderIndex, context, topic);
            return BoxedUnit.UNIT;
        });
        return context;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletion$1(PartitionAndReplica x$1) {
        String string = x$1.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$1(int failedBrokerId$1, PartitionAndReplica x$2) {
        return x$2.replica() == failedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$2(PartitionAndReplica x$4) {
        String string = x$4.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerFailureAfterDeletionStarted$1(int failedBrokerId$2, PartitionAndReplica x$5) {
        return x$5.replica() == failedBrokerId$2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$initContext$1(int brokerId) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Long l = BoxesRunTime.boxToLong((long)1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ void $anonfun$initContext$3(String topic$1, int replicationFactor$1, Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$1, int partitionId) {
        TopicPartition partition = new TopicPartition(topic$1, partitionId);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq replicas = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, replicationFactor$1).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)brokers$1.apply((i + leaderIndex$1.elem) % brokers$1.size())), IndexedSeq$.MODULE$.canBuildFrom());
        context$1.updatePartitionReplicaAssignment(partition, (Seq)replicas);
        ++leaderIndex$1.elem;
    }

    public static final /* synthetic */ void $anonfun$initContext$2(int numPartitions$1, int replicationFactor$1, Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$1, String topic) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numPartitions$1);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TopicDeletionManagerTest.$anonfun$initContext$3(topic, replicationFactor$1, brokers$1, leaderIndex$1, context$1, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public TopicDeletionManagerTest() {
        this.brokerId = 1;
    }
}

