/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001\u0002\u001c8\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004O\u0001\u0001\u0006Ia\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003K\u0011\u0019\u0001\u0006\u0001)A\u0005\u0017\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006BB.\u0001A\u0003%1\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011\u001d\u0011\u0007A1A\u0005\n\rDaa\u001a\u0001!\u0002\u0013!\u0007b\u00025\u0001\u0005\u0004%IA\u0013\u0005\u0007S\u0002\u0001\u000b\u0011B&\t\u000f)\u0004!\u0019!C\u0005\u0015\"11\u000e\u0001Q\u0001\n-Cq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004|\u0001\u0001\u0006IA\u001c\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\t)\u0001\u0001Q\u0001\nyD\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u0017A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005%\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fBq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002Z\u0001!\t!!\u0015\t\u000f\u0005%\u0004\u0001\"\u0001\u0002R!9\u0011Q\u000e\u0001\u0005\u0002\u0005E\u0003bBA9\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003k\u0002A\u0011AA)\u0011\u001d\tI\b\u0001C\u0001\u0003#Bq!! \u0001\t\u0003\t\t\u0006C\u0004\u0002\u0002\u0002!\t!!\u0015\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002R!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005E\u0003bBAG\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003#\u0003A\u0011AA)\u0011\u001d\t)\n\u0001C\u0001\u0003#Bq!!'\u0001\t\u0003\t\t\u0006C\u0004\u0002\u001e\u0002!\t!!\u0015\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002R!9\u0011Q\u0015\u0001\u0005\u0002\u0005E\u0003bBAU\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!a2\u0001\t\u0013\tI\rC\u0004\u0002N\u0002!I!a4\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\niCK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ$Vm\u001d;\u000b\u0005aJ\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:T!AO\u001e\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0003\u0011\u0002i\u0011aN\u0001\tEJ|7.\u001a:JIV\t1\n\u0005\u0002A\u0019&\u0011Q*\u0011\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003E!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0007%A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011a\u0017M\\4\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\ta\f\u0005\u0002A?&\u0011\u0001-\u0011\u0002\u0005\u0019>tw-A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007.F\u0001e!\t\u0001U-\u0003\u0002g\u0003\n)1\u000b[8si\u0006q\u0001O]8ek\u000e,'/\u00129pG\"\u0004\u0013\u0001\u0004;y]RKW.Z8vi6\u001b\u0018!\u0004;y]RKW.Z8vi6\u001b\b%\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\u0002\u0013QDhNU3tk2$X#\u00018\u0011\u0005=LX\"\u00019\u000b\u0005E\u0014\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0005M$\u0018AB2p[6|gN\u0003\u0002=k*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQ\bOA\tUe\u0006t7/Y2uS>t'+Z:vYR\f!\u0002\u001e=o%\u0016\u001cX\u000f\u001c;!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012A \t\u0004\u007f\u0006\u0005Q\"\u0001:\n\u0007\u0005\r!O\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nq\u0002\u001e=o\u0013\u0012\fe\u000eZ'be.,'o]\u000b\u0003\u0003\u0017\u0001b!!\u0004\u0002\u0014\u0005]QBAA\b\u0015\r\t\tbV\u0001\u0005kRLG.\u0003\u0003\u0002\u0016\u0005=!\u0001\u0002'jgR\u00042\u0001SA\r\u0013\r\tYb\u000e\u0002\u0014)bt\u0017\nZ!oI6\u000b'o[3s\u000b:$(/_\u0001\u0011ibt\u0017\nZ!oI6\u000b'o[3sg\u0002\n1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCV\u0011\u00111\u0005\t\u0004\u0011\u0006\u0015\u0012bAA\u0014o\t\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u0006aA\u000f\u001f8NKR\fG-\u0019;bA\u0005!R.\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ,\"!a\f\u0011\u0007!\u000b\t$C\u0002\u00024]\u0012q\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003Ui\u0017M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0002\nq\u0002\u001e=o'R\fG/Z'b]\u0006<WM]\u000b\u0003\u0003w\u00012\u0001SA\u001f\u0013\r\tyd\u000e\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001\u0003\u001e=o'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u000f!\fg\u000e\u001a7feV\u0011\u0011q\t\t\u0004\u0011\u0006%\u0013bAA&o\tICK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ\f\u0001\u0002[1oI2,'\u000fI\u0001\n[>\u001c7nQ1dQ\u0016$\"!a\u0015\u0011\u0007\u0001\u000b)&C\u0002\u0002X\u0005\u0013A!\u00168ji\u0006y3\u000f[8vY\u0012\u0014V-\u00128rk\u0016,X\rU1si&$\u0018n\u001c8t/\",gN\u0011:pW\u0016\u0014H)[:d_:tWm\u0019;fI\"\u001aq$!\u0018\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019x\u0003\u0015QWO\\5u\u0013\u0011\t9'!\u0019\u0003\tQ+7\u000f^\u0001>g\"|W\u000f\u001c3UQJ|w/\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g.\u00134FeJ|'oQ8eK:{G/\u0011<bS2\f'\r\\3G_J\u0004\u0016\u000e\u001a\u0015\u0004A\u0005u\u0013AK:i_VdGmQ8na2,G/\u001a#fY\u0006LX\rZ(qKJ\fG/[8o/\",gNT8FeJ|'o\u001d\u0015\u0004C\u0005u\u0013\u0001M:i_VdGmQ8na2,G/\u001a#fY\u0006LX\rZ(qKJ\fG/[8o/\",gNT8u\u0007>|'\u000fZ5oCR|'\u000fK\u0002#\u0003;\nAg\u001d5pk2$7i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8XQ\u0016t7i\\8sI&t\u0017\r^8s\u0019>\fG-\u001b8hQ\r\u0019\u0013QL\u0001:g\"|W\u000f\u001c3D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:<\u0006.\u001a8D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u000eC\u0017M\\4fI\"\u001aA%!\u0018\u0002mMDw.\u001e7e\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fI>\u0003XM]1uS>tw\u000b[3o\u0013:4\u0018\r\\5e!J|G-^2fe\u0016\u0003xn\u00195)\u0007\u0015\ni&A\u001ctQ>,H\u000eZ\"p[BdW\r^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]^CWmQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GK:\u001cW\r\u001a\u0015\u0004M\u0005u\u0013\u0001M:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8V].twn\u001e8FeJ|'\u000fK\u0002(\u0003;\nqg\u001d5pk2$G\u000b\u001b:po&cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]^CWM\\\"peJ,\b\u000f^'fgN\fw-Z#se>\u0014\bf\u0001\u0015\u0002^\u0005A4\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",g.T3tg\u0006<W\rV8p\u0019\u0006\u0014x-Z#se>\u0014\bfA\u0015\u0002^\u0005Y4\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",gNU3d_J$G*[:u)>|G*\u0019:hK\u0016\u0013(o\u001c:)\u0007)\ni&\u0001\u001ftQ>,H\u000e\u001a+ie><\u0018\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>tw\u000b[3o\u0013:4\u0018\r\\5e%\u0016\fX/\u001b:fI\u0006\u001b7n]#se>\u0014\bfA\u0016\u0002^\u0005!4\u000f[8vY\u0012\u0014V\r\u001e:z!\u0006\u0014H/\u001b;j_:<\u0006.\u001a8V].twn\u001e8U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:)\u00071\ni&\u0001\u001atQ>,H\u000e\u001a*fiJL\b+\u0019:uSRLwN\\,iK:tu\u000e\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:,%O]8sQ\ri\u0013QL\u0001/g\"|W\u000f\u001c3SKR\u0014\u0018\u0010U1si&$\u0018n\u001c8XQ\u0016tgj\u001c;F]>,x\r\u001b*fa2L7-Y:FeJ|'\u000fK\u0002/\u0003;\n\u0011h\u001d5pk2$'+\u001a;ssB\u000b'\u000f^5uS>tw\u000b[3o\u001d>$XI\\8vO\"\u0014V\r\u001d7jG\u0006\u001c\u0018I\u001a;fe\u0006\u0003\b/\u001a8e\u000bJ\u0014xN\u001d\u0015\u0004_\u0005u\u0013!R:i_VdGMU3n_Z,Gk\u001c9jGB\u000b'\u000f^5uS>tgI]8n/\u0006LG/\u001b8h'\u0016$xJ\\+ogV\u0004\bo\u001c:uK\u00124uN]'fgN\fw-\u001a$pe6\fG\u000fK\u00021\u0003;\nQD^3sS\u001aL(+\u001a;sS\u0016\u001c\b+\u0019:uSRLwN\\(o\u000bJ\u0014xN\u001d\u000b\u0005\u0003'\n\t\fC\u0004\u00024F\u0002\r!!.\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/s\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA`\u0003s\u0013a!\u0012:s_J\u001c\u0018a\n<fe&4\u0017\u0010\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:|e.\u0012:s_J$B!a\u0015\u0002F\"9\u00111\u0017\u001aA\u0002\u0005U\u0016!\n<fe&4\u0017pQ8na2,G/\u001a#fY\u0006LX\rZ(qKJ\fG/[8o\u001f:,%O]8s)\u0011\t\u0019&a3\t\u000f\u0005M6\u00071\u0001\u00026\u0006\u0019c/\u001a:jMf\u0014V-\\8wK\u0012+G.Y=fI>\u0003XM]1uS>twJ\\#se>\u0014H\u0003BA*\u0003#Dq!a-5\u0001\u0004\t),\u0001\rde\u0016\fG/\u001a)s_\u0012,8-\u001a:JI\u0016\u0013(o\u001c:NCB$B!a6\u0002hBA\u0011QBAm\u0003;\f\t/\u0003\u0003\u0002\\\u0006=!a\u0002%bg\"l\u0015\r\u001d\t\u0004)\u0006}\u0017B\u00011V!\u001d\ti!a9\u007f\u0003kKA!!:\u0002\u0010\t\u0019Q*\u00199\t\u000f\u0005%X\u00071\u0001\u00026\u00061QM\u001d:peN\u0004")
public class TransactionMarkerRequestCompletionHandlerTest {
    private final int brokerId;
    private final int txnTopicPartition;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch = (short)0;
    private final int txnTimeoutMs;
    private final int coordinatorEpoch;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkers = Arrays.asList((Object[])new TxnIdAndMarkerEntry[]{new TxnIdAndMarkerEntry(this.transactionalId(), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()})))});
    private final TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})), 0L, 0L);
    private final TransactionMarkerChannelManager markerChannelManager = (TransactionMarkerChannelManager)EasyMock.createNiceMock(TransactionMarkerChannelManager.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TransactionMarkerRequestCompletionHandler handler = new TransactionMarkerRequestCompletionHandler(this.brokerId(), this.txnStateManager(), this.markerChannelManager(), this.txnIdAndMarkers());

    private int brokerId() {
        return this.brokerId;
    }

    private int txnTopicPartition() {
        return this.txnTopicPartition;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private List<TxnIdAndMarkerEntry> txnIdAndMarkers() {
        return this.txnIdAndMarkers;
    }

    private TransactionMetadata txnMetadata() {
        return this.txnMetadata;
    }

    private TransactionMarkerChannelManager markerChannelManager() {
        return this.markerChannelManager;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TransactionMarkerRequestCompletionHandler handler() {
        return this.handler;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
    }

    @Test
    public void shouldReEnqueuePartitionsWhenBrokerDisconnected() {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, true, null, null, null));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfErrorCodeNotAvailableForPid() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(new HashMap());
        try {
            this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            Assert.fail((String)"should have thrown illegal argument exception");
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNoErrors() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNotCoordinator() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorLoading() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochChanged() {
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch() + 1, this.txnMetadata())))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenInvalidProducerEpoch() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.INVALID_PRODUCER_EPOCH);
    }

    @Test
    public void shouldCompleteDelayedOperationWheCoordinatorEpochFenced() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.TRANSACTION_COORDINATOR_FENCED);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenUnknownError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenCorruptMessageError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.CORRUPT_MESSAGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenMessageTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.MESSAGE_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenRecordListTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.RECORD_LIST_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenInvalidRequiredAcksError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.INVALID_REQUIRED_ACKS);
    }

    @Test
    public void shouldRetryPartitionWhenUnknownTopicOrPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotLeaderForPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_LEADER_FOR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasAfterAppendError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
    }

    @Test
    public void shouldRemoveTopicPartitionFromWaitingSetOnUnsupportedForMessageFormat() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    private void verifyRetriesPartitionOnError(Errors error) {
        this.mockCache();
        this.markerChannelManager().addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertEquals((Object)this.txnMetadata().topicPartitions(), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        EasyMock.verify((Object[])new Object[]{this.markerChannelManager()});
    }

    private void verifyThrowIllegalStateExceptionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        try {
            this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            Assert.fail((String)"should have thrown illegal state exception");
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    private void verifyCompleteDelayedOperationOnError(Errors error) {
        BooleanRef completed = BooleanRef.create((boolean)false);
        this.markerChannelManager().completeSendMarkersForTxnId(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, completed){
            private final BooleanRef completed$1;

            public void answer() {
                this.completed$1.elem = true;
            }
            {
                this.completed$1 = completed$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertTrue((boolean)this.txnMetadata().topicPartitions().isEmpty());
        Assert.assertTrue((boolean)completed.elem);
    }

    private void verifyRemoveDelayedOperationOnError(Errors error) {
        BooleanRef removed = BooleanRef.create((boolean)false);
        this.markerChannelManager().removeMarkersForTxnId(this.transactionalId());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, removed){
            private final BooleanRef removed$1;

            public void answer() {
                this.removed$1.elem = true;
            }
            {
                this.removed$1 = removed$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.markerChannelManager()});
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assert.assertTrue((boolean)removed.elem);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createProducerIdErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.topicPartition(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId()), errorsMap);
        return var2_2;
    }

    public TransactionMarkerRequestCompletionHandlerTest() {
        this.brokerId = 0;
        this.txnTopicPartition = 0;
        this.transactionalId = "txnId1";
        this.producerId = 0;
        this.txnTimeoutMs = 0;
        this.coordinatorEpoch = 0;
    }
}

