/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.nio.charset.StandardCharsets;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.utils.Json$;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.scalatestplus.junit.JUnitSuite;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0002\u0004\u0001\u001b!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0003i\u0002B\u0002\u0014\u0001A\u0003%a\u0004C\u0003(\u0001\u0011\u0005\u0001FA\u0004BG2$Vm\u001d;\u000b\u0005\u001dA\u0011\u0001B1vi\"T!!\u0003\u0006\u0002\u0011M,7-\u001e:jifT\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010-5\t\u0001C\u0003\u0002\u0012%\u0005)!.\u001e8ji*\u00111\u0003F\u0001\u000eg\u000e\fG.\u0019;fgR\u0004H.^:\u000b\u0003U\t1a\u001c:h\u0013\t9\u0002C\u0001\u0006K+:LGoU;ji\u0016\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0004\u0002\u000f\u0005\u001bGNS:p]V\ta\u0004\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005!A.\u00198h\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\rM#(/\u001b8h\u0003!\t5\r\u001c&t_:\u0004\u0013!\u0006;fgR\f5\r\u001c&t_:\u001cuN\u001c<feNLwN\u001c\u000b\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5uQ\t!\u0001\u0007\u0005\u00022g5\t!G\u0003\u0002\u0012)%\u0011AG\r\u0002\u0005)\u0016\u001cH\u000f")
public class AclTest
extends JUnitSuite {
    private final String AclJson;

    public String AclJson() {
        return this.AclJson;
    }

    @Test
    public void testAclJsonConversion() {
        Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3}));
        byte[] jsonAcls = Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Acl$.MODULE$.toJsonCompatibleMap(acls)).asJava());
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromBytes(jsonAcls));
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromBytes(this.AclJson().getBytes(StandardCharsets.UTF_8)));
    }

    public AclTest() {
        this.AclJson = "{\"version\": 1, \"acls\": [{\"host\": \"host1\",\"permissionType\": \"Deny\",\"operation\": \"READ\", \"principal\": \"User:alice\"  },  {  \"host\":  \"*\" ,  \"permissionType\": \"Allow\",  \"operation\":  \"Read\", \"principal\": \"User:bob\"  },  {  \"host\": \"host1\",  \"permissionType\": \"Deny\",  \"operation\":   \"Read\" ,  \"principal\": \"User:bob\"}  ]}";
    }
}

