/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000193Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)a\u0005\u0001C\u0001-!)\u0001\u0006\u0001C\u0001-!)!\u0006\u0001C\u0005W!)a\t\u0001C\u0005\u000f\n1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\n\u0015\u000511/\u001a:wKJT\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t\u0001\"\u0003\u0002\u0012\u0011\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011q\u0002A\u0001\u001ai\u0016\u001cH\u000fT5ti>3gm]3ug\u0016\u0013(o\u001c:D_\u0012,7\u000fF\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0011)f.\u001b;)\u0005\tq\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0013aA8sO&\u0011Q\u0005\t\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\u0004=\u0005yB/Z:u%\u0016\u001c\bo\u001c8tK&s7\r\\;eKNdU-\u00193fe\u0016\u0003xn\u00195)\u0005\u0011q\u0012aE1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014H\u0003B\f-syBQ!L\u0003A\u00029\nQ!\u001a:s_J\u0004\"aL\u001c\u000e\u0003AR!!\r\u001a\u0002\u0011A\u0014x\u000e^8d_2T!a\r\u001b\u0002\r\r|W.\\8o\u0015\tYQG\u0003\u00027E\u00051\u0011\r]1dQ\u0016L!\u0001\u000f\u0019\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015QT\u00011\u0001<\u0003!\u0011'o\\6fe&#\u0007C\u0001\r=\u0013\ti\u0014DA\u0002J]RDQaP\u0003A\u0002\u0001\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002B\t6\t!I\u0003\u0002De\u0005A!/Z9vKN$8/\u0003\u0002F\u0005\n\tB*[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0004\u0011.k\u0005CA!J\u0013\tQ%I\u0001\nMSN$xJ\u001a4tKR\u0014Vm\u001d9p]N,\u0007\"\u0002'\u0007\u0001\u0004Y\u0014\u0001\u00037fC\u0012,'/\u00133\t\u000b}2\u0001\u0019\u0001!")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testListOffsetsErrorCodes() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        ListOffsetRequest.PartitionData partitionData = new ListOffsetRequest.PartitionData(-2L, Optional.of(Predef$.MODULE$.int2Integer(0)));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ListOffsetRequest consumerRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetRequest replicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetRequest debugReplicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, replicaRequest);
        this.assertResponseError(Errors.REPLICA_NOT_AVAILABLE, nonReplica, debugReplicaRequest);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    @Test
    public void testResponseIncludesLeaderEpoch() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, 10, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(firstLeaderId, 0L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(firstLeaderId, -2L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), (Object)this.fetchOffsetAndEpoch$1(firstLeaderId, -1L, topicPartition));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(secondLeaderId, 0L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), (Object)this.fetchOffsetAndEpoch$1(secondLeaderId, -2L, topicPartition));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, secondLeaderEpoch), (Object)this.fetchOffsetAndEpoch$1(secondLeaderId, -1L, topicPartition));
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetRequest request) {
        ListOffsetResponse response = this.sendRequest(brokerId, request);
        Assert.assertEquals((long)request.partitionTimestamps().size(), (long)response.responseData().size());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.responseData()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)partitionData -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, partitionData);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetResponse sendRequest(int leaderId, ListOffsetRequest request) {
        SocketServer socketServer = this.brokerSocketServer(leaderId);
        return ListOffsetResponse.parse((ByteBuffer)this.connectAndSend((AbstractRequest)request, ApiKeys.LIST_OFFSETS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5()), (short)request.version());
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        ListOffsetRequest.PartitionData partitionData = new ListOffsetRequest.PartitionData(-2L, currentLeaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 fetchOffsetAndEpoch$1(int serverId, long timestamp, TopicPartition topicPartition$2) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        ListOffsetRequest.PartitionData partitionData = new ListOffsetRequest.PartitionData(timestamp, Optional.empty());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition$2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetResponse.PartitionData partitionData2 = (ListOffsetResponse.PartitionData)this.sendRequest(serverId, request).responseData().get(topicPartition$2);
        Optional epochOpt = partitionData2.leaderEpoch;
        Assert.assertTrue((boolean)epochOpt.isPresent());
        return new Tuple2.mcJI.sp(Predef$.MODULE$.Long2long(partitionData2.offset), Predef$.MODULE$.Integer2int((Integer)epochOpt.get()));
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetResponse.PartitionData partitionData) {
        Assert.assertEquals((Object)error$1, (Object)partitionData.error);
    }
}

