/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u0004<\u0001\u0001\u0006I\u0001\r\u0005\by\u0001\u0011\r\u0011\"\u00030\u0011\u0019i\u0004\u0001)A\u0005a!9a\b\u0001b\u0001\n\u0013y\u0003BB \u0001A\u0003%\u0001\u0007C\u0004A\u0001\t\u0007I\u0011B!\t\r!\u0003\u0001\u0015!\u0003C\u0011\u001dI\u0005A1A\u0005\n)CaA\u0014\u0001!\u0002\u0013Y\u0005\"B(\u0001\t\u0013\u0001\u0006b\u00020\u0001#\u0003%Ia\u0018\u0005\u0006U\u0002!\ta\u001b\u0005\u0006m\u0002!\ta\u001b\u0005\u0006q\u0002!\t!\u001f\u0005\u0007\u0003#\u0001A\u0011A6\t\r\u0005U\u0001\u0001\"\u0001l\u0011\u0019\tI\u0002\u0001C\u0001W\"1\u0011Q\u0004\u0001\u0005\u0002-Da!!\t\u0001\t\u0003Y\u0007BBA\u0013\u0001\u0011\u00051\u000e\u0003\u0004\u0002*\u0001!\ta\u001b\u0005\u0007\u0003[\u0001A\u0011A6\t\r\u0005E\u0002\u0001\"\u0001l\u0011\u0019\t)\u0004\u0001C\u0001W\"1\u0011\u0011\b\u0001\u0005\u0002-Dq!!\u0010\u0001\t\u0003\tyD\u0001\rSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a+fgRT!a\b\u0011\u0002\rM,'O^3s\u0015\u0005\t\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001-!\ti\u0003!D\u0001\u001f\u0003\u0011!\u0018\u0007\u001d\u0019\u0016\u0003A\u0002\"!M\u001d\u000e\u0003IR!a\r\u001b\u0002\r\r|W.\\8o\u0015\t\tSG\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e3\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ\u0001^\u0019qa\u0001\nA\u0001^\u0019qc\u0005)A/\r92A\u0005!AO\r92\u0003\u0015!(\u0007]\u0019!\u00039\u0011'o\\6fe\u0016sG\rU8j]R,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u0002\nqa\u00197vgR,'/\u0003\u0002H\t\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018a\u00042s_.,'/\u00128e!>Lg\u000e\u001e\u0011\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cX#A&\u0011\u00055b\u0015BA'\u001f\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/A\tgC&dW\r\u001a)beRLG/[8og\u0002\nab\u001c4gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eF\u0002R)f\u0003\"!\f*\n\u0005Ms\"AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\u0006+2\u0001\rAV\u0001\fM\u0016$8\r[(gMN,G\u000f\u0005\u0002&/&\u0011\u0001L\n\u0002\u0005\u0019>tw\rC\u0004[\u0019A\u0005\t\u0019A.\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u0003KqK!!\u0018\u0014\u0003\u0007%sG/\u0001\rpM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195%I\u00164\u0017-\u001e7uII*\u0012\u0001\u0019\u0016\u00037\u0006\\\u0013A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u001d4\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011\u000e\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001K:i_VdGmU3oI2\u000bG/Z:u%\u0016\fX/Z:u-\u0016\u00148/[8og\nKH)\u001a4bk2$H#\u00017\u0011\u0005\u0015j\u0017B\u00018'\u0005\u0011)f.\u001b;)\u00059\u0001\bCA9u\u001b\u0005\u0011(BA:8\u0003\u0015QWO\\5u\u0013\t)(O\u0001\u0003UKN$\u0018\u0001Q:i_VdGMR3uG\"dU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;JM2\u000b7\u000f^#q_\u000eDG)\u001a4j]\u0016$gi\u001c:T_6,\u0007+\u0019:uSRLwN\\:)\u0005=\u0001\u0018!F1tg\u0016\u0014H\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u000b\bYj|\u0018\u0011BA\u0007\u0011\u0015Y\b\u00031\u0001}\u0003\u001d1W\r^2iKJ\u0004\"!L?\n\u0005yt\"!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0003\u0003\u0001\u0002\u0019AA\u0002\u0003U\u0019\bn\\;mI\n+'+Z1es\u001a{'OR3uG\"\u00042!JA\u0003\u0013\r\t9A\n\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\u0001\u0005a\u0001\u0003\u0007\tQc\u001d5pk2$')\u001a+sk:\u001c\u0017\r^5oO2{w\rC\u0004\u0002\u0010A\u0001\r!a\u0001\u0002\u001fMDw.\u001e7e\u0005\u0016$U\r\\1zK\u0012\fQe\u001d5pk2$\u0007*\u00198eY\u0016,\u0005pY3qi&|gN\u0012:p[\ncwnY6j]\u001e\u001cVM\u001c3)\u0005E\u0001\u0018AP:i_VdGMR3uG\"dU-\u00193fe\u0016\u0003xn\u00195P]\u001aK'o\u001d;GKR\u001c\u0007n\u00148ms&3G*Z1eKJ,\u0005o\\2i\u0017:|wO\u001c+p\u0005>$\b\u000e\u000b\u0002\u0013a\u0006!4\u000f[8vY\u0012$&/\u001e8dCR,Gk\\(gMN,Go\u00159fG&4\u0017.\u001a3J]\u0016\u0003xn\u00195PM\u001a\u001cX\r\u001e*fgB|gn]3)\u0005M\u0001\u0018!T:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u001f\u001a47/\u001a;Ta\u0016\u001c\u0017NZ5fI&sW\t]8dQ>3gm]3u%\u0016\u001c\bo\u001c8tK&3gi\u001c7m_^,'\u000fS1t\u001d>luN]3Fa>\u001c\u0007n\u001d\u0015\u0003)A\f!j\u001d5pk2$g)\u001a;dQ2+\u0017\rZ3s\u000bB|7\r[*fG>tG\rV5nK&3G*Z1eKJ\u0014V\r\u001d7jKN<\u0016\u000e\u001e5Fa>\u001c\u0007NT8u\u0017:|wO\u001c+p\r>dGn\\<fe\"\u0012Q\u0003]\u00014g\"|W\u000f\u001c3Vg\u0016dU-\u00193fe\u0016sGm\u00144gg\u0016$\u0018JZ%oi\u0016\u0014(I]8lKJ4VM]:j_:\u0014U\r\\8xeAB#A\u00069\u0002\u0001NDw.\u001e7e)J,hnY1uKR{\u0017J\\5uS\u0006dg)\u001a;dQ>3gm]3u\u0013\u001adU-\u00193feJ+G/\u001e:ogVsG-\u001a4j]\u0016$wJ\u001a4tKRD#a\u00069\u0002cMDw.\u001e7e!>dG.\u00138eK\u001aLg.\u001b;fYfLe\rT3bI\u0016\u0014(+\u001a;ve:\u001c\u0018I\\=Fq\u000e,\u0007\u000f^5p]\"\u0012\u0001\u0004]\u0001,g\"|W\u000f\u001c3N_Z,\u0007+\u0019:uSRLwN\\:PkR|e\r\u0016:v]\u000e\fG/\u001b8h\u0019><7\u000b^1uK\"\u0012\u0011\u0004]\u00019g\"|W\u000f\u001c3GS2$XM\u001d)beRLG/[8og6\u000bG-\u001a'fC\u0012,'\u000fR;sS:<G*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:uQ\tQ\u0002/\u0001%tQ>,H\u000eZ\"bi\u000eDW\t_2faRLwN\u001c$s_6\u0014En\\2lS:<7+\u001a8e/\",gn\u00155viRLgn\u001a#po:\u0014V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bI\"\u00121\u0004]\u0001\u0005gR,(\rF\u0004m\u0003\u0003\nY%!\u0016\t\u000f\u0005\rC\u00041\u0001\u0002F\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0004\u0007\u0006\u001d\u0013bAA%\t\nI\u0001+\u0019:uSRLwN\u001c\u0005\b\u0003\u001bb\u0002\u0019AA(\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042!LA)\u0013\r\t\u0019F\b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u001d\t9\u0006\ba\u0001\u00033\n1\u0001\\8h!\u0011\tY&a\u0018\u000e\u0005\u0005u#bAA,A%!\u0011\u0011MA/\u0005\raun\u001a")
public class ReplicaFetcherThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);
    private final FailedPartitions failedPartitions = new FailedPartitions();

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    private BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private OffsetAndEpoch offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    private int offsetAndEpoch$default$2() {
        return 1;
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), null, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)None$.MODULE$);
        Assert.assertEquals((long)ApiKeys.FETCH.latestVersion(), (long)thread.fetchRequestVersion());
        Assert.assertEquals((long)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (long)thread.offsetForLeaderEpochRequestVersion());
        Assert.assertEquals((long)ApiKeys.LIST_OFFSETS.latestVersion(), (long)thread.listOffsetRequestVersion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchLeaderEpochRequestIfLastEpochDefinedForSomePartitions() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)None$.MODULE$).once();
        EasyMock.expect((Object)log.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        partition.truncateTo(EasyMock.anyLong(), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(3);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(leaderEpoch, 1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(leaderEpoch, 1L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[3];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch3 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.t2p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        this.assertPartitionStates((AbstractFetcherThread)thread, false, true, false);
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)3L, (long)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        EasyMock.verify((Object[])new Object[]{logManager});
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        .colon.colon foreach_these = new .colon.colon((Object)this.t1p0(), (List)new .colon.colon((Object)this.t1p1(), (List)new .colon.colon((Object)this.t2p1(), (List)Nil$.MODULE$)));
        while (!foreach_these.isEmpty()) {
            TopicPartition topicPartition = (TopicPartition)foreach_these.head();
            ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed, topicPartition);
            foreach_these = (List)foreach_these.tail();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)EasyMock.createMock(BlockingSend.class);
        EasyMock.expect((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)EasyMock.anyObject())).andThrow((Throwable)new NullPointerException()).once();
        EasyMock.replay((Object[])new Object[]{mockBlockingSend});
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetsForLeaderEpochRequest.PartitionData partitionData2 = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), 0);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Map result = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), null, new Metrics(), (Time)new SystemTime(), null, (Option)new Some((Object)mockBlockingSend)).fetchEpochEndOffsets((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.UNKNOWN_SERVER_ERROR, -1, -1L);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(Errors.UNKNOWN_SERVER_ERROR, -1, -1L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map expected = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Assert.assertEquals((String)"results from leader epoch request should have undefined offset", (Object)expected, (Object)result);
        EasyMock.verify((Object[])new Object[]{mockBlockingSend});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnlyIfLeaderEpochKnownToBoth() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        partition.truncateTo(EasyMock.anyLong(), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(2);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(leaderEpoch, 1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(leaderEpoch, 1L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)3L, (long)mockNetwork.fetchCount());
        EasyMock.verify((Object[])new Object[]{logManager});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponse() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 1))).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)initialLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(leaderEpoch, 156L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(leaderEpoch, 172L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t2p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.head(), this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t2p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)156)));
        Assert.assertTrue((String)new StringBuilder(58).append("Expected ").append(this.t2p1()).append(" to truncate to offset 172 (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)172)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponseIfFollowerHasNoMoreEpochs() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpochAtFollower = 5;
        int leaderEpochAtLeader = 4;
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 3))).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpochAtFollower))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(leaderEpochAtLeader)).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)initialLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(leaderEpochAtLeader, 156L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(leaderEpochAtLeader, 202L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t2p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.head(), this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t2p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)156)));
        Assert.assertTrue((String)new StringBuilder(55).append("Expected ").append(this.t2p1()).append(" to truncate to offset ").append(initialLEO).append(" (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)initialLEO)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchLeaderEpochSecondTimeIfLeaderRepliesWithEpochNotKnownToFollower() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 2))).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(4)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(3)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)initialLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(4, 155L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(4, 143L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)0L, (long)mockNetwork.fetchCount());
        Tuple2[] tuple2Array3 = new Tuple2[2];
        EpochEndOffset epochEndOffset3 = new EpochEndOffset(3, 101L);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EpochEndOffset epochEndOffset4 = new EpochEndOffset(3, 102L);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map nextOffsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava();
        mockNetwork.setOffsetsForNextResponse(nextOffsets);
        thread.doWork();
        Assert.assertEquals((long)2L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        Assert.assertEquals((String)"OffsetsForLeaderEpochRequest version.", (long)3L, (long)mockNetwork.lastUsedOffsetForLeaderEpochVersion());
        thread.doWork();
        Assert.assertEquals((long)2L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        Assert.assertTrue((String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 102 (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)102)));
        Assert.assertTrue((String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 101 (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)101)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 2))).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(4)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(3)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)initialLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(-1, 155L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(-1, 143L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        Assert.assertEquals((String)"OffsetsForLeaderEpochRequest version.", (long)0L, (long)mockNetwork.lastUsedOffsetForLeaderEpochVersion());
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        Assert.assertTrue((String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 155 (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)155)));
        Assert.assertTrue((String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 143 (truncation offsets: ").append(truncateToCapture.getValues()).append(")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)143)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToInitialFetchOffsetIfLeaderReturnsUndefinedOffset() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int initialFetchOffset = 100;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)initialFetchOffset)).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[1];
        EpochEndOffset epochEndOffset = new EpochEndOffset(-1, -1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.head(), this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(initialFetchOffset, this.offsetAndEpoch$default$2());
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        thread.doWork();
        Assert.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldPollIndefinitelyIfLeaderReturnsAnyException() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        int highWaterMark = 100;
        int initialLeo = 300;
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)highWaterMark)).anyTimes();
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLeo, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)initialLeo)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1, -1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(Errors.UNKNOWN_SERVER_ERROR, -1, -1L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.head(), this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 3);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                thread.doWork();
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)0L, (long)truncated.getValues().size());
        offsetsReply.put(this.t1p0(), new EpochEndOffset(leaderEpoch, 156L));
        thread.doWork();
        Assert.assertEquals((long)156L, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldMovePartitionsOutOfTruncatingLogState() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        int leaderEpoch = 4;
        partition.truncateTo(0L, false);
        EasyMock.expect((Object)BoxedUnit.UNIT).times(2);
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(leaderEpoch, 1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(leaderEpoch, 1L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        Option option = thread.fetchState(this.t1p0());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object5 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)object5);
        Option option2 = thread.fetchState(this.t1p1());
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object6 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this2.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)object6);
        thread.doWork();
        Option option3 = thread.fetchState(this.t1p0());
        if (option3 == null) {
            throw null;
        }
        Option map_this3 = option3;
        Object object7 = map_this3.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this3.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)object7);
        Option option4 = thread.fetchState(this.t1p1());
        if (option4 == null) {
            throw null;
        }
        Option map_this4 = option4;
        Object object8 = map_this4.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this4.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)object8);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFilterPartitionsMadeLeaderDuringLeaderEpochRequest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        int initialLEO = 100;
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)(initialLEO - 2))).anyTimes();
        EasyMock.expect((Object)log.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5))).anyTimes();
        EasyMock.expect((Object)log.endOffsetForEpoch(5)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, 5))).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)initialLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(partition, replicaManager, log);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, partition, log});
        Tuple2[] tuple2Array = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(5, 52L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(5, 49L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        TopicPartition partitionThatBecameLeader = this.t1p0();
        mockNetwork.setEpochRequestCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> thread.removePartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionThatBecameLeader}))));
        thread.doWork();
        Assert.assertEquals((long)49L, (long)BoxesRunTime.unboxToLong((Object)truncateToCapture.getValue()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)EasyMock.createMock(BlockingSend.class);
        mockBlockingSend.initiateClose();
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new IllegalArgumentException()).once();
        mockBlockingSend.close();
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new IllegalStateException()).once();
        EasyMock.replay((Object[])new Object[]{mockBlockingSend});
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), null, new Metrics(), (Time)new SystemTime(), null, (Option)new Some((Object)mockBlockingSend));
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        EasyMock.verify((Object[])new Object[]{mockBlockingSend});
    }

    public void stub(Partition partition, ReplicaManager replicaManager, Log log) {
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p0())).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.nonOfflinePartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p1())).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.nonOfflinePartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t2p1())).andReturn((Object)log).anyTimes();
        EasyMock.expect((Object)replicaManager.nonOfflinePartition(this.t2p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
    }

    public static final /* synthetic */ void $anonfun$assertPartitionStates$1(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        Assert.assertTrue((boolean)fetcher$1.fetchState(tp).isDefined());
        PartitionFetchState fetchState = (PartitionFetchState)fetcher$1.fetchState(tp).get();
        Assert.assertEquals((String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeReadyForFetch$1 ? " NOT" : "")).append(" be ready for fetching").toString(), (Object)BoxesRunTime.boxToBoolean((boolean)shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()));
        Assert.assertEquals((String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeTruncatingLog$1 ? " NOT" : "")).append(" be truncating its log").toString(), (Object)BoxesRunTime.boxToBoolean((boolean)shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()));
        Assert.assertEquals((String)new StringBuilder(28).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeDelayed$1 ? " NOT" : "")).append(" be delayed").toString(), (Object)BoxesRunTime.boxToBoolean((boolean)shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()));
    }

    public static final /* synthetic */ Object $anonfun$assertPartitionStates$1$adapted(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher$1, shouldBeReadyForFetch$1, shouldBeTruncatingLog$1, shouldBeDelayed$1, tp);
        return BoxedUnit.UNIT;
    }
}

