/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\u000b\u0016\u0001iAQ!\n\u0001\u0005\u0002\u0019BQ\u0001\u000b\u0001\u0005R%Bq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019\u0001\u0006\u0001)A\u0005\r\"9\u0011\u000b\u0001b\u0001\n#\u0012\u0006BB/\u0001A\u0003%1\u000bC\u0004_\u0001\t\u0007I\u0011\u000b*\t\r}\u0003\u0001\u0015!\u0003T\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015\t\b\u0001\"\u0011g\u0011\u00151\b\u0001\"\u0001g\u0011\u0015Y\b\u0001\"\u0001g\u0011\u0015i\b\u0001\"\u0001g\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!I\u0011\u0011\b\u0001\u0012\u0002\u0013%\u00111\b\u0005\b\u0003#\u0002A\u0011BA*\u0005i\u0019\u0016m\u001d7Ba&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\t1r#\u0001\u0004tKJ4XM\u001d\u0006\u00021\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001c?A\u0011A$H\u0007\u0002+%\u0011a$\u0006\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3tiB\u0011\u0001eI\u0007\u0002C)\u0011!eF\u0001\u0004CBL\u0017B\u0001\u0013\"\u0005%\u0019\u0016m\u001d7TKR,\b/\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011A\u0004A\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012A\u000b\t\u0003W]j\u0011\u0001\f\u0006\u0003[9\nA!Y;uQ*\u0011q\u0006M\u0001\tg\u0016\u001cWO]5us*\u0011\u0011GM\u0001\u0007G>lWn\u001c8\u000b\u0005a\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001\u000f\u0017\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t1\b\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005!A.\u00198h\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\rM#(/\u001b8h\u0003eY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\u001c\u0011\u00023-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn]\u000b\u0002\rB\u0019qIT\u001e\u000e\u0003!S!!\u0013&\u0002\u0013%lW.\u001e;bE2,'BA&M\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0013\u0002\u0005\u0019&\u001cH/\u0001\u000elC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001c\b%\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002'B\u0019A+V,\u000e\u00031K!A\u0016'\u0003\tM{W.\u001a\t\u00031nk\u0011!\u0017\u0006\u00035~\nA!\u001e;jY&\u0011A,\u0017\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005\u0011\u0007C\u0001+d\u0013\t!GJA\u0002J]R\fQa]3u+B$\u0012a\u001a\t\u0003)\"L!!\u001b'\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0019-\u0004\"\u0001\\8\u000e\u00035T!A\\\u001b\u0002\u000b),h.\u001b;\n\u0005Al'A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\ti1\u000f\u0005\u0002mi&\u0011Q/\u001c\u0002\u0006\u0003\u001a$XM]\u00011i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\n+gm\u001c:f'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;)\u00059A\bC\u00017z\u0013\tQXN\u0001\u0003UKN$\u0018a\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;BMR,'oU1tY\"\u000bg\u000eZ:iC.,'+Z9vKN$\bFA\by\u00031\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$x+\u001b;i+:\u001cX\u000f\u001d9peR,GMV3sg&|g\u000e\u000b\u0002\u0011q\u000612/\u001a8e\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\u0006\u0005\u0002\u0004\u0005=\u0011qDA\u0015!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005a\u0005A!/Z9vKN$8/\u0003\u0003\u0002\u000e\u0005\u001d!aE!qSZ+'o]5p]N\u0014Vm\u001d9p]N,\u0007bBA\t#\u0001\u0007\u00111C\u0001\u0007g>\u001c7.\u001a;\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007@\u0003\rqW\r^\u0005\u0005\u0003;\t9B\u0001\u0004T_\u000e\\W\r\u001e\u0005\b\u0003C\t\u0002\u0019AA\u0012\u0003\u001d\u0011X-];fgR\u0004B!!\u0002\u0002&%!\u0011qEA\u0004\u0005I\t\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;\t\u0013\u0005-\u0012\u0003%AA\u0002\u00055\u0012AC1qSZ+'o]5p]B)A+a\f\u00024%\u0019\u0011\u0011\u0007'\u0003\r=\u0003H/[8o!\r!\u0016QG\u0005\u0004\u0003oa%!B*i_J$\u0018\u0001I:f]\u0012\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM*\"!!\u0010+\t\u00055\u0012qH\u0016\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0005v]\u000eDWmY6fI*\u0019\u00111\n'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002P\u0005\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A3/\u001a8e'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;WC2LG-\u0019;f%\u0016\u001c\bo\u001c8tKR\u0019q-!\u0016\t\u000f\u0005E1\u00031\u0001\u0002\u0014\u0001")
public class SaslApiVersionsRequestTest
extends BaseRequestTest
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
            ApiVersionsResponse response = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            Assert.assertEquals((long)Errors.ILLEGAL_SASL_STATE.code(), (long)response.data.errorCode());
        }
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)apiVersionsResponse.data.errorCode());
            ApiVersionsResponse apiVersionsResponse2 = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    private ApiVersionsResponse sendApiVersionsRequest(Socket socket, ApiVersionsRequest request, Option<Object> apiVersion) {
        return ApiVersionsResponse.parse((ByteBuffer)this.sendAndReceive((AbstractRequest)request, ApiKeys.API_VERSIONS, socket, apiVersion), (short)request.version());
    }

    private Option<Object> sendApiVersionsRequest$default$3() {
        return None$.MODULE$;
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest(new SaslHandshakeRequestData().setMechanism("PLAIN"));
        SaslHandshakeResponse handshakeResponse = SaslHandshakeResponse.parse((ByteBuffer)this.sendAndReceive((AbstractRequest)request, ApiKeys.SASL_HANDSHAKE, socket, this.sendAndReceive$default$4()), (short)request.version());
        Assert.assertEquals((Object)Errors.NONE, (Object)handshakeResponse.error());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"PLAIN", (List)Nil$.MODULE$);
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

