/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.tools.ConsumerPerformance;
import kafka.tools.ConsumerPerformance$;
import org.junit.Assert;
import org.junit.Test;
import scala.Console$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u3Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0013i\u0002B\u0002\u0014\u0001A\u0003%a\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\r=\u0002\u0001\u0015!\u0003*\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015q\u0004\u0001\"\u00012\u0011\u0015\u0001\u0005\u0001\"\u00012\u0011\u0015\u0011\u0005\u0001\"\u00012\u0011\u0015a\u0005\u0001\"\u0003N\u0005]\u0019uN\\:v[\u0016\u0014\b+\u001a:g_Jl\u0017M\\2f)\u0016\u001cHO\u0003\u0002\u000e\u001d\u0005)Ao\\8mg*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\u0019\u0005Qq.\u001e;D_:$XM\u001c;\u0016\u0003y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u0005%|'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.A\u0006pkR\u001cuN\u001c;f]R\u0004\u0013A\u00033bi\u00164uN]7biV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-E\u0005!A/\u001a=u\u0013\tq3F\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\u0006YA-\u0019;f\r>\u0014X.\u0019;!\u0003m!Xm\u001d;EKR\f\u0017\u000e\\3e\u0011\u0016\fG-\u001a:NCR\u001c\u0007NQ8esR\t!\u0007\u0005\u0002\u0014g%\u0011A\u0007\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0007mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002w\u0005\u0019qN]4\n\u0005uB$\u0001\u0002+fgR\fa\u0004^3ti:{g\u000eR3uC&dW\r\u001a%fC\u0012,'/T1uG\"\u0014u\u000eZ=)\u0005\u001d1\u0014A\u0003;fgR\u001cuN\u001c4jO\"\u0012\u0001BN\u0001!i\u0016\u001cHoQ8oM&<w+\u001b;i+:\u0014XmY8h]&TX\rZ(qi&|g\u000e\u000b\u0003\nm\u0011+\u0015\u0001C3ya\u0016\u001cG/\u001a3$\u0003\u0019\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u000bU>\u0004Ho]5na2,\u0017BA&I\u0005=y\u0005\u000f^5p]\u0016C8-\u001a9uS>t\u0017A\u0006;fgRDU-\u00193fe6\u000bGo\u00195D_:$XM\u001c;\u0015\tIr5\u000b\u0017\u0005\u0006\u001f*\u0001\r\u0001U\u0001\tI\u0016$\u0018-\u001b7fIB\u00111#U\u0005\u0003%R\u0011qAQ8pY\u0016\fg\u000eC\u0003U\u0015\u0001\u0007Q+A\ffqB,7\r^3e\u001fV$\b/\u001e;MS:,7i\\;oiB\u00111CV\u0005\u0003/R\u00111!\u00138u\u0011\u0015I&\u00021\u0001[\u0003\r1WO\u001c\t\u0004'm\u0013\u0014B\u0001/\u0015\u0005%1UO\\2uS>t\u0007\u0007")
public class ConsumerPerformanceTest {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    private ByteArrayOutputStream outContent() {
        return this.outContent;
    }

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDetailedHeaderMatchBody() {
        void testHeaderMatchContent_fun;
        JFunction0.mcV.sp & java.io.Serializable & Serializable intersect = (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> ConsumerPerformance$.MODULE$.printConsumerProgress(1, 0x100000L, 0L, 1L, 0L, 0L, 1L, this.dateFormat(), 1L);
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = true;
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(this, testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_expectedOutputLineCount)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNonDetailedHeaderMatchBody() {
        void testHeaderMatchContent_fun;
        JFunction0.mcV.sp & java.io.Serializable & Serializable intersect = (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> Predef$.MODULE$.println((Object)new StringBuilder(36).append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", ").append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", 1.0, 1.0, 1, 1.0, 1, 1, 1.1, 1.1").toString());
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = false;
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(this, testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_expectedOutputLineCount)));
    }

    @Test
    public void testConfig() {
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.options().valueOf((OptionSpec)config.bootstrapServersOpt()));
        Assert.assertEquals((Object)"test", (Object)config.topic());
        Assert.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test(expected=OptionException.class)
    public void testConfigWithUnrecognizedOption() {
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--new-consumer"});
        new ConsumerPerformance.ConsumerPerfConfig(args);
    }

    private void testHeaderMatchContent(boolean detailed, int expectedOutputLineCount, Function0<BoxedUnit> fun) {
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            ConsumerPerformance$.MODULE$.printHeader(detailed);
            fun.apply$mcV$sp();
            String[] contents = this.outContent().toString().split("\n");
            Assert.assertEquals((long)expectedOutputLineCount, (long)contents.length);
            String header = contents[0];
            String body = contents[1];
            Assert.assertEquals((long)header.split(",").length, (long)body.split(",").length);
        });
    }
}

