/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.ZkIsrManager$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%r!B\f\u0019\u0011\u0003ib!B\u0010\u0019\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0001\u0004%\tA\u000b\u0005\b]\u0005\u0001\r\u0011\"\u00010\u0011\u0019)\u0014\u0001)Q\u0005W\u0019!q\u0004\u0007\u0001;\u0011!!eA!A!\u0002\u0013)\u0005\u0002\u0003%\u0007\u0005\u0003\u0005\u000b\u0011B%\t\u0011U3!\u0011!Q\u0001\nYCQa\n\u0004\u0005\u0002qCq!\u0019\u0004C\u0002\u0013%!\u0006\u0003\u0004c\r\u0001\u0006Ia\u000b\u0005\tG\u001a\u0011\r\u0011\"\u0001\u0019I\"1\u0011O\u0002Q\u0001\n\u0015DqA\u001d\u0004C\u0002\u0013%1\u000fC\u0004\u0002\u0002\u0019\u0001\u000b\u0011\u0002;\t\u0011\u0005\raA1A\u0005\nMDq!!\u0002\u0007A\u0003%A\u000fC\u0004\u0002\b\u0019!\t%!\u0003\t\u000f\u0005-a\u0001\"\u0011\u0002\u000e!9\u00111\u0003\u0004\u0005B\u0005U\u0001\u0002CA\u0014\r\u0011\u0005\u0001$!\u0003\u0002\u0019i[\u0017j\u001d:NC:\fw-\u001a:\u000b\u0005eQ\u0012AB:feZ,'OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AH\u0001\u000e\u0003a\u0011ABW6JgJl\u0015M\\1hKJ\u001c\"!A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ$A\u000eEK\u001a\fW\u000f\u001c;JgJ\u0004&o\u001c9bO\u0006$\u0018n\u001c8D_:4\u0017nZ\u000b\u0002WA\u0011a\u0004L\u0005\u0003[a\u0011!$S:s\u0007\"\fgnZ3Qe>\u0004\u0018mZ1uS>t7i\u001c8gS\u001e\fq\u0004R3gCVdG/S:s!J|\u0007/Y4bi&|gnQ8oM&<w\fJ3r)\t\u00014\u0007\u0005\u0002#c%\u0011!g\t\u0002\u0005+:LG\u000fC\u00045\t\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013'\u0001\u000fEK\u001a\fW\u000f\u001c;JgJ\u0004&o\u001c9bO\u0006$\u0018n\u001c8D_:4\u0017n\u001a\u0011)\u0005\u00159\u0004C\u0001\u00129\u0013\tI4E\u0001\u0005w_2\fG/\u001b7f'\u00111\u0011e\u000f \u0011\u0005ya\u0014BA\u001f\u0019\u0005=\tE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014\bCA C\u001b\u0005\u0001%BA!\u001b\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bCA G\u0013\t9\u0005IA\u0005TG\",G-\u001e7fe\u0006!A/[7f!\tQ5+D\u0001L\u0015\t\tEJ\u0003\u0002N\u001d\u000611m\\7n_:T!aG(\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0005\u0003).\u0013A\u0001V5nK\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002X56\t\u0001L\u0003\u0002Z5\u0005\u0011!p[\u0005\u00037b\u0013QbS1gW\u0006T6n\u00117jK:$H\u0003B/_?\u0002\u0004\"A\b\u0004\t\u000b\u0011S\u0001\u0019A#\t\u000b!S\u0001\u0019A%\t\u000bUS\u0001\u0019\u0001,\u00027%\u001c(o\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]\u000e{gNZ5h\u0003qI7O]\"iC:<WMT8uS\u001aL7-\u0019;j_:\u001cuN\u001c4jO\u0002\nA\"[:s\u0007\"\fgnZ3TKR,\u0012!\u001a\t\u0004M.lW\"A4\u000b\u0005!L\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003U\u000e\n!bY8mY\u0016\u001cG/[8o\u0013\tawMA\u0002TKR\u0004\"A\\8\u000e\u00031K!\u0001\u001d'\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006i\u0011n\u001d:DQ\u0006tw-Z*fi\u0002\nq\u0002\\1ti&\u001b(o\u00115b]\u001e,Wj]\u000b\u0002iB\u0011QO`\u0007\u0002m*\u0011q\u000f_\u0001\u0007CR|W.[2\u000b\u0005eT\u0018AC2p]\u000e,(O]3oi*\u00111\u0010`\u0001\u0005kRLGNC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}4(AC!u_6L7\rT8oO\u0006\u0001B.Y:u\u0013N\u00148\t[1oO\u0016l5\u000fI\u0001\u0015Y\u0006\u001cH/S:s!J|\u0007/Y4bi&|g.T:\u0002+1\f7\u000f^%teB\u0013x\u000e]1hCRLwN\\'tA\u0005)1\u000f^1siR\t\u0001'\u0001\u0007dY\u0016\f'\u000fU3oI&tw\rF\u00021\u0003\u001fAa!!\u0005\u0015\u0001\u0004i\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007gV\u0014W.\u001b;\u0015\t\u0005]\u0011Q\u0004\t\u0004E\u0005e\u0011bAA\u000eG\t9!i\\8mK\u0006t\u0007bBA\u0010+\u0001\u0007\u0011\u0011E\u0001\rC2$XM]%te&#X-\u001c\t\u0004=\u0005\r\u0012bAA\u00131\ta\u0011\t\u001c;fe&\u001b(/\u0013;f[\u0006AR.Y=cKB\u0013x\u000e]1hCR,\u0017j\u001d:DQ\u0006tw-Z:")
public class ZkIsrManager
implements AlterIsrManager,
Logging {
    private final Scheduler scheduler;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final IsrChangePropagationConfig isrChangeNotificationConfig;
    private final scala.collection.mutable.Set<TopicPartition> isrChangeSet;
    private final AtomicLong lastIsrChangeMs;
    private final AtomicLong lastIsrPropagationMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void DefaultIsrPropagationConfig_$eq(IsrChangePropagationConfig x$1) {
        ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig_$eq(x$1);
    }

    public static IsrChangePropagationConfig DefaultIsrPropagationConfig() {
        return ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        AlterIsrManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private IsrChangePropagationConfig isrChangeNotificationConfig() {
        return this.isrChangeNotificationConfig;
    }

    public scala.collection.mutable.Set<TopicPartition> isrChangeSet() {
        return this.isrChangeSet;
    }

    private AtomicLong lastIsrChangeMs() {
        return this.lastIsrChangeMs;
    }

    private AtomicLong lastIsrPropagationMs() {
        return this.lastIsrPropagationMs;
    }

    @Override
    public void start() {
        JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> this.maybePropagateIsrChanges();
        long x$3 = this.isrChangeNotificationConfig().checkIntervalMs();
        long x$5 = this.scheduler.schedule$default$3();
        this.scheduler.schedule("isr-change-propagation", (Function0<BoxedUnit>)x$2, x$5, x$3, TimeUnit.MILLISECONDS);
    }

    @Override
    public void clearPending(TopicPartition topicPartition) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean submit(AlterIsrItem alterIsrItem) {
        void var3_3;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Writing new ISR ").append(alterIsrItem.leaderAndIsr().isr()).append(" to ZooKeeper with version ").append(alterIsrItem.leaderAndIsr().zkVersion()).append(" for partition ").append(alterIsrItem.topicPartition()).toString());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient, alterIsrItem.topicPartition(), alterIsrItem.leaderAndIsr(), alterIsrItem.controllerEpoch());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        if (var3_3 != false) {
            void var4_4;
            scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
            synchronized (set) {
                this.isrChangeSet().$plus$eq((Object)alterIsrItem.topicPartition());
                this.lastIsrChangeMs().set(this.time.milliseconds());
            }
            alterIsrItem.callback().apply((Object)package$.MODULE$.Right().apply((Object)alterIsrItem.leaderAndIsr().withZkVersion((int)var4_4)));
        } else {
            alterIsrItem.callback().apply((Object)package$.MODULE$.Left().apply((Object)Errors.INVALID_UPDATE_VERSION));
        }
        return true;
    }

    public void maybePropagateIsrChanges() {
        long now = this.time.milliseconds();
        scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
        synchronized (set) {
            if (this.isrChangeSet().nonEmpty() && (this.lastIsrChangeMs().get() + this.isrChangeNotificationConfig().lingerMs() < now || this.lastIsrPropagationMs().get() + this.isrChangeNotificationConfig().maxDelayMs() < now)) {
                this.zkClient.propagateIsrChanges((Set<TopicPartition>)this.isrChangeSet());
                this.isrChangeSet().clear();
                this.lastIsrPropagationMs().set(now);
            }
            return;
        }
    }

    public ZkIsrManager(Scheduler scheduler, Time time, KafkaZkClient zkClient) {
        this.scheduler = scheduler;
        this.time = time;
        this.zkClient = zkClient;
        this.isrChangeNotificationConfig = ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig();
        this.isrChangeSet = new HashSet();
        this.lastIsrChangeMs = new AtomicLong(time.milliseconds());
        this.lastIsrPropagationMs = new AtomicLong(time.milliseconds());
    }
}

