/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcher;
import kafka.tools.TopicPartitionReplica;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.Logging;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ReplicaVerificationTool$
implements Logging {
    public static final ReplicaVerificationTool$ MODULE$ = new ReplicaVerificationTool$();
    private static final String clientId = "replicaVerificationTool";
    private static final String dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat(MODULE$.dateFormatString());
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String clientId() {
        return clientId;
    }

    public String dateFormatString() {
        return dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(Time.SYSTEM.milliseconds()));
    }

    public void main(String[] args) {
        scala.collection.immutable.Map<Object, Node> map;
        Seq<TopicDescription> seq;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(30000L), (Object[])new Long[0]);
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print usage information.").forHelp();
        AbstractOptionSpec versionOpt = parser.accepts("version", "Print version information and exit.").forHelp();
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has((OptionSpec)helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        if (options.has((OptionSpec)versionOpt)) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (scala.collection.immutable.Seq<OptionSpec<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = (String)options.valueOf((OptionSpec)topicWhiteListOpt);
        IncludeList topicWhiteListFiler = new IncludeList(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(new StringBuilder(21).append(regex).append(" is an invalid regex.").toString());
        }
        int fetchSize = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        long initialOffsetTime = (Long)options.valueOf((OptionSpec)initialOffsetTimeOpt);
        long reportInterval = (Long)options.valueOf((OptionSpec)reportIntervalOpt);
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = "Getting topic metadata...";
            Object var33_18 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Admin adminClient = this.createAdminClient(brokerList);
        try {
            seq = this.listTopicsMetadata(adminClient);
            map = this.brokerDetails(adminClient);
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> adminClient.close(), this, Level.WARN);
        }
        scala.collection.immutable.Map<Object, Node> map2 = map;
        Seq filteredTopicMetadata = (Seq)seq.filter((Function1 & Serializable)topicMetaData -> BoxesRunTime.boxToBoolean((boolean)topicWhiteListFiler.isTopicAllowed(topicMetaData.name(), false)));
        if (filteredTopicMetadata.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$4(topicWhiteListOpt);
                Object var34_24 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
        Seq topicPartitionReplicas = (Seq)filteredTopicMetadata.flatMap((Function1 & Serializable)topicMetadata -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().flatMap((Function1 & Serializable)partitionMetadata -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicas()).asScala().map((Function1 & Serializable)node -> new TopicPartitionReplica(topicMetadata.name(), partitionMetadata.partition(), node.id()))));
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$8(topicPartitionReplicas);
            Object var35_26 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        scala.collection.immutable.Map brokerToTopicPartitions = (scala.collection.immutable.Map)topicPartitionReplicas.groupBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.replicaId())).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int brokerId = x0$1._1$mcI$sp();
                Seq partitions = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), partitions.map((Function1 & Serializable)partition -> new TopicPartition(partition.topic(), partition.partitionId())));
            }
            throw new MatchError(null);
        });
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$12(brokerToTopicPartitions);
            Object var36_28 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        scala.collection.immutable.Map expectedReplicasPerTopicPartition = (scala.collection.immutable.Map)topicPartitionReplicas.groupBy((Function1 & Serializable)replica -> new TopicPartition(replica.topic(), replica.partitionId())).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition topicAndPartition = (TopicPartition)x0$2._1();
                Seq replicaSet = (Seq)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)BoxesRunTime.boxToInteger((int)replicaSet.size()));
            }
            throw new MatchError(null);
        });
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$15(expectedReplicasPerTopicPartition);
            Object var37_30 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        Seq topicPartitions = (Seq)filteredTopicMetadata.flatMap((Function1 & Serializable)topicMetaData -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetaData.partitions()).asScala().map((Function1 & Serializable)partitionMetadata -> new TopicPartition(topicMetaData.name(), partitionMetadata.partition())));
        Properties consumerProps = this.consumerConfig(brokerList);
        ReplicaBuffer replicaBuffer = new ReplicaBuffer((Map<TopicPartition, Object>)expectedReplicasPerTopicPartition, this.initialOffsets((Seq<TopicPartition>)topicPartitions, consumerProps, initialOffsetTime), brokerToTopicPartitions.size(), reportInterval);
        int verificationBrokerId = ((Tuple2)brokerToTopicPartitions.head())._1$mcI$sp();
        AtomicInteger counter = new AtomicInteger(0);
        scala.collection.immutable.Iterable fetcherThreads = (scala.collection.immutable.Iterable)brokerToTopicPartitions.map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                int brokerId = x0$3._1$mcI$sp();
                Seq topicPartitions = (Seq)x0$3._2();
                return new ReplicaFetcher(new StringBuilder(15).append("ReplicaFetcher-").append(brokerId).toString(), (Node)map2.apply((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Iterable<TopicPartition>)topicPartitions, replicaBuffer, 30000, 256000, fetchSize, maxWaitMs, 1, brokerId == verificationBrokerId, consumerProps, counter.incrementAndGet());
            }
            throw new MatchError(null);
        });
        Exit.addShutdownHook((String)"ReplicaVerificationToolShutdownHook", () -> Exit$.$anonfun$addShutdownHook$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ReplicaVerificationTool$ info_this = MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = "Stopping all fetchers";
                Object var2_2 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            Object var1_1 = null;
            fetcherThreads.foreach((Function1 & Serializable)x$3 -> {
                x$3.shutdown();
                return BoxedUnit.UNIT;
            });
        }));
        fetcherThreads.foreach((Function1 & Serializable)x$4 -> {
            x$4.start();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringBuilder(34).append(this.getCurrentTimeString()).append(": verification process is started.").toString());
    }

    private Seq<TopicDescription> listTopicsMetadata(Admin adminClient) {
        Set topics = (Set)adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get();
        return CollectionConverters$.MODULE$.CollectionHasAsScala(((java.util.Map)adminClient.describeTopics((Collection)topics).all().get()).values()).asScala().toBuffer();
    }

    private scala.collection.immutable.Map<Object, Node> brokerDetails(Admin adminClient) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.describeCluster().nodes().get()).asScala().map((Function1 & Serializable)n -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)n.id()), n))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Admin createAdminClient(String brokerUrl) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerUrl);
        return Admin.create((Properties)props);
    }

    private Map<TopicPartition, Object> initialOffsets(Seq<TopicPartition> topicPartitions, Properties consumerConfig, long initialOffsetTime) {
        Map map;
        try (KafkaConsumer consumer = new KafkaConsumer(consumerConfig);){
            if (-1L == initialOffsetTime) {
                map = (Map)CollectionConverters$.MODULE$.MapHasAsScala(consumer.endOffsets((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicPartitions).asJava())).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition k = (TopicPartition)x0$1._1();
                        Long v = (Long)x0$1._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v));
                    }
                    throw new MatchError(null);
                });
            } else if (-2L == initialOffsetTime) {
                map = (Map)CollectionConverters$.MODULE$.MapHasAsScala(consumer.beginningOffsets((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicPartitions).asJava())).asScala().map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        TopicPartition k = (TopicPartition)x0$2._1();
                        Long v = (Long)x0$2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v));
                    }
                    throw new MatchError(null);
                });
            } else {
                scala.collection.immutable.Map timestampsToSearch = ((IterableOnceOps)topicPartitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)Predef$.MODULE$.long2Long(initialOffsetTime)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                map = (Map)CollectionConverters$.MODULE$.MapHasAsScala(consumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)timestampsToSearch).asJava())).asScala().map((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        TopicPartition k = (TopicPartition)x0$3._1();
                        OffsetAndTimestamp v = (OffsetAndTimestamp)x0$3._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
                    }
                    throw new MatchError(null);
                });
            }
        }
        return map;
    }

    private Properties consumerConfig(String brokerUrl) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerUrl);
        properties.put("group.id", "ReplicaVerification");
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        return properties;
    }

    private KafkaConsumer<String, String> createConsumer(Properties consumerConfig) {
        return new KafkaConsumer(consumerConfig);
    }

    public static final /* synthetic */ String $anonfun$main$1() {
        return "Getting topic metadata...";
    }

    public static final /* synthetic */ String $anonfun$main$4(ArgumentAcceptingOptionSpec topicWhiteListOpt$1) {
        return new StringBuilder(88).append("No topics found. ").append(topicWhiteListOpt$1).append(" if specified, is either filtering out all topics or there is no topic.").toString();
    }

    public static final /* synthetic */ String $anonfun$main$8(Seq topicPartitionReplicas$1) {
        return new StringBuilder(27).append("Selected topic partitions: ").append(topicPartitionReplicas$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$12(scala.collection.immutable.Map brokerToTopicPartitions$1) {
        return new StringBuilder(29).append("Topic partitions per broker: ").append(brokerToTopicPartitions$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$15(scala.collection.immutable.Map expectedReplicasPerTopicPartition$1) {
        return new StringBuilder(39).append("Expected replicas per topic partition: ").append(expectedReplicasPerTopicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$20() {
        return "Stopping all fetchers";
    }

    private ReplicaVerificationTool$() {
    }
}

