/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r=c!\u0002%J\u0001-k\u0005\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011\u0001.\t\u0011\u0005\u0004!\u0011!Q\u0001\nmC\u0001B\u0019\u0001\u0003\u0006\u0004%\ta\u0019\u0005\tU\u0002\u0011\t\u0011)A\u0005I\"A1\u000e\u0001BC\u0002\u0013\u00051\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003e\u0011!i\u0007A!b\u0001\n\u0003\u0019\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011=\u0004!\u0011!Q\u0001\n\u0011D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\ti\u0002\u0011\t\u0011)A\u0005k\"Q\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006I!a\u0001\t\u0013\u0005u\u0001A!A!\u0002\u0013)\bbBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003sA\u0001\"a\u0014\u0001A\u0003%\u00111\b\u0005\n\u0003#\u0002!\u0019!C\u0001\u0003'B\u0001\"a\u0017\u0001A\u0003%\u0011Q\u000b\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?B\u0001\"a\u001e\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003s\u0002!\u0019!C\u0005\u0003wB\u0001\"!%\u0001A\u0003%\u0011Q\u0010\u0005\n\u0003'\u0003!\u0019!C\u0005\u0003+C\u0001\"!,\u0001A\u0003%\u0011q\u0013\u0005\t\u0003_\u0003\u0001\u0019!C\u0005G\"I\u0011\u0011\u0017\u0001A\u0002\u0013%\u00111\u0017\u0005\b\u0003\u007f\u0003\u0001\u0015)\u0003e\u0011)\t\t\r\u0001b\u0001\n\u0003I\u00151\u0019\u0005\t\u0005\u0017\u0003\u0001\u0015!\u0003\u0002F\u001a9\u0011q\u001a\u0001A\u0013\u0006E\u0007BCA|=\tU\r\u0011\"\u0001\u0002z\"Q!\u0011\u0001\u0010\u0003\u0012\u0003\u0006I!a?\t\u0015\t\raD!f\u0001\n\u0003\u0011)\u0001\u0003\u0006\u0003\u000ey\u0011\t\u0012)A\u0005\u0005\u000fAq!a\b\u001f\t\u0003\u0011y\u0001C\u0004\u0003\u0016y!\tEa\u0006\t\u0013\tua$!A\u0005\u0002\t}\u0001\"\u0003B\u0013=E\u0005I\u0011\u0001B\u0014\u0011%\u0011iDHI\u0001\n\u0003\u0011y\u0004C\u0005\u0003Dy\t\t\u0011\"\u0011\u0003F!A!\u0011\u000b\u0010\u0002\u0002\u0013\u00051\rC\u0005\u0003Ty\t\t\u0011\"\u0001\u0003V!I!q\f\u0010\u0002\u0002\u0013\u0005#\u0011\r\u0005\n\u0005Wr\u0012\u0011!C\u0001\u0005[B\u0011Ba\u001e\u001f\u0003\u0003%\tE!\u001f\t\u0013\tud$!A\u0005B\t}\u0004\"\u0003BA=\u0005\u0005I\u0011\tBB\u0011%\u0011)IHA\u0001\n\u0003\u00129i\u0002\u0006\u0003\u000e\u0002\t\t\u0011#\u0001J\u0005\u001f3!\"a4\u0001\u0003\u0003E\t!\u0013BI\u0011\u001d\tyB\rC\u0001\u0005SC\u0011B!!3\u0003\u0003%)Ea!\t\u0013\t-&'!A\u0005\u0002\n5\u0006\"\u0003BZe\u0005\u0005I\u0011\u0011B[\u0011!\u00119\r\u0001C\u0001\u0013\n%\u0007\u0002\u0003Bm\u0001\u0011\u0005\u0011Ja7\t\u000f\te\u0007\u0001\"\u0003\u0003`\"A!1\u001e\u0001\u0005\u0002%\u0013i\u000fC\u0004\u0003~\u0002!\tEa@\t\u000f\r\u0005\u0001\u0001\"\u0011\u0003\u0000\"911\u0001\u0001\u0005\u0002\t}\bbBB\u0003\u0001\u0011%1q\u0001\u0005\b\u0007'\u0001A\u0011\u0002B\u0000\u0011\u001d\u0019)\u0002\u0001C\u0005\u0007/Aqa!\n\u0001\t\u0013\u0011y\u0010C\u0004\u0004(\u0001!Ia!\u000b\t\u000f\r]\u0002\u0001\"\u0001\u0003\u0000\u001eQ1\u0011I%\u0002\u0002#\u00051ja\u0011\u0007\u0013!K\u0015\u0011!E\u0001\u0017\u000e\u0015\u0003bBA\u0010\u000b\u0012\u00051q\t\u0005\n\u0007\u0013*\u0015\u0013!C\u0001\u0007\u0017\u0012\u0001\"Q2dKB$xN\u001d\u0006\u0003\u0015.\u000bqA\\3uo>\u00148NC\u0001M\u0003\u0015Y\u0017MZ6b'\r\u0001aJ\u0015\t\u0003\u001fBk\u0011!S\u0005\u0003#&\u0013A#\u00112tiJ\f7\r^*feZ,'\u000f\u00165sK\u0006$\u0007CA*W\u001b\u0005!&BA+L\u0003\u001diW\r\u001e:jGNL!a\u0016+\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0005f]\u0012\u0004v.\u001b8u\u0007\u0001)\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=.\u000bqa\u00197vgR,'/\u0003\u0002a;\nAQI\u001c3Q_&tG/A\u0005f]\u0012\u0004v.\u001b8uA\u0005q1/\u001a8e\u0005V4g-\u001a:TSj,W#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\u0007%sG/A\btK:$')\u001e4gKJ\u001c\u0016N_3!\u00039\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\fqB]3dm\n+hMZ3s'&TX\rI\u0001\u0012Y&\u001cH/\u001a8CC\u000e\\Gn\\4TSj,\u0017A\u00057jgR,gNQ1dW2|wmU5{K\u0002\naA\\8eK&#\u0017\u0001E2p]:,7\r^5p]F+x\u000e^1t!\ty%/\u0003\u0002t\u0013\n\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u0001\r[\u0016$(/[2Qe\u00164\u0017\u000e\u001f\t\u0003mvt!a^>\u0011\u0005a4W\"A=\u000b\u0005iL\u0016A\u0002\u001fs_>$h(\u0003\u0002}M\u00061\u0001K]3eK\u001aL!A`@\u0003\rM#(/\u001b8h\u0015\tah-\u0001\u0003uS6,\u0007\u0003BA\u0003\u00033i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0006kRLGn\u001d\u0006\u0005\u0003\u001b\ty!\u0001\u0004d_6lwN\u001c\u0006\u0004\u0019\u0006E!\u0002BA\n\u0003+\ta!\u00199bG\",'BAA\f\u0003\ry'oZ\u0005\u0005\u00037\t9A\u0001\u0003US6,\u0017!\u00037pOB\u0013XMZ5y\u0003\u0019a\u0014N\\5u}Q!\u00121EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\u0001\"a\u0014\u0001\t\u000bas\u0001\u0019A.\t\u000b\tt\u0001\u0019\u00013\t\u000b-t\u0001\u0019\u00013\t\u000b5t\u0001\u0019\u00013\t\u000b=t\u0001\u0019\u00013\t\u000bAt\u0001\u0019A9\t\u000bQt\u0001\u0019A;\t\u000f\u0005\u0005a\u00021\u0001\u0002\u0004!A\u0011Q\u0004\b\u0011\u0002\u0003\u0007Q/A\u0006oS>\u001cV\r\\3di>\u0014XCAA\u001e!\u0011\ti$a\u0013\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0001b\u00195b]:,Gn\u001d\u0006\u0005\u0003\u000b\n9%A\u0002oS>T!!!\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\nyD\u0001\u0005TK2,7\r^8s\u00031q\u0017n\\*fY\u0016\u001cGo\u001c:!\u00035\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYV\u0011\u0011Q\u000b\t\u0005\u0003{\t9&\u0003\u0003\u0002Z\u0005}\"aE*feZ,'oU8dW\u0016$8\t[1o]\u0016d\u0017AD:feZ,'o\u00115b]:,G\u000eI\u0001\u000baJ|7-Z:t_J\u001cXCAA1!\u0019\t\u0019'!\u001c\u0002r5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0004nkR\f'\r\\3\u000b\u0007\u0005-d-\u0001\u0006d_2dWm\u0019;j_:LA!a\u001c\u0002f\tY\u0011I\u001d:bs\n+hMZ3s!\ry\u00151O\u0005\u0004\u0003kJ%!\u0003)s_\u000e,7o]8s\u0003-\u0001(o\\2fgN|'o\u001d\u0011\u0002#A\u0014xnY3tg>\u00148o\u0015;beR,G-\u0006\u0002\u0002~A!\u0011qPAG\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015AB1u_6L7M\u0003\u0003\u0002\b\u0006%\u0015AC2p]\u000e,(O]3oi*!\u00111RA$\u0003\u0011)H/\u001b7\n\t\u0005=\u0015\u0011\u0011\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002%A\u0014xnY3tg>\u00148o\u0015;beR,G\rI\u0001\u0014E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]\u000b\u0003\u0003/\u0003B!!'\u0002*6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*\u0001\u0003d_J,'bA+\u0002\"*!\u00111UAS\u0003\u0019I\u0018-\\7fe*\u0011\u0011qU\u0001\u0004G>l\u0017\u0002BAV\u00037\u0013Q!T3uKJ\fAC\u00197pG.,G\rU3sG\u0016tG/T3uKJ\u0004\u0013!F2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r_\u0001\u001aGV\u0014(/\u001a8u!J|7-Z:t_JLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0003\u00026\u0006m\u0006cA3\u00028&\u0019\u0011\u0011\u00184\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003{S\u0012\u0011!a\u0001I\u0006\u0019\u0001\u0010J\u0019\u0002-\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq\u0002\n\u0001\u0003\u001e5s_R$H.\u001a3T_\u000e\\W\r^:\u0016\u0005\u0005\u0015\u0007CBA2\u0003\u000f\fY-\u0003\u0003\u0002J\u0006\u0015$!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X\rE\u0002\u0002Nzi\u0011\u0001\u0001\u0002\u0013\t\u0016d\u0017-_3e\u00072|7/Z*pG.,GoE\u0005\u001f\u0003'\fI.a;\u0002rB\u0019Q-!6\n\u0007\u0005]gM\u0001\u0004B]f\u0014VM\u001a\t\u0007\u00037\f)/a3\u000f\t\u0005u\u0017\u0011\u001d\b\u0004q\u0006}\u0017\"A4\n\u0007\u0005\rh-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0018\u0011\u001e\u0002\b\u001fJ$WM]3e\u0015\r\t\u0019O\u001a\t\u0004K\u00065\u0018bAAxM\n9\u0001K]8ek\u000e$\b\u0003BAn\u0003gLA!!>\u0002j\na1+\u001a:jC2L'0\u00192mK\u000611o\\2lKR,\"!a?\u0011\t\u0005u\u0012Q`\u0005\u0005\u0003\u007f\fyDA\u0007T_\u000e\\W\r^\"iC:tW\r\\\u0001\bg>\u001c7.\u001a;!\u0003E)g\u000e\u001a+ie>$H\u000f\\3US6,Wj]\u000b\u0003\u0005\u000f\u00012!\u001aB\u0005\u0013\r\u0011YA\u001a\u0002\u0005\u0019>tw-\u0001\nf]\u0012$\u0006N]8ui2,G+[7f\u001bN\u0004CCBAf\u0005#\u0011\u0019\u0002C\u0004\u0002x\u000e\u0002\r!a?\t\u000f\t\r1\u00051\u0001\u0003\b\u000591m\\7qCJ,Gc\u00013\u0003\u001a!9!1\u0004\u0013A\u0002\u0005-\u0017\u0001\u0002;iCR\fAaY8qsR1\u00111\u001aB\u0011\u0005GA\u0011\"a>&!\u0003\u0005\r!a?\t\u0013\t\rQ\u0005%AA\u0002\t\u001d\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005SQC!a?\u0003,-\u0012!Q\u0006\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00038\u0019\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YD!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0005#\u0006\u0002B\u0004\u0005W\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B$!\u0011\u0011IEa\u0014\u000e\u0005\t-#\u0002\u0002B'\u0003\u000f\nA\u0001\\1oO&\u0019aPa\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u000bB/!\r)'\u0011L\u0005\u0004\u000572'aA!os\"A\u0011Q\u0018\u0016\u0002\u0002\u0003\u0007A-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\u0007\u0005\u0004\u0003f\t\u001d$qK\u0007\u0003\u0003SJAA!\u001b\u0002j\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011yG!\u001e\u0011\u0007\u0015\u0014\t(C\u0002\u0003t\u0019\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002>2\n\t\u00111\u0001\u0003X\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u00119Ea\u001f\t\u0011\u0005uV&!AA\u0002\u0011\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002I\u0006AAo\\*ue&tw\r\u0006\u0002\u0003H\u00051Q-];bYN$BAa\u001c\u0003\n\"I\u0011Q\u0018\u0019\u0002\u0002\u0003\u0007!qK\u0001\u0012i\"\u0014x\u000e\u001e;mK\u0012\u001cvnY6fiN\u0004\u0013A\u0005#fY\u0006LX\rZ\"m_N,7k\\2lKR\u00042!!43'\u0015\u0011$1\u0013BP!)\u0011)Ja'\u0002|\n\u001d\u00111Z\u0007\u0003\u0005/S1A!'g\u0003\u001d\u0011XO\u001c;j[\u0016LAA!(\u0003\u0018\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t\u0005&qU\u0007\u0003\u0005GSAA!*\u0002H\u0005\u0011\u0011n\\\u0005\u0005\u0003k\u0014\u0019\u000b\u0006\u0002\u0003\u0010\u0006)\u0011\r\u001d9msR1\u00111\u001aBX\u0005cCq!a>6\u0001\u0004\tY\u0010C\u0004\u0003\u0004U\u0002\rAa\u0002\u0002\u000fUt\u0017\r\u001d9msR!!q\u0017Bb!\u0015)'\u0011\u0018B_\u0013\r\u0011YL\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\u0015\u0014y,a?\u0003\b%\u0019!\u0011\u00194\u0003\rQ+\b\u000f\\33\u0011%\u0011)MNA\u0001\u0002\u0004\tY-A\u0002yIA\nQ\"\u00193e!J|7-Z:t_J\u001cHCBA[\u0005\u0017\u0014)\u000eC\u0004\u0003N^\u0002\rAa4\u0002\u001b9,w\u000f\u0015:pG\u0016\u001c8o\u001c:t!\u0019\t\u0019G!5\u0002r%!!1[A3\u0005\u0019\u0011UO\u001a4fe\"1!q[\u001cA\u0002U\fQ\u0003\u001d:pG\u0016\u001c8o\u001c:UQJ,\u0017\r\u001a)sK\u001aL\u00070A\bti\u0006\u0014H\u000f\u0015:pG\u0016\u001c8o\u001c:t)\u0011\t)L!8\t\r\t]\u0007\b1\u0001v)\u0019\t)L!9\u0003j\"9\u0011QL\u001dA\u0002\t\r\bC\u0002B3\u0005K\f\t(\u0003\u0003\u0003h\u0006%$aA*fc\"1!q[\u001dA\u0002U\f\u0001C]3n_Z,\u0007K]8dKN\u001cxN]:\u0015\r\u0005U&q\u001eBz\u0011\u0019\u0011\tP\u000fa\u0001I\u0006Y!/Z7pm\u0016\u001cu.\u001e8u\u0011\u001d\u0011)P\u000fa\u0001\u0005o\faB]3rk\u0016\u001cHo\u00115b]:,G\u000eE\u0002P\u0005sL1Aa?J\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005U\u0016!D1xC&$8\u000b[;uI><h.A\u0002sk:\f\u0001c\u001c9f]N+'O^3s'>\u001c7.\u001a;\u0015\u0011\u0005U3\u0011BB\u0007\u0007#Aaaa\u0003?\u0001\u0004)\u0018\u0001\u00025pgRDaaa\u0004?\u0001\u0004!\u0017\u0001\u00029peRDQ!\u001c A\u0002\u0011\fA#Y2dKB$h*Z<D_:tWm\u0019;j_:\u001c\u0018AB1dG\u0016\u0004H\u000f\u0006\u0003\u0004\u001a\rm\u0001#B3\u0003:\u0006m\bbBB\u000f\u0001\u0002\u00071qD\u0001\u0004W\u0016L\b\u0003BA\u001f\u0007CIAaa\t\u0002@\ta1+\u001a7fGRLwN\\&fs\u0006I2\r\\8tKRC'o\u001c;uY\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0003M\t7o]5h]:+woQ8o]\u0016\u001cG/[8o)!\u0011yga\u000b\u00040\rM\u0002bBB\u0017\u0005\u0002\u0007\u00111`\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\u000f\rE\"\t1\u0001\u0002r\u0005I\u0001O]8dKN\u001cxN\u001d\u0005\b\u0007k\u0011\u0005\u0019\u0001B8\u0003!i\u0017-\u001f\"m_\u000e\\\u0017AB<bW\u0016,\b\u000fK\u0002D\u0007w\u0001BA!\u0013\u0004>%!1q\bB&\u0005!ye/\u001a:sS\u0012,\u0017\u0001C!dG\u0016\u0004Ho\u001c:\u0011\u0005=+5cA#\u0002TR\u001111I\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\r5#fA;\u0003,\u0001")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int listenBacklogSize;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;

    public static String $lessinit$greater$default$9() {
        return "";
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    public int listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
            return;
        }
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
            return;
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$14 -> {
            x$14.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)x$15 -> {
            x$15.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$16 -> {
                x$16.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$17 -> {
                x$17.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$18)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        Object var3_3 = null;
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$18) {
        return x$18.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int listenBacklogSize, int nodeId, ConnectionQuotas connectionQuotas, String metricPrefix, Time time, String logPrefix) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.listenBacklogSize = listenBacklogSize;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        super(connectionQuotas);
        this.logIdent_$eq(logPrefix);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port(), listenBacklogSize);
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

