/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.FeatureZNodeStatus$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FeatureZNode$
implements Serializable {
    public static final FeatureZNode$ MODULE$ = new FeatureZNode$();
    private static final String VersionKey = "version";
    private static final String StatusKey = "status";
    private static final String FeaturesKey = "features";
    private static final int V1 = 1;
    private static final int CurrentVersion = MODULE$.V1();

    private String VersionKey() {
        return VersionKey;
    }

    private String StatusKey() {
        return StatusKey;
    }

    private String FeaturesKey() {
        return FeaturesKey;
    }

    public int V1() {
        return V1;
    }

    public int CurrentVersion() {
        return CurrentVersion;
    }

    public String path() {
        return "/feature";
    }

    public java.util.Map<String, java.util.Map<String, Short>> asJavaMap(Map<String, Map<String, Object>> scalaMap) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)scalaMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String featureName = (String)x0$1._1();
                Map versionInfo = (Map)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)versionInfo.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String label = (String)x0$2._1();
                        short version = BoxesRunTime.unboxToShort((Object)x0$2._2());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)version);
                    }
                    throw new MatchError(null);
                })).asJava());
            }
            throw new MatchError(null);
        })).asJava();
    }

    public byte[] encode(FeatureZNode featureZNode) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.StatusKey()), (Object)BoxesRunTime.boxToInteger((int)featureZNode.status().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FeaturesKey()), (Object)featureZNode.features().toMap())}));
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.MutableMapHasAsJava(jsonMap).asJava());
    }

    public FeatureZNode decode(byte[] jsonBytes) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            Features finalizedFeatures;
            JsonObject featureInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)featureInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < this.V1()) {
                throw new IllegalArgumentException(new StringBuilder(46).append("Unsupported version: ").append(version).append(" of feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Option featuresMap = featureInfo.get(this.FeaturesKey()).flatMap((Function1 & Serializable)x$20 -> {
                void decodeMap_factory;
                Factory decodeMap_factory2 = Map$.MODULE$.mapFactory();
                DecodeJson$DecodeInt$ decodeMap_decodeJson = DecodeJson$DecodeInt$.MODULE$;
                Object var1_2 = null;
                Object var2_1 = null;
                Factory factory = Map$.MODULE$.mapFactory();
                DecodeJson decodeMap_decodeJson2 = new DecodeJson<M>(decodeMap_decodeJson, decodeMap_factory2){
                    private final DecodeJson decodeJson$3;
                    private final Factory factory$2;

                    public Object decode(JsonNode node) {
                        return DecodeJson.decode$(this, node);
                    }

                    public final Either<String, M> decodeEither(JsonNode node) {
                        return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeMap$1(node, this.decodeJson$3, this.factory$2);
                    }
                    {
                        this.decodeJson$3 = decodeJson$3;
                        this.factory$2 = factory$2;
                    }
                };
                Object var3_4 = null;
                factory = null;
                DecodeJson decodeOption_decodeJson = new /* invalid duplicate definition of identical inner class */;
                Object var5_5 = null;
                return (Option)x$20.to(new DecodeJson<Option<E>>(decodeOption_decodeJson){
                    private final DecodeJson decodeJson$1;

                    public Object decode(JsonNode node) {
                        return DecodeJson.decode$(this, node);
                    }

                    public final Either<String, Option<E>> decodeEither(JsonNode node) {
                        return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeOption$1(node, this.decodeJson$1);
                    }
                    {
                        this.decodeJson$1 = decodeJson$1;
                    }
                });
            });
            if (featuresMap.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(35).append("Features map can not be absent in: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            java.util.Map<String, java.util.Map<String, Short>> features = this.asJavaMap((Map<String, Map<String, Object>>)((Map)featuresMap.map((Function1 & Serializable)theMap -> (Map)theMap.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String featureName = (String)x0$1._1();
                    Map versionInfo = (Map)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)versionInfo.map((Function1 & Serializable)x0$2 -> {
                        if (x0$2 != null) {
                            String label = (String)x0$2._1();
                            int version = x0$2._2$mcI$sp();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)BoxesRunTime.boxToShort((short)((short)version)));
                        }
                        throw new MatchError(null);
                    }));
                }
                throw new MatchError(null);
            })).getOrElse((Function0 & Serializable)() -> (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))));
            Option statusInt = featureInfo.get(this.StatusKey()).flatMap((Function1 & Serializable)x$21 -> {
                DecodeJson$DecodeInt$ decodeOption_decodeJson = DecodeJson$DecodeInt$.MODULE$;
                Object var1_1 = null;
                return (Option)x$21.to(new /* invalid duplicate definition of identical inner class */);
            });
            if (statusInt.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Status can not be absent in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Option<FeatureZNodeStatus> status = FeatureZNodeStatus$.MODULE$.withNameOpt(BoxesRunTime.unboxToInt((Object)statusInt.get()));
            if (status.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Malformed status: ").append(statusInt).append(" found in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            try {
                finalizedFeatures = Features.fromFinalizedFeaturesMap(features);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(50).append("Unable to convert to finalized features from map: ").append(features).toString(), e);
            }
            return new FeatureZNode((FeatureZNodeStatus)status.get(), (Features<FinalizedVersionRange>)finalizedFeatures);
        }
        if (either instanceof Left) {
            JsonProcessingException e = (JsonProcessingException)((Left)either).value();
            throw new IllegalArgumentException(new StringBuilder(37).append("Failed to parse feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
        }
        throw new MatchError(either);
    }

    public FeatureZNode apply(FeatureZNodeStatus status, Features<FinalizedVersionRange> features) {
        return new FeatureZNode(status, features);
    }

    public Option<Tuple2<FeatureZNodeStatus, Features<FinalizedVersionRange>>> unapply(FeatureZNode x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.status(), x$0.features()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FeatureZNode$.class);
    }

    private FeatureZNode$() {
    }
}

