/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import kafka.server.metadata.MetadataPartition;
import kafka.server.metadata.MetadataPartitions;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\u0012%\u0001-B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\to\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u001d!\u0005\u00011A\u0005\n\u0015Cq!\u0018\u0001A\u0002\u0013%a\f\u0003\u0004e\u0001\u0001\u0006KA\u0012\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u0011\u001d\u0019\b\u00011A\u0005\nQDaA\u001e\u0001!B\u00139\u0007bB<\u0001\u0001\u0004%I\u0001\u001f\u0005\bu\u0002\u0001\r\u0011\"\u0003|\u0011\u0019i\b\u0001)Q\u0005s\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\u0007\u0001\u0001\u0006I!!\u0001\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0005\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!!*\u0001\t\u0003\t9\u000bC\u0004\u00024\u0002!\t!a*\u000335+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u001d\"vS2$WM\u001d\u0006\u0003K\u0019\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003O!\naa]3sm\u0016\u0014(\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u000e\t\u0003[UJ!A\u000e\u0018\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005q\u0001O]3w!\u0006\u0014H/\u001b;j_:\u001cX#\u0001\u001e\u0011\u0005mbT\"\u0001\u0013\n\u0005u\"#AE'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N\fq\u0002\u001d:fmB\u000b'\u000f^5uS>t7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u00135\t\u0005\u0002<\u0001!)!'\u0002a\u0001i!)\u0001(\u0002a\u0001u\u0005Qa.Z<OC6,W*\u00199\u0016\u0003\u0019\u0003Ba\u0012'O36\t\u0001J\u0003\u0002J\u0015\u0006!Q\u000f^5m\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\u00075\u000b\u0007\u000f\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#:j\u0011A\u0015\u0006\u0003'*\na\u0001\u0010:p_Rt\u0014BA+/\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Us\u0003\u0003B$Mii\u0003\"aO.\n\u0005q##!E'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]\u0006qa.Z<OC6,W*\u00199`I\u0015\fHCA0c!\ti\u0003-\u0003\u0002b]\t!QK\\5u\u0011\u001d\u0019w!!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003-qWm\u001e(b[\u0016l\u0015\r\u001d\u0011\u0002\u00119,w/\u00133NCB,\u0012a\u001a\t\u0005\u000f2Cg\n\u0005\u0002jc6\t!N\u0003\u0002lY\u000611m\\7n_:T!!K7\u000b\u00059|\u0017AB1qC\u000eDWMC\u0001q\u0003\ry'oZ\u0005\u0003e*\u0014A!V;jI\u0006aa.Z<JI6\u000b\u0007o\u0018\u0013fcR\u0011q,\u001e\u0005\bG*\t\t\u00111\u0001h\u0003%qWm^%e\u001b\u0006\u0004\b%A\boK^\u0014VM^3sg\u0016LE-T1q+\u0005I\b\u0003B$M\u001d\"\f1C\\3x%\u00164XM]:f\u0013\u0012l\u0015\r]0%KF$\"a\u0018?\t\u000f\rl\u0011\u0011!a\u0001s\u0006\u0001b.Z<SKZ,'o]3JI6\u000b\u0007\u000fI\u0001\bG\"\fgnZ3e+\t\t\t\u0001E\u0003H\u0003\u0007\t9!C\u0002\u0002\u0006!\u00131aU3u!\ri\u0013\u0011B\u0005\u0004\u0003\u0017q#aA!os\u0006A1\r[1oO\u0016$\u0007%A\u0007`Y>\u001c\u0017\r\\\"iC:<W\rZ\u000b\u0003\u0003'\u0001BaRA\u000b5&\u0019\u0011q\u0003%\u0003\u000f!\u000b7\u000f[*fi\u0006qq\f\\8dC2\u001c\u0005.\u00198hK\u0012\u0004\u0013!D0m_\u000e\fGNU3n_Z,G-\u0001\b`Y>\u001c\u0017\r\u001c*f[>4X\r\u001a\u0011\u0002\u001bQ|\u0007/[2JIR{g*Y7f)\u0011\t\u0019#!\u000b\u0011\t5\n)CT\u0005\u0004\u0003Oq#AB(qi&|g\u000e\u0003\u0004\u0002,U\u0001\r\u0001[\u0001\u0003S\u0012\fQ\u0002^8qS\u000et\u0015-\\3U_&#G\u0003BA\u0019\u0003g\u0001B!LA\u0013Q\"1\u0011Q\u0007\fA\u00029\u000bAA\\1nK\u0006y!/Z7pm\u0016$v\u000e]5d\u0005fLE\r\u0006\u0003\u0002<\u00055\u0003#BA\u001f\u0003\u000fRf\u0002BA \u0003\u0007r1!UA!\u0013\u0005y\u0013bAA#]\u00059\u0001/Y2lC\u001e,\u0017\u0002BA%\u0003\u0017\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u000br\u0003BBA\u0016/\u0001\u0007\u0001.\u0001\u0007iC:$G.Z\"iC:<W\rF\u0002`\u0003'Bq!!\u0016\u0019\u0001\u0004\t9&\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u00033\ni&\u0004\u0002\u0002\\)\u0011QE[\u0005\u0005\u0003?\nYFA\u000bQCJ$\u0018\u000e^5p]\u000eC\u0017M\\4f%\u0016\u001cwN\u001d3\u0002\u001d\u0005$G-V;jI6\u000b\u0007\u000f]5oOR)q,!\u001a\u0002h!1\u0011QG\rA\u00029Ca!a\u000b\u001a\u0001\u0004A\u0017!\u0005:f[>4X-V;jI6\u000b\u0007\u000f]5oOR\u0019q,!\u001c\t\r\u0005-\"\u00041\u0001i\u0003\r9W\r\u001e\u000b\u0007\u0003g\n)(!\u001f\u0011\t5\n)C\u0017\u0005\u0007\u0003oZ\u0002\u0019\u0001(\u0002\u0013Q|\u0007/[2OC6,\u0007BBA>7\u0001\u0007A'A\u0006qCJ$\u0018\u000e^5p]&#\u0017aA:fiR\u0019q,!!\t\r\u0005\rE\u00041\u0001[\u0003%\u0001\u0018M\u001d;ji&|g.\u0001\fnCf\u0014W-\u00113e)>dunY1m%\u0016lwN^3e)\ry\u0016\u0011\u0012\u0005\u0007\u0003\u0007k\u0002\u0019\u0001.\u0002'A\u0014XM^%nC\u001e,\u0007*Y:U_BL7-\u00133\u0015\t\u0005=\u0015Q\u0013\t\u0004[\u0005E\u0015bAAJ]\t9!i\\8mK\u0006t\u0007BBAL=\u0001\u0007\u0001.A\u0004u_BL7-\u00133\u0002\rI,Wn\u001c<f)\u0015y\u0016QTAP\u0011\u0019\t9h\ba\u0001\u001d\"1\u00111P\u0010A\u0002Q\nQAY;jY\u0012$\u0012AO\u0001\rY>\u001c\u0017\r\\\"iC:<W\r\u001a\u000b\u0003\u0003S\u0003R!a+\u00022jk!!!,\u000b\u0007\u0005=f&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0002\u0002.\u0006aAn\\2bYJ+Wn\u001c<fI\u0002")
public class MetadataPartitionsBuilder {
    private final int brokerId;
    private final MetadataPartitions prevPartitions;
    private Map<String, Map<Object, MetadataPartition>> newNameMap;
    private Map<Uuid, String> newIdMap;
    private Map<String, Uuid> newReverseIdMap;
    private final java.util.Set<Object> changed;
    private final HashSet<MetadataPartition> _localChanged;
    private final HashSet<MetadataPartition> _localRemoved;

    public int brokerId() {
        return this.brokerId;
    }

    public MetadataPartitions prevPartitions() {
        return this.prevPartitions;
    }

    private Map<String, Map<Object, MetadataPartition>> newNameMap() {
        return this.newNameMap;
    }

    private void newNameMap_$eq(Map<String, Map<Object, MetadataPartition>> x$1) {
        this.newNameMap = x$1;
    }

    private Map<Uuid, String> newIdMap() {
        return this.newIdMap;
    }

    private void newIdMap_$eq(Map<Uuid, String> x$1) {
        this.newIdMap = x$1;
    }

    private Map<String, Uuid> newReverseIdMap() {
        return this.newReverseIdMap;
    }

    private void newReverseIdMap_$eq(Map<String, Uuid> x$1) {
        this.newReverseIdMap = x$1;
    }

    private java.util.Set<Object> changed() {
        return this.changed;
    }

    private HashSet<MetadataPartition> _localChanged() {
        return this._localChanged;
    }

    private HashSet<MetadataPartition> _localRemoved() {
        return this._localRemoved;
    }

    public Option<String> topicIdToName(Uuid id) {
        return Option$.MODULE$.apply((Object)this.newIdMap().get(id));
    }

    public Option<Uuid> topicNameToId(String name) {
        return Option$.MODULE$.apply((Object)this.newReverseIdMap().get(name));
    }

    public Iterable<MetadataPartition> removeTopicById(Uuid id) {
        String name = (String)Option$.MODULE$.apply((Object)this.newIdMap().remove(id)).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(31).append("Unable to locate topic with ID ").append(id).toString());
        });
        this.newReverseIdMap().remove(name);
        Map<Object, MetadataPartition> prevPartitionMap = this.newNameMap().remove(name);
        if (prevPartitionMap == null) {
            return (Iterable)package$.MODULE$.Seq().empty();
        }
        this.changed().remove(prevPartitionMap);
        Collection<MetadataPartition> removedPartitions = prevPartitionMap.values();
        if (this.prevImageHasTopicId(id)) {
            removedPartitions.forEach(partition -> {
                if (partition.isReplicaFor(this.brokerId())) {
                    this._localRemoved().add((MetadataPartition)partition);
                }
            });
        } else {
            removedPartitions.forEach(partition -> {
                if (partition.isReplicaFor(this.brokerId())) {
                    this._localChanged().remove(partition);
                }
            });
        }
        return CollectionConverters$.MODULE$.CollectionHasAsScala(removedPartitions).asScala();
    }

    public void handleChange(PartitionChangeRecord record) {
        Option<String> option = this.topicIdToName(record.topicId());
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException(new StringBuilder(31).append("Unable to locate topic with ID ").append(record.topicId()).toString());
        }
        if (option instanceof Some) {
            String name = (String)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(this.newNameMap().get(name));
            if (None$.MODULE$.equals(option2)) {
                throw new RuntimeException(new StringBuilder(33).append("Unable to locate topic with name ").append(name).toString());
            }
            if (option2 instanceof Some) {
                Map partitionMap = (Map)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply(partitionMap.get(BoxesRunTime.boxToInteger((int)record.partitionId())));
                if (None$.MODULE$.equals(option3)) {
                    throw new RuntimeException(new StringBuilder(18).append("Unable to locate ").append(name).append("-").append(record.partitionId()).toString());
                }
                if (option3 instanceof Some) {
                    MetadataPartition partition = (MetadataPartition)((Some)option3).value();
                    this.set(partition.merge(record));
                    return;
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    public void addUuidMapping(String name, Uuid id) {
        this.newIdMap().put(id, name);
        this.newReverseIdMap().put(name, id);
    }

    public void removeUuidMapping(Uuid id) {
        String topicName = this.newIdMap().remove(id);
        if (topicName != null) {
            this.newReverseIdMap().remove(topicName);
        }
    }

    public Option<MetadataPartition> get(String topicName, int partitionId) {
        return Option$.MODULE$.apply(this.newNameMap().get(topicName)).flatMap((Function1 & Serializable)m -> Option$.MODULE$.apply(m.get(BoxesRunTime.boxToInteger((int)partitionId))));
    }

    public void set(MetadataPartition partition) {
        Map<Object, MetadataPartition> map;
        Map<Object, MetadataPartition> prevPartitionMap = this.newNameMap().get(partition.topicName());
        if (prevPartitionMap == null) {
            HashMap<Object, MetadataPartition> m = new HashMap<Object, MetadataPartition>(1);
            this.changed().add(m);
            map = m;
        } else if (this.changed().contains(prevPartitionMap)) {
            map = prevPartitionMap;
        } else {
            HashMap<Object, MetadataPartition> m = new HashMap<Object, MetadataPartition>(prevPartitionMap.size() + 1);
            m.putAll(prevPartitionMap);
            this.changed().add(m);
            map = m;
        }
        Map<Object, MetadataPartition> newPartitionMap = map;
        MetadataPartition prevPartition = newPartitionMap.put(BoxesRunTime.boxToInteger((int)partition.partitionIndex()), partition);
        if (partition.isReplicaFor(this.brokerId())) {
            this._localChanged().add(partition);
        } else if (prevPartition != null) {
            this.maybeAddToLocalRemoved(prevPartition);
        }
        this.newNameMap().put(partition.topicName(), newPartitionMap);
    }

    private void maybeAddToLocalRemoved(MetadataPartition partition) {
        Uuid currentTopicId;
        if (partition.isReplicaFor(this.brokerId()) && ((currentTopicId = this.newReverseIdMap().get(partition.topicName())) != null ? this.prevImageHasTopicId(currentTopicId) : this.prevPartitions().allTopicNames().contains((Object)partition.topicName()))) {
            this._localRemoved().add(partition);
            return;
        }
    }

    private boolean prevImageHasTopicId(Uuid topicId) {
        return this.prevPartitions().topicIdToName(topicId).isDefined();
    }

    public void remove(String topicName, int partitionId) {
        Map<Object, MetadataPartition> prevPartitionMap = this.newNameMap().get(topicName);
        if (prevPartitionMap != null) {
            (this.changed().contains(prevPartitionMap) ? Option$.MODULE$.apply((Object)prevPartitionMap.remove(BoxesRunTime.boxToInteger((int)partitionId))) : Option$.MODULE$.apply((Object)prevPartitionMap.get(BoxesRunTime.boxToInteger((int)partitionId))).map((Function1 & Serializable)prevPartition2 -> {
                HashMap newPartitionMap = new HashMap(prevPartitionMap.size() - 1);
                prevPartitionMap.forEach((prevPartitionId, prevPartition) -> MetadataPartitionsBuilder.$anonfun$remove$2(partitionId, newPartitionMap, BoxesRunTime.unboxToInt((Object)prevPartitionId), prevPartition));
                this.changed().add(newPartitionMap);
                this.newNameMap().put(topicName, newPartitionMap);
                return prevPartition2;
            })).foreach((Function1 & Serializable)partition -> {
                this.maybeAddToLocalRemoved(partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public MetadataPartitions build() {
        void var1_1;
        MetadataPartitions result = new MetadataPartitions(this.newNameMap(), this.newIdMap(), this.newReverseIdMap());
        this.newNameMap_$eq(Collections.unmodifiableMap(this.newNameMap()));
        this.newIdMap_$eq(Collections.unmodifiableMap(this.newIdMap()));
        this.newReverseIdMap_$eq(Collections.unmodifiableMap(this.newReverseIdMap()));
        return var1_1;
    }

    public Set<MetadataPartition> localChanged() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this._localChanged()).asScala();
    }

    public Set<MetadataPartition> localRemoved() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this._localRemoved()).asScala();
    }

    public static final /* synthetic */ void $anonfun$remove$2(int partitionId$2, HashMap newPartitionMap$1, int prevPartitionId, MetadataPartition prevPartition) {
        if (prevPartitionId != partitionId$2) {
            newPartitionMap$1.put(BoxesRunTime.boxToInteger((int)prevPartitionId), prevPartition);
        }
    }

    public MetadataPartitionsBuilder(int brokerId, MetadataPartitions prevPartitions) {
        this.brokerId = brokerId;
        this.prevPartitions = prevPartitions;
        this.newNameMap = prevPartitions.copyNameMap();
        this.newIdMap = prevPartitions.copyIdMap();
        this.newReverseIdMap = prevPartitions.copyReverseIdMap();
        this.changed = Collections.newSetFromMap(new IdentityHashMap());
        this._localChanged = new HashSet();
        this._localRemoved = new HashSet();
    }
}

