/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.metrics.KafkaYammerMetrics;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r}c!\u0002/^\u0003\u0003\u0011\u0007\"\u00026\u0001\t\u0003Y\u0007bB7\u0001\u0005\u0004%\tE\u001c\u0005\u0007k\u0002\u0001\u000b\u0011B8\t\u000bY\u0004A\u0011I<\t\u000fm\u0004!\u0019!C\u0001]\"1A\u0010\u0001Q\u0001\n=Dq! \u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\u0010\u0001\u0001\u000b\u0011B@\t\u0013\u0005E\u0001A1A\u0005\u0002\u0005M\u0001\u0002CA\u0015\u0001\u0001\u0006I!!\u0006\t\u0011\u0005-\u0002A1A\u0005\u0002yDq!!\f\u0001A\u0003%q\u0010C\u0005\u00020\u0001\u0011\r\u0011\"\u0001\u0002\u0014!A\u0011\u0011\u0007\u0001!\u0002\u0013\t)\u0002\u0003\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u007f\u0011\u001d\t)\u0004\u0001Q\u0001\n}D\u0001\"a\u000e\u0001\u0005\u0004%\tA\u001c\u0005\b\u0003s\u0001\u0001\u0015!\u0003p\u0011%\tY\u0004\u0001b\u0001\n\u0003\ti\u0004\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA \u0011)\t9\u0006\u0001EC\u0002\u0013E\u0013\u0011\f\u0005\b\u0003[\u0002A\u0011CA8\u0011%\ty\t\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BAJ\u0011%\t\t\u000b\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAJ\u0011%\t)\u000b\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAJ\u0011%\tI\u000b\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAJ\u0011%\ti\u000b\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAJ\u0011%\t\t\f\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAJ\u0011%\t)\f\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u00028\u0002\u0001\u000b\u0011BAJ\u0011\u001d\tI\f\u0001D\u0001\u0003wCq!!4\u0001\r\u0003\tY\fC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005e\u0007\u0001\"\u0001\u0002R\"9\u00111\u001c\u0001\u0005\u0002\u0005E\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003G\u0004A\u0011AAi\u0011\u001d\t)\u000f\u0001C\u0001\u0003#Dq!a:\u0001\t\u0003\t\t\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005=\b\u0001\"\u0001\u0002R\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005E\u0007bBAz\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003k\u0004A\u0011AA|\u0011\u001d\u0011)\u0002\u0001C\u0001\u0003oDqAa\u0006\u0001\t\u0003\t9\u0010C\u0004\u0003\u001a\u0001!\t!a>\t\u000f\tm\u0001\u0001\"\u0001\u0002x\"9!Q\u0004\u0001\u0005\u0002\u0005]\bb\u0002B\u0010\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0005C\u0001A\u0011\tB\u0012\u0011\u0019\u0011\u0019\u0005\u0001C!o\"1!Q\n\u0001\u0005\u0002]DaAa\u0016\u0001\t#9\bb\u0002B-\u0001\u0011%!1\f\u0005\u0007\u0005\u007f\u0002A\u0011A<\t\r\t\r\u0005\u0001\"\u0001x\u0011\u0019\u00119\t\u0001C\u0001o\"1!1\u0012\u0001\u0005\u0002]DaAa$\u0001\t\u00139\bB\u0002BI\u0001\u0011%q\u000fC\u0004\u0003\u0014\u0002!IA!&\t\u000f\te\u0005\u0001\"\u0005\u0003\u001c\"1!q\u0014\u0001\u0005\n]DaA!)\u0001\t\u00039\bB\u0002BS\u0001\u0011\u0005q\u000f\u0003\u0004\u0003*\u0002!\ta\u001e\u0005\u0007\u0005[\u0003A\u0011A<\t\r\tE\u0006\u0001\"\u0003x\u0011\u0019\u0011\u0019\f\u0001C\u0001o\"1!q\u0017\u0001\u0005\u0002]DaAa/\u0001\t\u00139\bB\u0002B_\u0001\u0011\u0005q\u000fC\u0004\u0003B\u0002!)Ba1\t\u000f\t\r\b\u0001\"\u0006\u0003f\"I1\u0011\u0002\u0001\u0012\u0002\u0013U11\u0002\u0005\n\u0007C\u0001\u0011\u0013!C\u000b\u0007\u0017A\u0011ba\t\u0001#\u0003%)b!\n\t\u0013\r%\u0002!%A\u0005\u0016\r-\u0001\"CB\u0016\u0001E\u0005IQCB\u0017\u0011\u001d\u0019\t\u0004\u0001C\t\u0007gAqa!\u0014\u0001\t\u0013\u0019y\u0005C\u0005\u0004Z\u0001\t\n\u0011\"\u0003\u0004\f!I11\f\u0001\u0012\u0002\u0013%11\u0002\u0005\n\u0007;\u0002\u0011\u0013!C\u0005\u0007K\u0011\u0011$\u00128e)>,e\u000eZ!vi\"|'/\u001b>bi&|g\u000eV3ti*\u0011alX\u0001\u0004CBL'\"\u00011\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aY4\u0011\u0005\u0011,W\"A/\n\u0005\u0019l&AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005\u0011D\u0017BA5^\u0005%\u0019\u0016m\u001d7TKR,\b/\u0001\u0004=S:LGO\u0010\u000b\u0002YB\u0011A\rA\u0001\fEJ|7.\u001a:D_VtG/F\u0001p!\t\u00018/D\u0001r\u0015\u0005\u0011\u0018!B:dC2\f\u0017B\u0001;r\u0005\rIe\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u)\u0005A\bC\u00019z\u0013\tQ\u0018O\u0001\u0003V]&$\u0018A\u00038v[J+7m\u001c:eg\u0006Ya.^7SK\u000e|'\u000fZ:!\u0003-9'o\\;q!J,g-\u001b=\u0016\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003mC:<'BAA\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019\u001d\u0014x.\u001e9Qe\u00164\u0017\u000e\u001f\u0011\u0002\u000b\u001d\u0014x.\u001e9\u0016\u0005\u0005U\u0001\u0003BA\f\u0003KqA!!\u0007\u0002\"A\u0019\u00111D9\u000e\u0005\u0005u!bAA\u0010C\u00061AH]8pizJ1!a\tr\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\u0014\u0015\r\t\u0019#]\u0001\u0007OJ|W\u000f\u001d\u0011\u0002\u0017Q|\u0007/[2Qe\u00164\u0017\u000e_\u0001\ri>\u0004\u0018n\u0019)sK\u001aL\u0007\u0010I\u0001\u0006i>\u0004\u0018nY\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0011]LG\u000eZ2be\u0012\f\u0011b^5mI\u000e\f'\u000f\u001a\u0011\u0002\tA\f'\u000f^\u0001\u0006a\u0006\u0014H\u000fI\u0001\u0003iB,\"!a\u0010\u0011\t\u0005\u0005\u0013\u0011K\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u000511m\\7n_:T1\u0001YA%\u0015\u0011\tY%!\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty%A\u0002pe\u001eLA!a\u0015\u0002D\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005qAO];tiN#xN]3GS2,WCAA.!\u0015\u0001\u0018QLA1\u0013\r\ty&\u001d\u0002\u0005'>lW\r\u0005\u0003\u0002d\u0005%TBAA3\u0015\u0011\t9'a\u0002\u0002\u0005%|\u0017\u0002BA6\u0003K\u0012AAR5mK\u0006y\u0011-\u001e;i_JL'0\u001a:DY\u0006\u001c8/\u0006\u0002\u0002rA\"\u00111OA?!\u0019\t9\"!\u001e\u0002z%!\u0011qOA\u0014\u0005\u0015\u0019E.Y:t!\u0011\tY(! \r\u0001\u0011Y\u0011q\u0010\f\u0002\u0002\u0003\u0005)\u0011AAA\u0005\ryF%M\t\u0005\u0003\u0007\u000bI\tE\u0002q\u0003\u000bK1!a\"r\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001]AF\u0013\r\ti)\u001d\u0002\u0004\u0003:L\u0018!\u0004;pa&\u001c'+Z:pkJ\u001cW-\u0006\u0002\u0002\u0014B!\u0011QSAN\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006\r\u0013\u0001\u0003:fg>,(oY3\n\t\u0005u\u0015q\u0013\u0002\u0010%\u0016\u001cx.\u001e:dKB\u000bG\u000f^3s]\u0006qAo\u001c9jGJ+7o\\;sG\u0016\u0004\u0013!D4s_V\u0004(+Z:pkJ\u001cW-\u0001\bhe>,\bOU3t_V\u00148-\u001a\u0011\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016\f\u0001c\u00197vgR,'OU3t_V\u00148-\u001a\u0011\u0002+A\u0014XMZ5yK\u0012$v\u000e]5d%\u0016\u001cx.\u001e:dK\u00061\u0002O]3gSb,G\rV8qS\u000e\u0014Vm]8ve\u000e,\u0007%A\u000bqe\u00164\u0017\u000e_3e\u000fJ|W\u000f\u001d*fg>,(oY3\u0002-A\u0014XMZ5yK\u0012<%o\\;q%\u0016\u001cx.\u001e:dK\u0002\nQc^5mI\u000e\f'\u000f\u001a+pa&\u001c'+Z:pkJ\u001cW-\u0001\fxS2$7-\u0019:e)>\u0004\u0018n\u0019*fg>,(oY3!\u0003U9\u0018\u000e\u001c3dCJ$wI]8vaJ+7o\\;sG\u0016\fac^5mI\u000e\f'\u000fZ$s_V\u0004(+Z:pkJ\u001cW\rI\u0001\u0010G2LWM\u001c;Qe&t7-\u001b9bYV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005\u001d\u00171I\u0001\tg\u0016\u001cWO]5us&!\u00111ZAa\u00059Y\u0015MZ6b!JLgnY5qC2\fab[1gW\u0006\u0004&/\u001b8dSB\fG.A\tdYV\u001cH/\u001a:BGRLwN\\!sON,\"!a5\u0011\u000bA\f).!\u0006\n\u0007\u0005]\u0017OA\u0003BeJ\f\u00170\u0001\tdYV\u001cH/\u001a:BYR,'/\u0011:hg\u00061Bo\u001c9jG\n\u0013xn[3s%\u0016\fG-Q2m\u0003J<7/\u0001\bqe>$WoY3BG2\f%oZ:\u0015\t\u0005M\u0017\u0011\u001d\u0005\b\u0003_Q\u0003\u0019AA\u000b\u0003=!Wm]2sS\n,\u0017i\u00197Be\u001e\u001c\u0018!\u00063fY\u0016$X\rR3tGJL'-Z!dY\u0006\u0013xm]\u0001\u0013I\u0016dW\r^3Xe&$X-Q2m\u0003J<7/\u0001\bd_:\u001cX/\\3BG2\f%oZ:\u0015\t\u0005M\u0017Q\u001e\u0005\b\u0003_q\u0003\u0019AA\u000b\u000319'o\\;q\u0003\u000ed\u0017I]4t\u0003u\u0001(o\u001c3vG\u0016\u001cuN\\:v[\u0016<\u0016\u000e\u001c3dCJ$\u0017i\u00197Be\u001e\u001c\u0018A\b9s_\u0012,8-Z\"p]N,X.\u001a)sK\u001aL\u00070\u001a3BG2\u001c\u0018I]4t\u0003\u0001\u001aE.^:uKJ\f5\r^5p]\u0006sGm\u00117vgR,'/\u00117uKJ\f5\r\\:\u0016\u0005\u0005e\bCBA~\u0005\u000b\u0011I!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003%IW.\\;uC\ndWMC\u0002\u0003\u0004E\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119!!@\u0003\u0007M+G\u000f\u0005\u0003\u0003\f\tEQB\u0001B\u0007\u0015\u0011\u0011y!a\u0011\u0002\u0007\u0005\u001cG.\u0003\u0003\u0003\u0014\t5!AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uef\f!\u0003V8qS\u000e\u0014%o\\6feJ+\u0017\rZ!dY\u0006aqI]8vaJ+\u0017\rZ!dY\u0006aAk\u001c9jGJ+\u0017\rZ!dY\u0006iAk\u001c9jG^\u0013\u0018\u000e^3BG2\f\u0001\u0003V8qS\u000e$Um]2sS\n,\u0017i\u00197\u0002\u001dQ{\u0007/[2De\u0016\fG/Z!dY\u0006)1/\u001a;VaR\u0019\u0001P!\n\t\u000f\t\u001d\u0012\b1\u0001\u0003*\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0003,\t]RB\u0001B\u0017\u0015\rq&q\u0006\u0006\u0005\u0005c\u0011\u0019$A\u0004kkBLG/\u001a:\u000b\t\tU\u0012QJ\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005s\u0011iC\u0001\u0005UKN$\u0018J\u001c4pQ\rI$Q\b\t\u0005\u0005W\u0011y$\u0003\u0003\u0003B\t5\"A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002;\u0005\u000f\u0002BAa\u000b\u0003J%!!1\nB\u0017\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u000euKN$\bK]8ek\u000e,7i\u001c8tk6,g+[1BgNLwM\u001c\u0015\u0004w\tE\u0003\u0003\u0002B\u0016\u0005'JAA!\u0016\u0003.\t!A+Z:u\u0003y\u0019wN\u001c4je6\u0014V-Y;uQ\u0016tG/[2bi&|g.T3ue&\u001c7/\u0001\u0005hKR<\u0015-^4f)\u0011\u0011iFa\u001f\u0011\r\t}#\u0011\u000fB;\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014\u0001B2pe\u0016TAAa\u001a\u0003j\u00059Q.\u001a;sS\u000e\u001c(\u0002\u0002B6\u0005[\na!_1n[\u0016\u0014(B\u0001B8\u0003\r\u0019w.\\\u0005\u0005\u0005g\u0012\tGA\u0003HCV<W\rE\u0002q\u0005oJ1A!\u001fr\u0005\u0019!u.\u001e2mK\"9!QP\u001fA\u0002\u0005U\u0011AC7fiJL7MT1nK\u0006qB/Z:u!J|G-^2f\u0007>t7/^7f-&\f7+\u001e2tGJL'-\u001a\u0015\u0004}\tE\u0013A\t;fgR\u0004&o\u001c3vG\u0016\u001cuN\\:v[\u0016<\u0016\u000e\u001e5XS2$7-\u0019:e\u0003\u000ed7\u000fK\u0002@\u0005#\n!\u0005^3tiB\u0013x\u000eZ;dK\u000e{gn];nK^KG\u000f\u001b)sK\u001aL\u00070\u001a3BG2\u001c\bf\u0001!\u0003R\u0005yC/Z:u!J|G-^2f\u0007>t7/^7f)>\u0004\u0018nY!vi>\u001c%/Z1uKR{\u0007/[2De\u0016\fG/Z!dY\"\u001a\u0011I!\u0015\u0002/M,GoV5mI\u000e\f'\u000f\u001a*fg>,(oY3BG2\u001c\u0018aF:fiB\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0017i\u00197t\u0003M\u0019X\r\u001e*fC\u0012\fe\u000eZ,sSR,\u0017i\u00197t)\rA(q\u0013\u0005\b\u0003w!\u0005\u0019AA \u0003E\u0019X\r^!dYN\fe\u000e\u001a)s_\u0012,8-\u001a\u000b\u0004q\nu\u0005bBA\u001e\u000b\u0002\u0007\u0011qH\u0001\u0015g\u0016$8i\u001c8tk6,'o\u0012:pkB\f5\r\\:\u0002kQ,7\u000f\u001e(p\t\u0016\u001c8M]5cKB\u0013x\u000eZ;dK>\u00138i\u001c8tk6,w+\u001b;i_V$Hk\u001c9jG\u0012+7o\u0019:jE\u0016\f5\r\u001c\u0015\u0004\u000f\nE\u0013\u0001\b;fgRtu\u000e\u0015:pIV\u001cWmV5uQ\u0012+7o\u0019:jE\u0016\f5\r\u001c\u0015\u0004\u0011\nE\u0013\u0001\u000b;fgRtunQ8ogVlWmV5uQ>,H\u000fR3tGJL'-Z!dYZK\u0017-Q:tS\u001et\u0007fA%\u0003R\u0005YC/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5pkR$Um]2sS\n,\u0017i\u00197WS\u0006\u001cVOY:de&\u0014W\rK\u0002K\u0005#\n\u0001E\\8D_:\u001cX/\\3XSRDw.\u001e;EKN\u001c'/\u001b2f\u0003\u000ed7+\u001a;va\u0006)C/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0003\u000edg+[1BgNLwM\u001c\u0015\u0004\u0019\nE\u0013\u0001\u000b;fgRtunQ8ogVlWmV5uQ\u0012+7o\u0019:jE\u0016\f5\r\u001c,jCN+(m]2sS\n,\u0007fA'\u0003R\u0005ibn\\\"p]N,X.Z,ji\"$Um]2sS\n,\u0017i\u00197TKR,\b/\u0001\buKN$hj\\$s_V\u0004\u0018i\u00197)\u0007=\u0013\t&A\u0006tK:$'+Z2pe\u0012\u001cHc\u0002=\u0003F\n}'\u0011\u001d\u0005\b\u0005\u000f\u0004\u0006\u0019\u0001Be\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003\u0003Bf\u0005'\u00149Na6\u000e\u0005\t5'\u0002\u0002Bd\u0005\u001fTAA!5\u0002H\u000591\r\\5f]R\u001c\u0018\u0002\u0002Bk\u0005\u001b\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#\u00029\u0002V\ne\u0007c\u00019\u0003\\&\u0019!Q\\9\u0003\t\tKH/\u001a\u0005\u0006wB\u0003\ra\u001c\u0005\b\u0003w\u0001\u0006\u0019AA \u00039\u0019wN\\:v[\u0016\u0014VmY8sIN$R\u0002\u001fBt\u0005k\u00149Pa?\u0003~\n}\bb\u0002Bu#\u0002\u0007!1^\u0001\tG>t7/^7feBA!Q\u001eBy\u0005/\u00149.\u0004\u0002\u0003p*!!\u0011\u001eBh\u0013\u0011\u0011\u0019Pa<\u0003\u0011\r{gn];nKJDqa_)\u0011\u0002\u0003\u0007q\u000e\u0003\u0005\u0003zF\u0003\n\u00111\u0001p\u00039\u0019H/\u0019:uS:<wJ\u001a4tKRD\u0011\"a\fR!\u0003\u0005\r!!\u0006\t\u0011\u0005]\u0012\u000b%AA\u0002=D\u0011b!\u0001R!\u0003\u0005\raa\u0001\u0002\u000fQLW.Z8viB\u0019\u0001o!\u0002\n\u0007\r\u001d\u0011O\u0001\u0003M_:<\u0017\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0002\u0016\u0004_\u000e=1FAB\t!\u0011\u0019\u0019b!\b\u000e\u0005\rU!\u0002BB\f\u00073\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rm\u0011/\u0001\u0006b]:|G/\u0019;j_:LAaa\b\u0004\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"aa\n+\t\u0005U1qB\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*\u0014\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u00111q\u0006\u0016\u0005\u0007\u0007\u0019y!\u0001\fde\u0016\fG/Z*de\u0006l\u0017\tZ7j]\u000ec\u0017.\u001a8u)!\u0019)d!\u0011\u0004F\r%\u0003\u0003BB\u001c\u0007{i!a!\u000f\u000b\t\rm\"qZ\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0007\u007f\u0019IDA\u0003BI6Lg\u000eC\u0004\u0004D]\u0003\r!!\u0006\u0002\u001dM\u001c'/Y7NK\u000eD\u0017M\\5t[\"91qI,A\u0002\u0005U\u0011\u0001B;tKJDqaa\u0013X\u0001\u0004\t)\"\u0001\u0005qCN\u001cxo\u001c:e\u00035\u001awN\\:v[\u0016\u0014VmY8sINLuM\\8sK>sW-Q;uQ>\u0014\u0018N_1uS>tW\t_2faRLwN\u001c\u000b\nq\u000eE31KB+\u0007/BqA!;Y\u0001\u0004\u0011Y\u000fC\u0004|1B\u0005\t\u0019A8\t\u0011\te\b\f%AA\u0002=D\u0011\"a\fY!\u0003\u0005\r!!\u0006\u0002o\r|gn];nKJ+7m\u001c:eg&;gn\u001c:f\u001f:,\u0017)\u001e;i_JL'0\u0019;j_:,\u0005pY3qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003]\u001awN\\:v[\u0016\u0014VmY8sINLuM\\8sK>sW-Q;uQ>\u0014\u0018N_1uS>tW\t_2faRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u000594m\u001c8tk6,'+Z2pe\u0012\u001c\u0018j\u001a8pe\u0016|e.Z!vi\"|'/\u001b>bi&|g.\u0012=dKB$\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ\u0002")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int brokerCount;
    private final int numRecords;
    private final String groupPrefix;
    private final String group;
    private final String topicPrefix;
    private final String topic;
    private final String wildcard;
    private final int part;
    private final TopicPartition tp;
    private final ResourcePattern topicResource;
    private final ResourcePattern groupResource;
    private final ResourcePattern clusterResource;
    private final ResourcePattern prefixedTopicResource;
    private final ResourcePattern prefixedGroupResource;
    private final ResourcePattern wildcardTopicResource;
    private final ResourcePattern wildcardGroupResource;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterActionArgs());
        AclCommand$.MODULE$.main(this.clusterAlterArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String groupPrefix() {
        return this.groupPrefix;
    }

    public String group() {
        return this.group;
    }

    public String topicPrefix() {
        return this.topicPrefix;
    }

    public String topic() {
        return this.topic;
    }

    public String wildcard() {
        return this.wildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private Some<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    public Class<?> authorizerClass() {
        return AclAuthorizer.class;
    }

    public ResourcePattern topicResource() {
        return this.topicResource;
    }

    public ResourcePattern groupResource() {
        return this.groupResource;
    }

    public ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    public ResourcePattern prefixedTopicResource() {
        return this.prefixedTopicResource;
    }

    public ResourcePattern prefixedGroupResource() {
        return this.prefixedGroupResource;
    }

    public ResourcePattern wildcardTopicResource() {
        return this.wildcardTopicResource;
    }

    public ResourcePattern wildcardGroupResource() {
        return this.wildcardGroupResource;
    }

    public abstract KafkaPrincipal clientPrincipal();

    public abstract KafkaPrincipal kafkaPrincipal();

    public String[] clusterActionArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=ClusterAction", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipal()).toString()};
    }

    public String[] clusterAlterArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=Alter", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipal()).toString()};
    }

    public String[] topicBrokerReadAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipal()).toString()};
    }

    public String[] produceAclArgs(String topic) {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] describeAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] deleteDescribeAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] deleteWriteAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Write", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] consumeAclArgs(String topic) {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), new StringBuilder(8).append("--group=").append(this.group()).toString(), "--consumer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] groupAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--group=").append(this.group()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] produceConsumeWildcardAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), new StringBuilder(8).append("--group=").append(this.wildcard()).toString(), "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] produceConsumePrefixedAclsArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topicPrefix()).toString(), new StringBuilder(8).append("--group=").append(this.groupPrefix()).toString(), "--resource-pattern-type=prefixed", "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public scala.collection.immutable.Set<AccessControlEntry> ClusterActionAndClusterAlterAcls() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW), new AccessControlEntry(this.kafkaPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicCreateAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW)}));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4(), this.createTopic$default$5());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    public void confirmReauthenticationMetrics() {
        double expiredConnectionsKilledCountTotal = BoxesRunTime.unboxToDouble((Object)this.getGauge("ExpiredConnectionsKilledCount").value());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$1(expiredConnectionsKilledCountTotal, s);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((double)0.0, (double)expiredConnectionsKilledCountTotal, (double)0.0, (String)"Should have been zero expired connections killed total");
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$2(s);
            return BoxedUnit.UNIT;
        });
    }

    private Gauge<Object> getGauge(String metricName) {
        return (Gauge)((Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.$anonfun$getGauge$1(metricName, x0$1))).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString());
        }))._2();
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithWildcardAcls() {
        this.setWildcardResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithPrefixedAcls() {
        this.setPrefixedResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeTopicAutoCreateTopicCreateAcl() {
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        this.setAclsAndProduce(tp2);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        int x$2 = this.numRecords();
        String x$3 = tp2.topic();
        int n = 0;
        int n2 = this.part();
        long l = 10000L;
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, n, x$3, n2, l);
        this.confirmReauthenticationMetrics();
    }

    private void setWildcardResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumeWildcardAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setWildcardResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setPrefixedResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumePrefixedAclsArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setPrefixedResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setReadAndWriteAcls(TopicPartition tp) {
        AclCommand$.MODULE$.main(this.produceAclArgs(tp.topic()));
        AclCommand$.MODULE$.main(this.consumeAclArgs(tp.topic()));
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setReadAndWriteAcls$1(this, tp, s);
            return BoxedUnit.UNIT;
        });
    }

    public void setAclsAndProduce(TopicPartition tp) {
        this.setReadAndWriteAcls(tp);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), tp);
    }

    private void setConsumerGroupAcls() {
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource(), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl() {
        this.setConsumerGroupAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Assertions.assertThrows(TopicAuthorizationException.class, () -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertThrows(TopicAuthorizationException.class, () -> {
            int x$2 = this.numRecords();
            String x$3 = this.tp().topic();
            int n = 0;
            int n2 = this.part();
            long l = 10000L;
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, n, x$3, n2, l);
        });
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ExecutionException e1 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava()).allTopicNames().get());
        Assertions.assertTrue((boolean)(e1.getCause() instanceof TopicAuthorizationException), (String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause()).toString());
        String topic2 = "topic2";
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        this.setReadAndWriteAcls(tp2);
        this.sendRecords(producer, this.numRecords(), tp2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        int x$8 = this.numRecords();
        int n = 0;
        int n2 = this.part();
        long l = 10000L;
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$8, n, topic2, n2, l);
        Map describeResults = adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava()).topicNameValues();
        Assertions.assertEquals((int)1, (int)((TopicDescription)((KafkaFuture)describeResults.get(topic2)).get()).partitions().size());
        ExecutionException e2 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava()).allTopicNames().get());
        Assertions.assertTrue((boolean)(e2.getCause() instanceof TopicAuthorizationException), (String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause()).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), tp2}))).asJava());
        this.sendRecords(producer, this.numRecords(), tp2);
        BooleanRef topic2RecordConsumed = BooleanRef.create((boolean)false);
        Assertions.assertThrows(TopicAuthorizationException.class, () -> {
            long l = 15000L;
            long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                ConsumerRecords consumerRecords = consumer.poll(Duration.ofMillis(100L));
                Assertions.assertEquals(Collections.singleton(tp2), (Object)consumerRecords.partitions(), (String)new StringBuilder(45).append("Consumed records with unexpected partitions: ").append(consumerRecords).toString());
                topic2RecordConsumed$1.elem = true;
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Consumer didn't fail with authorization exception within timeout");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollRecordsUntilTrue_waitUntilTrue_pause));
            }
        });
        this.setReadAndWriteAcls(this.tp());
        if (!topic2RecordConsumed.elem) {
            this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 1, topic2);
        }
        this.sendRecords(producer, this.numRecords(), this.tp());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic());
        Map describeResults2 = adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava()).topicNameValues();
        Assertions.assertEquals((int)1, (int)((TopicDescription)((KafkaFuture)describeResults2.get(this.topic())).get()).partitions().size());
        Assertions.assertEquals((int)1, (int)((TopicDescription)((KafkaFuture)describeResults2.get(topic2)).get()).partitions().size());
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource(), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicAuthorizationException e = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertThrows(KafkaException.class, () -> this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L));
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        Assertions.assertThrows(TopicAuthorizationException.class, () -> {
            String string;
            int n = 1;
            int n2 = 0;
            String string2 = string = this.topic();
            string = null;
            String x$5 = string2;
            int n3 = this.part();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, n, n2, x$5, n3, 3000L);
        });
        this.setReadAndWriteAcls(this.tp());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), "topic2"}))).asJava());
        Assertions.assertThrows(TopicAuthorizationException.class, () -> {
            String string;
            int n = 1;
            int n2 = 0;
            String string2 = string = this.topic();
            string = null;
            String x$11 = string2;
            int n3 = this.part();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, n, n2, x$11, n3, 3000L);
        });
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic());
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource(), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        TopicAuthorizationException e = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TopicAuthorizationException e = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
        this.confirmReauthenticationMetrics();
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)this.TopicWriteAcl().$plus$plus(this.TopicDescribeAcl()).$plus$plus(this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource(), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        GroupAuthorizationException e = (GroupAuthorizationException)Assertions.assertThrows(GroupAuthorizationException.class, () -> this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L));
        Assertions.assertEquals((Object)this.group(), (Object)e.groupId());
        this.confirmReauthenticationMetrics();
    }

    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, tp, producer, BoxesRunTime.unboxToInt((Object)i))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public final void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(consumer, numRecords, timeout);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assertions.assertEquals((Object)topic, (Object)record.topic());
            Assertions.assertEquals((int)part, (int)record.partition());
            Assertions.assertEquals((long)offset, (long)record.offset());
        });
    }

    public final int consumeRecords$default$2() {
        return 1;
    }

    public final int consumeRecords$default$3() {
        return 0;
    }

    public final String consumeRecords$default$4() {
        return this.topic();
    }

    public final int consumeRecords$default$5() {
        return this.part();
    }

    public final long consumeRecords$default$6() {
        return 10000L;
    }

    public Admin createScramAdminClient(String scramMechanism, String user, String password) {
        return this.createAdminClient(this.brokerList(), this.securityProtocol(), (Option<File>)this.trustStoreFile(), this.clientSaslProperties(), scramMechanism, user, password);
    }

    private void consumeRecordsIgnoreOneAuthorizationException(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic) {
        try {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.part(), 10000L);
            return;
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.part(), 10000L);
            return;
        }
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$2() {
        return 1;
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$3() {
        return 0;
    }

    private String consumeRecordsIgnoreOneAuthorizationException$default$4() {
        return this.topic();
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAndClusterAlterAcls(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.clusterResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$1(double expiredConnectionsKilledCountTotal$1, KafkaServer s) {
        long numExpiredKilled = TestUtils$.MODULE$.totalMetricValue((KafkaBroker)s, "expired-connections-killed-count");
        Assertions.assertEquals((long)0L, (long)numExpiredKilled, (String)new StringBuilder(58).append("Should have been zero expired connections killed: ").append(numExpiredKilled).append("(total=").append(expiredConnectionsKilledCountTotal$1).append(")").toString());
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$2(KafkaServer s) {
        Assertions.assertEquals((long)0L, (long)TestUtils$.MODULE$.totalMetricValue((KafkaBroker)s, "failed-reauthentication-total"), (String)"failed re-authentications not 0");
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        boolean bl = !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$setWildcardResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl()).$plus$plus($this.TopicBrokerReadAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardTopicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardGroupResource(), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$setPrefixedResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedTopicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedGroupResource(), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$setReadAndWriteAcls$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, tp$1.topic(), PatternType.LITERAL), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), AccessControlEntryFilter.ANY);
    }

    private static final boolean verifyNoRecords$1(ConsumerRecords records, TopicPartition tp2$1, BooleanRef topic2RecordConsumed$1) {
        Assertions.assertEquals(Collections.singleton(tp2$1), (Object)records.partitions(), (String)new StringBuilder(45).append("Consumed records with unexpected partitions: ").append(records).toString());
        topic2RecordConsumed$1.elem = true;
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$7() {
        return "Consumer didn't fail with authorization exception within timeout";
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$3, int i) {
        ProducerRecord record = new ProducerRecord(tp$2.topic(), Predef$.MODULE$.int2Integer(tp$2.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$3.send(record);
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 3;
        this.numRecords = 1;
        this.groupPrefix = "gr";
        this.group = new StringBuilder(3).append(this.groupPrefix()).append("oup").toString();
        this.topicPrefix = "e2e";
        this.topic = new StringBuilder(5).append(this.topicPrefix()).append("topic").toString();
        this.wildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicResource = new ResourcePattern(ResourceType.TOPIC, this.topic(), PatternType.LITERAL);
        this.groupResource = new ResourcePattern(ResourceType.GROUP, this.group(), PatternType.LITERAL);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.prefixedTopicResource = new ResourcePattern(ResourceType.TOPIC, this.topicPrefix(), PatternType.PREFIXED);
        this.prefixedGroupResource = new ResourcePattern(ResourceType.GROUP, this.groupPrefix(), PatternType.PREFIXED);
        this.wildcardTopicResource = new ResourcePattern(ResourceType.TOPIC, this.wildcard(), PatternType.LITERAL);
        this.wildcardGroupResource = new ResourcePattern(ResourceType.GROUP, this.wildcard(), PatternType.LITERAL);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), this.authorizerClass().getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp(), "1500");
        this.consumerConfig().setProperty("group.id", "group");
        this.consumerConfig().setProperty("metadata.max.age.ms", "1500");
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$6$adapted(TopicPartition tp2$1, BooleanRef topic2RecordConsumed$1, ConsumerRecords records) {
        return BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.verifyNoRecords$1(records, tp2$1, topic2RecordConsumed$1));
    }
}

