/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaServer;
import kafka.server.Server;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits;
import kafka.utils.Logging;
import kafka.utils.Logging$;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.LoggingSignalHandler;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Kafka$
implements Logging {
    public static final Kafka$ MODULE$ = new Kafka$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Properties getPropsFromArgs(String[] args) {
        Properties properties;
        OptionParser optionParser = new OptionParser(false);
        ArgumentAcceptingOptionSpec overrideOpt = optionParser.accepts("override", "Optional property that should override values set in server.properties file").withRequiredArg().ofType(String.class);
        optionParser.accepts("version", "Print version information and exit.");
        if (args.length == 0 || ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"--help")) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("USAGE: java [options] %s server.properties [--override property=value]*"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.getClass().getCanonicalName()), '$')))})));
        }
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)"--version")) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        String loadProps_filename = args[0];
        Properties properties2 = properties = Utils.loadProps((String)loadProps_filename, null);
        Object var6_4 = null;
        properties = null;
        Properties props = properties2;
        if (args.length > 1) {
            OptionSet options = optionParser.parse((String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])args), 1, args.length));
            if (options.nonOptionArguments().size() > 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringBuilder(31).append("Found non argument parameters: ").append(Predef$.MODULE$.wrapRefArray(options.nonOptionArguments().toArray()).mkString(",")).toString());
            }
            new Implicits.PropertiesOps(props).$plus$plus$eq(CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(options.valuesOf((OptionSpec)overrideOpt)).asScala(), true));
        }
        return props;
    }

    private Server buildServer(Properties props) {
        boolean fromProps_doLog = false;
        KafkaConfig config = new KafkaConfig(props, fromProps_doLog);
        if (config.requiresZookeeper()) {
            return new KafkaServer(config, Time.SYSTEM, (Option<String>)None$.MODULE$, false);
        }
        return new KafkaRaftServer(config, Time.SYSTEM, (Option<String>)None$.MODULE$);
    }

    public void main(String[] args) {
        try {
            Server server;
            block9: {
                Properties serverProps = this.getPropsFromArgs(args);
                server = this.buildServer(serverProps);
                try {
                    if (!OperatingSystem.IS_WINDOWS && !Java.isIbmJdk()) {
                        new LoggingSignalHandler().register();
                    }
                }
                catch (ReflectiveOperationException e) {
                    if (!this.logger().underlying().isWarnEnabled()) break block9;
                    String msgWithLogIdent_msg = Kafka$.$anonfun$main$1(e);
                    Object var7_5 = null;
                    this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), (Throwable)e);
                }
            }
            Exit.addShutdownHook((String)"kafka-shutdown-hook", () -> Exit$.$anonfun$addShutdownHook$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    server.shutdown();
                    return;
                }
                catch (Throwable throwable) {
                    Kafka$ fatal_this = MODULE$;
                    if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
                        String string;
                        String string2 = string = "Halting Kafka.";
                        string = null;
                        String msgWithLogIdent_msg = string2;
                        Object var2_3 = null;
                        fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg));
                    }
                    Object var1_1 = null;
                    throw Exit$.MODULE$.halt(1, (Option<String>)None$.MODULE$);
                }
            }));
            try {
                server.startup();
            }
            catch (Throwable e) {
                if (this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
                    String string;
                    String string2 = string = "Exiting Kafka due to fatal exception during startup.";
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var8_8 = null;
                    this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
                }
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
            server.awaitShutdown();
        }
        catch (Throwable e) {
            if (this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
                String string;
                String string3 = string = "Exiting Kafka due to fatal exception";
                string = null;
                String msgWithLogIdent_msg = string3;
                Object var9_11 = null;
                this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
            }
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
        throw Exit$.MODULE$.exit(0, (Option<String>)None$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$main$1(ReflectiveOperationException e$1) {
        return new StringBuilder(94).append("Failed to register optional signal handler that logs a message when the process is terminated ").append(new StringBuilder(49).append("by a signal. Reason for registration failure is: ").append(e$1).toString()).toString();
    }

    public static final /* synthetic */ ReflectiveOperationException $anonfun$main$2(ReflectiveOperationException e$1) {
        return e$1;
    }

    public static final /* synthetic */ String $anonfun$main$4() {
        return "Halting Kafka.";
    }

    public static final /* synthetic */ String $anonfun$main$5() {
        return "Exiting Kafka due to fatal exception during startup.";
    }

    public static final /* synthetic */ Throwable $anonfun$main$6(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$main$7() {
        return "Exiting Kafka due to fatal exception";
    }

    public static final /* synthetic */ Throwable $anonfun$main$8(Throwable e$3) {
        return e$3;
    }

    private Kafka$() {
    }
}

