/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.Locale;
import kafka.cluster.EndPoint;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class EndPoint$
implements Serializable {
    public static final EndPoint$ MODULE$ = new EndPoint$();
    private static final Regex uriParseExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(.*)://\\[?([0-9a-zA-Z\\-%._:]*)\\]?:(-?[0-9]+)"));
    private static final Map<ListenerName, SecurityProtocol> DefaultSecurityProtocolMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SecurityProtocol.values()), (Function1 & Serializable)sp2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ListenerName.forSecurityProtocol((SecurityProtocol)sp2)), sp2), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());

    private Regex uriParseExp() {
        return uriParseExp;
    }

    public Map<ListenerName, SecurityProtocol> DefaultSecurityProtocolMap() {
        return DefaultSecurityProtocolMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EndPoint createEndPoint(String connectionString, Option<Map<ListenerName, SecurityProtocol>> securityProtocolMap) {
        Option option;
        Map protocolMap = (Map)securityProtocolMap.getOrElse((Function0 & Serializable)() -> MODULE$.DefaultSecurityProtocolMap());
        if (connectionString != null && !(option = this.uriParseExp().unapplySeq((CharSequence)connectionString)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String listenerNameString = (String)((LinearSeqOps)option.get()).apply(0);
            String string = (String)((LinearSeqOps)option.get()).apply(1);
            String port = (String)((LinearSeqOps)option.get()).apply(2);
            if ("".equals(string)) {
                ListenerName listenerName = ListenerName.normalised((String)listenerNameString);
                return new EndPoint(null, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(port)), listenerName, EndPoint$.securityProtocol$1(listenerName, protocolMap));
            }
        }
        if (connectionString == null) throw new KafkaException(new StringBuilder(37).append("Unable to parse ").append(connectionString).append(" to a broker endpoint").toString());
        Option option2 = this.uriParseExp().unapplySeq((CharSequence)connectionString);
        if (option2.isEmpty()) throw new KafkaException(new StringBuilder(37).append("Unable to parse ").append(connectionString).append(" to a broker endpoint").toString());
        if (option2.get() == null) throw new KafkaException(new StringBuilder(37).append("Unable to parse ").append(connectionString).append(" to a broker endpoint").toString());
        if (((List)option2.get()).lengthCompare(3) != 0) throw new KafkaException(new StringBuilder(37).append("Unable to parse ").append(connectionString).append(" to a broker endpoint").toString());
        String listenerNameString = (String)((LinearSeqOps)option2.get()).apply(0);
        String host = (String)((LinearSeqOps)option2.get()).apply(1);
        String port = (String)((LinearSeqOps)option2.get()).apply(2);
        ListenerName listenerName = ListenerName.normalised((String)listenerNameString);
        return new EndPoint(host, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(port)), listenerName, EndPoint$.securityProtocol$1(listenerName, protocolMap));
    }

    public String parseListenerName(String connectionString) {
        Option option;
        if (connectionString == null || (option = this.uriParseExp().unapplySeq((CharSequence)connectionString)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(3) != 0) {
            throw new KafkaException(new StringBuilder(37).append("Unable to parse a listener name from ").append(connectionString).toString());
        }
        String string = ((String)((LinearSeqOps)option.get()).apply(0)).toUpperCase(Locale.ROOT);
        return string;
    }

    public EndPoint fromJava(Endpoint endpoint) {
        return new EndPoint(endpoint.host(), endpoint.port(), new ListenerName((String)endpoint.listenerName().get()), endpoint.securityProtocol());
    }

    public EndPoint apply(String host, int port, ListenerName listenerName, SecurityProtocol securityProtocol) {
        return new EndPoint(host, port, listenerName, securityProtocol);
    }

    public Option<Tuple4<String, Object, ListenerName, SecurityProtocol>> unapply(EndPoint x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.listenerName(), (Object)x$0.securityProtocol()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EndPoint$.class);
    }

    private static final SecurityProtocol securityProtocol$1(ListenerName listenerName, Map protocolMap$1) {
        return (SecurityProtocol)protocolMap$1.getOrElse((Object)listenerName, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(42).append("No security protocol defined for listener ").append(listenerName.value()).toString());
        });
    }

    private EndPoint$() {
    }
}

