/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtils$;
import kafka.admin.ClusterLinkCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.FilterJson;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class ClusterLinkCommand$
implements Logging {
    public static final ClusterLinkCommand$ MODULE$ = new ClusterLinkCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, (Option<ConfluentAdmin>)None$.MODULE$);
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(44).append("Error while executing cluster link command: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = Utils.stackTrace((Throwable)e);
                    Object var5_4 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode, null);
        }
    }

    private ConfluentAdmin createAdminClient(ClusterLinkCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)((AdminClient)Admin.create((Properties)props));
    }

    /*
     * WARNING - void declaration
     */
    private String verifyPropertyAndFilters(ClusterLinkCommandOptions opts, Properties props, String propName, ArgumentAcceptingOptionSpec<String> jsonFileOpt, ArgumentAcceptingOptionSpec<String> filterJsonOpt) {
        void var8_9;
        boolean bl;
        String string;
        boolean isSourceLink = props.getProperty(ClusterLinkConfig$.MODULE$.LinkModeProp(), LinkMode$Destination$.MODULE$.name()).equals(LinkMode$Source$.MODULE$.name());
        boolean propValue = props.getProperty(propName, "false").equals("true");
        if (opts.options().has(jsonFileOpt)) {
            string = Utils.readFileAsString((String)opts.valueOf(jsonFileOpt));
            bl = false;
        } else if (opts.options().has(filterJsonOpt)) {
            string = opts.valueOf(filterJsonOpt);
            bl = true;
        } else {
            string = "";
            bl = false;
        }
        boolean bl2 = bl;
        String jsonString = string;
        if (isSourceLink) {
            if (propValue) {
                Predef$.MODULE$.println((Object)new StringBuilder(42).append("Ignoring ").append(propName).append(" for source cluster link creation").toString());
                props.remove(propName);
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)var8_9))) {
                String optionName = bl2 ? (String)filterJsonOpt.options().get(0) : (String)jsonFileOpt.options().get(0);
                Predef$.MODULE$.println((Object)new StringBuilder(42).append("Ignoring ").append(optionName).append(" for source cluster link creation").toString());
            }
            return "";
        }
        if (propValue && var8_9.trim().isEmpty()) {
            opts.printMessageAndExit(new StringBuilder(151).append(propName).append(" is set to true but the JSON filters are not passed in. Please pass").append(" in the path to the JSON file using the --").append(jsonFileOpt.options().get(0)).append(" option and rerun the create link command.").toString());
        }
        if (!propValue && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(var8_9.trim()))) {
            opts.printMessageAndExit(new StringBuilder(161).append(propName).append(" is set to false but JSON filters are passed in. Please set").append(" ").append(propName).append(" to true in the link configuration and rerun the create link command with the passed in JSON filters.").toString());
        }
        return var8_9;
    }

    private Map<String, String> loadConfigs(ClusterLinkCommandOptions opts) {
        Properties properties;
        if (opts.options().has(opts.configOpt())) {
            properties = AdminUtils$.MODULE$.parseConfigs(opts.valueOf(opts.configOpt()));
        } else {
            Predef$.MODULE$.require(opts.options().has(opts.configFileOpt()));
            String loadProps_filename = (String)opts.options().valueOf(opts.configFileOpt());
            properties = Utils.loadProps((String)loadProps_filename, null);
            Object var9_2 = null;
        }
        Properties props = properties;
        String aclFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), opts.aclFiltersJsonFileOpt(), opts.aclFiltersJsonOpt());
        String consumerOffsetFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), opts.consumerGroupFiltersJsonFileOpt(), opts.consumerGroupFiltersJsonOpt());
        String topicFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), opts.topicFiltersJsonFileOpt(), opts.topicFiltersJsonOpt());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(aclFilterJsonString))) {
            Option<AclFiltersJson> aclJson = AclJson$.MODULE$.parse(aclFilterJsonString);
            if (aclJson instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilterJsonString);
            } else if (None$.MODULE$.equals(aclJson)) {
                opts.printMessageAndExit(new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.AclSyncEnableProp()).append(" is set to true but the JSON file").append(" passed has invalid values. Please put valid values in the JSON file and rerun the create link command.").toString());
            } else {
                throw new MatchError(aclJson);
            }
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(consumerOffsetFilterJsonString))) {
            Option<FilterJson> offsetJson = ClusterLinkFilterJson$.MODULE$.parse(consumerOffsetFilterJsonString);
            if (offsetJson instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), consumerOffsetFilterJsonString);
            } else if (None$.MODULE$.equals(offsetJson)) {
                opts.printMessageAndExit(new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is set to true but the").append(" JSON file passed has invalid values. Please put valid values in the JSON file and rerun the create link").append(" command.").toString());
            } else {
                throw new MatchError(offsetJson);
            }
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicFilterJsonString))) {
            Option<FilterJson> topicsJson = ClusterLinkFilterJson$.MODULE$.parse(topicFilterJsonString);
            if (topicsJson instanceof Some) {
                props.put(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), topicFilterJsonString);
            } else if (None$.MODULE$.equals(topicsJson)) {
                opts.printMessageAndExit(new StringBuilder(136).append(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).append(" is set to true but the JSON").append(" file passed has invalid values. Please put valid values in the JSON file and rerun the create link").append(" command.").toString());
            } else {
                throw new MatchError(topicsJson);
            }
        }
        return CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block13: {
            ClusterLinkCommandOptions opts = new ClusterLinkCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0 & Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options().has((OptionSpec)opts.createOpt())) {
                        this.createClusterLink(opts, client);
                    } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                        this.listClusterLinks(opts, client);
                    } else if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                        this.deleteClusterLink(opts, client);
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        ClusterLinkCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", e);
                        break block13;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ClusterLinkCommand$.throwAdminCommandFailedException$1(((ClusterAuthorizationException)throwable).getMessage(), e);
                        break block13;
                    }
                    throw e;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)"Error while issuing request");
                    throw e;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void createClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        Option<String> clusterId = opts.valueAsOption(opts.clusterIdOpt());
        boolean validateOnly = opts.options().has((OptionSpec)opts.validateOnlyOpt());
        boolean excludeValidateLink = opts.options().has((OptionSpec)opts.excludeValidateLinkOpt());
        NewClusterLink clusterLink = new NewClusterLink(linkName, (String)clusterId.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.MapHasAsJava(this.loadConfigs(opts)).asJava());
        CreateClusterLinksOptions options = new CreateClusterLinksOptions().validateOnly(validateOnly).validateLink(!excludeValidateLink);
        client.createClusterLinks((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)clusterLink, (List)Nil$.MODULE$)).asJava(), options).all().get();
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Cluster link '").append(linkName).append("' creation successfully ").append(action).append(".").toString());
    }

    private void listClusterLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        Option<String> linkName = opts.valueAsOption(opts.linkNameOpt());
        boolean includeTopics = opts.options().has((OptionSpec)opts.includeTopicsOpt());
        ListClusterLinksOptions options = new ListClusterLinksOptions().includeTopics(includeTopics);
        linkName.foreach((Function1 & Serializable)ln -> options.linkNames(Optional.of(Collections.singletonList(ln))));
        Iterable result = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)client.listClusterLinks(options).result().get()).asScala();
        if (result.nonEmpty()) {
            result.foreach((Function1 & Serializable)cl -> {
                ClusterLinkCommand$.$anonfun$listClusterLinks$2(cl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (linkName instanceof Some) {
            String ln2 = (String)((Some)linkName).value();
            Predef$.MODULE$.println((Object)new StringBuilder(23).append("Link name '").append(ln2).append("' not found.").toString());
            return;
        }
        if (None$.MODULE$.equals(linkName)) {
            Predef$.MODULE$.println((Object)"No cluster links found.");
            return;
        }
        throw new MatchError(linkName);
    }

    private void deleteClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        boolean validateOnly = opts.options().has((OptionSpec)opts.validateOnlyOpt());
        boolean force = opts.options().has((OptionSpec)opts.forceOpt());
        DeleteClusterLinksOptions options = new DeleteClusterLinksOptions().validateOnly(validateOnly).force(force);
        client.deleteClusterLinks((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)linkName, (List)Nil$.MODULE$)).asJava(), options).all().get();
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Cluster link '").append(linkName).append("' deletion successfully ").append(action).append(".").toString());
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        Predef$.MODULE$.println((Object)message);
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ void $anonfun$listClusterLinks$2(ClusterLinkListing cl) {
        String localClusterId = cl.localClusterId() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cl.localClusterId())) ? new StringBuilder(22).append(", local cluster ID: '").append(cl.localClusterId()).append("'").toString() : "";
        Predef$.MODULE$.print((Object)new StringBuilder(79).append("Link name: '").append(cl.linkName()).append("', link ID: '").append(cl.clusterLinkId()).append("', remote cluster ID: '").append(cl.remoteClusterId()).append("'").append(localClusterId).append(", remote cluster available: '").append(cl.available()).append("'").toString());
        if (cl.topics().isPresent()) {
            Predef$.MODULE$.print((Object)new StringBuilder(10).append(", topics: ").append(cl.topics().get()).toString());
        }
        Predef$.MODULE$.println();
    }

    private ClusterLinkCommand$() {
    }
}

