/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.MirrorCommand;
import kafka.admin.MirrorCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MirrorCommand$
implements Logging {
    public static final MirrorCommand$ MODULE$ = new MirrorCommand$();
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static int exitCode = 0;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    private SimpleDateFormat formatter() {
        return formatter;
    }

    private int exitCode() {
        return exitCode;
    }

    private void exitCode_$eq(int x$1) {
        exitCode = x$1;
    }

    public void main(String[] args) {
        try {
            try {
                this.run(args, (Option<ConfluentAdmin>)None$.MODULE$);
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(38).append("Error while executing mirror command: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = Utils.stackTrace((Throwable)e);
                    Object var4_3 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                this.exitCode_$eq(1);
            }
        }
        finally {
            Exit.exit((int)this.exitCode(), null);
        }
    }

    private ConfluentAdmin createAdminClient(MirrorCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)((AdminClient)Admin.create((Properties)props));
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        MirrorCommandOptions opts = new MirrorCommandOptions(args);
        opts.checkArgs();
        try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0 & Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options().has((OptionSpec)opts.listOpt())) {
                    this.listMirrors(opts, client);
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeMirrors(opts, client);
                } else if (opts.options().has((OptionSpec)opts.promoteOpt())) {
                    this.stopMirrors(opts, client, AlterMirrorOp.PROMOTE);
                } else if (opts.options().has((OptionSpec)opts.failoverOpt())) {
                    this.stopMirrors(opts, client, AlterMirrorOp.FAILOVER);
                } else if (opts.options().has((OptionSpec)opts.pauseOpt())) {
                    this.pauseMirrors(opts, client, AlterMirrorOp.PAUSE);
                } else if (opts.options().has((OptionSpec)opts.unpauseOpt())) {
                    this.pauseMirrors(opts, client, AlterMirrorOp.RESUME);
                } else if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createMirror(opts, (Admin)client);
                }
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)throwable;
                    String throwAdminCommandFailedException$1_message = "Timed out waiting for results";
                    throw new AdminCommandFailedException(throwAdminCommandFailedException$1_message, timeoutException);
                }
                if (throwable instanceof ClusterAuthorizationException) {
                    ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                    String throwAdminCommandFailedException$1_message = clusterAuthorizationException.getMessage();
                    throw new AdminCommandFailedException(throwAdminCommandFailedException$1_message, (Throwable)clusterAuthorizationException);
                }
                throw e;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private Seq<String> doListMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        ListMirrorsOptions options = new ListMirrorsOptions().includeStopped(opts.includeStopped());
        opts.linkName().foreach((Function1 & Serializable)linkName -> options.linkName(Optional.of(linkName)));
        return CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)client.listMirrors(options).result().get()).asScala().toSeq();
    }

    private void listMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        this.doListMirrors(opts, client).foreach((Function1 & Serializable)topic -> {
            Predef$.MODULE$.println((Object)topic);
            return BoxedUnit.UNIT;
        });
    }

    private void describeMirrors(MirrorCommandOptions opts, ConfluentAdmin client) {
        Seq<String> topics = this.resolveTopics(opts, client);
        DescribeMirrorsOptions options = new DescribeMirrorsOptions();
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(client.describeMirrors((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava(), options).result()).asScala();
        BooleanRef hasTopic = BooleanRef.create((boolean)false);
        if (result.nonEmpty()) {
            scala.collection.immutable.Set partitions = ((IterableOnceOps)result.flatMap((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    try {
                        MirrorTopicDescription desc = (MirrorTopicDescription)((KafkaFuture)x0$1._2()).get();
                        return package$.MODULE$.Range().apply(0, desc.numPartitions()).map((Function1 & Serializable)part -> MirrorCommand$.$anonfun$describeMirrors$2(topic, BoxesRunTime.unboxToInt((Object)part))).toSet();
                    }
                    catch (Throwable e) {
                        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(58).append("Unable to get mirror topic description for mirror topic ").append(topic).append(": ").append(e).toString());
                        return Predef$.MODULE$.Set().empty();
                    }
                }
                throw new MatchError(null);
            })).toSet();
            scala.collection.mutable.Map replicas = CollectionConverters$.MODULE$.MapHasAsScala(client.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava((Set)partitions).asJava(), new ReplicaStatusOptions()).result()).asScala();
            result.foreach((Function1 & Serializable)x0$2 -> {
                MirrorCommand$.$anonfun$describeMirrors$3(opts, hasTopic, replicas, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        if (!hasTopic.elem) {
            Predef$.MODULE$.println((Object)"No mirror topics found.");
            return;
        }
    }

    public String getMirrorTopicInformation(String topic, MirrorTopicDescription desc) {
        StringBuilder builder = new StringBuilder();
        builder.append(new java.lang.StringBuilder(77).append("Topic: ").append(topic).append("\tLinkName: ").append(desc.linkName()).append("\tLinkId: ").append(desc.clusterLinkId()).append("\tSourceTopic: ").append(desc.sourceTopic()).append("\tState: ").append(desc.state()).append("\tSourceTopicId: ").append(desc.sourceTopicId()).append("\tStateTime: ").append(this.timeToDate(desc.stateTimeMs())).toString());
        return builder.toString();
    }

    public String getMirrorPartitionInformation(ReplicaStatus.MirrorInfo mi, ReplicaStatus leader, int part, long stoppedLogEndOffset) {
        long lastSourceFetchHW = mi.lastFetchSourceHighWatermark() != -1L ? mi.lastFetchSourceHighWatermark() : stoppedLogEndOffset;
        long logEndOffset = leader.logEndOffset();
        long lag = lastSourceFetchHW < 0L ? -1L : lastSourceFetchHW - logEndOffset;
        long timeSinceLastFetchMs = leader.lastCaughtUpTimeMs() - mi.lastFetchTimeMs();
        StringBuilder builder = new StringBuilder();
        builder.append(new java.lang.StringBuilder(99).append("\tPartition: ").append(part).append("\tState: ").append(mi.state().toString()).append("\tDestLogEndOffset: ").append(logEndOffset).append("\tLastFetchSourceHighWatermark: ").append(lastSourceFetchHW).append("\tLag: ").append(lag).append("\tTimeSinceLastFetchMs: ").append(timeSinceLastFetchMs).toString());
        return builder.toString();
    }

    public long getMirrorPartitionInformation$default$4() {
        return -1L;
    }

    public String getMirrorPartitionError(int part, Throwable e) {
        String errorMessage = e instanceof ExecutionException ? ((ExecutionException)e).getCause().getMessage() : e.getMessage();
        StringBuilder builder = new StringBuilder();
        builder.append(new java.lang.StringBuilder(50).append("\tPartition: ").append(part).append("\tError: Failed to get replica status: ").append(errorMessage).toString());
        return builder.toString();
    }

    private void stopMirrors(MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp stopOp) {
        Seq<String> topics = this.resolveTopics(opts, client);
        AlterMirrorOp alterMirrorOp = stopOp;
        AlterMirrorOp alterMirrorOp2 = AlterMirrorOp.FAILOVER;
        if (!(alterMirrorOp == null ? alterMirrorOp2 != null : !alterMirrorOp.equals(alterMirrorOp2)) || opts.validateOnly()) {
            this.doStopMirrors(topics, opts, client, stopOp);
            return;
        }
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(53).append("Calculating max offset and ms lag for mirror topics: ").append(topics.mkString("[", ", ", "]")).toString());
        scala.collection.mutable.Map topicToOffsetLag = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map topicToLagMs = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        DescribeMirrorsOptions describeOptions = new DescribeMirrorsOptions();
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(client.describeMirrors((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava(), describeOptions).result()).asScala();
        if (result.nonEmpty()) {
            scala.collection.immutable.Set partitions = ((IterableOnceOps)result.flatMap((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    try {
                        MirrorTopicDescription desc = (MirrorTopicDescription)((KafkaFuture)x0$1._2()).get();
                        topicToOffsetLag.put((Object)topic, (Object)BoxesRunTime.boxToLong((long)-1L));
                        topicToLagMs.put((Object)topic, (Object)BoxesRunTime.boxToLong((long)-1L));
                        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), desc.numPartitions()).map((Function1 & Serializable)part -> MirrorCommand$.$anonfun$stopMirrors$2(topic, BoxesRunTime.unboxToInt((Object)part))).toSet();
                    }
                    catch (Throwable e) {
                        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(58).append("Unable to get mirror topic description for mirror topic ").append(topic).append(": ").append(e).toString());
                        return Predef$.MODULE$.Set().empty();
                    }
                }
                throw new MatchError(null);
            })).toSet();
            scala.collection.mutable.Map replicas = CollectionConverters$.MODULE$.MapHasAsScala(client.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava((Set)partitions).asJava(), new ReplicaStatusOptions()).result()).asScala();
            result.foreach((Function1 & Serializable)x0$2 -> {
                MirrorCommand$.$anonfun$stopMirrors$3(replicas, topicToOffsetLag, topicToLagMs, x0$2);
                return BoxedUnit.UNIT;
            });
        } else {
            Predef$.MODULE$.println((Object)"No mirror topics found to calculate lag and offset.");
            this.exitCode_$eq(1);
            Exit.exit((int)this.exitCode(), null);
        }
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(70).append("Finished calculating max offset lag and max lag ms for mirror topics: ").append(topics.mkString("[", ", ", "]")).toString());
        scala.collection.mutable.Set violatingTopics = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        topics.foreach((Function1 & Serializable)t -> {
            if (topicToOffsetLag.contains(t) && topicToLagMs.contains(t)) {
                long topicOffsetLag = BoxesRunTime.unboxToLong((Object)topicToOffsetLag.apply(t));
                if (BoxesRunTime.unboxToLong((Object)topicToLagMs.apply(t)) > 0L || topicOffsetLag > 0L) {
                    return violatingTopics.$plus$eq(t);
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (violatingTopics.nonEmpty()) {
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(178).append("Found following mirror topics with greater lag offset and/or lag ms than").append(" specified: ").append(violatingTopics.mkString("[", ", ", "]")).append(". Not proceeding with promote.").append(" If you still wish to promote, use the failover command instead.").toString());
            violatingTopics.foreach((Function1 & Serializable)t -> {
                MirrorCommand$.$anonfun$stopMirrors$10(topicToLagMs, topicToOffsetLag, t);
                return BoxedUnit.UNIT;
            });
            this.exitCode_$eq(1);
            Exit.exit((int)this.exitCode(), null);
        }
        this.doStopMirrors(topics, opts, client, stopOp);
    }

    private void doStopMirrors(Seq<String> topics, MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp stopOp) {
        String action = opts.validateOnly() ? "validated" : "scheduled";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)stopOp))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options).values()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$doStopMirrors$2(action, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void pauseMirrors(MirrorCommandOptions opts, ConfluentAdmin client, AlterMirrorOp pauseOp) {
        Seq<String> topics = this.resolveTopics(opts, client);
        AlterMirrorOp alterMirrorOp = pauseOp;
        AlterMirrorOp alterMirrorOp2 = AlterMirrorOp.PAUSE;
        String upperCommand = !(alterMirrorOp != null ? !alterMirrorOp.equals(alterMirrorOp2) : alterMirrorOp2 != null) ? "Pausing" : "Resuming";
        String lowerCommand = upperCommand.toLowerCase(Locale.ROOT);
        String action = opts.validateOnly() ? "validated" : "completed";
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)pauseOp))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsOptions options = new AlterMirrorsOptions().validateOnly(opts.validateOnly());
        CollectionConverters$.MODULE$.MapHasAsScala(client.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options).values()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            MirrorCommand$.$anonfun$pauseMirrors$2(upperCommand, action, lowerCommand, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void createMirror(MirrorCommandOptions opts, Admin client) {
        MirrorCommand.MirrorCommandTopicPartition topic = new MirrorCommand.MirrorCommandTopicPartition(opts);
        if (Topic.hasCollisionChars((String)((String)topic.name().get()))) {
            Predef$.MODULE$.println((Object)"WARNING: Due to limitations in metric names, topics with a period ('.') or underscore ('_') could collide. To avoid issues it is best to use either, but not both.");
        }
        if (topic.replicationFactor().exists((Function1 & Serializable)rf -> BoxesRunTime.boxToBoolean((boolean)MirrorCommand$.$anonfun$createMirror$1(rf)))) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(70).append("The replication factor must be between 1 and ").append(Short.MAX_VALUE).append(" inclusive").toString());
        }
        try {
            None$ partitions = None$.MODULE$;
            NewTopic newTopic = new NewTopic((String)topic.name().get(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)partitions)), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(topic.replicationFactor().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToShort((short)MirrorCommand$.$anonfun$createMirror$2(x$5))).map((Function1 & Serializable)x -> MirrorCommand$.$anonfun$createMirror$3(BoxesRunTime.unboxToShort((Object)x))))));
            java.util.Map configsMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(topic.configs().stringPropertyNames()).asScala().map((Function1 & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)topic.configs().getProperty((String)name)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            newTopic.configs(configsMap);
            topic.mirrorTopic().foreach((Function1 & Serializable)mt -> newTopic.mirror(Optional.of(new NewMirrorTopic((String)topic.linkName().get(), mt))));
            client.createTopics(Collections.singleton(newTopic), new CreateTopicsOptions().retryOnQuotaViolation(false)).all().get();
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(15).append("Created topic ").append(topic.name().get()).append(".").toString());
            return;
        }
        catch (ExecutionException e) {
            if (e.getCause() == null) {
                throw e;
            }
            throw e.getCause();
        }
    }

    private Seq<String> resolveTopics(MirrorCommandOptions opts, ConfluentAdmin client) {
        Option<Seq<String>> option = opts.topics();
        if (option instanceof Some) {
            return (Seq)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            return this.doListMirrors(opts, client);
        }
        throw new MatchError(option);
    }

    public Properties parseTopicConfigsToBeAdded(MirrorCommandOptions opts) {
        Buffer configsToBeAdded = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)opts.topicConfig().getOrElse((Function0 & Serializable)() -> Collections.emptyList())).asScala().map((Function1 & Serializable)x$6 -> x$6.split("\\s*=\\s*"));
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)MirrorCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config))), (Function0 & Serializable)() -> "Invalid topic config: all configs to be added must be in the format \"key=val\".");
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1 & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(165).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString());
        }
        if (props.containsKey("confluent.placement.constraints")) {
            throw new IllegalArgumentException("Configuration cannot contain 'confluent.placement.constraints' option.");
        }
        return props;
    }

    public String timeToDate(long timeMs) {
        return this.formatter().format(new Date(timeMs));
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ TopicPartition $anonfun$describeMirrors$2(String topic$1, int part) {
        return new TopicPartition(topic$1, part);
    }

    public static final /* synthetic */ String $anonfun$describeMirrors$6(Throwable e$2) {
        return new java.lang.StringBuilder(36).append("Unable to get stoppedLogEndOffsets. ").append(e$2).toString();
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$4(scala.collection.mutable.Map replicas$1, String topic$2, Option stoppedLogEndOffsets$1, MirrorCommandOptions opts$2, int part) {
        block12: {
            try {
                long l;
                ReplicaStatus leader = (ReplicaStatus)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((List)((KafkaFuture)replicas$1.apply((Object)new TopicPartition(topic$2, part))).get()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isLeader()))).head();
                if (!leader.mirrorInfo().isPresent()) {
                    throw new ClusterLinkNotFoundException("Mirror state not associated with the partition");
                }
                ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                if (stoppedLogEndOffsets$1 instanceof Some) {
                    Seq offsets = (Seq)((Some)stoppedLogEndOffsets$1).value();
                    try {
                        l = Predef$.MODULE$.Long2long((Long)offsets.apply(part));
                    }
                    catch (Throwable e) {
                        MirrorCommand$ warn_this = MODULE$;
                        if (warn_this.logger().underlying().isWarnEnabled()) {
                            String msgWithLogIdent_msg = MirrorCommand$.$anonfun$describeMirrors$6(e);
                            Object var14_10 = null;
                            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                        }
                        Object var13_9 = null;
                        l = -1L;
                    }
                } else if (None$.MODULE$.equals(stoppedLogEndOffsets$1)) {
                    l = -1L;
                } else {
                    throw new MatchError((Object)stoppedLogEndOffsets$1);
                }
                long stoppedLogEndOffset = l;
                if (opts$2.pendingStoppedOnly()) {
                    ReplicaStatus.MirrorInfo.State state = mi.state();
                    ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                    if (!(state != null ? !state.equals(state2) : state2 != null)) {
                        Predef$.MODULE$.println((Object)MODULE$.getMirrorPartitionInformation(mi, leader, part, -1L));
                    }
                    break block12;
                }
                Predef$.MODULE$.println((Object)MODULE$.getMirrorPartitionInformation(mi, leader, part, stoppedLogEndOffset));
                return;
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)MODULE$.getMirrorPartitionError(part, e));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$3(MirrorCommandOptions opts$2, BooleanRef hasTopic$1, scala.collection.mutable.Map replicas$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            block6: {
                String topic = (String)x0$2._1();
                try {
                    MirrorTopicDescription desc = (MirrorTopicDescription)((KafkaFuture)x0$2._2()).get();
                    if (opts$2.pendingStoppedOnly()) {
                        MirrorTopicDescription.State state = desc.state();
                        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.PENDING_STOPPED;
                        if (state != null ? !state.equals(state2) : state2 != null) break block6;
                    }
                    Predef$.MODULE$.println((Object)MODULE$.getMirrorTopicInformation(topic, desc));
                    hasTopic$1.elem = true;
                    MirrorTopicDescription.State state = desc.state();
                    MirrorTopicDescription.State state3 = MirrorTopicDescription.State.STOPPED;
                    None$ stoppedLogEndOffsets = !(state != null ? !state.equals(state3) : state3 != null) && desc.stoppedLogEndOffsets() != null ? new Some((Object)CollectionConverters$.MODULE$.ListHasAsScala(desc.stoppedLogEndOffsets()).asScala().toSeq()) : None$.MODULE$;
                    package$.MODULE$.Range().apply(0, desc.numPartitions()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> MirrorCommand$.$anonfun$describeMirrors$4(replicas$1, topic, (Option)stoppedLogEndOffsets, opts$2, arg_0)));
                }
                catch (ExecutionException e) {
                    Predef$.MODULE$.println((Object)new java.lang.StringBuilder(15).append("Topic: ").append(topic).append("\tError: ").append(e.getCause()).toString());
                    return;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)new java.lang.StringBuilder(15).append("Topic: ").append(topic).append("\tError: ").append(e).toString());
                }
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TopicPartition $anonfun$stopMirrors$2(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    public static final /* synthetic */ Object $anonfun$stopMirrors$4(scala.collection.mutable.Map replicas$2, String topic$4, scala.collection.mutable.Map topicToOffsetLag$1, scala.collection.mutable.Map topicToLagMs$1, int part) {
        Object object;
        block5: {
            try {
                ReplicaStatus leader = (ReplicaStatus)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((List)((KafkaFuture)replicas$2.apply((Object)new TopicPartition(topic$4, part))).get()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isLeader()))).head();
                if (leader.mirrorInfo().isPresent()) {
                    ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                    long timeSinceLastFetchMs = leader.lastCaughtUpTimeMs() - mi.lastFetchTimeMs();
                    long lagOffset = mi.lastFetchSourceHighWatermark() - leader.logEndOffset();
                    if (BoxesRunTime.unboxToLong((Object)topicToOffsetLag$1.getOrElse((Object)topic$4, (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) < lagOffset) {
                        topicToOffsetLag$1.put((Object)topic$4, (Object)BoxesRunTime.boxToLong((long)lagOffset));
                    }
                    object = BoxesRunTime.unboxToLong((Object)topicToLagMs$1.getOrElse((Object)topic$4, (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) < timeSinceLastFetchMs && BoxesRunTime.unboxToLong((Object)topicToOffsetLag$1.getOrElse((Object)topic$4, (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) < lagOffset ? topicToLagMs$1.put((Object)topic$4, (Object)BoxesRunTime.boxToLong((long)timeSinceLastFetchMs)) : BoxedUnit.UNIT;
                    break block5;
                }
                return BoxedUnit.UNIT;
            }
            catch (ExecutionException e) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(58).append("Error while calculating lag for").append(" mirror topic ").append(topic$4).append(" partition ").append(part).append(": ").append(e.getCause()).toString());
                return BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(91).append("Error while calculating lag for mirror topic").append(" ").append(topic$4).append(" partition ").append(part).append(". Mirror partition may have failed.").toString());
                object = BoxedUnit.UNIT;
            }
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$stopMirrors$3(scala.collection.mutable.Map replicas$2, scala.collection.mutable.Map topicToOffsetLag$1, scala.collection.mutable.Map topicToLagMs$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String topic = (String)x0$2._1();
            try {
                MirrorTopicDescription desc = (MirrorTopicDescription)((KafkaFuture)x0$2._2()).get();
                package$.MODULE$.Range().apply(0, desc.numPartitions()).foreach((Function1 & Serializable)part -> MirrorCommand$.$anonfun$stopMirrors$4(replicas$2, topic, topicToOffsetLag$1, topicToLagMs$1, BoxesRunTime.unboxToInt((Object)part)));
                return;
            }
            catch (ExecutionException e) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(52).append("Failed to get mirror description for topic").append(" mirror ").append(topic).append(": ").append(e.getCause()).toString());
                return;
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(52).append("Failed to get mirror description for mirror topic").append(" ").append(topic).append(": ").append(e).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$stopMirrors$10(scala.collection.mutable.Map topicToLagMs$1, scala.collection.mutable.Map topicToOffsetLag$1, String t) {
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(30).append("Max lag ms for mirror topic ").append(t).append(": ").append(topicToLagMs$1.apply((Object)t)).toString());
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(34).append("Max offset lag for mirror topic ").append(t).append(": ").append(topicToOffsetLag$1.apply((Object)t)).toString());
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$doStopMirrors$2(String action$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(147).append("Request for stopping topic ").append(topic).append("'s mirror was successfully ").append(action$1).append(". Please use").append(" the describe command with the --pending-stopped-only option to monitor progress.").toString());
                return;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(50).append("Error encountered while stopping topic ").append(topic).append("'s mirror: ").append(ex).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$pauseMirrors$2(String upperCommand$1, String action$2, String lowerCommand$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(36).append(upperCommand$1).append(" topic '").append(topic).append("'s mirror was successfully ").append(action$2).append(".").toString());
                return;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println((Object)new java.lang.StringBuilder(43).append("Error encountered while ").append(lowerCommand$1).append(" topic '").append(topic).append("'s mirror: ").append(ex).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createMirror$1(Integer rf) {
        return Predef$.MODULE$.Integer2int(rf) > Short.MAX_VALUE || Predef$.MODULE$.Integer2int(rf) < 1;
    }

    public static final /* synthetic */ short $anonfun$createMirror$2(Integer x$5) {
        return (short)Predef$.MODULE$.Integer2int(x$5);
    }

    public static final /* synthetic */ Short $anonfun$createMirror$3(short x) {
        return BoxesRunTime.boxToShort((short)x);
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    private MirrorCommand$() {
    }
}

