/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ReplicaExclusionCommand$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandLineUtils$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u4A!\u0006\f\u00037!I!\u0005\u0001B\u0001B\u0003%1\u0005\u000e\u0005\u0006k\u0001!\tA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0003Y\u0004B\u0002#\u0001A\u0003%A\bC\u0004F\u0001\t\u0007I\u0011\u0001$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u001dY\u0005A1A\u0005\u0002\u0019Ca\u0001\u0014\u0001!\u0002\u00139\u0005bB'\u0001\u0005\u0004%\tA\u0012\u0005\u0007\u001d\u0002\u0001\u000b\u0011B$\t\u000f=\u0003!\u0019!C\u0001w!1\u0001\u000b\u0001Q\u0001\nqBq!\u0015\u0001C\u0002\u0013\u00051\b\u0003\u0004S\u0001\u0001\u0006I\u0001\u0010\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006M\u0002!\ta\u001a\u0005\u0006W\u0002!\ta\u001a\u0005\u0006Y\u0002!I!\u001c\u0002\u001f%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001cu.\\7b]\u0012|\u0005\u000f^5p]NT!a\u0006\r\u0002\u000b\u0005$W.\u001b8\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004G\u0001\u0006kRLGn]\u0005\u0003Cy\u0011QcQ8n[\u0006tG\rR3gCVdGo\u00149uS>t7/\u0001\u0003be\u001e\u001c\bc\u0001\u0013(S5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0003BeJ\f\u0017\u0010\u0005\u0002+c9\u00111f\f\t\u0003Y\u0015j\u0011!\f\u0006\u0003]i\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019&\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A*\u0013B\u0001\u0012!\u0003\u0019a\u0014N\\5u}Q\u0011q'\u000f\t\u0003q\u0001i\u0011A\u0006\u0005\u0006E\t\u0001\raI\u0001\u0010E>|Go\u001d;sCB\u001cVM\u001d<feV\tA\bE\u0002>\u0001&j\u0011A\u0010\u0006\u0002\u007f\u0005Q!n\u001c9ug&l\u0007\u000f\\3\n\u0005\u0005s$aG!sOVlWM\u001c;BG\u000e,\u0007\u000f^5oO>\u0003H/[8o'B,7-\u0001\tc_>$8\u000f\u001e:baN+'O^3sA\u0005\u00012m\\7nC:$7i\u001c8gS\u001e|\u0005\u000f^\u0001\u0012G>lW.\u00198e\u0007>tg-[4PaR\u0004\u0013!\u00033fY\u0016$Xm\u00149u+\u00059\u0005CA\u001fI\u0013\tIeHA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJ\f!\u0002Z3mKR,w\n\u001d;!\u0003\u0019\tG\rZ(qi\u00069\u0011\r\u001a3PaR\u0004\u0013a\u00033fg\u000e\u0014\u0018NY3PaR\fA\u0002Z3tGJL'-Z(qi\u0002\nAB\u0019:pW\u0016\u0014\u0018\nZ:PaR\fQB\u0019:pW\u0016\u0014\u0018\nZ:PaR\u0004\u0013A\u0002:fCN|g.A\u0004sK\u0006\u001cxN\u001c\u0011\u0002\u000fY\fG.^3PMV\u0011Q\u000b\u0017\u000b\u0003-\u0006\u0004\"a\u0016-\r\u0001\u0011)\u0011,\u0005b\u00015\n\tA+\u0005\u0002\\=B\u0011A\u0005X\u0005\u0003;\u0016\u0012qAT8uQ&tw\r\u0005\u0002%?&\u0011\u0001-\n\u0002\u0004\u0003:L\b\"\u00022\u0012\u0001\u0004\u0019\u0017aA8qiB\u0019Q\b\u001a,\n\u0005\u0015t$AC(qi&|gn\u00159fG\u0006Qa/\u001a:jMf\f%oZ:\u0015\u0003!\u0004\"\u0001J5\n\u0005),#\u0001B+oSR\f\u0011b\u00195fG.\f%oZ:\u0002%Y,'/\u001b4z%\u0016\fX/\u001b:fI\u0006\u0013xm\u001d\u000b\u0004Q:\u001c\b\"B8\u0015\u0001\u0004\u0001\u0018aB8qi&|gn\u001d\t\u0003{EL!A\u001d \u0003\u0013=\u0003H/[8o'\u0016$\b\"\u0002;\u0015\u0001\u0004)\u0018\u0001\u0003:fcVL'/\u001a3\u0011\u0007\u00112\b0\u0003\u0002xK\tQAH]3qK\u0006$X\r\u001a 1\u0005e\\\bcA\u001feuB\u0011qk\u001f\u0003\nyN\f\t\u0011!A\u0003\u0002i\u00131a\u0018\u00133\u0001")
public final class ReplicaExclusionCommandOptions
extends CommandDefaultOptions {
    private final ArgumentAcceptingOptionSpec<String> bootstrapServer = this.parser().accepts("bootstrap-server", "A hostname and port for the broker to connect to, in the form host:port. Multiple comma separated URLs can be given. REQUIRED.").withRequiredArg().describedAs("host:port").ofType(String.class);
    private final ArgumentAcceptingOptionSpec<String> commandConfigOpt = this.parser().accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("file").ofType(String.class);
    private final OptionSpecBuilder deleteOpt = this.parser().accepts("delete", "Delete a replica exclusion.");
    private final OptionSpecBuilder addOpt = this.parser().accepts("add", "Add a replica placement exclusion on brokers in from the cluster.");
    private final OptionSpecBuilder describeOpt = this.parser().accepts("describe", "Describe the status of the broker removal operation.");
    private final ArgumentAcceptingOptionSpec<String> brokerIdsOpt = this.parser().accepts("broker-ids", "The comma-separated list of ids of the Kafka brokers for which the exclusions will apply.").withRequiredArg().describedAs("broker ids").ofType(String.class);
    private final ArgumentAcceptingOptionSpec<String> reason = this.parser().accepts("reason", "The reason given for excluding the set of brokers.").withRequiredArg().describedAs("reason").ofType(String.class);

    public ArgumentAcceptingOptionSpec<String> bootstrapServer() {
        return this.bootstrapServer;
    }

    public ArgumentAcceptingOptionSpec<String> commandConfigOpt() {
        return this.commandConfigOpt;
    }

    public OptionSpecBuilder deleteOpt() {
        return this.deleteOpt;
    }

    public OptionSpecBuilder addOpt() {
        return this.addOpt;
    }

    public OptionSpecBuilder describeOpt() {
        return this.describeOpt;
    }

    public ArgumentAcceptingOptionSpec<String> brokerIdsOpt() {
        return this.brokerIdsOpt;
    }

    public ArgumentAcceptingOptionSpec<String> reason() {
        return this.reason;
    }

    public <T> T valueOf(OptionSpec<T> opt) {
        return (T)this.options().valueOf(opt);
    }

    public void verifyArgs() {
        this.verifyRequiredArgs(this.options(), (Seq<OptionSpec<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServer()}));
        if (new .colon.colon((Object)this.deleteOpt(), (List)new .colon.colon((Object)this.addOpt(), (List)new .colon.colon((Object)this.describeOpt(), (List)Nil$.MODULE$))).count(arg_0 -> ReplicaExclusionCommandOptions.$anonfun$verifyArgs$1$adapted(this.options(), arg_0)) != 1) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Command must include exactly one action: ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.deleteOpt())).append(", ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.addOpt())).append(" or ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.describeOpt())).append(".").toString());
        }
        if (!this.options().has((OptionSpec)this.describeOpt())) {
            if (!this.options().has(this.brokerIdsOpt())) {
                throw new IllegalArgumentException(new StringBuilder(31).append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.brokerIdsOpt())).append(" must be supplied ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.deleteOpt())).append(" or ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.addOpt())).append(" is used.").toString());
            }
            String brokerIds = (String)this.options().valueOf(this.brokerIdsOpt());
            if (brokerIds.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(34).append("No broker ids were supplied with ").append(ReplicaExclusionCommand$.MODULE$.flagName((OptionSpec<?>)this.brokerIdsOpt())).append(".").toString());
            }
            if (StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(brokerIds), (Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionCommandOptions.$anonfun$verifyArgs$2(BoxesRunTime.unboxToChar((Object)id))))) {
                throw new IllegalArgumentException(new StringBuilder(42).append("Broker ids contain unrepresentable IDs - ").append(brokerIds).append(".").toString());
            }
            return;
        }
    }

    public void checkArgs() {
        if (super.args().length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), "Set, remove and describe broker replica placement exclusion.");
        }
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(this, "This tool allows for setting, removing and describing the status of broker replica placement exclusions.");
        try {
            this.verifyArgs();
            return;
        }
        catch (Throwable e) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), e.getMessage());
        }
    }

    private void verifyRequiredArgs(OptionSet options, Seq<OptionSpec<?>> required) {
        required.foreach((Function1 & Serializable)arg -> {
            ReplicaExclusionCommandOptions.$anonfun$verifyRequiredArgs$1(options, arg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$verifyArgs$2(char id) {
        return id < '\u0000';
    }

    public static final /* synthetic */ void $anonfun$verifyRequiredArgs$1(OptionSet options$1, OptionSpec arg) {
        if (!options$1.has(arg)) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Missing required argument '").append(arg).append("'").toString());
        }
    }

    public ReplicaExclusionCommandOptions(String[] args) {
        super(args, false);
        this.options_$eq(this.parser().parse(super.args()));
    }

    public static final /* synthetic */ Object $anonfun$verifyArgs$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }
}

