/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.balancer.BalancerCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerAdditionsResult;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BrokerAdditionCommand$
implements Logging {
    public static final BrokerAdditionCommand$ MODULE$ = new BrokerAdditionCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        None$ clientOpt = None$.MODULE$;
        try {
            try {
                BalancerCommandOptions opts = new BalancerCommandOptions(args);
                opts.checkArgs();
                clientOpt = new Some((Object)this.createAdminClient(opts));
                this.runAddition(opts, (ConfluentAdmin)clientOpt.get());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(72).append("Unexpected error while running the kafka-add-brokers command-line tool: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = Utils.stackTrace((Throwable)e);
                    Object var7_6 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                exitCode = 1;
            }
        }
        finally {
            clientOpt.foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            Exit.exit((int)exitCode, null);
        }
    }

    public void runAddition(BalancerCommandOptions opts, ConfluentAdmin client) {
        try {
            None$ brokerIdOpt = opts.options().has(opts.brokerIdOpt()) ? new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(opts.valueOf(opts.brokerIdOpt()))))) : None$.MODULE$;
            this.describeBrokerAddition((Option<Object>)brokerIdOpt, client);
            return;
        }
        catch (ApiException e) {
            if (e instanceof TimeoutException) {
                throw new AdminCommandFailedException("Timed out waiting for the broker addition results", e);
            }
            if (e instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)e;
                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), e);
            }
            if (e instanceof BalancerOfflineException) {
                BalancerOfflineException balancerOfflineException = (BalancerOfflineException)e;
                throw new AdminCommandFailedException(balancerOfflineException.getMessage(), (Throwable)balancerOfflineException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while issuing the describe broker additions request");
            throw e;
        }
    }

    public void describeBrokerAddition(Option<Object> brokerIdOpt, ConfluentAdmin client) {
        Iterable iterable;
        String msgAnnex = "";
        DescribeBrokerAdditionsResult brokerAdditionsResult = client.describeBrokerAdditions();
        if (brokerIdOpt instanceof Some) {
            int brokerId = BoxesRunTime.unboxToInt((Object)((Some)brokerIdOpt).value());
            msgAnnex = new StringBuilder(12).append(" for broker ").append(brokerId).toString();
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric((Optional)brokerAdditionsResult.description(brokerId).get()));
            if (option instanceof Some) {
                BrokerAdditionDescription additionDesc = (BrokerAdditionDescription)((Some)option).value();
                iterable = new .colon.colon((Object)additionDesc, (List)Nil$.MODULE$);
            } else {
                iterable = Nil$.MODULE$;
            }
        } else if (None$.MODULE$.equals(brokerIdOpt)) {
            iterable = CollectionConverters$.MODULE$.CollectionHasAsScala(((Map)brokerAdditionsResult.descriptions().get()).values()).asScala();
        } else {
            throw new MatchError(brokerIdOpt);
        }
        Iterable additions = iterable;
        if (additions.isEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(31).append("No broker additions in progress").append(msgAnnex).toString());
            return;
        }
        additions.foreach((Function1 & Serializable)desc -> {
            Predef$.MODULE$.println((Object)BrokerAdditionCommand$.MODULE$.additionDescriptionString(desc));
            return BoxedUnit.UNIT;
        });
    }

    private String additionDescriptionString(BrokerAdditionDescription desc) {
        String lineSeparator = new StringBuilder(2).append(System.lineSeparator()).append("  ").toString();
        String baseStringDescription = new StringBuilder(70).append("Broker ").append(desc.brokerId()).append(" addition status - ").append(desc.generalOperationStatus()).append(". Sub-task statuses:").append(lineSeparator).append("Partition Reassignment: ").append(desc.partitionReassignmentsStatus()).toString();
        if (desc.additionError().isPresent()) {
            BalancerOperationError balancerOpError = (BalancerOperationError)desc.additionError().get();
            baseStringDescription = new StringBuilder(2).append(baseStringDescription).append(lineSeparator).append(balancerOpError.exception().getClass().getName()).append(": ").append(balancerOpError.errorMessage()).toString();
        }
        baseStringDescription = new StringBuilder(25).append(baseStringDescription).append(lineSeparator).append("Operation Creation Time: ").append(ClientUtils.utcDateFor((long)desc.createTimeMs())).toString();
        baseStringDescription = new StringBuilder(28).append(baseStringDescription).append(lineSeparator).append("Operation Last Update Time: ").append(ClientUtils.utcDateFor((long)desc.lastUpdateTimeMs())).toString();
        return baseStringDescription;
    }

    public ConfluentAdmin createAdminClient(BalancerCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)Admin.create((Properties)props);
    }

    public String flagName(OptionSpec<?> option) {
        return new StringBuilder(2).append("--").append(option.options().get(0)).toString();
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private BrokerAdditionCommand$() {
    }
}

