/*
 * Decompiled with CFR 0.152.
 */
package kafka.assignor;

import java.util.List;
import java.util.Optional;
import kafka.assignor.TopicReplicaAssignor;
import kafka.assignor.TopicReplicaAssignorBuilder;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;

public class ConfluentReplicaPlacer
implements ReplicaPlacer {
    private final ReplicaPlacer defaultPlacer;
    private final TopicReplicaAssignorBuilder assignorBuilder;

    public ConfluentReplicaPlacer(ReplicaPlacer defaultPlacer, TopicReplicaAssignorBuilder assignorBuilder) {
        this.defaultPlacer = defaultPlacer;
        this.assignorBuilder = assignorBuilder;
    }

    public List<List<Integer>> place(PlacementSpec placement, ClusterDescriber cluster) throws InvalidReplicationFactorException {
        this.assignorBuilder.updateClusterDescriber(cluster);
        Optional<TopicReplicaAssignor> assignor = this.assignorBuilder.maybeBuildAssignor(Optional.ofNullable(placement.principal()));
        if (assignor.isPresent()) {
            TopicReplicaAssignor.NewPartitions newPartitions = new TopicReplicaAssignor.NewPartitions(placement.topicName(), placement.startPartition() + placement.numPartitions(), placement.startPartition(), placement.numReplicas());
            Optional<List<List<Integer>>> result = placement.startPartition() == 0 ? assignor.get().computeAssignmentForNewTopic(newPartitions, Optional.empty(), placement.excludedBrokerIds()) : assignor.get().computeAssignmentForExistingTopic(newPartitions, Optional.empty(), placement.excludedBrokerIds());
            if (result.isPresent()) {
                return result.get();
            }
        }
        return this.defaultPlacer.place(placement, cluster);
    }
}

