/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.availability.AllThreadsStuck$;
import kafka.availability.AnyThreadStuck$;
import kafka.availability.BrokerHealthManager$;
import kafka.availability.BrokerHealthManagerConfig;
import kafka.availability.BrokerHealthManagerConfig$;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.HealthSamplesWindow;
import kafka.availability.HealthStatusAggregationOperator;
import kafka.availability.HealthStatusAggregationOperator_And$;
import kafka.availability.HealthStatusAggregationOperator_Or$;
import kafka.availability.Healthy$;
import kafka.availability.Suspect$;
import kafka.availability.ThreadCountersHealthStatusCriteria;
import kafka.availability.ThreadCountersHealthStatusCriteria$;
import kafka.availability.Unhealthy$;
import kafka.common.ControlledShutdownRequestReason;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.KafkaScheduler;
import kafka.utils.ShutdownableThread;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WeakHashMap;
import scala.collection.mutable.WeakHashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=g\u0001B A\u0001\u0015C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"Aq\u000e\u0001B\u0001B\u0003%\u0001\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003x\u0011\u0015Y\b\u0001\"\u0001}\u0011%\t)\u0001\u0001a\u0001\n\u0003\t9\u0001C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0002\u0012!A\u0011q\u0003\u0001!B\u0013\tI\u0001C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0001\u0002$!I\u00111\u0006\u0001A\u0002\u0013\u0005\u0011Q\u0006\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u0002&!I\u0011Q\u0007\u0001A\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003s\u0001\u0001\u0019!C\u0001\u0003wAq!a\u0010\u0001A\u0003&1\u000fC\u0005\u0002D\u0001\u0001\r\u0011\"\u0001\u0002F!I\u0011q\t\u0001A\u0002\u0013\u0005\u0011\u0011\n\u0005\b\u0003\u001b\u0002\u0001\u0015)\u0003x\u0011%\t\t\u0006\u0001a\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\f\u0002\u0001\r\u0011\"\u0001\u0002\u000e\"A\u0011\u0011\u0013\u0001!B\u0013\t)\u0006C\u0005\u0002\u0014\u0002\u0001\r\u0011\"\u0003\u0002\b!I\u0011Q\u0013\u0001A\u0002\u0013%\u0011q\u0013\u0005\t\u00037\u0003\u0001\u0015)\u0003\u0002\n!I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\n\u0003O\u0003\u0001\u0019!C\u0005\u0003SC\u0001\"!,\u0001A\u0003&\u0011\u0011\u0015\u0005\n\u0003_\u0003\u0001\u0019!C\u0005\u0003?C\u0011\"!-\u0001\u0001\u0004%I!a-\t\u0011\u0005]\u0006\u0001)Q\u0005\u0003CC\u0011\"!/\u0001\u0005\u0004%I!a/\t\u0011\u0005e\b\u0001)A\u0005\u0003{C\u0011\"a?\u0001\u0005\u0004%I!!@\t\u0011\t\u0015\u0001\u0001)A\u0005\u0003\u007fD\u0011Ba\u0002\u0001\u0001\u0004%I!a(\t\u0013\t%\u0001\u00011A\u0005\n\t-\u0001\u0002\u0003B\b\u0001\u0001\u0006K!!)\t\u0013\tE\u0001\u00011A\u0005\n\u0005}\u0005\"\u0003B\n\u0001\u0001\u0007I\u0011\u0002B\u000b\u0011!\u0011I\u0002\u0001Q!\n\u0005\u0005\u0006\"\u0003B\u000e\u0001\u0001\u0007I\u0011BAP\u0011%\u0011i\u0002\u0001a\u0001\n\u0013\u0011y\u0002\u0003\u0005\u0003$\u0001\u0001\u000b\u0015BAQ\u0011\u001d\u0011)\u0003\u0001C\u0001\u0003oAqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u0003,\u0001!\tE!\u000b\t\u0013\t5\u0002A1A\u0005\n\t=\u0002\u0002\u0003B\u001c\u0001\u0001\u0006IA!\r\t\u000f\te\u0002\u0001\"\u0001\u0003<!9!Q\t\u0001\u0005\u0002\t%\u0002b\u0002B$\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0005\u0013\u0002A\u0011\tB\u0015\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u001bBqA!\u001c\u0001\t\u0003\u0011y\u0007C\u0004\u0003x\u0001!\tE!\u000b\t\u000f\te\u0004\u0001\"\u0011\u0003|!9!Q\u0013\u0001\u0005B\t]\u0005b\u0002BR\u0001\u0011\u0005#QU\u0004\b\u0005[\u0003\u0005\u0012\u0001BX\r\u0019y\u0004\t#\u0001\u00032\"11p\u000fC\u0001\u0005sC\u0011Ba/<\u0005\u0004%\tA!0\t\u0011\t57\b)A\u0005\u0005\u007f\u00131C\u0011:pW\u0016\u0014\b*Z1mi\"l\u0015M\\1hKJT!!\u0011\"\u0002\u0019\u00054\u0018-\u001b7bE&d\u0017\u000e^=\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\r2\u0013\u0006CA$K\u001b\u0005A%BA%C\u0003\u0015)H/\u001b7t\u0013\tY\u0005J\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007CA'Q\u001b\u0005q%BA(C\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011K\u0014\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0011\u0005M3V\"\u0001+\u000b\u0005U\u0013\u0015aB7fiJL7m]\u0005\u0003/R\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003Y\u0019wN\u001c;s_2dW\rZ*ikR$wn\u001e8I_>\\\u0007\u0003\u0002.^?\u0016l\u0011a\u0017\u0006\u00029\u0006)1oY1mC&\u0011al\u0017\u0002\n\rVt7\r^5p]F\u0002\"\u0001Y2\u000e\u0003\u0005T!A\u0019\"\u0002\r\r|W.\\8o\u0013\t!\u0017MA\u0010D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t'+Z9vKN$(+Z1t_:\u0004\"A\u00174\n\u0005\u001d\\&\u0001B+oSR\f\u0001B_6DY&,g\u000e\u001e\t\u0003U6l\u0011a\u001b\u0006\u0003Y\n\u000b!A_6\n\u00059\\'!D&bM.\f'l[\"mS\u0016tG/\u0001\njg\u0006\u001bG/\u001b<f\u0007>tGO]8mY\u0016\u0014\bc\u0001.rg&\u0011!o\u0017\u0002\n\rVt7\r^5p]B\u0002\"A\u0017;\n\u0005U\\&a\u0002\"p_2,\u0017M\\\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005aLX\"\u0001!\n\u0005i\u0004%!\u0007\"s_.,'\u000fS3bYRDW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fa\u0001P5oSRtDcB?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0003q\u0002AQ\u0001W\u0003A\u0002eCQ\u0001[\u0003A\u0002%DQa\\\u0003A\u0002ADQA^\u0003A\u0002]\fA\u0002^8uC2\u001c\u0016-\u001c9mKN,\"!!\u0003\u0011\u0007i\u000bY!C\u0002\u0002\u000em\u0013A\u0001T8oO\u0006\u0001Bo\u001c;bYN\u000bW\u000e\u001d7fg~#S-\u001d\u000b\u0004K\u0006M\u0001\"CA\u000b\u000f\u0005\u0005\t\u0019AA\u0005\u0003\rAH%M\u0001\u000ei>$\u0018\r\\*b[BdWm\u001d\u0011)\u0007!\tY\u0002E\u0002[\u0003;I1!a\b\\\u0005!1x\u000e\\1uS2,\u0017A\u00052s_.,'\u000fS3bYRD7\u000b^1ukN,\"!!\n\u0011\u0007a\f9#C\u0002\u0002*\u0001\u0013!C\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;vg\u00061\"M]8lKJDU-\u00197uQN#\u0018\r^;t?\u0012*\u0017\u000fF\u0002f\u0003_A\u0011\"!\u0006\u000b\u0003\u0003\u0005\r!!\n\u0002'\t\u0014xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d\u0011)\u0007-\tY\"A\njg6KG/[4bi&|g.\u00128bE2,G-F\u0001t\u0003]I7/T5uS\u001e\fG/[8o\u000b:\f'\r\\3e?\u0012*\u0017\u000fF\u0002f\u0003{A\u0001\"!\u0006\u000e\u0003\u0003\u0005\ra]\u0001\u0015SNl\u0015\u000e^5hCRLwN\\#oC\ndW\r\u001a\u0011)\u00079\tY\"\u0001\u0004d_:4\u0017nZ\u000b\u0002o\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0007\u0015\fY\u0005\u0003\u0005\u0002\u0016A\t\t\u00111\u0001x\u0003\u001d\u0019wN\u001c4jO\u0002B3!EA\u000e\u0003}\u0001(/\u001a<UQJ,\u0017\r\u001a'pG\u0006d7i\\;oi\u0016\u00148o\u00158baNDw\u000e^\u000b\u0003\u0003+\u0002\u0002\"a\u0016\u0002b\u0005\u0015\u0014\u0011O\u0007\u0003\u00033RA!a\u0017\u0002^\u0005!Q\u000f^5m\u0015\t\ty&\u0001\u0003kCZ\f\u0017\u0002BA2\u00033\u00121!T1q!\u0011\t9'!\u001c\u000e\u0005\u0005%$\u0002BA6\u0003;\nA\u0001\\1oO&!\u0011qNA5\u0005\u0019!\u0006N]3bIB1\u0011qKA:\u0003oJA!!\u001e\u0002Z\t!A*[:u!\u0011\tI(a\"\u000e\u0005\u0005m$bA!\u0002~)\u00191)a \u000b\t\u0005\u0005\u00151Q\u0001\nG>tg\r\\;f]RT!!!\"\u0002\u0005%|\u0017\u0002BAE\u0003w\u00121\u0003\u00165sK\u0006$Gj\\2bY\u000e{WO\u001c;feN\f1\u0005\u001d:fmRC'/Z1e\u0019>\u001c\u0017\r\\\"pk:$XM]:T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000fF\u0002f\u0003\u001fC\u0011\"!\u0006\u0014\u0003\u0003\u0005\r!!\u0016\u0002AA\u0014XM\u001e+ie\u0016\fG\rT8dC2\u001cu.\u001e8uKJ\u001c8K\\1qg\"|G\u000fI\u0001\u001baJ,gOT;n\u0007>l\u0007\u000f\\3uK\u0012\u001cFo\u001c:bO\u0016|\u0005o]\u0001\u001faJ,gOT;n\u0007>l\u0007\u000f\\3uK\u0012\u001cFo\u001c:bO\u0016|\u0005o]0%KF$2!ZAM\u0011%\t)BFA\u0001\u0002\u0004\tI!A\u000eqe\u00164h*^7D_6\u0004H.\u001a;fIN#xN]1hK>\u00038\u000fI\u0001\u001bG>tG/[4v_V\u001cXK\u001c5fC2$\b._*b[BdWm]\u000b\u0003\u0003C\u00032AWAR\u0013\r\t)k\u0017\u0002\u0004\u0013:$\u0018AH2p]RLw-^8vgVs\u0007.Z1mi\"L8+Y7qY\u0016\u001cx\fJ3r)\r)\u00171\u0016\u0005\n\u0003+I\u0012\u0011!a\u0001\u0003C\u000b1dY8oi&<Wo\\;t+:DW-\u00197uQf\u001c\u0016-\u001c9mKN\u0004\u0013\u0001G2p]RLw-^8vg\"+\u0017\r\u001c;isN\u000bW\u000e\u001d7fg\u0006a2m\u001c8uS\u001e,x.^:IK\u0006dG\u000f[=TC6\u0004H.Z:`I\u0015\fHcA3\u00026\"I\u0011Q\u0003\u000f\u0002\u0002\u0003\u0007\u0011\u0011U\u0001\u001aG>tG/[4v_V\u001c\b*Z1mi\"L8+Y7qY\u0016\u001c\b%\u0001\u001auQJ,\u0017\rZ*uk\u000e\\7+Y7qY\u0016\u001c()_\"p[B|g.\u001a8u)f\u0004XMQ=UQJ,\u0017\rZ$s_V\u0004H+\u001f9f+\t\ti\f\u0005\u0005\u0002@\u0006%\u00171ZAx\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000f\\\u0016AC2pY2,7\r^5p]&!\u00111MAa!\u0011\ti-!;\u000f\t\u0005=\u0017Q\u001d\b\u0005\u0003#\f\u0019O\u0004\u0003\u0002T\u0006\u0005h\u0002BAk\u0003?tA!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0004\u00037$\u0015A\u0002\u001fs_>$h(\u0003\u0002\u0002\u0006&!\u0011\u0011QAB\u0013\r\u0019\u0015qP\u0005\u0004\u0003\u0006u\u0014\u0002BAt\u0003w\n1\u0003\u00165sK\u0006$Gj\\2bY\u000e{WO\u001c;feNLA!a;\u0002n\nyA\u000b\u001b:fC\u0012<%o\\;q)f\u0004XM\u0003\u0003\u0002h\u0006m\u0004\u0003CA`\u0003\u0013\f\t0a>\u0011\t\u00055\u00171_\u0005\u0005\u0003k\fiOA\nNKR\u0014\u0018nY\"p[B|g.\u001a8u)f\u0004X\r\u0005\u0005\u0002@\u0006%\u0017QMA\u0005\u0003M\"\bN]3bIN#XoY6TC6\u0004H.Z:Cs\u000e{W\u000e]8oK:$H+\u001f9f\u0005f$\u0006N]3bI\u001e\u0013x.\u001e9UsB,\u0007%\u0001\u000fv]\",\u0017\r\u001c;isN#xN]1hKN\u000bW\u000e\u001d7f/&tGm\\<\u0016\u0005\u0005}\bc\u0001=\u0003\u0002%\u0019!1\u0001!\u0003'!+\u0017\r\u001c;i'\u0006l\u0007\u000f\\3t/&tGm\\<\u0002;Ut\u0007.Z1mi\"L8\u000b^8sC\u001e,7+Y7qY\u0016<\u0016N\u001c3po\u0002\n\u0001fY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t\u000b:<\u0017N\\3UQJ,\u0017\rZ$s_V\u00048o\u0015;vG.\fAfY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t\u000b:<\u0017N\\3UQJ,\u0017\rZ$s_V\u00048o\u0015;vG.|F%Z9\u0015\u0007\u0015\u0014i\u0001C\u0005\u0002\u0016\r\n\t\u00111\u0001\u0002\"\u0006I3m\u001c8uS\u001e,x.^:TC6\u0004H.Z:F]\u001eLg.\u001a+ie\u0016\fGm\u0012:pkB\u001c8\u000b^;dW\u0002\n\u0011fY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t'R|'/Y4f)\"\u0014X-\u00193He>,\bo]*uk\u000e\\\u0017!L2p]RLw-^8vgN\u000bW\u000e\u001d7fgN#xN]1hKRC'/Z1e\u000fJ|W\u000f]:TiV\u001c7n\u0018\u0013fcR\u0019QMa\u0006\t\u0013\u0005Ua%!AA\u0002\u0005\u0005\u0016AK2p]RLw-^8vgN\u000bW\u000e\u001d7fgN#xN]1hKRC'/Z1e\u000fJ|W\u000f]:TiV\u001c7\u000eI\u0001/G>tG/[4v_V\u001c8+Y7qY\u0016\u001chj\\*u_J\fw-\u001a+ie\u0016\fG-T1lS:<\u0007K]8he\u0016\u001c8/\u0001\u001ad_:$\u0018nZ;pkN\u001c\u0016-\u001c9mKNtun\u0015;pe\u0006<W\r\u00165sK\u0006$W*Y6j]\u001e\u0004&o\\4sKN\u001cx\fJ3r)\r)'\u0011\u0005\u0005\n\u0003+I\u0013\u0011!a\u0001\u0003C\u000bqfY8oi&<Wo\\;t'\u0006l\u0007\u000f\\3t\u001d>\u001cFo\u001c:bO\u0016$\u0006N]3bI6\u000b7.\u001b8h!J|wM]3tg\u0002\n\u0011\"[:IK\u0006dG\u000f[=\u0002\u001bI,Wn\u001c<f\u001b\u0016$(/[2t)\u0005)\u0017\u0001C:ikR$wn\u001e8\u0002+!\f'\u000fZ*ikR$wn\u001e8TG\",G-\u001e7feV\u0011!\u0011\u0007\t\u0004\u000f\nM\u0012b\u0001B\u001b\u0011\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u00065be\u0012\u001c\u0006.\u001e;e_^t7k\u00195fIVdWM\u001d\u0011\u0002\u000f%\u001c8\u000b^;dWR)1O!\u0010\u0003B!9!q\b\u0019A\u0002\u0005\u0015\u0014A\u0002;ie\u0016\fG\rC\u0004\u0003DA\u0002\r!a\u001e\u0002\u0019\r,(O]\"pk:$XM]:\u0002\u001f1|wm\u0015;vG.$\u0006N]3bIN\f\u0011#[:Ce>\\WM]+oQ\u0016\fG\u000e\u001e5z\u0003\u0019!wnV8sW\u0006\u00012\u000f^1ukN$&/\u00198tSRLwN\u001c\u000b\bK\n=#1\u000bB,\u0011\u001d\u0011\t\u0006\u000ea\u0001\u0003K\t1cY;se\u0016tG\u000fS3bYRD7\u000b^1ukNDqA!\u00165\u0001\u0004\t)#A\boK^DU-\u00197uQN#\u0018\r^;t\u0011\u001d\u0011I\u0006\u000ea\u0001\u00057\nqa]1na2,7\u000f\u0005\u0004\u0003^\t\u001d\u0014\u0011\u0015\b\u0005\u0005?\u0012\u0019G\u0004\u0003\u0002X\n\u0005\u0014\"\u0001/\n\u0007\t\u00154,A\u0004qC\u000e\\\u0017mZ3\n\t\t%$1\u000e\u0002\t\u0013R,'/\u00192mK*\u0019!QM.\u000271|wM\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;vg\u000eC\u0017M\\4f)\u001d)'\u0011\u000fB:\u0005kBqA!\u00156\u0001\u0004\t)\u0003C\u0004\u0003VU\u0002\r!!\n\t\u000f\teS\u00071\u0001\u0003\\\u0005\u0019!/\u001e8\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!Q\u0010\t\u0007\u0005\u007f\u0012\tI!\"\u000e\u0005\u0005\u0015\u0017\u0002\u0002BB\u0003\u000b\u00141aU3u!\u0011\u00119Ia$\u000f\t\t%%1\u0012\t\u0004\u0003/\\\u0016b\u0001BG7\u00061\u0001K]3eK\u001aLAA!%\u0003\u0014\n11\u000b\u001e:j]\u001eT1A!$\\\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000eF\u0002f\u00053CqAa'9\u0001\u0004\u0011i*A\u0005oK^\u001cuN\u001c4jOB\u0019QJa(\n\u0007\t\u0005fJA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$R!\u001aBT\u0005WCqA!+:\u0001\u0004\u0011i*A\u0005pY\u0012\u001cuN\u001c4jO\"9!1T\u001dA\u0002\tu\u0015a\u0005\"s_.,'\u000fS3bYRDW*\u00198bO\u0016\u0014\bC\u0001=<'\rY$1\u0017\t\u00045\nU\u0016b\u0001B\\7\n1\u0011I\\=SK\u001a$\"Aa,\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!q\u0018\t\u0007\u0005\u0003\u00149M!3\u000e\u0005\t\r'\u0002\u0002Bc\u0003\u000b\f\u0011\"[7nkR\f'\r\\3\n\t\t\r%1\u0019\t\u0005\u0003O\u0012Y-\u0003\u0003\u0003\u0012\u0006%\u0014A\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011")
public class BrokerHealthManager
extends ShutdownableThread
implements BrokerReconfigurable,
KafkaMetricsGroup {
    private final Function1<ControlledShutdownRequestReason, BoxedUnit> controlledShutdownHook;
    private final KafkaZkClient zkClient;
    private final Function0<Object> isActiveController;
    private volatile long totalSamples;
    private volatile BrokerHealthStatus brokerHealthStatus;
    private volatile boolean isMitigationEnabled;
    private volatile BrokerHealthManagerConfig config;
    private java.util.Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot;
    private long prevNumCompletedStorageOps;
    private int contiguousUnhealthySamples;
    private int contiguousHealthySamples;
    private final scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType;
    private final HealthSamplesWindow unhealthyStorageSampleWindow;
    private int contiguousSamplesEngineThreadGroupsStuck;
    private int contiguousSamplesStorageThreadGroupsStuck;
    private int contiguousSamplesNoStorageThreadMakingProgress;
    private final KafkaScheduler hardShutdownScheduler;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$(this, metricName, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$(this, metricName);
    }

    public long totalSamples() {
        return this.totalSamples;
    }

    public void totalSamples_$eq(long x$1) {
        this.totalSamples = x$1;
    }

    public BrokerHealthStatus brokerHealthStatus() {
        return this.brokerHealthStatus;
    }

    public void brokerHealthStatus_$eq(BrokerHealthStatus x$1) {
        this.brokerHealthStatus = x$1;
    }

    public boolean isMitigationEnabled() {
        return this.isMitigationEnabled;
    }

    public void isMitigationEnabled_$eq(boolean x$1) {
        this.isMitigationEnabled = x$1;
    }

    public BrokerHealthManagerConfig config() {
        return this.config;
    }

    public void config_$eq(BrokerHealthManagerConfig x$1) {
        this.config = x$1;
    }

    public java.util.Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot() {
        return this.prevThreadLocalCountersSnapshot;
    }

    public void prevThreadLocalCountersSnapshot_$eq(java.util.Map<Thread, List<ThreadLocalCounters>> x$1) {
        this.prevThreadLocalCountersSnapshot = x$1;
    }

    private long prevNumCompletedStorageOps() {
        return this.prevNumCompletedStorageOps;
    }

    private void prevNumCompletedStorageOps_$eq(long x$1) {
        this.prevNumCompletedStorageOps = x$1;
    }

    private int contiguousUnhealthySamples() {
        return this.contiguousUnhealthySamples;
    }

    private void contiguousUnhealthySamples_$eq(int x$1) {
        this.contiguousUnhealthySamples = x$1;
    }

    private int contiguousHealthySamples() {
        return this.contiguousHealthySamples;
    }

    private void contiguousHealthySamples_$eq(int x$1) {
        this.contiguousHealthySamples = x$1;
    }

    private scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType() {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType;
    }

    private HealthSamplesWindow unhealthyStorageSampleWindow() {
        return this.unhealthyStorageSampleWindow;
    }

    private int contiguousSamplesEngineThreadGroupsStuck() {
        return this.contiguousSamplesEngineThreadGroupsStuck;
    }

    private void contiguousSamplesEngineThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesEngineThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesStorageThreadGroupsStuck() {
        return this.contiguousSamplesStorageThreadGroupsStuck;
    }

    private void contiguousSamplesStorageThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesStorageThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesNoStorageThreadMakingProgress() {
        return this.contiguousSamplesNoStorageThreadMakingProgress;
    }

    private void contiguousSamplesNoStorageThreadMakingProgress_$eq(int x$1) {
        this.contiguousSamplesNoStorageThreadMakingProgress = x$1;
    }

    public boolean isHealthy() {
        block3: {
            block2: {
                if (!this.isMitigationEnabled()) break block2;
                BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
                Healthy$ healthy$ = Healthy$.MODULE$;
                if (brokerHealthStatus == null || !brokerHealthStatus.equals(healthy$)) break block3;
            }
            return true;
        }
        return false;
    }

    public void removeMetrics() {
        this.removeMetric("ContiguousUnhealthySamples", this.removeMetric$default$2());
        this.removeMetric("ContiguousSamplesEngineThreadGroupsStuck", this.removeMetric$default$2());
        this.removeMetric("ContiguousSamplesStorageThreadGroupsStuck", this.removeMetric$default$2());
        this.removeMetric("ContiguousSamplesNoStorageThreadMakingProgress", this.removeMetric$default$2());
        this.removeMetric("UnhealthinessCount", this.removeMetric$default$2());
    }

    @Override
    public void shutdown() {
        this.removeMetrics();
        super.shutdown();
    }

    private KafkaScheduler hardShutdownScheduler() {
        return this.hardShutdownScheduler;
    }

    public boolean isStuck(Thread thread, ThreadLocalCounters currCounters) {
        return this.isPrevCountersPresent$1() && this.isThreadStuck$1(thread, currCounters);
    }

    public void logStuckThreads() {
        this.threadStuckSamplesByComponentTypeByThreadGroupType().foreach((Function1 & Serializable)x0$1 -> {
            BrokerHealthManager.$anonfun$logStuckThreads$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isBrokerUnhealthy() {
        java.util.Map currentThreadLocalCounterSnapshotForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        LongRef currNumCompletedStorageOps = LongRef.create((long)0L);
        currentThreadLocalCounterSnapshotForAllThreads.forEach((thread, threadLocalCountersList) -> threadLocalCountersList.forEach(threadLocalCounters -> {
            boolean isThreadStuck = this.isStuck((Thread)thread, (ThreadLocalCounters)threadLocalCounters);
            ThreadLocalCounters.MetricComponentType metricComponentType = threadLocalCounters.metricComponentType;
            ThreadLocalCounters.MetricComponentType metricComponentType2 = ThreadLocalCounters.MetricComponentType.STORAGE;
            if (!(metricComponentType != null ? !metricComponentType.equals(metricComponentType2) : metricComponentType2 != null)) {
                currNumCompletedStorageOps$1.elem += threadLocalCounters.numSuccessOps + threadLocalCounters.numFailedOps;
            }
            scala.collection.mutable.Map threadToNumStuckSamplesMap = (scala.collection.mutable.Map)((scala.collection.mutable.Map)this.threadStuckSamplesByComponentTypeByThreadGroupType().getOrElseUpdate((Object)threadLocalCounters.threadGroupType, (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))).getOrElseUpdate((Object)threadLocalCounters.metricComponentType, (Function0 & Serializable)() -> (WeakHashMap)WeakHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            long stuckCount = BoxesRunTime.unboxToLong((Object)threadToNumStuckSamplesMap.getOrElseUpdate(thread, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            if (isThreadStuck) {
                threadToNumStuckSamplesMap.update(thread, (Object)BoxesRunTime.boxToLong((long)(stuckCount + 1L)));
                return;
            }
            threadToNumStuckSamplesMap.update(thread, (Object)BoxesRunTime.boxToLong((long)0L));
        }));
        this.prevThreadLocalCountersSnapshot_$eq(currentThreadLocalCounterSnapshotForAllThreads);
        boolean engineThreadsStuck = this.isThreadGroupStuck$1(this.config().engineThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.ENGINE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean storageThreadsStuck = this.isThreadGroupStuck$1(this.config().storageThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.STORAGE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean noStorageThreadMakingProgress = this.prevNumCompletedStorageOps() == currNumCompletedStorageOps.elem;
        this.prevNumCompletedStorageOps_$eq(currNumCompletedStorageOps.elem);
        if (engineThreadsStuck) {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(this.contiguousSamplesEngineThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(0);
        }
        if (storageThreadsStuck) {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(this.contiguousSamplesStorageThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(0);
        }
        if (noStorageThreadMakingProgress) {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(this.contiguousSamplesNoStorageThreadMakingProgress() + 1);
        } else {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(0);
        }
        return engineThreadsStuck && storageThreadsStuck && noStorageThreadMakingProgress;
    }

    @Override
    public void doWork() {
        this.pause(this.config().brokerHealthManagerSampleDurationMs(), TimeUnit.MILLISECONDS);
        this.totalSamples_$eq(this.totalSamples() + 1L);
        int isSampleUnhealthy = 0;
        if (this.isBrokerUnhealthy()) {
            isSampleUnhealthy = 1;
            this.contiguousUnhealthySamples_$eq(this.contiguousUnhealthySamples() + 1);
            this.contiguousHealthySamples_$eq(0);
        } else {
            this.contiguousUnhealthySamples_$eq(0);
            this.contiguousHealthySamples_$eq(this.contiguousHealthySamples() + 1);
        }
        BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        if (brokerHealthStatus != null && brokerHealthStatus.equals(healthy$)) {
            this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
            int numOfSamplesBeforeSuspect = this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect();
            this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSamplesBeforeSuspect);
            if (this.unhealthyStorageSampleWindow().size() == numOfSamplesBeforeSuspect && this.unhealthyStorageSampleWindow().countedSamples() * 100 / this.unhealthyStorageSampleWindow().size() >= this.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition()) {
                this.statusTransition(Healthy$.MODULE$, Suspect$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
            }
        } else {
            BrokerHealthStatus brokerHealthStatus2 = this.brokerHealthStatus();
            Suspect$ suspect$ = Suspect$.MODULE$;
            if (brokerHealthStatus2 != null && brokerHealthStatus2.equals(suspect$)) {
                int numOfSampleBeforeUnhealthy = this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy();
                this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
                this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSampleBeforeUnhealthy);
                int minUnhealthySamples = numOfSampleBeforeUnhealthy * this.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() / 100;
                int minHealthySamples = numOfSampleBeforeUnhealthy - minUnhealthySamples;
                if (this.unhealthyStorageSampleWindow().size() - this.unhealthyStorageSampleWindow().countedSamples() > minHealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Healthy$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
                } else if (this.unhealthyStorageSampleWindow().countedSamples() >= minUnhealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Unhealthy$.MODULE$, (Iterable<Object>)this.unhealthyStorageSampleWindow().samples());
                }
            }
        }
        BrokerHealthStatus brokerHealthStatus3 = this.brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        if (brokerHealthStatus3 == null) {
            return;
        }
        if (brokerHealthStatus3.equals(unhealthy$)) {
            if (this.isMitigationEnabled()) {
                this.hardShutdownScheduler().startup();
                this.hardShutdownScheduler().schedule("Hard-Kill-Broker", (Function0<BoxedUnit>)(Function0 & Serializable)() -> Exit$.MODULE$.halt(1, (Option<String>)None$.MODULE$), this.config().brokerHealthManagerHardKillDurationMs(), this.hardShutdownScheduler().schedule$default$4(), this.hardShutdownScheduler().schedule$default$5());
                this.logStuckThreads();
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(205).append("[BrokerHealth] Broker has remained unhealthy for ").append(this.config().brokerHealthManagerSampleDurationMs() * this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy()).append(" ms. ").append("(1) Calling controlled shutdown to move leadership away if not controller. (2) Killing the ZK Connection. (3) Then will exit. Is the node controller - ").append($this.isActiveController.apply$mcZ$sp()).toString());
                if (!this.isActiveController.apply$mcZ$sp()) {
                    this.controlledShutdownHook.apply((Object)ControlledShutdownRequestReason.UNHEALTHY);
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.zkClient.close(), this, Level.ERROR);
                this.hardShutdownScheduler().shutdown();
                throw Exit$.MODULE$.halt(1, (Option<String>)None$.MODULE$);
            }
            if (this.contiguousHealthySamples() > this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
                Queue healthySamples = (Queue)Queue$.MODULE$.fill(this.contiguousHealthySamples(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
                this.statusTransition(Unhealthy$.MODULE$, Healthy$.MODULE$, (Iterable<Object>)healthySamples);
                return;
            }
            return;
        }
    }

    public void statusTransition(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        this.brokerHealthStatus_$eq(newHealthStatus);
        this.logBrokerHealthStatusChange(currentHealthStatus, newHealthStatus, samples);
        this.unhealthyStorageSampleWindow().reset();
    }

    public void logBrokerHealthStatusChange(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        if (!this.isMitigationEnabled()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("[BrokerHealth] Broker health status changed. Previous Health Status: ").append(currentHealthStatus).append(" New Health Status: ").append(newHealthStatus).append(" Unhealthy Samples: ").append(samples).toString());
            this.logStuckThreads();
            return;
        }
    }

    @Override
    public void run() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        super.run();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerEngineRequestHandlerThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Engine Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerStorageRequestHandlerThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Storage Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerStorageBackgroundThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Storage Background Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (ThreadCountersHealthStatusCriteria$.MODULE$.fromString(newConfig.confluentConfig().brokerHealthManagerStorageNetworkThreadsStuckCriteria()).isEmpty()) {
            throw new ConfigException("Storage Network Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(BrokerHealthManagerConfig$.MODULE$.apply(newConfig));
        this.isMitigationEnabled_$eq(this.config().isBrokerHealthManagerMitigationEnabled());
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$1() {
        return this.contiguousUnhealthySamples();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$2() {
        return this.contiguousSamplesEngineThreadGroupsStuck();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$3() {
        return this.contiguousSamplesStorageThreadGroupsStuck();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$4() {
        return this.contiguousSamplesNoStorageThreadMakingProgress();
    }

    public final /* synthetic */ int kafka$availability$BrokerHealthManager$$$anonfun$new$5() {
        return this.unhealthyStorageSampleWindow().countedSamples();
    }

    private final boolean isPrevCountersPresent$1() {
        return this.prevThreadLocalCountersSnapshot() != null;
    }

    private final boolean isThreadStuck$1(Thread thread$1, ThreadLocalCounters currCounters$1) {
        ObjectRef prevCounters = ObjectRef.create(null);
        ((java.lang.Iterable)this.prevThreadLocalCountersSnapshot().getOrDefault(thread$1, new ArrayList())).forEach(threadLocalCounters -> {
            block7: {
                block6: {
                    ThreadLocalCounters.MetricComponentType metricComponentType;
                    ThreadLocalCounters.MetricComponentType metricComponentType2;
                    block5: {
                        metricComponentType2 = threadLocalCounters.metricComponentType;
                        metricComponentType = currCounters$1.metricComponentType;
                        if (metricComponentType2 != null) break block5;
                        if (metricComponentType != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!metricComponentType2.equals(metricComponentType)) break block7;
                }
                prevCounters$1.elem = threadLocalCounters;
                return;
            }
        });
        if ((ThreadLocalCounters)prevCounters.elem != null) {
            return currCounters$1.numSuccessOps + currCounters$1.numFailedOps == ((ThreadLocalCounters)prevCounters.elem).numSuccessOps + ((ThreadLocalCounters)prevCounters.elem).numFailedOps && currCounters$1.numInProgressOps == ((ThreadLocalCounters)prevCounters.elem).numInProgressOps && currCounters$1.numInProgressOps >= 1L;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$3(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, ThreadLocalCounters.MetricComponentType metricComponentType$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Thread thread = (Thread)x0$3._1();
            long numStuckSamples = x0$3._2$mcJ$sp();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(121).append("[BrokerHealthManager] Broker has stuck threads. Thread Group type stuck = ").append(threadGroupType$1).append(" Component type = ").append(metricComponentType$1).append(" Thread = ").append(thread.getName()).append(" num stuck samples ").append(numStuckSamples).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$2(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            ThreadLocalCounters.MetricComponentType metricComponentType = (ThreadLocalCounters.MetricComponentType)x0$2._1();
            ((scala.collection.mutable.Map)x0$2._2()).foreach((Function1 & Serializable)x0$3 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$3($this, threadGroupType$1, metricComponentType, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$1(BrokerHealthManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ThreadLocalCounters.ThreadGroupType threadGroupType = (ThreadLocalCounters.ThreadGroupType)x0$1._1();
            ((scala.collection.mutable.Map)x0$1._2()).foreach((Function1 & Serializable)x0$2 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$2($this, threadGroupType, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$8(ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, boolean x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (x1$1 != null) {
            long numStuckSamples = x1$1._2$mcJ$sp();
            if (AnyThreadStuck$.MODULE$.equals(countersHealthStatusCriteria$1)) {
                return x0$1 || numStuckSamples > 0L;
            }
            if (AllThreadsStuck$.MODULE$.equals(countersHealthStatusCriteria$1)) {
                return x0$1 && numStuckSamples > 0L;
            }
            return x0$1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$7(boolean initialValue$1, ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadToNumStuckSamples) {
        return BoxesRunTime.unboxToBoolean((Object)threadToNumStuckSamples.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)initialValue$1), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$8(countersHealthStatusCriteria$1, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$6(ThreadLocalCounters.MetricComponentType componentType$1, boolean initialValue$1, ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadGroup) {
        return threadGroup.get((Object)componentType$1).exists((Function1 & Serializable)threadToNumStuckSamples -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$7(initialValue$1, countersHealthStatusCriteria$1, threadToNumStuckSamples)));
    }

    private final boolean isThreadGroupStuckAccordingToCriteria$1(boolean initialValue, ThreadLocalCounters.ThreadGroupType threadGroupType, ThreadLocalCounters.MetricComponentType componentType, ThreadCountersHealthStatusCriteria countersHealthStatusCriteria) {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType().get((Object)threadGroupType).exists((Function1 & Serializable)threadGroup -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$6(componentType, initialValue, countersHealthStatusCriteria, threadGroup)));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$9(BrokerHealthManager $this, HealthStatusAggregationOperator healthStatusAggregationOperator$1, ThreadLocalCounters.MetricComponentType componentType$2, boolean x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (x1$1 != null) {
            ThreadCountersHealthStatusCriteria criteria;
            ThreadLocalCounters.ThreadGroupType groupType = (ThreadLocalCounters.ThreadGroupType)x1$1._1();
            ThreadCountersHealthStatusCriteria threadCountersHealthStatusCriteria = criteria = (ThreadCountersHealthStatusCriteria)x1$1._2();
            AllThreadsStuck$ allThreadsStuck$ = AllThreadsStuck$.MODULE$;
            boolean initialValue = threadCountersHealthStatusCriteria != null && threadCountersHealthStatusCriteria.equals(allThreadsStuck$);
            HealthStatusAggregationOperator healthStatusAggregationOperator = healthStatusAggregationOperator$1;
            HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
            if (healthStatusAggregationOperator != null && healthStatusAggregationOperator.equals(healthStatusAggregationOperator_And$)) {
                return x0$1 && $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
            }
            HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator$1;
            HealthStatusAggregationOperator_Or$ healthStatusAggregationOperator_Or$ = HealthStatusAggregationOperator_Or$.MODULE$;
            if (healthStatusAggregationOperator2 != null && healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_Or$)) {
                return x0$1 || $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
            }
            return false;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isThreadGroupStuck$1(scala.collection.immutable.Map threadStatusCriteria, ThreadLocalCounters.MetricComponentType componentType, HealthStatusAggregationOperator healthStatusAggregationOperator) {
        boolean threadGroupStuckInitialValue;
        HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator;
        HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
        boolean bl = threadGroupStuckInitialValue = healthStatusAggregationOperator2 != null && healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_And$);
        return threadStatusCriteria.nonEmpty() && BoxesRunTime.unboxToBoolean((Object)threadStatusCriteria.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)threadGroupStuckInitialValue), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManager.$anonfun$isBrokerUnhealthy$9(this, healthStatusAggregationOperator, componentType, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
    }

    public BrokerHealthManager(Function1<ControlledShutdownRequestReason, BoxedUnit> controlledShutdownHook, KafkaZkClient zkClient, Function0<Object> isActiveController, BrokerHealthManagerConfig initialConfig) {
        this.controlledShutdownHook = controlledShutdownHook;
        this.zkClient = zkClient;
        this.isActiveController = isActiveController;
        super("BrokerHealthManager", true);
        this.totalSamples = 0L;
        this.brokerHealthStatus = Healthy$.MODULE$;
        this.isMitigationEnabled = initialConfig.isBrokerHealthManagerMitigationEnabled();
        this.config = initialConfig;
        this.prevThreadLocalCountersSnapshot = null;
        this.prevNumCompletedStorageOps = 0L;
        this.contiguousUnhealthySamples = 0;
        this.contiguousHealthySamples = 0;
        this.threadStuckSamplesByComponentTypeByThreadGroupType = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.unhealthyStorageSampleWindow = new HealthSamplesWindow();
        this.contiguousSamplesEngineThreadGroupsStuck = 0;
        this.contiguousSamplesStorageThreadGroupsStuck = 0;
        this.contiguousSamplesNoStorageThreadMakingProgress = 0;
        this.newGauge("ContiguousUnhealthySamples", new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("ContiguousSamplesEngineThreadGroupsStuck", new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("ContiguousSamplesStorageThreadGroupsStuck", new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("ContiguousSamplesNoStorageThreadMakingProgress", new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("UnhealthinessCount", new Gauge<Object>(this){
            private final /* synthetic */ BrokerHealthManager $outer;

            public final int value() {
                return this.$outer.kafka$availability$BrokerHealthManager$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.hardShutdownScheduler = new KafkaScheduler(1, "kafka-scheduler-", true, false);
    }
}

