/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kafka.catalog.LocalStore;
import kafka.common.TenantHelpers;

public class InMemoryLocalStore
implements LocalStore {
    private final Map<String, MetadataEvent> topicMetadataEvents = new ConcurrentHashMap<String, MetadataEvent>();
    private final Map<String, Set<String>> logicalClusterToTopics = new ConcurrentHashMap<String, Set<String>>();

    @Override
    public void addMetadataEvent(String logicalCluster, String topic, MetadataEvent metadataEvent) {
        this.verifyTopicAndLogicalCluster(logicalCluster, topic);
        this.topicMetadataEvents.put(topic, metadataEvent);
        this.logicalClusterToTopics.computeIfAbsent(logicalCluster, k -> new TreeSet()).add(topic);
    }

    @Override
    public Set<String> topics(String logicalCluster) {
        return this.logicalClusterToTopics.getOrDefault(logicalCluster, Collections.emptySet());
    }

    @Override
    public Set<String> logicalClusters() {
        return this.logicalClusterToTopics.keySet();
    }

    @Override
    public MetadataEvent metadataEvent(String topic) {
        return this.topicMetadataEvents.get(topic);
    }

    @Override
    public MetadataEvent removeMetadataEvent(String logicalCluster, String topic) {
        this.verifyTopicAndLogicalCluster(logicalCluster, topic);
        MetadataEvent toRemove = this.topicMetadataEvents.remove(topic);
        if (toRemove != null) {
            this.logicalClusterToTopics.get(logicalCluster).remove(topic);
            if (this.logicalClusterToTopics.get(logicalCluster).isEmpty()) {
                this.logicalClusterToTopics.remove(logicalCluster);
            }
        }
        return toRemove;
    }

    @Override
    public void clear() {
        this.topicMetadataEvents.clear();
        this.logicalClusterToTopics.clear();
    }

    @Override
    public int size() {
        return this.topicMetadataEvents.size();
    }

    private void verifyTopicAndLogicalCluster(String logicalCluster, String topic) {
        if (!TenantHelpers.isTenantPrefixed(topic)) {
            throw new IllegalArgumentException(String.format("Provided topic %s does not have tenant prefix.", topic));
        }
        if (!topic.startsWith(logicalCluster)) {
            throw new IllegalArgumentException(String.format("Provided topic %s doesn't belongs to logical cluster %s", topic, logicalCluster));
        }
    }
}

