/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kafka.catalog.TopicMetadataSnapshotCollector;
import kafka.utils.Scheduler;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageListener;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.slf4j.Logger;
import scala.Function0;
import scala.runtime.AbstractFunction0;
import scala.runtime.BoxedUnit;

public class KRaftTopicMetadataCollector
implements MetadataImageListener,
TopicMetadataSnapshotCollector {
    private final Logger log;
    private final int snapshotInitDelay;
    private final int snapshotInterval;
    private final int maxTopicsInSnapshot;
    private final String destTopic;
    private final int nodeId;
    private final AtomicReference<MetadataImage> latestImage;
    private final AtomicBoolean isActive;
    private Scheduler snapshotScheduler;

    public KRaftTopicMetadataCollector(int snapshotInitDelay, int snapshotInterval, int maxTopicsInSnapshot, String destTopic, int nodeId) {
        this.snapshotInitDelay = snapshotInitDelay;
        this.snapshotInterval = snapshotInterval;
        this.maxTopicsInSnapshot = maxTopicsInSnapshot;
        this.destTopic = destTopic;
        this.nodeId = nodeId;
        this.latestImage = new AtomicReference<Object>(null);
        this.isActive = new AtomicBoolean(false);
        this.log = new LogContext("[KRaftTopicMedataCollector id=" + nodeId + "]").logger(this.getClass());
        this.log.debug("Constructed, snapshot init delay {}s, interval {}s", (Object)snapshotInitDelay, (Object)snapshotInterval);
    }

    public void start() {
        if (this.snapshotScheduler != null) {
            throw new IllegalStateException("Cannot start a topic metadata collector multiple times");
        }
        this.snapshotScheduler = this.registerSnapshotTask(this.snapshotInitDelay, this.snapshotInterval);
    }

    public void stop() {
        this.deregisterSnapshotTask(this.snapshotScheduler);
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public void onLeaderUpdate(LeaderAndEpoch leader) {
        if (leader.leaderId().equals(OptionalInt.of(this.nodeId))) {
            this.isActive.set(true);
            this.log.debug("MetadataCollector is active");
        } else if (this.isActive.compareAndSet(true, false)) {
            this.log.debug("MetadataCollector is no longer active");
        }
    }

    public void onMetadataImageUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage) {
        this.latestImage.set(newMetadataImage);
    }

    @Override
    public Function0<BoxedUnit> emitMetadataSnapshot() {
        return new AbstractFunction0<BoxedUnit>(){

            public BoxedUnit apply() {
                if (!KRaftTopicMetadataCollector.this.isActive.get()) {
                    return BoxedUnit.UNIT;
                }
                MetadataImage curImage = KRaftTopicMetadataCollector.this.latestImage.getAndSet(null);
                if (curImage != null && !curImage.isEmpty()) {
                    KRaftTopicMetadataCollector.this.log.debug("In scheduled snapshot function");
                }
                return BoxedUnit.UNIT;
            }
        };
    }
}

