/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import com.google.protobuf.Timestamp;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.OpType;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kafka.log.LogConfig;
import org.apache.kafka.common.Uuid;

public class MetadataEventUtils {
    public static final String TOPIC_SNAPSHOT = "TOPIC_SNAPSHOT";
    public static final String TOPIC_DELTA = "TOPIC_DELTA";
    public static final String CATALOG_TOPIC_METADATA_SUBJECT = "catalog-topic-metadata-exporter";

    public static MetadataEvent topicMetadataEventFromLogConfig(LogConfig logConfig, String topicName, Uuid topicId, int partitionCount, int replicationFactor, @Nullable Timestamp createTime, @Nullable Timestamp updateTime) {
        List cleanupPolicy;
        TopicMetadata.Builder topicMetadataBuilder = TopicMetadata.newBuilder();
        topicMetadataBuilder.setTopicId(topicId.toString()).setTopicName(topicName).setRetentionMs(logConfig.getLong(LogConfig.RetentionMsProp())).setRetentionBytes(logConfig.getLong(LogConfig.RetentionBytesProp())).setReplicationFactor(replicationFactor).setPartitionsCount(partitionCount).setKeySchemaValidation(logConfig.getBoolean(LogConfig.KeySchemaValidationEnableProp())).setValueSchemaValidation(logConfig.getBoolean(LogConfig.ValueSchemaValidationEnableProp()));
        if (createTime != null) {
            topicMetadataBuilder.setCreateTime(createTime);
        }
        if (updateTime != null) {
            topicMetadataBuilder.setUpdateTime(updateTime);
        }
        if ((cleanupPolicy = logConfig.getList(LogConfig.CleanupPolicyProp()).stream().map(String::toLowerCase).collect(Collectors.toList())).size() >= 2 && cleanupPolicy.contains(LogConfig.Compact()) && cleanupPolicy.contains(LogConfig.Delete())) {
            topicMetadataBuilder.setCleanupPolicy(TopicMetadata.CleanupPolicy.COMPACT_DELETE);
        } else if (cleanupPolicy.contains(LogConfig.Compact())) {
            topicMetadataBuilder.setCleanupPolicy(TopicMetadata.CleanupPolicy.COMPACT);
        } else if (cleanupPolicy.contains(LogConfig.Delete())) {
            topicMetadataBuilder.setCleanupPolicy(TopicMetadata.CleanupPolicy.DELETE);
        }
        return MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.build()).build();
    }

    public static MetadataEvent topicMetadataEventForDeletion(String topicName, Optional<String> topicId, Timestamp updateTime) {
        TopicMetadata.Builder topicMetadataBuilder = TopicMetadata.newBuilder().setTopicName(topicName).setUpdateTime(updateTime);
        topicId.ifPresent(topicMetadataBuilder::setTopicId);
        return MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.build()).build();
    }

    public static MetadataChange snapshotEvent(String logicalClusterId, List<MetadataEvent> metadataEvents) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.SNAPSHOT).addAllEvents(metadataEvents).build();
    }

    public static MetadataChange topicCreateEvent(String logicalClusterId, MetadataEvent metadataEvent) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.CREATE).addEvents(metadataEvent).build();
    }

    public static MetadataChange topicUpdateEvent(String logicalClusterId, MetadataEvent metadataEvent) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.UPDATE).addEvents(metadataEvent).build();
    }

    public static MetadataChange topicDeleteEvent(String logicalClusterId, MetadataEvent metadataEvent) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.DELETE).addEvents(metadataEvent).build();
    }

    public static Event topicMetadataCloudEvent(MetadataChange metadataChange, String sourceUrl, String type, int epoch, @Nullable String route, int page, int total) {
        Event event = new Event().setId(UUID.randomUUID().toString()).setSource(sourceUrl).setSubject(CATALOG_TOPIC_METADATA_SUBJECT).setType(type).setTime(OffsetDateTime.now(Clock.systemUTC())).setData("application/protobuf", metadataChange.toByteArray()).setExtension(Extensions.epoch.name(), String.valueOf(epoch)).setExtension(Extensions.partitionkey.name(), metadataChange.getSource());
        if (route != null) {
            event.setExtension(Extensions.route.name(), route);
        }
        if (MetadataEventUtils.checkIsPagination(page, total)) {
            event.setExtension(Extensions.page.name(), String.valueOf(page)).setExtension(Extensions.total.name(), String.valueOf(total));
        }
        return event;
    }

    public static Event topicMetadataDeltaCloudEvent(MetadataChange metadataChange, int epoch, String route) {
        String topicName = metadataChange.getEvents(0).getTopicMetadata().getTopicName();
        return MetadataEventUtils.topicMetadataCloudEvent(metadataChange, MetadataEventUtils.deltaSourceUrl(metadataChange.getSource(), topicName), TOPIC_DELTA, epoch, route, -1, -1);
    }

    public static Event topicMetadataSnapshotCloudEvent(MetadataChange metadataChange, int epoch, String route, int page, int total) {
        return MetadataEventUtils.topicMetadataCloudEvent(metadataChange, MetadataEventUtils.snapshotSourceUrl(metadataChange.getSource()), TOPIC_SNAPSHOT, epoch, route, page, total);
    }

    public static boolean checkIsPagination(int page, int total) {
        if (page < 0 && total < 0) {
            return false;
        }
        if (page >= 0 && page < total) {
            return true;
        }
        throw new IllegalArgumentException(String.format("Cannot have pagination with page %d of total %d", page, total));
    }

    public static String snapshotSourceUrl(String logicalClusterId) {
        return String.format("crn://confluent.cloud/kafka=%s/topics", logicalClusterId);
    }

    public static String deltaSourceUrl(String logicalClusterId, String topicName) {
        return String.format("crn://confluent.cloud/kafka=%s/topic=%s", logicalClusterId, topicName);
    }

    static enum Extensions {
        route,
        partitionkey,
        epoch,
        page,
        total;

    }
}

