/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.Objects;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Uuid;

public class TopicInfo {
    private String logicalClusterId;
    private Uuid topicId;
    private int partitions;
    private int replicationFactors;

    public TopicInfo(String topic, Uuid topicId, int partitions, int replicationFactors) {
        String tenantPrefix = TenantHelpers.extractTenantPrefix(topic, false);
        this.logicalClusterId = tenantPrefix == null ? "" : tenantPrefix;
        this.topicId = topicId;
        this.partitions = partitions;
        this.replicationFactors = replicationFactors;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public int partitions() {
        return this.partitions;
    }

    public int replicationFactors() {
        return this.replicationFactors;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public String toString() {
        return "TopicInfo(topicId=" + this.topicId + ", logicalClusterId=" + this.logicalClusterId + ", partitions=" + this.partitions + ", replicationFactors=" + this.replicationFactors + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicInfo)) {
            return false;
        }
        TopicInfo that = (TopicInfo)o;
        return Objects.equals(this.topicId, that.topicId) && Objects.equals(this.logicalClusterId, that.logicalClusterId) && this.partitions == that.partitions() && this.replicationFactors == that.replicationFactors();
    }

    public int hashCode() {
        return Objects.hash(this.topicId, this.logicalClusterId, this.partitions, this.replicationFactors);
    }
}

