/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.TopicInfo;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.event.SnapshotEvent;
import kafka.catalog.exceptions.TopicConfigFetchRequestException;
import kafka.common.TenantHelpers;
import kafka.log.LogConfig;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;

public class CacheBuildEvent
extends MetadataCollectorEvent {
    private int maxNumTopicsProcess;

    public CacheBuildEvent(ZKTopicMetadataCollector collector, int maxNumTopicsProcess, Time time) {
        super(collector, time);
        this.maxNumTopicsProcess = maxNumTopicsProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        ZKTopicMetadataCollectorContext context = this.context();
        Iterator<String> topicIter = context.initialTopics().iterator();
        int processed = 0;
        while (topicIter.hasNext() && processed < this.maxNumTopicsProcess) {
            String topic = topicIter.next();
            try {
                Optional<LogConfig> logConfigsMap = this.getLogConfigsForTopic(context, topic);
                if (!logConfigsMap.isPresent()) continue;
                TopicInfo topicInfo = context.removeTopicFromInitialSnapshot(topic);
                MetadataEvent topicMetadataEvent = MetadataEventUtils.topicMetadataEventFromLogConfig(logConfigsMap.get(), TenantHelpers.extractLogicalName(topic), topicInfo.topicId(), topicInfo.partitions(), topicInfo.replicationFactors(), null, null);
                context.localStore().addMetadataEvent(topicInfo.logicalClusterId(), topic, topicMetadataEvent);
            }
            catch (TopicConfigFetchRequestException e) {
                LOG.error("Skipping topic {} due to", (Object)topic, (Object)e);
                context.catalogMetrics().collectorEventHandleErrorSensor.record();
            }
            finally {
                ++processed;
            }
        }
        this.scheduleSnapshotOrNextCacheBuild(context);
    }

    private void scheduleSnapshotOrNextCacheBuild(ZKTopicMetadataCollectorContext context) {
        if (!context.cacheInitialized()) {
            context.eventQueue().appendWithTag("CACHE_BUILD_EVENT", new CacheBuildEvent(this.collector, this.maxNumTopicsProcess, this.time));
        } else {
            long delayNs = TimeUnit.NANOSECONDS.convert(context.config().snapshotInitDelaySec, TimeUnit.SECONDS);
            long currNs = this.time.nanoseconds();
            long passNs = currNs - context.startNs();
            long remainNs = Math.max(0L, delayNs - passNs);
            LOG.debug("Finished cache build. Schedule SnapshotEvent in {} ns from now", (Object)remainNs);
            context.eventQueue().scheduleDeferred("SNAPSHOT_EVENT", (Function<OptionalLong, OptionalLong>)new EventQueue.DeadlineFunction(currNs + remainNs), new SnapshotEvent(this.collector, this.time));
        }
    }

    public String toString() {
        return "CacheBuildEvent(maxNumTopicsProcess=" + this.maxNumTopicsProcess + ')';
    }
}

