/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kafka.catalog.MetadataCollectorEventQueue;
import kafka.catalog.TopicInfo;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorConfig;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.CacheBuildEvent;
import kafka.catalog.event.CollectorStopEvent;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;

public class CollectorStartupEvent
extends MetadataCollectorEvent {
    private final ZKTopicMetadataCollectorConfig config;
    private final MetadataCollectorEventQueue eventQueue;
    private final KafkaZkClient zkClient;
    private final Metrics metrics;
    private final KafkaConfig originalConfig;
    private final int epoch;
    private final Map<String, TopicInfo> initialTopicsWithInfo;

    public CollectorStartupEvent(ZKTopicMetadataCollector collector, ZKTopicMetadataCollectorConfig config, Map<String, TopicInfo> initialTopicsWithInfo, MetadataCollectorEventQueue eventQueue, Metrics metrics, KafkaZkClient zkClient, KafkaConfig originalConfig, int epoch, Time time) {
        super(collector, time);
        this.config = config;
        this.initialTopicsWithInfo = initialTopicsWithInfo;
        this.eventQueue = eventQueue;
        this.zkClient = zkClient;
        this.metrics = metrics;
        this.originalConfig = originalConfig;
        this.epoch = epoch;
    }

    public void run() throws Exception {
        Map<String, TopicInfo> filteredMap = this.initialTopicsWithInfo.entrySet().stream().filter(entry -> !Objects.equals(((TopicInfo)entry.getValue()).logicalClusterId(), "")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ZKTopicMetadataCollectorContext context = new ZKTopicMetadataCollectorContext(this.config, filteredMap, this.eventQueue, this.metrics, this.zkClient, this.originalConfig, this.epoch, this.time);
        this.collector.setCollectorContext(Optional.of(context));
        this.eventQueue.appendWithTag("CACHE_BUILD_EVENT", new CacheBuildEvent(this.collector, this.config.maxNumTopicsProcess, this.time));
        LOG.info("Finished starting ZKTopicMetadataCollector with epoch {}", (Object)this.epoch);
    }

    @Override
    public void handleException(Throwable e) {
        LOG.error("Error during starting ZKTopicMetadataCollector", e);
        this.eventQueue.append(new CollectorStopEvent(this.collector, this.time));
    }

    public String toString() {
        return "CollectorStartupEvent(epoch=" + this.epoch + ')';
    }
}

