/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import java.util.Optional;
import java.util.Set;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.TopicInfo;
import kafka.catalog.ZKTopicMetadataCollector;
import kafka.catalog.ZKTopicMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;

public class TopicDeletionEvent
extends MetadataCollectorEvent {
    private final Set<String> deleteTopics;

    public TopicDeletionEvent(ZKTopicMetadataCollector collector, Set<String> deleteTopics, Time time) {
        super(collector, time);
        this.deleteTopics = deleteTopics;
    }

    public void run() throws Exception {
        ZKTopicMetadataCollectorContext context = this.context();
        LOG.debug("Deleting topics {}", this.deleteTopics);
        Timestamp observeTimestamp = Timestamps.fromNanos((long)this.eventObserveTime);
        for (String deleteTopic : this.deleteTopics) {
            String logicalClusterId = TenantHelpers.extractTenantPrefix(deleteTopic, false);
            MetadataEvent deleted = context.localStore().removeMetadataEvent(logicalClusterId, deleteTopic);
            Optional<String> topicId = Optional.ofNullable(deleted).map(MetadataEvent::getTopicMetadata).map(TopicMetadata::getTopicId);
            if (!topicId.isPresent()) {
                topicId = Optional.ofNullable(context.removeTopicFromInitialSnapshot(deleteTopic)).map(TopicInfo::topicId).map(Uuid::toString);
            }
            MetadataEvent topicMetadataEvent = MetadataEventUtils.topicMetadataEventForDeletion(TenantHelpers.extractLogicalName(deleteTopic), topicId, observeTimestamp);
            MetadataChange topicDeleteChange = MetadataEventUtils.topicDeleteEvent(logicalClusterId, topicMetadataEvent);
            this.emitDeltaEvent(context, topicDeleteChange);
        }
    }

    public String toString() {
        return "TopicDeletionEvent(deletedTopics=" + this.deleteTopics + ')';
    }
}

