/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.Optional;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.RackAndRequiredReplicaCountsAndEligibleBrokers;
import kafka.cluster.RackIndexAndAssignment;
import kafka.cluster.RackIndexAndReplicasCount;
import kafka.cluster.RequiredReplicaCountsAndEligibleBrokers;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Observer$ {
    public static final Observer$ MODULE$ = new Observer$();
    private static final String RackConstraintKey = "rack";

    public String RackConstraintKey() {
        return RackConstraintKey;
    }

    public Map<Object, ReplicaAssignment> getReplicaAssignment(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement, int numPartitions, int replicationFactor, boolean mrcRackMixingSupportedEnabled, int fixedStartIndex, int startPartitionId) {
        if (mrcRackMixingSupportedEnabled) {
            return this.getReplicaAssignmentWithRackMixingSupport(brokers, topicPlacement, numPartitions, replicationFactor, fixedStartIndex, startPartitionId);
        }
        return this.getReplicaAssignmentWithoutRackMixingSupport(brokers, topicPlacement, numPartitions, replicationFactor, fixedStartIndex, startPartitionId);
    }

    public int getReplicaAssignment$default$6() {
        return -1;
    }

    public int getReplicaAssignment$default$7() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Object, ReplicaAssignment> getReplicaAssignmentWithoutRackMixingSupport(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement2, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        void var9_9;
        void var8_8;
        Tuple2 tuple2 = (Tuple2)topicPlacement2.map((Function1 & Serializable)topicPlacement -> new Tuple2(MODULE$.partitionBrokersByConstraint(brokers, (Seq<TopicPlacement.ConstraintCount>)CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala()), MODULE$.partitionBrokersByConstraint(brokers, (Seq<TopicPlacement.ConstraintCount>)CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.observers()).asScala()))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicationFactor)), (Object)brokers), (List)Nil$.MODULE$), (Object)Seq$.MODULE$.empty()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq replicationAndSyncEligible = (Seq)tuple2._1();
        Seq replicationAndObserverEligible = (Seq)tuple2._2();
        this.validatePartitioning((Seq<Seq<BrokerMetadata>>)((Seq)((IterableOps)var8_8.$plus$plus((IterableOnce)var9_9)).map((Function1 & Serializable)x$2 -> (Seq)x$2._2())));
        return this.partitionReplicaAssignment((Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)var8_8, numPartitions, fixedStartIndex, startPartitionId), (Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)var9_9, numPartitions, fixedStartIndex, startPartitionId));
    }

    /*
     * WARNING - void declaration
     */
    private Map<Object, ReplicaAssignment> getReplicaAssignmentWithRackMixingSupport(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement2, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        void var10_10;
        void var9_9;
        Seq requiredReplicaCountsAndEligibleBrokers = (Seq)topicPlacement2.map((Function1 & Serializable)topicPlacement -> MODULE$.buildRequiredReplicaCountsAndEligibleBrokers((TopicPlacement)topicPlacement, brokers)).getOrElse((Function0 & Serializable)() -> new .colon.colon((Object)new RequiredReplicaCountsAndEligibleBrokers(replicationFactor, 0, brokers, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$));
        this.validatePartitioning((Seq<Seq<BrokerMetadata>>)((Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1 & Serializable)x$3 -> x$3.eligibleBrokers())));
        Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>> tuple2 = this.assignReplicasToPartitionsWithRackMixingSupport((Seq<RequiredReplicaCountsAndEligibleBrokers>)requiredReplicaCountsAndEligibleBrokers, numPartitions, fixedStartIndex, startPartitionId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map syncReplicaAssignments = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map observerAssignments = (scala.collection.mutable.Map)tuple2._2();
        return this.partitionReplicaAssignment((Map<Object, Seq<Object>>)var9_9, (Map<Object, Seq<Object>>)var10_10);
    }

    public void validateTopicPlacementUpdate(TopicPlacement topicPlacement, Seq<BrokerMetadata> brokers) {
        this.validatePartitioning((Seq<Seq<BrokerMetadata>>)((Seq)this.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, brokers).map((Function1 & Serializable)x$5 -> x$5.eligibleBrokers())));
    }

    public Seq<RequiredReplicaCountsAndEligibleBrokers> buildRequiredReplicaCountsAndEligibleBrokers(TopicPlacement topicPlacement, Seq<BrokerMetadata> brokers) {
        Map syncReplicasKeyedByRack = (Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala().zipWithIndex()).foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(map, constraintCountAndIndex) -> MODULE$.keyByRackFunc("Replicas contains duplicate constraint", (scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount>)map, (Tuple2<TopicPlacement.ConstraintCount, Object>)constraintCountAndIndex));
        Map observersKeyedByRack = (Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.observers()).asScala().zipWithIndex()).foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(map, constraintCountAndIndex) -> MODULE$.keyByRackFunc("Observers contains duplicate constraint", (scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount>)map, (Tuple2<TopicPlacement.ConstraintCount, Object>)constraintCountAndIndex));
        scala.collection.immutable.Seq requiredReplicaCountsAndEligibleBrokers = ((IterableOnceOps)syncReplicasKeyedByRack.keySet().$plus$plus((IterableOnce)observersKeyedByRack.keySet()).map((Function1 & Serializable)rack -> {
            void var11_13;
            void var7_8;
            void var10_12;
            void var6_7;
            None$ none$;
            int n;
            None$ none$2;
            int n2;
            Option option = syncReplicasKeyedByRack.get(rack);
            if (option instanceof Some) {
                RackIndexAndReplicasCount x = (RackIndexAndReplicasCount)((Some)option).value();
                n2 = x.replicaCount();
                none$2 = new Some((Object)BoxesRunTime.boxToInteger((int)x.rackIndex()));
            } else if (None$.MODULE$.equals(option)) {
                n2 = 0;
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            None$ none$3 = none$2;
            int syncReplicas = n2;
            Option syncReplicaIndex = (Option)none$3;
            Option option2 = observersKeyedByRack.get(rack);
            if (option2 instanceof Some) {
                RackIndexAndReplicasCount x = (RackIndexAndReplicasCount)((Some)option2).value();
                n = x.replicaCount();
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)x.rackIndex()));
            } else if (None$.MODULE$.equals(option2)) {
                n = 0;
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)option2);
            }
            None$ none$4 = none$;
            int observers = n;
            Option observersIndex = (Option)none$4;
            Seq matchedBrokers = (Seq)brokers.filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (Map<String, String>)rack)));
            return new RackAndRequiredReplicaCountsAndEligibleBrokers((Map<String, String>)rack, new RequiredReplicaCountsAndEligibleBrokers((int)var6_7, (int)var10_12, (Seq<BrokerMetadata>)matchedBrokers, (Option<Object>)var7_8, (Option<Object>)var11_13));
        })).toSeq();
        scala.collection.immutable.Seq invalidRacks = (scala.collection.immutable.Seq)requiredReplicaCountsAndEligibleBrokers.filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Observer$.$anonfun$buildRequiredReplicaCountsAndEligibleBrokers$5(x)));
        if (invalidRacks.size() > 0) {
            String detailedErrMsg = ((scala.collection.immutable.Seq)invalidRacks.map((Function1 & Serializable)x0$1 -> new StringBuilder(106).append("for constraint ").append(x0$1.rack()).append(" there are ").append(x0$1.countsAndEligibleBrokers().eligibleBrokers().size()).append(" ").append("matching brokers but the topic placement requires ").append(x0$1.countsAndEligibleBrokers().syncReplicas()).append(" sync replicas and ").append(x0$1.countsAndEligibleBrokers().observers()).append(" observers").toString())).mkString(", ");
            throw new InvalidConfigurationException(new StringBuilder(39).append("Failed to satisfy the topic placement: ").append(detailedErrMsg).toString());
        }
        return (Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1 & Serializable)x$8 -> x$8.countsAndEligibleBrokers());
    }

    private scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount> keyByRackFunc(String errorMsg, scala.collection.mutable.Map<Map<String, String>, RackIndexAndReplicasCount> map, Tuple2<TopicPlacement.ConstraintCount, Object> constraintCountAndIndex) {
        Option option = map.get((Object)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)constraintCountAndIndex._1()).constraints()).asScala());
        if (option instanceof Some) {
            throw new InvalidConfigurationException(errorMsg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        map.put((Object)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)constraintCountAndIndex._1()).constraints()).asScala(), (Object)new RackIndexAndReplicasCount(constraintCountAndIndex._2$mcI$sp(), ((TopicPlacement.ConstraintCount)constraintCountAndIndex._1()).count()));
        return map;
    }

    private scala.collection.mutable.Map<Object, Seq<Object>> assignReplicasToPartitions(Seq<Tuple2<Object, Seq<BrokerMetadata>>> replicationAndBrokers, int partitions, int fixedStartIndex, int startPartitionId) {
        return (scala.collection.mutable.Map)((IterableOnceOps)replicationAndBrokers.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int replication = x0$1._1$mcI$sp();
                Seq brokerList = (Seq)x0$1._2();
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerList, partitions, replication, fixedStartIndex, startPartitionId);
            }
            throw new MatchError(null);
        })).foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment));
    }

    private Tuple2<scala.collection.mutable.Map<Object, Seq<Object>>, scala.collection.mutable.Map<Object, Seq<Object>>> assignReplicasToPartitionsWithRackMixingSupport(Seq<RequiredReplicaCountsAndEligibleBrokers> requiredReplicaCountsAndEligibleBrokers, int numPartitions, int fixedStartIndex, int startPartitionId) {
        Seq syncReplicaAndObserverAssignments = (Seq)requiredReplicaCountsAndEligibleBrokers.map((Function1 & Serializable)countsAndBrokers -> {
            int numSyncReplicas = countsAndBrokers.syncReplicas();
            int numObservers = countsAndBrokers.observers();
            int replicationFactor = numSyncReplicas + numObservers;
            return (Map)AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)countsAndBrokers.eligibleBrokers(), numPartitions, replicationFactor, fixedStartIndex, startPartitionId).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    void var6_6;
                    void var5_5;
                    int partition = x0$1._1$mcI$sp();
                    Tuple2 tuple2 = ((Seq)x0$1._2()).splitAt(numSyncReplicas);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    Seq syncReplicaAssignment = (Seq)tuple2._1();
                    Seq observerAssignment = (Seq)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)new Tuple2((Object)new RackIndexAndAssignment(countsAndBrokers.syncReplicasRackIndex(), (Seq<Object>)var5_5), (Object)new RackIndexAndAssignment(countsAndBrokers.observersRackIndex(), (Seq<Object>)var6_6)));
                }
                throw new MatchError(null);
            });
        });
        Seq syncReplicaOrderedAssignments = (Seq)((IterableOps)((IterableOps)((SeqOps)((IterableOps)((Seq)syncReplicaAndObserverAssignments.map((Function1 & Serializable)assignment -> (Map)assignment.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int partition = x0$2._1$mcI$sp();
                Tuple2 tuple2 = (Tuple2)x0$2._2();
                if (tuple2 != null) {
                    RackIndexAndAssignment indexAndAssignment = (RackIndexAndAssignment)tuple2._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)indexAndAssignment);
                }
            }
            throw new MatchError(x0$2);
        }))).flatMap((Function1 & Serializable)x -> x.toSeq())).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Observer$.$anonfun$assignReplicasToPartitionsWithRackMixingSupport$6(x)))).sortWith((Function2 & Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.sortWithPartitionAndRackIndex((Tuple2<Object, RackIndexAndAssignment>)t1, (Tuple2<Object, RackIndexAndAssignment>)t2)))).map((Function1 & Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), ((RackIndexAndAssignment)x._2()).assignment()))).map((Function1 & Serializable)x -> (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())), x._2())})));
        Seq observerOrderedAssignments = (Seq)((IterableOps)((IterableOps)((SeqOps)((IterableOps)((Seq)syncReplicaAndObserverAssignments.map((Function1 & Serializable)assignment -> (Map)assignment.map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                int partition = x0$3._1$mcI$sp();
                Tuple2 tuple2 = (Tuple2)x0$3._2();
                if (tuple2 != null) {
                    RackIndexAndAssignment observerAssignment = (RackIndexAndAssignment)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)observerAssignment);
                }
            }
            throw new MatchError(x0$3);
        }))).flatMap((Function1 & Serializable)x -> x.toSeq())).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Observer$.$anonfun$assignReplicasToPartitionsWithRackMixingSupport$13(x)))).sortWith((Function2 & Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.sortWithPartitionAndRackIndex((Tuple2<Object, RackIndexAndAssignment>)t1, (Tuple2<Object, RackIndexAndAssignment>)t2)))).map((Function1 & Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), ((RackIndexAndAssignment)x._2()).assignment()))).map((Function1 & Serializable)x -> (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp())), x._2())})));
        return new Tuple2(syncReplicaOrderedAssignments.foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment)), observerOrderedAssignments.foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment)));
    }

    /*
     * WARNING - void declaration
     */
    public boolean sortWithPartitionAndRackIndex(Tuple2<Object, RackIndexAndAssignment> t1, Tuple2<Object, RackIndexAndAssignment> t2) {
        void var6_6;
        void var4_4;
        Option<Object> option = ((RackIndexAndAssignment)t1._2()).rackIndex();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("The rack index of t1 is None which is not sortable.");
            }
            throw new MatchError(option);
        }
        int v = BoxesRunTime.unboxToInt((Object)((Some)option).value());
        Option<Object> option2 = ((RackIndexAndAssignment)t2._2()).rackIndex();
        if (!(option2 instanceof Some)) {
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException("The rack index of t2 is None which is not sortable.");
            }
            throw new MatchError(option2);
        }
        int v2 = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
        if (t1._1$mcI$sp() < t2._1$mcI$sp()) {
            return true;
        }
        if (t1._1$mcI$sp() > t2._1$mcI$sp()) {
            return false;
        }
        return var4_4 < var6_6;
    }

    private Map<Object, ReplicaAssignment> partitionReplicaAssignment(Map<Object, Seq<Object>> syncReplicas, Map<Object, Seq<Object>> observerReplicas) {
        if (observerReplicas.nonEmpty()) {
            Set set = syncReplicas.keySet();
            Set set2 = observerReplicas.keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                int syncSize = syncReplicas.keySet().size();
                int observerSize = observerReplicas.keySet().size();
                throw new InvalidConfigurationException(new StringBuilder(115).append("Must assign observers to all or none of the partitions. ").append(syncSize).append(" partitions with sync replicas. ").append(observerSize).append(" partitions with observers.").toString());
            }
        }
        return (Map)syncReplicas.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                Seq observerAssignment = (Seq)observerReplicas.getOrElse((Object)BoxesRunTime.boxToInteger((int)partition), (Function0 & Serializable)() -> (Seq)Seq$.MODULE$.empty());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)((Seq)replicas.$plus$plus((IterableOnce)observerAssignment)), (Seq<Object>)observerAssignment));
            }
            throw new MatchError(null);
        });
    }

    public Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionBrokersByConstraint(Seq<BrokerMetadata> brokers, Seq<TopicPlacement.ConstraintCount> constraints) {
        return (Seq)constraints.map((Function1 & Serializable)constraint -> {
            Seq matchedBrokers = (Seq)brokers.filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, constraint)));
            if (matchedBrokers.size() < constraint.count()) {
                throw new InvalidConfigurationException(new StringBuilder(75).append("Number of broker found (").append(matchedBrokers.size()).append(") matching ").append("constraint ").append(constraint).append(" is less than required count ").append(constraint.count()).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)constraint.count()), (Object)matchedBrokers);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void validatePartitioning(Seq<Seq<BrokerMetadata>> partitionedBrokers) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = (Tuple2)partitionedBrokers.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable)(acc, brokers) -> {
            void var3_3;
            void var2_2;
            if (acc == null) {
                throw new MatchError(null);
            }
            int count = acc._1$mcI$sp();
            scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)acc._2();
            if (brokers.toSet().size() != brokers.size()) {
                throw new InvalidConfigurationException(new StringBuilder(58).append("Duplicate eligible brokers ").append(brokers).append(" match a placement constraints.").toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(var2_2 + brokers.size())), (Object)var3_3.$plus$plus((IterableOnce)brokers));
        });
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int count = tuple2._1$mcI$sp();
        scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)tuple2._2();
        if (var3_3 != var4_4.size()) {
            throw new InvalidConfigurationException(new StringBuilder(58).append("Some brokers satisfy more than one placement constraints: ").append(partitionedBrokers).toString());
        }
    }

    public scala.collection.mutable.Map<Object, Seq<Object>> mergeAssignmentMap(scala.collection.mutable.Map<Object, Seq<Object>> mergedAssignment, Map<Object, Seq<Object>> currentAssignment) {
        return (scala.collection.mutable.Map)mergedAssignment.$plus$plus((IterableOnce)currentAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partitionId = x0$1._1$mcI$sp();
                Seq replicaIds = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), MODULE$.mergeReplicaLists((Seq<Object>)((Seq)mergedAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0 & Serializable)() -> (Seq)Seq$.MODULE$.empty())), (Seq<Object>)replicaIds));
            }
            throw new MatchError(null);
        }));
    }

    public Seq<Object> mergeReplicaLists(Seq<Object> brokerList1, Seq<Object> brokerList2) {
        Seq commonReplicas = (Seq)brokerList1.intersect(brokerList2);
        if (commonReplicas.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(64).append("Replica with ids (").append(commonReplicas).append(") satisfy more than one placement constraints.").toString());
        }
        return (Seq)brokerList1.$plus$plus(brokerList2);
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, TopicPlacement.ConstraintCount constraint) {
        return this.brokerMatchesPlacementConstraint(broker, (Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(constraint.constraints()).asScala());
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, Map<String, String> rack2) {
        scala.collection.immutable.Map properties = Option$.MODULE$.option2Iterable(broker.rack().map((Function1 & Serializable)rack -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.RackConstraintKey()), rack))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return TopicPlacement.ConstraintCount.isSubset(CollectionConverters$.MODULE$.MapHasAsJava(rack2).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)properties).asJava());
    }

    public Option<ApiError> validateAssignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment.Assignment assignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return this.validateAssignmentStructure(assignment).orElse((Function0 & Serializable)() -> topicPlacement.flatMap((Function1 & Serializable)placementConstraint -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.syncReplicas().map((Function1 & Serializable)id -> Observer$.$anonfun$validateAssignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.observers().map((Function1 & Serializable)id -> Observer$.$anonfun$validateAssignment$5(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)))).asJava()))).map((Function1 & Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message))));
    }

    public Option<ApiError> validateAssignmentStructure(ReplicaAssignment.Assignment assignment) {
        Seq<Object> replicas = assignment.replicas();
        scala.collection.immutable.Set replicaSet = replicas.toSet();
        if (replicas.isEmpty() || replicas.size() != replicaSet.size()) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(57).append("Duplicate replicas not allowed in partition assignment: ").append(replicas.mkString(", ")).append(".").toString()));
        }
        if (replicas.exists((Function1)(JFunction1.mcZI.sp & Serializable)x$12 -> x$12 < 0)) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(44).append("Invalid replica id in partition assignment: ").append(replicas.mkString(", ")).toString()));
        }
        if (!assignment.replicas().endsWith(assignment.observers())) {
            String observerMsg = assignment.observers().mkString(", ");
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(85).append("Assignment contains observers (").append(observerMsg).append(") and the replicas' (").append(replicas.mkString(", ")).append(") ").append("suffix doesn't match observers.").toString()));
        }
        return None$.MODULE$;
    }

    public Option<ApiError> validateReassignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment reassignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return reassignment.targetAssignment().flatMap((Function1 & Serializable)assignment -> topicPlacement.flatMap((Function1 & Serializable)placementConstraint -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.syncReplicas().map((Function1 & Serializable)id -> Observer$.$anonfun$validateReassignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.observers().map((Function1 & Serializable)id -> Observer$.$anonfun$validateReassignment$5(liveBrokerAttributes, reassignment, BoxesRunTime.unboxToInt((Object)id)))).asJava()))).map((Function1 & Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message))));
    }

    public static final /* synthetic */ boolean $anonfun$buildRequiredReplicaCountsAndEligibleBrokers$5(RackAndRequiredReplicaCountsAndEligibleBrokers x) {
        return x.countsAndEligibleBrokers().eligibleBrokers().size() < x.countsAndEligibleBrokers().syncReplicas() + x.countsAndEligibleBrokers().observers();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToPartitionsWithRackMixingSupport$6(Tuple2 x) {
        return ((RackIndexAndAssignment)x._2()).assignment().length() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToPartitionsWithRackMixingSupport$13(Tuple2 x) {
        return ((RackIndexAndAssignment)x._2()).assignment().length() > 0;
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$3(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.MapHasAsJava((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable)() -> (Map)scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$5(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.MapHasAsJava((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable)() -> (Map)scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$3(Map liveBrokerAttributes$2, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.MapHasAsJava((Map)liveBrokerAttributes$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable)() -> (Map)scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$5(Map liveBrokerAttributes$2, ReplicaAssignment reassignment$1, int id) {
        Option attributes = liveBrokerAttributes$2.get((Object)BoxesRunTime.boxToInteger((int)id));
        Option attributes2 = reassignment$1.originAssignment().replicas().contains((Object)BoxesRunTime.boxToInteger((int)id)) ? attributes : attributes.orElse((Function0 & Serializable)() -> new Some(scala.collection.Map$.MODULE$.empty()));
        return TopicPlacement.Replica.of(id, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(attributes2.map((Function1 & Serializable)x$13 -> CollectionConverters$.MODULE$.MapHasAsJava(x$13).asJava()))));
    }

    private Observer$() {
    }
}

